package at.hannibal2.skyhanni.mixins.transformers;

import at.hannibal2.skyhanni.features.misc.visualwords.ModifyVisualWords;
import at.hannibal2.skyhanni.utils.compat.OrderedTextUtils;
import net.minecraft.class_327;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(class_327.class)
public class MixinTextRenderer {

    @ModifyVariable(
        //#if MC < 1.21.7
        method = "drawInternal(Lnet/minecraft/text/OrderedText;FFIZLorg/joml/Matrix4f;Lnet/minecraft/client/render/VertexConsumerProvider;Lnet/minecraft/client/font/TextRenderer$TextLayerType;IIZ)I",
        //#else
        //$$ method = "prepare(Lnet/minecraft/text/OrderedText;FFIZI)Lnet/minecraft/client/font/TextRenderer$GlyphDrawable;",
        //#endif
        index = 1,
        at = @At("HEAD"),
        argsOnly = true
    )
    private class_5481 modifyOrderedText(class_5481 value) {

        class_5481 replaced = ModifyVisualWords.INSTANCE.transformText(
            value
        );

        if (replaced == null) return value;
        return replaced;
    }

    @ModifyVariable(
        //#if MC < 1.21.7
        method = "drawInternal(Ljava/lang/String;FFIZLorg/joml/Matrix4f;Lnet/minecraft/client/render/VertexConsumerProvider;Lnet/minecraft/client/font/TextRenderer$TextLayerType;IIZ)I",
        //#else
        //$$ method = "prepare(Ljava/lang/String;FFIZI)Lnet/minecraft/client/font/TextRenderer$GlyphDrawable;",
        //#endif
        index = 1,
        at = @At("HEAD"),
        argsOnly = true
    )
    private String modifyString(String value) {

        class_5481 replaced = ModifyVisualWords.INSTANCE.transformText(
            OrderedTextUtils.legacyTextToOrderedText(value)
        );

        if (replaced == null) return value;
        return OrderedTextUtils.orderedTextToLegacyString(replaced);
    }

    @ModifyVariable(
        method = "getWidth(Lnet/minecraft/text/OrderedText;)I",
        index = 1,
        at = @At("HEAD"),
        argsOnly = true
    )
    private class_5481 modifyWidth(class_5481 value) {

        class_5481 replaced = ModifyVisualWords.INSTANCE.transformText(
            value
        );

        if (replaced == null) return value;
        return replaced;
    }

    @ModifyVariable(
        method = "getWidth(Ljava/lang/String;)I",
        index = 1,
        at = @At("HEAD"),
        argsOnly = true
    )
    private String modifyWidth(String value) {

        class_5481 replaced = ModifyVisualWords.INSTANCE.transformText(
            OrderedTextUtils.legacyTextToOrderedText(value)
        );

        if (replaced == null) return value;
        return OrderedTextUtils.orderedTextToLegacyString(replaced);
    }

    @ModifyVariable(
        method = "getWidth(Lnet/minecraft/text/StringVisitable;)I",
        index = 1,
        at = @At("HEAD"),
        argsOnly = true
    )
    private class_5348 modifyWidth(class_5348 value) {

        class_5348 replaced = ModifyVisualWords.INSTANCE.transformStringVisitable(
            value
        );

        if (replaced == null) return value;
        return replaced;
    }
}
