package at.hannibal2.skyhanni.mixins.transformers.gui;

import at.hannibal2.skyhanni.data.ToolTipData;
import at.hannibal2.skyhanni.mixins.hooks.GuiContainerHook;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
//#if MC > 1.21.8
//$$ import net.minecraft.client.input.KeyInput;
//#endif

@Mixin(class_465.class)
public abstract class MixinGuiContainer<T extends class_1703> extends class_437 {

    @Shadow
    @Nullable
    protected class_1735 focusedSlot;

    protected MixinGuiContainer(class_2561 title) {
        super(title);
    }

    @Unique
    private final GuiContainerHook skyHanni$hook = new GuiContainerHook(this);

    @Inject(method = "keyPressed", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;close()V", shift = At.Shift.BEFORE), cancellable = true)
    //#if MC < 1.21.9
    private void closeWindowPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        //#else
        //$$ private void closeWindowPressed(KeyInput input, CallbackInfoReturnable<Boolean> cir) {
        //#endif
        skyHanni$hook.closeWindowPressed(cir);
    }

    //#if MC < 1.21.6
    @Inject(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;drawSlotHighlightBack(Lnet/minecraft/client/gui/DrawContext;)V"))
    //#else
    //$$ @Inject(method = "renderMain", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;drawSlotHighlightBack(Lnet/minecraft/client/gui/DrawContext;)V"))
    //#endif
    private void backgroundDrawn(class_332 context, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        skyHanni$hook.backgroundDrawn(context, mouseX, mouseY, deltaTicks);
    }

    @Inject(method = "render", at = @At("HEAD"), cancellable = true)
    private void preDraw(class_332 context, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        skyHanni$hook.preDraw(context, mouseX, mouseY, deltaTicks, ci);
    }

    @Inject(method = "render", at = @At("TAIL"))
    private void postDraw(class_332 context, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        skyHanni$hook.postDraw(context, mouseX, mouseY, deltaTicks);
    }

    //#if MC < 1.21.6
    @Inject(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;drawForeground(Lnet/minecraft/client/gui/DrawContext;II)V", shift = At.Shift.AFTER))
    //#else
    //$$ @Inject(method = "renderMain", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;drawSlotHighlightFront(Lnet/minecraft/client/gui/DrawContext;)V", shift = At.Shift.AFTER))
    //#endif
    private void onForegroundDraw(class_332 context, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        skyHanni$hook.foregroundDrawn(context, mouseX, mouseY, deltaTicks);
    }

    @Inject(method = "drawSlot", at = @At("HEAD"), cancellable = true)
    private void onDrawSlot(class_332 context, class_1735 slot, CallbackInfo ci) {
        skyHanni$hook.onDrawSlot(slot, ci);
    }

    @Inject(method = "drawSlot", at = @At("RETURN"))
    private void onDrawSlotReturn(class_332 context, class_1735 slot, CallbackInfo ci) {
        skyHanni$hook.onDrawSlotPost(slot);
    }

    @Inject(method = "onMouseClick(Lnet/minecraft/screen/slot/Slot;IILnet/minecraft/screen/slot/SlotActionType;)V", at = @At("HEAD"), cancellable = true)
    private void onMouseClick(class_1735 slot, int slotId, int button, class_1713 actionType, CallbackInfo cir) {
        skyHanni$hook.onMouseClick(slot, slotId, button, actionType.method_68805(), cir);
    }

    //#if MC < 1.21.6
    @Inject(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;drawSlotHighlightBack(Lnet/minecraft/client/gui/DrawContext;)V", shift = At.Shift.AFTER))
    //#else
    //$$ @Inject(method = "renderMain", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/ingame/HandledScreen;drawSlotHighlightBack(Lnet/minecraft/client/gui/DrawContext;)V", shift = At.Shift.AFTER))
    //#endif
    private void renderBackgroundTexture(class_332 context, int mouseX, int mouseY, float deltaTicks, CallbackInfo ci) {
        ToolTipData.INSTANCE.setLastSlot(this.focusedSlot);
    }

}
