package at.hannibal2.skyhanni.mixins.transformers.renderer;

import at.hannibal2.skyhanni.data.entity.EntityOpacityManager;
import at.hannibal2.skyhanni.mixins.hooks.EntityRenderDispatcherHookKt;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_10197;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
//#if MC > 1.21.8
//$$ import org.spongepowered.asm.mixin.injection.ModifyArg;
//#endif

@Mixin(class_10197.class)
public class MixinEquipmentRenderer {

    //#if MC < 1.21.9
    @WrapOperation(method = "render(Lnet/minecraft/client/render/entity/equipment/EquipmentModel$LayerType;Lnet/minecraft/registry/RegistryKey;Lnet/minecraft/client/model/Model;Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/util/Identifier;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/item/ItemRenderer;getArmorGlintConsumer(Lnet/minecraft/client/render/VertexConsumerProvider;Lnet/minecraft/client/render/RenderLayer;Z)Lnet/minecraft/client/render/VertexConsumer;"))
    private class_4588 replaceVertexConsumer(class_4597 vertexConsumerProvider, class_1921 renderLayer, boolean b, Operation<class_4588> original, @Local(ordinal = 1) class_2960 identifier) {
        if (EntityRenderDispatcherHookKt.getEntity() instanceof class_1309 livingEntity) {
            Integer entityAlpha = EntityOpacityManager.getEntityOpacity(livingEntity);
            if (entityAlpha == null) return original.call(vertexConsumerProvider, renderLayer, b);

            class_1921 newRenderLayer = class_1921.method_65052(identifier);
            return original.call(vertexConsumerProvider, newRenderLayer, b);
        }
        return original.call(vertexConsumerProvider, renderLayer, b);
    }
    //#else
    //$$ @ModifyArg(method = "render(Lnet/minecraft/client/render/entity/equipment/EquipmentModel$LayerType;Lnet/minecraft/registry/RegistryKey;Lnet/minecraft/client/model/Model;Ljava/lang/Object;Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/command/OrderedRenderCommandQueue;ILnet/minecraft/util/Identifier;II)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/command/RenderCommandQueue;submitModel(Lnet/minecraft/client/model/Model;Ljava/lang/Object;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/RenderLayer;IIILnet/minecraft/client/texture/Sprite;ILnet/minecraft/client/render/command/ModelCommandRenderer$CrumblingOverlayCommand;)V", ordinal = 1), index = 3)
    //$$ private RenderLayer replaceVertexConsumer(RenderLayer original, @Local(ordinal = 1) Identifier identifier) {
    //$$     if (EntityRenderDispatcherHookKt.getEntity() instanceof LivingEntity livingEntity) {
    //$$         Integer entityAlpha = EntityOpacityManager.getEntityOpacity(livingEntity);
    //$$         if (entityAlpha == null) return original;
    //$$
    //$$         return RenderLayer.createArmorTranslucent(identifier);
    //$$     }
    //$$     return original;
    //$$ }
    //#endif

}
