package at.hannibal2.skyhanni.utils.compat

import net.minecraft.client.MinecraftClient
//#if MC < 1.16
//$$ import net.minecraft.client.gui.ScaledResolution
//$$
//#endif

object GuiScreenUtils {

    private val mc get() = MinecraftClient.getInstance()

    val scaledWindowHeight: Int
        get() =
//#if MC < 1.16
//$$             ScaledResolution(mc).scaledHeight
//#else
           mc.window.scaledHeight.toInt()
//#endif

    val scaledWindowWidth: Int
        get() =
//#if MC < 1.16
//$$             ScaledResolution(mc).scaledWidth
//#else
           mc.window.scaledWidth.toInt()
//#endif

    val displayWidth: Int
        get() =
//#if MC < 1.16
//$$             mc.displayWidth
//#else
           mc.window.framebufferWidth.toInt()
//#endif

    val displayHeight: Int
        get() =
//#if MC < 1.16
//$$             mc.displayHeight
//#else
           mc.window.framebufferHeight.toInt()
//#endif

    val scaleFactor: Int
        get() =
//#if MC < 1.16
//$$             ScaledResolution(mc).scaleFactor
//#else
           mc.window.scaleFactor.toInt()
//#endif

    private val globalMouseX get() = MouseCompat.getX()
    private val globalMouseY get() = MouseCompat.getY()

    val mouseX: Int
        get() {
            var x = globalMouseX * scaledWindowWidth / displayWidth
            //#if MC > 1.21
            if (mc.window.framebufferWidth > mc.window.width) x *= 2
            //#endif
            return x
        }

    val mouseY: Int
        get() {
            val height = this.scaledWindowHeight
            // TODO: in later versions the height - factor is removed, i think
            var y = globalMouseY * height / displayHeight
//#if MC < 1.21
//$$             return height - y - 1
//#else
           if (mc.window.framebufferHeight > mc.window.height) y *= 2
           return y
//#endif
        }

    val mousePos: Pair<Int, Int> get() = mouseX to mouseY
}
