/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.api.storage;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.api.storage.StorageCategory;
import at.hannibal2.skyhanni.api.storage.StorageSearchConsumer;
import at.hannibal2.skyhanni.api.storage.StorageSearchConsumerKt;
import at.hannibal2.skyhanni.api.storage.StorageSearchResult;
import at.hannibal2.skyhanni.api.storage.StorageSearchResultKt;
import at.hannibal2.skyhanni.config.ConfigFileType;
import at.hannibal2.skyhanni.config.StorageData;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.model.SkyHanniInventoryContainer;
import at.hannibal2.skyhanni.events.BlockClickEvent;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.InventoryCloseEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.BlockUtils;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010%\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\f\u0010\u0003J\u000f\u0010\r\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\r\u0010\u0003J\u000f\u0010\u000e\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00122\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u0019\u001a\u00020\u00062\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ)\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001f0\u001e0\u001d2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010#\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\"H\u0007\u00a2\u0006\u0004\b#\u0010$J\u0017\u0010&\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020%H\u0007\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010)\u001a\u00020(H\u0002\u00a2\u0006\u0004\b)\u0010*J\r\u0010,\u001a\u00020+\u00a2\u0006\u0004\b,\u0010-J!\u0010/\u001a\u0016\u0012\u0004\u0012\u00020\u0012\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u001d0.\u00a2\u0006\u0004\b/\u00100J%\u00104\u001a\b\u0012\u0004\u0012\u0002030\u001d2\u0006\u00101\u001a\u00020\u00122\b\b\u0002\u00102\u001a\u00020(\u00a2\u0006\u0004\b4\u00105J%\u00107\u001a\b\u0012\u0004\u0012\u0002030\u001d2\u0006\u00106\u001a\u00020\u00122\b\b\u0002\u00102\u001a\u00020(\u00a2\u0006\u0004\b7\u00105J\u001b\u0010:\u001a\b\u0012\u0004\u0012\u0002030\u001d2\u0006\u00109\u001a\u000208\u00a2\u0006\u0004\b:\u0010;J'\u0010?\u001a\b\u0012\u0004\u0012\u0002030\u001d2\u0012\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u00020=0<\"\u00020=\u00a2\u0006\u0004\b?\u0010@J\u0017\u0010C\u001a\u0004\u0018\u00010B2\u0006\u0010A\u001a\u00020\u0012\u00a2\u0006\u0004\bC\u0010DJ\u0017\u0010E\u001a\u0004\u0018\u00010\u001b2\u0006\u0010A\u001a\u00020\u0012\u00a2\u0006\u0004\bE\u0010FJ\u0017\u0010H\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020GH\u0007\u00a2\u0006\u0004\bH\u0010IJ\u0017\u0010K\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020JH\u0007\u00a2\u0006\u0004\bK\u0010LJ\u0017\u0010N\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020MH\u0007\u00a2\u0006\u0004\bN\u0010OR\u001d\u0010Q\u001a\b\u0012\u0004\u0012\u0002030P8\u0006\u00a2\u0006\f\n\u0004\bQ\u0010R\u001a\u0004\bS\u0010TR(\u0010U\u001a\b\u0012\u0004\u0012\u0002030\u001d8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bU\u0010R\u001a\u0004\bV\u0010T\"\u0004\bW\u0010XR \u0010]\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020Z0Y8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b[\u0010\\R\u0018\u0010_\u001a\u0004\u0018\u00010^8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b_\u0010`R\u0014\u0010b\u001a\u00020a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bb\u0010cR\u001b\u0010i\u001a\u00020d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\be\u0010f\u001a\u0004\bg\u0010hR\u001b\u0010l\u001a\u00020d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bj\u0010f\u001a\u0004\bk\u0010hR\u001b\u0010o\u001a\u00020d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bm\u0010f\u001a\u0004\bn\u0010hR\u001d\u0010q\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020Z0.8F\u00a2\u0006\u0006\u001a\u0004\bp\u00100R\u001d\u0010s\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020Z0.8F\u00a2\u0006\u0006\u001a\u0004\br\u00100R\u001d\u0010u\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020Z0.8F\u00a2\u0006\u0006\u001a\u0004\bt\u00100R\u001d\u0010w\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020Z0.8F\u00a2\u0006\u0006\u001a\u0004\bv\u00100R \u0010z\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020Z0x8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\by\u00100R\u001d\u0010|\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020Z0.8F\u00a2\u0006\u0006\u001a\u0004\b{\u00100R*\u0010~\u001a\u0004\u0018\u00010Z2\b\u0010}\u001a\u0004\u0018\u00010Z8\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0004\b~\u0010\u007f\u001a\u0006\b\u0080\u0001\u0010\u0081\u0001R\u0019\u0010\u0082\u0001\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0082\u0001\u0010\u0083\u0001R\u0019\u0010\u0084\u0001\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0084\u0001\u0010\u0083\u0001R\u001b\u0010\u0085\u0001\u001a\u0004\u0018\u00010\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0085\u0001\u0010\u0086\u0001R\u001b\u0010\u0087\u0001\u001a\u0004\u0018\u00010\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\b\n\u0006\b\u0087\u0001\u0010\u0086\u0001R\u001e\u0010\u008a\u0001\u001a\u00020d8BX\u0082\u0084\u0002\u00a2\u0006\u000e\n\u0005\b\u0088\u0001\u0010f\u001a\u0005\b\u0089\u0001\u0010h\u00a8\u0006\u008b\u0001"}, d2={"Lat/hannibal2/skyhanni/api/storage/StorageApi;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "event", "", "onInventoryFullyOpened", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;", "onGuiContainerSlotClick", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;)V", "onTick", "onSecondPassed", "setupSaveJob", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onMinutePassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "", "name", "", "Lnet/minecraft/class_1799;", "inventory", "handleRead", "(Ljava/lang/String;Ljava/util/Collection;)V", "handlePrivateIslandRead", "(Ljava/util/Collection;)V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "position", "", "Lkotlin/Pair;", "Lnet/minecraft/class_2248;", "getNeighbourBlocks", "(Lat/hannibal2/skyhanni/utils/LorenzVec;)Ljava/util/List;", "Lat/hannibal2/skyhanni/events/BlockClickEvent;", "onBlockClick", "(Lat/hannibal2/skyhanni/events/BlockClickEvent;)V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebugDataCollect", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "", "isPrivateIslandStorageEnabled", "()Z", "Lat/hannibal2/skyhanni/api/storage/StorageSearchConsumer;", "search", "()Lat/hannibal2/skyhanni/api/storage/StorageSearchConsumer;", "", "getAllStorageData", "()Ljava/util/Map;", "pattern", "ignoreCase", "Lat/hannibal2/skyhanni/api/storage/StorageSearchResult;", "searchByName", "(Ljava/lang/String;Z)Ljava/util/List;", "itemId", "searchByItemId", "Ljava/util/UUID;", "uuid", "searchByUuid", "(Ljava/util/UUID;)Ljava/util/List;", "", "Lat/hannibal2/skyhanni/api/storage/StorageCategory;", "categories", "searchByCategory", "([Lat/hannibal2/skyhanni/api/storage/StorageCategory;)Ljava/util/List;", "storageName", "", "getPageFromStorageName", "(Ljava/lang/String;)Ljava/lang/Integer;", "getLocationFromStorageName", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;", "itemBackgroundRender", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryCloseEvent;", "onGuiContainerClose", "(Lat/hannibal2/skyhanni/events/InventoryCloseEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "renderWaypoints", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "", "toHighlightResults", "Ljava/util/List;", "getToHighlightResults", "()Ljava/util/List;", "currentInventoryResults", "getCurrentInventoryResults", "setCurrentInventoryResults", "(Ljava/util/List;)V", "Ljava/util/NavigableMap;", "Lat/hannibal2/skyhanni/data/model/SkyHanniInventoryContainer;", "getStorage", "()Ljava/util/NavigableMap;", "storage", "Lkotlinx/coroutines/Job;", "saveJob", "Lkotlinx/coroutines/Job;", "Lkotlinx/coroutines/sync/Mutex;", "saveMutex", "Lkotlinx/coroutines/sync/Mutex;", "Ljava/util/regex/Pattern;", "enderchestPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getEnderchestPattern", "()Ljava/util/regex/Pattern;", "enderchestPattern", "backpackPattern$delegate", "getBackpackPattern", "backpackPattern", "riftStoragePattern$delegate", "getRiftStoragePattern", "riftStoragePattern", "getAccessStorage", "accessStorage", "getEnderchest", "enderchest", "getBackpack", "backpack", "getRiftStorage", "riftStorage", "", "getMutableIslandChest", "mutableIslandChest", "getIslandChest", "islandChest", "value", "currentStorage", "Lat/hannibal2/skyhanni/data/model/SkyHanniInventoryContainer;", "getCurrentStorage", "()Lat/hannibal2/skyhanni/data/model/SkyHanniInventoryContainer;", "shouldReCheck", "Z", "shouldSave", "lastChestClicked", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "doubleChestCord", "unparsePrivateIslandChestPattern$delegate", "getUnparsePrivateIslandChestPattern", "unparsePrivateIslandChestPattern", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nStorageApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageApi.kt\nat/hannibal2/skyhanni/api/storage/StorageApi\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,392:1\n8#2:393\n8#2:395\n8#2:397\n8#2:426\n8#2:428\n8#2:430\n8#2:432\n1#3:394\n1#3:396\n1#3:398\n1#3:427\n1#3:429\n1#3:431\n1#3:433\n1563#4:399\n1634#4,3:400\n774#4:403\n865#4,2:404\n774#4:406\n865#4,2:407\n1563#4:409\n1634#4,3:410\n295#4,2:413\n1056#4:415\n1563#4:416\n1634#4,3:417\n1252#4,4:422\n1563#4:434\n1634#4,3:435\n1878#4,3:438\n774#4:441\n865#4,2:442\n1869#4,2:444\n1761#4,3:446\n465#5:420\n415#5:421\n*S KotlinDebug\n*F\n+ 1 StorageApi.kt\nat/hannibal2/skyhanni/api/storage/StorageApi\n*L\n105#1:393\n110#1:395\n115#1:397\n318#1:426\n321#1:428\n324#1:430\n353#1:432\n105#1:394\n110#1:396\n115#1:398\n318#1:427\n321#1:429\n324#1:431\n353#1:433\n138#1:399\n138#1:400,3\n195#1:403\n195#1:404,2\n219#1:406\n219#1:407,2\n228#1:409\n228#1:410,3\n238#1:413,2\n257#1:415\n257#1:416\n257#1:417,3\n274#1:422,4\n366#1:434\n366#1:435,3\n367#1:438,3\n381#1:441\n381#1:442,2\n381#1:444,2\n173#1:446,3\n274#1:420\n274#1:421\n*E\n"})
public final class StorageApi {
    @NotNull
    public static final StorageApi INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final List<StorageSearchResult> toHighlightResults;
    @NotNull
    private static List<StorageSearchResult> currentInventoryResults;
    @Nullable
    private static Job saveJob;
    @NotNull
    private static final Mutex saveMutex;
    @NotNull
    private static final RepoPattern enderchestPattern$delegate;
    @NotNull
    private static final RepoPattern backpackPattern$delegate;
    @NotNull
    private static final RepoPattern riftStoragePattern$delegate;
    @Nullable
    private static SkyHanniInventoryContainer currentStorage;
    private static boolean shouldReCheck;
    private static boolean shouldSave;
    @Nullable
    private static LorenzVec lastChestClicked;
    @Nullable
    private static LorenzVec doubleChestCord;
    @NotNull
    private static final RepoPattern unparsePrivateIslandChestPattern$delegate;

    private StorageApi() {
    }

    @NotNull
    public final List<StorageSearchResult> getToHighlightResults() {
        return toHighlightResults;
    }

    @NotNull
    public final List<StorageSearchResult> getCurrentInventoryResults() {
        return currentInventoryResults;
    }

    public final void setCurrentInventoryResults(@NotNull List<StorageSearchResult> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        currentInventoryResults = list;
    }

    private final NavigableMap<String, SkyHanniInventoryContainer> getStorage() {
        Object object = ProfileStorageData.INSTANCE.getStorageProfiles();
        if (object == null || (object = ((StorageData.ProfileSpecific)object).getData()) == null) {
            object = new TreeMap();
        }
        return object;
    }

    private final Pattern getEnderchestPattern() {
        return (Pattern)enderchestPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final Pattern getBackpackPattern() {
        return (Pattern)backpackPattern$delegate.getValue(this, $$delegatedProperties[1]);
    }

    private final Pattern getRiftStoragePattern() {
        return (Pattern)riftStoragePattern$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @NotNull
    public final Map<String, SkyHanniInventoryContainer> getAccessStorage() {
        return this.getStorage();
    }

    @NotNull
    public final Map<String, SkyHanniInventoryContainer> getEnderchest() {
        return StringUtils.INSTANCE.subMapOfStringsStartingWith("Ender Chest", this.getStorage());
    }

    @NotNull
    public final Map<String, SkyHanniInventoryContainer> getBackpack() {
        return StringUtils.INSTANCE.subMapOfStringsStartingWith("Backpack", this.getStorage());
    }

    @NotNull
    public final Map<String, SkyHanniInventoryContainer> getRiftStorage() {
        return StringUtils.INSTANCE.subMapOfStringsStartingWith("Rift Storage", this.getStorage());
    }

    private final Map<String, SkyHanniInventoryContainer> getMutableIslandChest() {
        return StringUtils.INSTANCE.subMapOfStringsStartingWith("Private Island Chest", this.getStorage());
    }

    @NotNull
    public final Map<String, SkyHanniInventoryContainer> getIslandChest() {
        return this.getMutableIslandChest();
    }

    @Nullable
    public final SkyHanniInventoryContainer getCurrentStorage() {
        return currentStorage;
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onInventoryFullyOpened(@NotNull InventoryFullyOpenedEvent event2) {
        Pattern $this$matchMatcher$iv;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getEnderchestPattern();
        String text$iv = event2.getInventoryName();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$onInventoryFullyOpened_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            String string = RegexUtils.INSTANCE.groupOrNull($this$onInventoryFullyOpened_u24lambda_u240, "page");
            int page = string != null ? Integer.parseInt(string) : 1;
            INSTANCE.handleRead("Ender Chest " + page, event2.getInventoryItemsWithNull().values());
            return;
        }
        RegexUtils this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getBackpackPattern();
        text$iv = event2.getInventoryName();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(text$iv);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$onInventoryFullyOpened_u24lambda_u241 = it$iv;
            boolean bl3 = false;
            String string = RegexUtils.INSTANCE.groupOrNull($this$onInventoryFullyOpened_u24lambda_u241, "page");
            int page = string != null ? Integer.parseInt(string) : 1;
            INSTANCE.handleRead("Backpack " + page, event2.getInventoryItemsWithNull().values());
            return;
        }
        this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getRiftStoragePattern();
        text$iv = event2.getInventoryName();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(text$iv);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$onInventoryFullyOpened_u24lambda_u242 = it$iv;
            boolean bl4 = false;
            String string = RegexUtils.INSTANCE.groupOrNull($this$onInventoryFullyOpened_u24lambda_u242, "page");
            int page = string != null ? Integer.parseInt(string) : 1;
            INSTANCE.handleRead("Rift Storage " + page, event2.getInventoryItemsWithNull().values());
            return;
        }
        if (!IslandType.PRIVATE_ISLAND.isCurrent() || !this.isPrivateIslandStorageEnabled()) {
            return;
        }
        if (InventoryUtils.INSTANCE.isInNormalChest(event2.getInventoryName())) {
            this.handlePrivateIslandRead(event2.getInventoryItemsWithNull().values());
        }
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onGuiContainerSlotClick(@NotNull GuiContainerEvent.SlotClickEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (currentStorage == null) {
            return;
        }
        shouldReCheck = true;
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(onlyOnSkyblock=true)
    public final void onTick() {
        if (!shouldReCheck) {
            return;
        }
        SkyHanniInventoryContainer skyHanniInventoryContainer = currentStorage;
        if (skyHanniInventoryContainer != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = InventoryUtils.INSTANCE.getItemsInOpenChestWithNull();
            SkyHanniInventoryContainer skyHanniInventoryContainer2 = skyHanniInventoryContainer;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                class_1735 class_17352 = (class_1735)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.method_7677());
            }
            skyHanniInventoryContainer2.setItems(CollectionsKt.drop((Iterable)((List)destination$iv$iv), (int)9));
        }
        shouldReCheck = false;
        shouldSave = true;
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onSecondPassed() {
        block4: {
            block3: {
                if (!shouldSave) break block3;
                Job job2 = saveJob;
                boolean bl = job2 != null ? job2.isActive() : false;
                if (!bl) break block4;
            }
            return;
        }
        this.setupSaveJob();
    }

    private final void setupSaveJob() {
        saveJob = SkyHanniMod.launchIOCoroutineWithMutex-exY8QGI$default(SkyHanniMod.INSTANCE, "storage api save", saveMutex, 0L, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (!StorageApi.access$getShouldSave$p()) {
                            return Unit.INSTANCE;
                        }
                        SkyHanniMod.INSTANCE.getConfigManager().saveConfig(ConfigFileType.STORAGE, "Updated Items");
                        StorageApi.access$setShouldSave$p(false);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 4, null);
    }

    @HandleEvent(onlyOnIsland=IslandType.PRIVATE_ISLAND)
    public final void onMinutePassed(@NotNull SecondPassedEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!event2.repeatSeconds(60) || !this.isPrivateIslandStorageEnabled()) {
            return;
        }
        CollectionUtils.INSTANCE.removeIf(this.getMutableIslandChest(), StorageApi::onMinutePassed$lambda$6);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleRead(String name2, Collection<class_1799> inventory) {
        void $this$filterTo$iv$iv;
        List saneInventory = CollectionsKt.drop((Iterable)inventory, (int)9);
        SkyHanniInventoryContainer old = (SkyHanniInventoryContainer)this.getStorage().get(name2);
        SkyHanniInventoryContainer stored = null;
        if (old == null) {
            stored = new SkyHanniInventoryContainer(name2, 9, saneInventory, null, null, null, 56, null);
            ((Map)this.getStorage()).put(name2, stored);
            return;
        }
        stored = old;
        old.setItems(saneInventory);
        currentStorage = stored;
        shouldSave = true;
        Iterable $this$filter$iv = toHighlightResults;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StorageSearchResult it = (StorageSearchResult)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getStorageName(), (Object)name2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        currentInventoryResults = (List)destination$iv$iv;
        toHighlightResults.removeAll((Collection)currentInventoryResults);
    }

    /*
     * WARNING - void declaration
     */
    private final void handlePrivateIslandRead(Collection<class_1799> inventory) {
        void $this$filterTo$iv$iv;
        LorenzVec lorenzVec = lastChestClicked;
        if (lorenzVec == null) {
            StorageApi $this$handlePrivateIslandRead_u24lambda_u248 = this;
            boolean bl = false;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"inventory", inventory)};
            ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Failed to save chest", "Failed to save chest on Private Island", pairArray, false, false, false, null, 120, null);
            return;
        }
        LorenzVec primary = lorenzVec;
        LorenzVec secondary = doubleChestCord;
        String name2 = "Private Island Chest " + primary;
        List saneInventory = CollectionsKt.toList((Iterable)inventory);
        SkyHanniInventoryContainer old = (SkyHanniInventoryContainer)this.getStorage().get(name2);
        SkyHanniInventoryContainer stored = null;
        if (old == null) {
            stored = new SkyHanniInventoryContainer(name2, 9, saneInventory, "Private Island Chest", primary, secondary);
            ((Map)this.getStorage()).put(name2, stored);
            return;
        }
        stored = old;
        old.setItems(saneInventory);
        currentStorage = stored;
        shouldSave = true;
        Iterable $this$filter$iv = toHighlightResults;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StorageSearchResult it = (StorageSearchResult)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getStorageName(), (Object)name2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        currentInventoryResults = (List)destination$iv$iv;
        toHighlightResults.removeAll((Collection)currentInventoryResults);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<LorenzVec, class_2248>> getNeighbourBlocks(LorenzVec position) {
        void $this$mapTo$iv$iv;
        Object[] objectArray = new LorenzVec[]{LorenzVec.add$default(position, 1, 0, 0, 6, null), LorenzVec.add$default(position, -1, 0, 0, 6, null), LorenzVec.add$default(position, 0, 0, 1, 3, null), LorenzVec.add$default(position, 0, 0, -1, 3, null)};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LorenzVec lorenzVec = (LorenzVec)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)BlockUtils.INSTANCE.getBlockAt((LorenzVec)it)));
        }
        return (List)destination$iv$iv;
    }

    @HandleEvent(onlyOnIsland=IslandType.PRIVATE_ISLAND)
    public final void onBlockClick(@NotNull BlockClickEvent event2) {
        LorenzVec otherChest;
        Object v1;
        block8: {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            if (event2.getClickType() != ClickType.RIGHT_CLICK) {
                return;
            }
            if (!this.isPrivateIslandStorageEnabled()) {
                return;
            }
            class_2248 class_22482 = event2.getGetBlockState().method_26204();
            class_2281 class_22812 = class_22482 instanceof class_2281 ? (class_2281)class_22482 : null;
            if (class_22812 == null) {
                return;
            }
            class_2281 chest = class_22812;
            Iterable $this$firstOrNull$iv = this.getNeighbourBlocks(event2.getPosition());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSecond(), (Object)chest)) continue;
                v1 = element$iv;
                break block8;
            }
            v1 = null;
        }
        Pair pair = v1;
        LorenzVec lorenzVec = otherChest = pair != null ? (LorenzVec)pair.getFirst() : null;
        if (otherChest == null) {
            lastChestClicked = event2.getPosition();
            doubleChestCord = null;
        } else if (otherChest.lengthSquared() > event2.getPosition().lengthSquared()) {
            lastChestClicked = event2.getPosition();
            doubleChestCord = otherChest;
        } else {
            lastChestClicked = otherChest;
            doubleChestCord = event2.getPosition();
        }
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onDebugDataCollect(@NotNull DebugDataCollectEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        event2.title("Storage Data");
        if (this.getStorage().isEmpty()) {
            event2.addIrrelevant("Empty");
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Collection collection = this.getStorage().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$sortedBy$iv = collection;
            boolean $i$f$sortedBy = false;
            $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    SkyHanniInventoryContainer it = (SkyHanniInventoryContainer)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getInternalName());
                    it = (SkyHanniInventoryContainer)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getInternalName())));
                }
            });
            DebugDataCollectEvent debugDataCollectEvent = event2;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SkyHanniInventoryContainer skyHanniInventoryContainer = (SkyHanniInventoryContainer)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(CollectionsKt.plus((Collection)it.getDebug(), (Iterable)CollectionsKt.listOf((Object)"")));
            }
            debugDataCollectEvent.addIrrelevant(CollectionsKt.flatten((Iterable)((List)destination$iv$iv)));
        }
    }

    private final boolean isPrivateIslandStorageEnabled() {
        return SkyHanniMod.feature.getInventory().getSavePrivateIslandChests();
    }

    @NotNull
    public final StorageSearchConsumer search() {
        return new StorageSearchConsumer();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<class_1799>> getAllStorageData() {
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv = this.getStorage();
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            SkyHanniInventoryContainer container = (SkyHanniInventoryContainer)entry2.getValue();
            List<class_1799> list = container.getItems();
            map3.put(k, list);
        }
        return destination$iv$iv;
    }

    @NotNull
    public final List<StorageSearchResult> searchByName(@NotNull String pattern, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        return StorageSearchConsumerKt.filterByName(this.search(), pattern, ignoreCase).getResults();
    }

    public static /* synthetic */ List searchByName$default(StorageApi storageApi, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return storageApi.searchByName(string, bl);
    }

    @NotNull
    public final List<StorageSearchResult> searchByItemId(@NotNull String itemId, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)itemId, (String)"itemId");
        return StorageSearchConsumerKt.filterByItemId(this.search(), itemId, ignoreCase).getResults();
    }

    public static /* synthetic */ List searchByItemId$default(StorageApi storageApi, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return storageApi.searchByItemId(string, bl);
    }

    @NotNull
    public final List<StorageSearchResult> searchByUuid(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return StorageSearchConsumerKt.filterByUuid(this.search(), uuid).getResults();
    }

    @NotNull
    public final List<StorageSearchResult> searchByCategory(StorageCategory ... categories) {
        Intrinsics.checkNotNullParameter((Object)categories, (String)"categories");
        return StorageSearchConsumerKt.filterByCategory(this.search(), Arrays.copyOf(categories, categories.length)).getResults();
    }

    @Nullable
    public final Integer getPageFromStorageName(@NotNull String storageName) {
        Intrinsics.checkNotNullParameter((Object)storageName, (String)"storageName");
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = this.getEnderchestPattern();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(storageName);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$getPageFromStorageName_u24lambda_u2415 = it$iv;
            boolean bl2 = false;
            String string = RegexUtils.INSTANCE.groupOrNull($this$getPageFromStorageName_u24lambda_u2415, "page");
            return string != null ? Integer.parseInt(string) : 1;
        }
        RegexUtils this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getBackpackPattern();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(storageName);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$getPageFromStorageName_u24lambda_u2416 = it$iv;
            boolean bl3 = false;
            String string = RegexUtils.INSTANCE.groupOrNull($this$getPageFromStorageName_u24lambda_u2416, "page");
            return string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
        }
        this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getRiftStoragePattern();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(storageName);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$getPageFromStorageName_u24lambda_u2417 = it$iv;
            boolean bl4 = false;
            String string = RegexUtils.INSTANCE.groupOrNull($this$getPageFromStorageName_u24lambda_u2417, "page");
            return string != null ? Integer.parseInt(string) : 1;
        }
        if (StringsKt.startsWith$default((String)storageName, (String)"Ender Chest ", (boolean)false, (int)2, null)) {
            return StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)storageName, (CharSequence)"Ender Chest "));
        }
        if (StringsKt.startsWith$default((String)storageName, (String)"Backpack ", (boolean)false, (int)2, null)) {
            return StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)storageName, (CharSequence)"Backpack "));
        }
        if (StringsKt.startsWith$default((String)storageName, (String)"Rift Storage ", (boolean)false, (int)2, null)) {
            return StringsKt.toIntOrNull((String)StringsKt.removePrefix((String)storageName, (CharSequence)"Rift Storage "));
        }
        return null;
    }

    private final Pattern getUnparsePrivateIslandChestPattern() {
        return (Pattern)unparsePrivateIslandChestPattern$delegate.getValue(this, $$delegatedProperties[3]);
    }

    @Nullable
    public final LorenzVec getLocationFromStorageName(@NotNull String storageName) {
        LorenzVec lorenzVec;
        Intrinsics.checkNotNullParameter((Object)storageName, (String)"storageName");
        if (!StringsKt.startsWith$default((String)storageName, (String)"Private Island Chest", (boolean)false, (int)2, null)) {
            return null;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern $this$matchMatcher$iv = this.getUnparsePrivateIslandChestPattern();
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(storageName);
        boolean bl = false;
        if (it$iv.matches()) {
            Double z;
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$getLocationFromStorageName_u24lambda_u2418 = it$iv;
            boolean bl2 = false;
            String string = RegexUtils.INSTANCE.groupOrNull($this$getLocationFromStorageName_u24lambda_u2418, "x");
            Double x = string != null ? StringsKt.toDoubleOrNull((String)string) : null;
            String string2 = RegexUtils.INSTANCE.groupOrNull($this$getLocationFromStorageName_u24lambda_u2418, "y");
            Double y = string2 != null ? StringsKt.toDoubleOrNull((String)string2) : null;
            String string3 = RegexUtils.INSTANCE.groupOrNull($this$getLocationFromStorageName_u24lambda_u2418, "z");
            Double d = z = string3 != null ? StringsKt.toDoubleOrNull((String)string3) : null;
            lorenzVec = x != null && y != null && z != null ? new LorenzVec(x, y, z) : null;
        } else {
            lorenzVec = null;
        }
        return lorenzVec;
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void itemBackgroundRender(@NotNull GuiContainerEvent.BackgroundDrawnEvent event2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (currentInventoryResults.isEmpty()) {
            return;
        }
        int offSet = ((StorageSearchResult)CollectionsKt.first(currentInventoryResults)).getCategory().getIndexOffSet();
        Iterable $this$map$iv = currentInventoryResults;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StorageSearchResult storageSearchResult = (StorageSearchResult)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSlotIndex() + offSet);
        }
        HashSet slots = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
        Iterable $this$forEachIndexed$iv = InventoryUtils.INSTANCE.getItemsInOpenChestWithNull();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void slot;
            int n;
            Object item$iv$iv;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (class_1735)item$iv;
            int index = n;
            boolean bl = false;
            if (!slots.contains(index)) continue;
            RenderUtils.INSTANCE.highlight((class_1735)slot, LorenzColor.YELLOW);
        }
    }

    @HandleEvent
    public final void onGuiContainerClose(@NotNull InventoryCloseEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        currentInventoryResults = CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent(onlyOnIsland=IslandType.PRIVATE_ISLAND)
    public final void renderWaypoints(@NotNull SkyHanniRenderWorldEvent event2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Iterable $this$filter$iv = toHighlightResults;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StorageSearchResult it = (StorageSearchResult)element$iv$iv;
            boolean bl = false;
            if (!StorageSearchResultKt.isPrivateIslandChest(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LorenzVec location;
            StorageSearchResult it = (StorageSearchResult)element$iv;
            boolean bl = false;
            if (it.getLocation() == null) continue;
            Color color = Color.YELLOW;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"YELLOW");
            WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event2, location, color, true, false, 0.0, 0.0, 0.0, 0.0f, false, 496, null);
        }
    }

    private static final boolean onMinutePassed$lambda$6(Map.Entry entry) {
        boolean bl;
        boolean bl2;
        SkyHanniInventoryContainer chest;
        block11: {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
            chest = (SkyHanniInventoryContainer)entry.getValue();
            if (chest.getPrimaryCords() == null) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Chest", (Object)chest), TuplesKt.to((Object)"Storage", INSTANCE.getAccessStorage())};
                ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "Something went wrong during Private Island cleanup", "Tried to remove a container that isn't a chest", pairArray, false, false, false, null, 120, null);
                return false;
            }
            if (LocationUtils.INSTANCE.distanceSqToPlayer(chest.getPrimaryCords()) > 900.0) {
                bl2 = false;
            } else if (!(BlockUtils.INSTANCE.getBlockAt(chest.getPrimaryCords()) instanceof class_2281)) {
                bl2 = true;
            } else if (chest.getSecondaryCords() == null) {
                Iterable $this$any$iv = INSTANCE.getNeighbourBlocks(chest.getPrimaryCords());
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl3 = false;
                        if (!(it.getSecond() instanceof class_2281)) continue;
                        bl2 = true;
                        break block11;
                    }
                    bl2 = false;
                }
            } else {
                bl2 = !(BlockUtils.INSTANCE.getBlockAt(chest.getSecondaryCords()) instanceof class_2281);
            }
        }
        boolean it = bl = bl2;
        boolean bl4 = false;
        if (it) {
            ChatUtils.debug$default(ChatUtils.INSTANCE, "Removed Private Island Chest at: " + chest.getPrimaryCords(), false, 2, null);
        }
        return bl;
    }

    public static final /* synthetic */ boolean access$getShouldSave$p() {
        return shouldSave;
    }

    public static final /* synthetic */ void access$setShouldSave$p(boolean bl) {
        shouldSave = bl;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StorageApi.class, "enderchestPattern", "getEnderchestPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StorageApi.class, "backpackPattern", "getBackpackPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StorageApi.class, "riftStoragePattern", "getRiftStoragePattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(StorageApi.class, "unparsePrivateIslandChestPattern", "getUnparsePrivateIslandChestPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new StorageApi();
        toHighlightResults = new ArrayList();
        currentInventoryResults = CollectionsKt.emptyList();
        saveMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        enderchestPattern$delegate = RepoPattern.Companion.pattern("storage.enderchest", "Ender Chest(?: \\((?<page>\\d+)/\\d+\\))?");
        backpackPattern$delegate = RepoPattern.Companion.pattern("storage.backpack", ".* Backpack\u00a7r \\(Slot #(?<page>\\d+)\\)");
        riftStoragePattern$delegate = RepoPattern.Companion.pattern("storage.rift", "Rift Storage(?: \\((?<page>\\d+)/\\d+\\))?");
        unparsePrivateIslandChestPattern$delegate = RepoPattern.Companion.pattern("storage.privateislandchestunparse", "Private Island Chest LorenzVec\\(x=(?<x>-?\\d+(\\.\\d+)?), y=(?<y>-?\\d+(\\.\\d+)?), z=(?<z>-?\\d+(\\.\\d+)?)\\)");
    }
}

