/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.api.storage;

import at.hannibal2.skyhanni.api.storage.StorageCategory;
import at.hannibal2.skyhanni.data.HypixelData;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b!\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0011\u0010\u0010J\r\u0010\u0012\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0010J\u0015\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u001c\u0010\u0010J\u0010\u0010\u001d\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u001f\u0010 J\u0012\u0010!\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0004\b!\u0010\"JP\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001\u00a2\u0006\u0004\b#\u0010$J\u001a\u0010&\u001a\u00020\u00132\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b&\u0010'J\u0010\u0010(\u001a\u00020\u0004H\u00d6\u0001\u00a2\u0006\u0004\b(\u0010\u001bJ\u0010\u0010)\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b)\u0010\u0010R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010*\u001a\u0004\b+\u0010\u0019R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010,\u001a\u0004\b-\u0010\u001bR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010.\u001a\u0004\b/\u0010\u0010R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u00100\u001a\u0004\b1\u0010\u001eR\u0019\u0010\n\u001a\u0004\u0018\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\n\u00102\u001a\u0004\b3\u0010 R\u0019\u0010\f\u001a\u0004\u0018\u00010\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u00104\u001a\u0004\b5\u0010\"\u00a8\u00066"}, d2={"Lat/hannibal2/skyhanni/api/storage/StorageSearchResult;", "", "Lnet/minecraft/class_1799;", "item", "", "slotIndex", "", "storageName", "Lat/hannibal2/skyhanni/api/storage/StorageCategory;", "category", "page", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "location", "<init>", "(Lnet/minecraft/class_1799;ILjava/lang/String;Lat/hannibal2/skyhanni/api/storage/StorageCategory;Ljava/lang/Integer;Lat/hannibal2/skyhanni/utils/LorenzVec;)V", "getUniqueLocation", "()Ljava/lang/String;", "getUniqueSlotLocation", "getDisplayName", "", "allowServerChange", "", "runAccess", "(Z)V", "component1", "()Lnet/minecraft/class_1799;", "component2", "()I", "component3", "component4", "()Lat/hannibal2/skyhanni/api/storage/StorageCategory;", "component5", "()Ljava/lang/Integer;", "component6", "()Lat/hannibal2/skyhanni/utils/LorenzVec;", "copy", "(Lnet/minecraft/class_1799;ILjava/lang/String;Lat/hannibal2/skyhanni/api/storage/StorageCategory;Ljava/lang/Integer;Lat/hannibal2/skyhanni/utils/LorenzVec;)Lat/hannibal2/skyhanni/api/storage/StorageSearchResult;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Lnet/minecraft/class_1799;", "getItem", "I", "getSlotIndex", "Ljava/lang/String;", "getStorageName", "Lat/hannibal2/skyhanni/api/storage/StorageCategory;", "getCategory", "Ljava/lang/Integer;", "getPage", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "getLocation", "1.21.5"})
public final class StorageSearchResult {
    @NotNull
    private final class_1799 item;
    private final int slotIndex;
    @NotNull
    private final String storageName;
    @NotNull
    private final StorageCategory category;
    @Nullable
    private final Integer page;
    @Nullable
    private final LorenzVec location;

    public StorageSearchResult(@NotNull class_1799 item2, int slotIndex, @NotNull String storageName, @NotNull StorageCategory category, @Nullable Integer page, @Nullable LorenzVec location) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        Intrinsics.checkNotNullParameter((Object)storageName, (String)"storageName");
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        this.item = item2;
        this.slotIndex = slotIndex;
        this.storageName = storageName;
        this.category = category;
        this.page = page;
        this.location = location;
    }

    public /* synthetic */ StorageSearchResult(class_1799 class_17992, int n, String string, StorageCategory storageCategory, Integer n2, LorenzVec lorenzVec, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            n2 = null;
        }
        if ((n3 & 0x20) != 0) {
            lorenzVec = null;
        }
        this(class_17992, n, string, storageCategory, n2, lorenzVec);
    }

    @NotNull
    public final class_1799 getItem() {
        return this.item;
    }

    public final int getSlotIndex() {
        return this.slotIndex;
    }

    @NotNull
    public final String getStorageName() {
        return this.storageName;
    }

    @NotNull
    public final StorageCategory getCategory() {
        return this.category;
    }

    @Nullable
    public final Integer getPage() {
        return this.page;
    }

    @Nullable
    public final LorenzVec getLocation() {
        return this.location;
    }

    @NotNull
    public final String getUniqueLocation() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.category.ordinal()]) {
            case 1 -> {
                Integer v0 = this.page;
                yield "enderchest_page_" + (v0 != null ? v0 : 1);
            }
            case 2 -> {
                Integer v2 = this.page;
                yield "backpack_page_" + (v2 != null ? v2 : 1);
            }
            case 3 -> {
                Integer v3 = this.page;
                yield "rift_storage_page_" + (v3 != null ? v3 : 1);
            }
            case 4 -> {
                LorenzVec v4 = this.location;
                yield "private_island_" + (v4 != null ? v4.toCleanString(" ") : null);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final String getUniqueSlotLocation() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.category.ordinal()]) {
            case 1 -> {
                Integer v0 = this.page;
                yield "enderchest_page_" + (v0 != null ? v0 : 1) + "_slot_" + this.slotIndex;
            }
            case 2 -> {
                Integer v2 = this.page;
                yield "backpack_page_" + (v2 != null ? v2 : 1) + "_slot_" + this.slotIndex;
            }
            case 3 -> {
                Integer v3 = this.page;
                yield "rift_storage_page_" + (v3 != null ? v3 : 1) + "_slot_" + this.slotIndex;
            }
            case 4 -> {
                LorenzVec v4 = this.location;
                yield "private_island_" + (v4 != null ? v4.toCleanString(" ") : null) + "_slot_" + this.slotIndex;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final String getDisplayName() {
        String itemName2 = TextCompatKt.formattedTextCompatLeadingWhiteLessResets(this.item.method_7964());
        return switch (WhenMappings.$EnumSwitchMapping$0[this.category.ordinal()]) {
            case 1 -> itemName2 + "\u00a7f in Ender Chest" + (String)(this.page != null ? " (Page " + this.page + ")" : "");
            case 2 -> itemName2 + "\u00a7f in Backpack" + (String)(this.page != null ? " (Page " + this.page + ")" : "");
            case 3 -> itemName2 + "\u00a7f in Rift Storage" + (String)(this.page != null ? " (Page " + this.page + ")" : "");
            case 4 -> {
                LorenzVec v1 = this.location;
                yield itemName2 + "\u00a7f in Private Island Chest at " + (v1 != null ? v1.toCleanString(" ") : null);
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final void runAccess(boolean allowServerChange) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.category.ordinal()]) {
            case 1: {
                Integer n = this.page;
                HypixelCommands.INSTANCE.enderChest(n != null ? n : 1);
                break;
            }
            case 2: {
                Integer n = this.page;
                HypixelCommands.INSTANCE.backPack(n != null ? n : 1);
                break;
            }
            case 3: {
                Function0 consumer = StorageSearchResult::runAccess$lambda$0;
                if (allowServerChange) {
                    consumer.invoke();
                    break;
                }
                if (HypixelData.INSTANCE.getSkyBlockIsland() != IslandType.THE_RIFT) break;
                ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, this.getDisplayName() + " Cant access from here. Click to warp to the rift.", consumer, null, 0L, false, null, false, false, 252, null);
                break;
            }
            case 4: {
                Function0 consumer = StorageSearchResult::runAccess$lambda$1;
                if (allowServerChange) {
                    consumer.invoke();
                    break;
                }
                if (HypixelData.INSTANCE.getSkyBlockIsland() != IslandType.PRIVATE_ISLAND) break;
                ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, this.getDisplayName() + " Cant access from here. Click to warp to the Private Island.", consumer, null, 0L, false, null, false, false, 252, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    @NotNull
    public final class_1799 component1() {
        return this.item;
    }

    public final int component2() {
        return this.slotIndex;
    }

    @NotNull
    public final String component3() {
        return this.storageName;
    }

    @NotNull
    public final StorageCategory component4() {
        return this.category;
    }

    @Nullable
    public final Integer component5() {
        return this.page;
    }

    @Nullable
    public final LorenzVec component6() {
        return this.location;
    }

    @NotNull
    public final StorageSearchResult copy(@NotNull class_1799 item2, int slotIndex, @NotNull String storageName, @NotNull StorageCategory category, @Nullable Integer page, @Nullable LorenzVec location) {
        Intrinsics.checkNotNullParameter((Object)item2, (String)"item");
        Intrinsics.checkNotNullParameter((Object)storageName, (String)"storageName");
        Intrinsics.checkNotNullParameter((Object)((Object)category), (String)"category");
        return new StorageSearchResult(item2, slotIndex, storageName, category, page, location);
    }

    public static /* synthetic */ StorageSearchResult copy$default(StorageSearchResult storageSearchResult, class_1799 class_17992, int n, String string, StorageCategory storageCategory, Integer n2, LorenzVec lorenzVec, int n3, Object object) {
        if ((n3 & 1) != 0) {
            class_17992 = storageSearchResult.item;
        }
        if ((n3 & 2) != 0) {
            n = storageSearchResult.slotIndex;
        }
        if ((n3 & 4) != 0) {
            string = storageSearchResult.storageName;
        }
        if ((n3 & 8) != 0) {
            storageCategory = storageSearchResult.category;
        }
        if ((n3 & 0x10) != 0) {
            n2 = storageSearchResult.page;
        }
        if ((n3 & 0x20) != 0) {
            lorenzVec = storageSearchResult.location;
        }
        return storageSearchResult.copy(class_17992, n, string, storageCategory, n2, lorenzVec);
    }

    @NotNull
    public String toString() {
        return "StorageSearchResult(item=" + this.item + ", slotIndex=" + this.slotIndex + ", storageName=" + this.storageName + ", category=" + this.category + ", page=" + this.page + ", location=" + this.location + ")";
    }

    public int hashCode() {
        int result2 = this.item.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.slotIndex);
        result2 = result2 * 31 + this.storageName.hashCode();
        result2 = result2 * 31 + this.category.hashCode();
        result2 = result2 * 31 + (this.page == null ? 0 : ((Object)this.page).hashCode());
        result2 = result2 * 31 + (this.location == null ? 0 : this.location.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StorageSearchResult)) {
            return false;
        }
        StorageSearchResult storageSearchResult = (StorageSearchResult)other;
        if (!Intrinsics.areEqual((Object)this.item, (Object)storageSearchResult.item)) {
            return false;
        }
        if (this.slotIndex != storageSearchResult.slotIndex) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.storageName, (Object)storageSearchResult.storageName)) {
            return false;
        }
        if (this.category != storageSearchResult.category) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.page, (Object)storageSearchResult.page)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.location, (Object)storageSearchResult.location);
    }

    private static final Unit runAccess$lambda$0() {
        HypixelCommands.INSTANCE.warp("rift");
        return Unit.INSTANCE;
    }

    private static final Unit runAccess$lambda$1() {
        if (HypixelData.INSTANCE.getSkyBlockIsland() != IslandType.PRIVATE_ISLAND) {
            HypixelCommands.INSTANCE.warp("home");
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StorageCategory.values().length];
            try {
                nArray[StorageCategory.ENDER_CHEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageCategory.BACKPACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageCategory.RIFT_STORAGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StorageCategory.PRIVATE_ISLAND_CHEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

