/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.data;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.config.features.misc.TrackerConfig;
import at.hannibal2.skyhanni.data.ItemAddManager;
import at.hannibal2.skyhanni.deps.moulconfig.observer.Property;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.ItemAddEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\f\u0010\u000bJ\u001b\u0010\u0010\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0019\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\"\u0010\u001b\u001a\u00020\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001a\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\"\u0010 \u001a\u00020\u00188\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010\u001a\u001a\u0004\b!\u0010\u001d\"\u0004\b\"\u0010\u001f\u00a8\u0006#"}, d2={"Lat/hannibal2/skyhanni/data/TrackerManager;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ConfigLoadEvent;", "event", "", "onConfigLoad", "(Lat/hannibal2/skyhanni/events/ConfigLoadEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent;", "onRenderOverlayFirst", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent;)V", "onRenderOverlayLast", "", "", "args", "commandEditTracker", "([Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "Lat/hannibal2/skyhanni/events/ItemAddEvent;", "onItemAdd", "(Lat/hannibal2/skyhanni/events/ItemAddEvent;)V", "", "hasChanged", "Z", "dirty", "getDirty", "()Z", "setDirty", "(Z)V", "commandEditTrackerSuccess", "getCommandEditTrackerSuccess", "setCommandEditTrackerSuccess", "1.21.5"})
public final class TrackerManager {
    @NotNull
    public static final TrackerManager INSTANCE = new TrackerManager();
    private static boolean hasChanged;
    private static boolean dirty;
    private static boolean commandEditTrackerSuccess;

    private TrackerManager() {
    }

    public final boolean getDirty() {
        return dirty;
    }

    public final void setDirty(boolean bl) {
        dirty = bl;
    }

    public final boolean getCommandEditTrackerSuccess() {
        return commandEditTrackerSuccess;
    }

    public final void setCommandEditTrackerSuccess(boolean bl) {
        commandEditTrackerSuccess = bl;
    }

    @HandleEvent
    public final void onConfigLoad(@NotNull ConfigLoadEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        TrackerConfig $this$onConfigLoad_u24lambda_u241 = SkyHanniMod.feature.misc.getTracker();
        boolean bl = false;
        Property[] propertyArray = new Property[]{$this$onConfigLoad_u24lambda_u241.getTextOrder(), $this$onConfigLoad_u24lambda_u241.getShowTable(), $this$onConfigLoad_u24lambda_u241.getItemsShown()};
        ConditionalUtils.INSTANCE.onToggle(propertyArray, TrackerManager::onConfigLoad$lambda$1$lambda$0);
    }

    @HandleEvent(priority=-2)
    public final void onRenderOverlayFirst(@NotNull GuiRenderEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (hasChanged) {
            dirty = true;
        }
    }

    @HandleEvent(priority=2)
    public final void onRenderOverlayLast(@NotNull GuiRenderEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (hasChanged) {
            dirty = false;
            hasChanged = false;
        }
    }

    public final void commandEditTracker(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        if (args.length < 2) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Usage: /shedittracker <item name> <amount>", false, 2, null);
            return;
        }
        Integer n = NumberUtil.INSTANCE.formatIntOrUserError((String)ArraysKt.last((Object[])args));
        if (n == null) {
            return;
        }
        int amount = n;
        if (amount == 0) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Amount can not be zero!", false, 2, null);
            return;
        }
        String rawName = CollectionsKt.joinToString$default((Iterable)ArraysKt.dropLast((Object[])args, (int)1), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        NeuInternalName internalName2 = NeuInternalName.Companion.fromItemNameOrInternalName(rawName);
        if (!internalName2.isKnownItem()) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "No item found for '" + rawName + "'!", false, null, false, false, null, 62, null);
            return;
        }
        commandEditTrackerSuccess = false;
        new ItemAddEvent(internalName2, amount, ItemAddManager.Source.COMMAND).post();
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        event2.registerBrigadier("shedittracker", (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)TrackerManager::onCommandRegistration$lambda$3));
    }

    @HandleEvent(priority=2)
    public final void onItemAdd(@NotNull ItemAddEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getSource() != ItemAddManager.Source.COMMAND || event2.isCancelled()) {
            return;
        }
        if (!commandEditTrackerSuccess) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Could not edit the Item Tracker! Does this item belong to this tracker? Is the tracker active right now?", false, 2, null);
        }
    }

    private static final void onConfigLoad$lambda$1$lambda$0() {
        hasChanged = true;
    }

    private static final Unit onCommandRegistration$lambda$3$lambda$2(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.commandEditTracker(it);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$3(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Changes the tracked item amount for Diana, Fishing, Pest, Excavator, and Slayer Item Trackers.");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_BUG_FIX);
        $this$registerBrigadier.legacyCallbackArgs((Function1<String[], Unit>)((Function1)TrackerManager::onCommandRegistration$lambda$3$lambda$2));
        return Unit.INSTANCE;
    }
}

