/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.fishing.BarnTimerConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.mob.Mob;
import at.hannibal2.skyhanni.data.title.TitleManager;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.MobEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.fishing.SeaCreatureFishEvent;
import at.hannibal2.skyhanni.events.minecraft.KeyDownEvent;
import at.hannibal2.skyhanni.features.fishing.FishingApi;
import at.hannibal2.skyhanni.features.fishing.SeaCreatureManager;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.RecalculatingValue;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TimeUnit;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.collection.TimeLimitedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0003J\u000f\u0010\u0014\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0003J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0003J\u000f\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u001c\u0010\u0003J\u0017\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020#H\u0007\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b&\u0010\u0003J\u000f\u0010'\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b'\u0010\u001bJ\u0017\u0010)\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020(H\u0007\u00a2\u0006\u0004\b)\u0010*R\u0014\u0010.\u001a\u00020+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u00100\u001a\u00020/8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b0\u00101R \u00105\u001a\u000e\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u000204028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0016\u00107\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0018\u00109\u001a\u0004\u0018\u00010 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0018\u0010;\u001a\u0004\u0018\u00010 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010:R\u0016\u0010=\u001a\u00020<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u0018\u0010?\u001a\u0004\u0018\u00010/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b?\u00101R\u0016\u0010@\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u00108R\u001c\u0010B\u001a\b\u0012\u0004\u0012\u0002030A8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0016\u0010D\u001a\u00020<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010>R\u001a\u0010E\u001a\b\u0012\u0004\u0012\u0002030A8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bE\u0010CR\u001b\u0010J\u001a\u00020<8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bF\u0010G\u001a\u0004\bH\u0010IR\u0016\u0010K\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bK\u0010LR\u0016\u0010M\u001a\u00020<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010>R\u0016\u0010N\u001a\u0002048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bN\u00108\u00a8\u0006O"}, d2={"Lat/hannibal2/skyhanni/features/fishing/FishingTimer;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "event", "", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "playSound", "Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;", "onMobSpawn", "(Lat/hannibal2/skyhanni/events/MobEvent$Spawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;", "onMobDespawn", "(Lat/hannibal2/skyhanni/events/MobEvent$DeSpawn$SkyblockMob;)V", "Lat/hannibal2/skyhanni/events/fishing/SeaCreatureFishEvent;", "onSeaCreatureFish", "(Lat/hannibal2/skyhanni/events/fishing/SeaCreatureFishEvent;)V", "handle", "handleBabySlugs", "Lat/hannibal2/skyhanni/events/minecraft/KeyDownEvent;", "onKeyDown", "(Lat/hannibal2/skyhanni/events/minecraft/KeyDownEvent;)V", "updateInfo", "", "updateLocation", "()Z", "onTick", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "", "createDisplay", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebug", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "onWorldChange", "isEnabled", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/fishing/BarnTimerConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/fishing/BarnTimerConfig;", "config", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "barnLocation", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "", "Lat/hannibal2/skyhanni/data/mob/Mob;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "mobDespawnTime", "Ljava/util/Map;", "lastSeaCreatureFished", "J", "display", "Ljava/lang/String;", "lastNameFished", "", "babyMagmaSlugsToFind", "I", "lastMagmaSlugLocation", "lastMagmaSlugTime", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedSet;", "recentBabyMagmaSlugs", "Lat/hannibal2/skyhanni/utils/collection/TimeLimitedSet;", "mobsToFind", "recentMobs", "currentCap$delegate", "Lat/hannibal2/skyhanni/utils/RecalculatingValue;", "getCurrentCap", "()I", "currentCap", "rightLocation", "Z", "currentCount", "startTime", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nFishingTimer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FishingTimer.kt\nat/hannibal2/skyhanni/features/fishing/FishingTimer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n774#2:271\n865#2,2:272\n1056#2:274\n1869#2,2:275\n774#2:277\n865#2,2:278\n1056#2:280\n1869#2,2:281\n1999#2,14:283\n*S KotlinDebug\n*F\n+ 1 FishingTimer.kt\nat/hannibal2/skyhanni/features/fishing/FishingTimer\n*L\n135#1:271\n135#1:272,2\n136#1:274\n140#1:275,2\n152#1:277\n152#1:278,2\n153#1:280\n157#1:281,2\n178#1:283,14\n*E\n"})
public final class FishingTimer {
    @NotNull
    public static final FishingTimer INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final LorenzVec barnLocation;
    @NotNull
    private static final Map<Mob, SimpleTimeMark> mobDespawnTime;
    private static long lastSeaCreatureFished;
    @Nullable
    private static String display;
    @Nullable
    private static String lastNameFished;
    private static int babyMagmaSlugsToFind;
    @Nullable
    private static LorenzVec lastMagmaSlugLocation;
    private static long lastMagmaSlugTime;
    @NotNull
    private static TimeLimitedSet<Mob> recentBabyMagmaSlugs;
    private static int mobsToFind;
    @NotNull
    private static final TimeLimitedSet<Mob> recentMobs;
    @NotNull
    private static final RecalculatingValue currentCap$delegate;
    private static boolean rightLocation;
    private static int currentCount;
    private static long startTime;

    private FishingTimer() {
    }

    private final BarnTimerConfig getConfig() {
        return SkyHanniMod.feature.getFishing().getBarnTimer();
    }

    private final int getCurrentCap() {
        return ((Number)currentCap$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    @HandleEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (babyMagmaSlugsToFind != 0) {
            if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastMagmaSlugTime), (long)DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.SECONDS)) > 0) {
                babyMagmaSlugsToFind = 0;
                lastMagmaSlugLocation = null;
            }
        }
        rightLocation = this.updateLocation();
        long l = Duration.getInWholeSeconds-impl((long)SimpleTimeMark.passedSince-UwyO8pc(startTime)) - (long)this.getConfig().getAlertTime();
        boolean bl = 0L <= l ? l < 4L : false;
        if (bl) {
            this.playSound();
        }
        if (this.getConfig().getWormLimitAlert() && IslandType.CRYSTAL_HOLLOWS.isCurrent()) {
            if (currentCount >= 20) {
                this.playSound();
                TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, "\u00a7cWORM CAP FULL!!!", null, DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), null, null, null, 0.0, false, false, null, 0L, null, null, 0L, 16378, null);
            }
        } else if (this.getConfig().getFishingCapAlert() && currentCount >= this.getCurrentCap()) {
            this.playSound();
        }
    }

    private final void playSound() {
        SoundUtils.INSTANCE.repeatSound(250L, 4, SoundUtils.INSTANCE.getPlingSound());
    }

    @HandleEvent
    public final void onMobSpawn(@NotNull MobEvent.Spawn.SkyblockMob event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        Mob mob = event2.getMob();
        if (Intrinsics.areEqual((Object)mob.getName(), (Object)"Baby Magma Slug")) {
            ((Collection)recentBabyMagmaSlugs).add(mob);
            DelayedRun.INSTANCE.runNextTick((Function0<Unit>)((Function0)FishingTimer::onMobSpawn$lambda$1));
            return;
        }
        if (!SeaCreatureManager.INSTANCE.getAllFishingMobs().containsKey(mob.getName())) {
            return;
        }
        ((Collection)recentMobs).add(mob);
        this.handle();
    }

    @HandleEvent
    public final void onMobDespawn(@NotNull MobEvent.DeSpawn.SkyblockMob event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Mob mob = event2.getMob();
        ((Collection)recentBabyMagmaSlugs).remove(event2.getMob());
        if (mobDespawnTime.containsKey(mob)) {
            mobDespawnTime.remove(mob);
            if (Intrinsics.areEqual((Object)mob.getName(), (Object)"Magma Slug")) {
                lastMagmaSlugLocation = LorenzVecKt.getLorenzVec((class_1297)mob.getBaseEntity());
                babyMagmaSlugsToFind += 3;
                lastMagmaSlugTime = SimpleTimeMark.Companion.now-uFjCsEo();
                this.handleBabySlugs();
            }
        }
        ((Collection)recentMobs).remove(mob);
        this.updateInfo();
    }

    @HandleEvent
    public final void onSeaCreatureFish(@NotNull SeaCreatureFishEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (!rightLocation) {
            return;
        }
        lastSeaCreatureFished = SimpleTimeMark.Companion.now-uFjCsEo();
        lastNameFished = event2.getSeaCreature().getName();
        mobsToFind = event2.getDoubleHook() ? 2 : 1;
        this.handle();
    }

    /*
     * WARNING - void declaration
     */
    private final void handle() {
        void $this$filterTo$iv$iv;
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastSeaCreatureFished), (long)DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS)) > 0) {
            return;
        }
        String string = lastNameFished;
        if (string == null) {
            return;
        }
        String name2 = string;
        Iterable $this$filter$iv = recentMobs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Mob it = (Mob)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it.getName(), (Object)name2) && !mobDespawnTime.containsKey(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List mobs = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Mob it = (Mob)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(LocationUtils.INSTANCE.distanceToPlayer((class_1297)it.getBaseEntity()));
                it = (Mob)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(LocationUtils.INSTANCE.distanceToPlayer((class_1297)it.getBaseEntity())));
            }
        }), (int)mobsToFind);
        if (mobs.isEmpty()) {
            return;
        }
        mobsToFind -= mobs.size();
        Iterable $this$forEach$iv = mobs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Mob it = (Mob)element$iv;
            boolean bl = false;
            mobDespawnTime.put(it, SimpleTimeMark.box-impl(SimpleTimeMark.Companion.now-uFjCsEo()));
        }
        if (mobsToFind == 0) {
            recentMobs.clear();
            lastNameFished = null;
        }
        this.updateInfo();
    }

    /*
     * WARNING - void declaration
     */
    private final void handleBabySlugs() {
        void $this$filterTo$iv$iv;
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastMagmaSlugTime), (long)DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS)) > 0) {
            return;
        }
        if (babyMagmaSlugsToFind == 0) {
            return;
        }
        LorenzVec lorenzVec = lastMagmaSlugLocation;
        if (lorenzVec == null) {
            return;
        }
        LorenzVec location = lorenzVec;
        Iterable $this$filter$iv = recentBabyMagmaSlugs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Mob it = (Mob)element$iv$iv;
            boolean bl = false;
            if (!(!mobDespawnTime.containsKey(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List slugs = CollectionsKt.take((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(location){
            final /* synthetic */ LorenzVec $location$inlined;
            {
                this.$location$inlined = lorenzVec;
            }

            public final int compare(T a, T b) {
                Mob it = (Mob)a;
                boolean bl = false;
                Comparable comparable = Double.valueOf(LocationUtils.INSTANCE.distanceTo((class_1297)it.getBaseEntity(), this.$location$inlined));
                it = (Mob)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(LocationUtils.INSTANCE.distanceTo((class_1297)it.getBaseEntity(), this.$location$inlined)));
            }
        }), (int)babyMagmaSlugsToFind);
        if (slugs.isEmpty()) {
            return;
        }
        babyMagmaSlugsToFind -= slugs.size();
        Iterable $this$forEach$iv = slugs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Mob it = (Mob)element$iv;
            boolean bl = false;
            mobDespawnTime.put(it, SimpleTimeMark.box-impl(SimpleTimeMark.Companion.now-uFjCsEo()));
        }
        if (babyMagmaSlugsToFind == 0) {
            recentBabyMagmaSlugs.clear();
            lastMagmaSlugLocation = null;
        }
        this.updateInfo();
    }

    @HandleEvent
    public final void onKeyDown(@NotNull KeyDownEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (class_310.method_1551().field_1755 != null) {
            return;
        }
        if (event2.getKeyCode() != this.getConfig().getManualResetTimer()) {
            return;
        }
        mobDespawnTime.replaceAll((arg_0, arg_1) -> FishingTimer.onKeyDown$lambda$9(FishingTimer::onKeyDown$lambda$8, arg_0, arg_1));
    }

    private final void updateInfo() {
        Object v0;
        currentCount = mobDespawnTime.size();
        Iterable $this$maxByOrNull$iv = mobDespawnTime.values();
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                long it = ((SimpleTimeMark)maxElem$iv).unbox-impl();
                boolean bl = false;
                Comparable maxValue$iv = (Comparable)Duration.box-impl((long)SimpleTimeMark.passedSince-UwyO8pc(it));
                do {
                    Object e$iv = iterator$iv.next();
                    long it2 = ((SimpleTimeMark)e$iv).unbox-impl();
                    $i$a$-maxByOrNull-FishingTimer$updateInfo$1 = false;
                    Comparable v$iv = (Comparable)Duration.box-impl((long)SimpleTimeMark.passedSince-UwyO8pc(it2));
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        SimpleTimeMark simpleTimeMark = v0;
        startTime = simpleTimeMark != null ? simpleTimeMark.unbox-impl() : SimpleTimeMark.Companion.farPast();
        display = this.createDisplay();
    }

    private final boolean updateLocation() {
        if (this.getConfig().getShowAnywhere()) {
            return true;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[SkyBlockUtils.INSTANCE.getCurrentIsland().ordinal()]) {
            case 1 -> {
                Object v0 = this.getConfig().getCrystalHollows().get();
                Intrinsics.checkNotNullExpressionValue(v0, (String)"get(...)");
                yield (Boolean)v0;
            }
            case 2 -> {
                Object v2 = this.getConfig().getCrimsonIsle().get();
                Intrinsics.checkNotNullExpressionValue(v2, (String)"get(...)");
                yield (Boolean)v2;
            }
            case 3 -> {
                Object v3 = this.getConfig().getWinterIsland().get();
                Intrinsics.checkNotNullExpressionValue(v3, (String)"get(...)");
                yield (Boolean)v3;
            }
            case 4 -> {
                if (LocationUtils.INSTANCE.distanceToPlayer(barnLocation) < 50.0) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                if (((Boolean)this.getConfig().getForStranded().get()).booleanValue() && SkyBlockUtils.INSTANCE.isStrandedProfile()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @HandleEvent
    public final void onTick() {
        if (!this.isEnabled()) {
            return;
        }
        if (!rightLocation) {
            return;
        }
        if (currentCount == 0) {
            return;
        }
        if (!FishingApi.isFishing$default(FishingApi.INSTANCE, false, 1, null)) {
            return;
        }
        display = this.createDisplay();
    }

    @HandleEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (!rightLocation) {
            return;
        }
        if (currentCount == 0) {
            return;
        }
        if (!FishingApi.isFishing$default(FishingApi.INSTANCE, false, 1, null)) {
            return;
        }
        String string = display;
        if (string == null) {
            return;
        }
        String text = string;
        RenderUtils.renderString$default(RenderUtils.INSTANCE, this.getConfig().getPos(), text, 0, 0, "BarnTimer", 6, null);
    }

    private final String createDisplay() {
        long passedSince = SimpleTimeMark.passedSince-UwyO8pc(startTime);
        String timeColor = Duration.compareTo-LRDsOJo((long)passedSince, (long)DurationKt.toDuration((int)this.getConfig().getAlertTime(), (DurationUnit)DurationUnit.SECONDS)) > 0 ? "\u00a7c" : "\u00a7e";
        String timeFormat = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, passedSince, TimeUnit.MINUTE, false, false, 0, false, false, 62, null);
        String countColor = this.getConfig().getFishingCapAlert() && currentCount >= this.getCurrentCap() ? "\u00a7c" : "\u00a7e";
        String name2 = StringUtils.pluralize$default(StringUtils.INSTANCE, currentCount, "sea creature", null, false, 12, null);
        return timeColor + timeFormat + " \u00a78(" + countColor + currentCount + " \u00a7b" + name2 + "\u00a78)";
    }

    @HandleEvent
    public final void onDebug(@NotNull DebugDataCollectEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        event2.title("Barn Fishing Timer");
        event2.addIrrelevant((Function1<? super List<String>, Unit>)((Function1)FishingTimer::onDebug$lambda$11));
    }

    @HandleEvent
    public final void onWorldChange() {
        mobDespawnTime.clear();
        recentMobs.clear();
        babyMagmaSlugsToFind = 0;
        display = null;
        lastMagmaSlugLocation = null;
        lastMagmaSlugTime = SimpleTimeMark.Companion.farPast();
        recentBabyMagmaSlugs.clear();
        mobsToFind = 0;
        currentCount = 0;
        startTime = SimpleTimeMark.Companion.farPast();
    }

    private final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && (Boolean)this.getConfig().getEnabled().get() != false;
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 3, "fishing.barnTimer", "fishing.barnTimer.enabled", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 3, "fishing.barnTimerAlertTime", "fishing.barnTimer.alertTime", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 3, "fishing.barnTimerCrystalHollows", "fishing.barnTimer.crystalHollows", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 3, "fishing.barnTimerForStranded", "fishing.barnTimer.forStranded", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 3, "fishing.wormLimitAlert", "fishing.barnTimer.wormLimitAlert", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 3, "fishing.manualResetTimer", "fishing.barnTimer.manualResetTimer", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 3, "fishing.barnTimerPos", "fishing.barnTimer.pos", null, 8, null);
    }

    private static final int currentCap_delegate$lambda$0() {
        return switch (WhenMappings.$EnumSwitchMapping$0[SkyBlockUtils.INSTANCE.getCurrentIsland().ordinal()]) {
            case 1 -> 20;
            case 2 -> 5;
            default -> INSTANCE.getConfig().getFishingCapAmount();
        };
    }

    private static final Unit onMobSpawn$lambda$1() {
        INSTANCE.handleBabySlugs();
        return Unit.INSTANCE;
    }

    private static final SimpleTimeMark onKeyDown$lambda$8(Mob mob, SimpleTimeMark simpleTimeMark) {
        Intrinsics.checkNotNullParameter((Object)mob, (String)"<unused var>");
        return SimpleTimeMark.box-impl(SimpleTimeMark.Companion.now-uFjCsEo());
    }

    private static final SimpleTimeMark onKeyDown$lambda$9(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SimpleTimeMark)$tmp0.invoke(p0, p1);
    }

    private static final Unit onDebug$lambda$11(List $this$addIrrelevant) {
        Intrinsics.checkNotNullParameter((Object)$this$addIrrelevant, (String)"$this$addIrrelevant");
        $this$addIrrelevant.add("lastSeaCreatureFished: " + SimpleTimeMark.toString-impl(lastSeaCreatureFished));
        $this$addIrrelevant.add("lastNameFished: " + lastNameFished);
        $this$addIrrelevant.add("babyMagmaSlugsToFind: " + babyMagmaSlugsToFind);
        $this$addIrrelevant.add("lastMagmaSlugLocation: " + lastMagmaSlugLocation);
        $this$addIrrelevant.add("lastMagmaSlugTime: " + SimpleTimeMark.toString-impl(lastMagmaSlugTime));
        $this$addIrrelevant.add("recentBabyMagmaSlugs: " + recentBabyMagmaSlugs);
        $this$addIrrelevant.add("mobsToFind: " + mobsToFind);
        $this$addIrrelevant.add("recentMobs: " + recentMobs);
        $this$addIrrelevant.add("currentCap: " + INSTANCE.getCurrentCap());
        $this$addIrrelevant.add("mobDespawnTime: " + mobDespawnTime);
        $this$addIrrelevant.add("startTime: " + SimpleTimeMark.toString-impl(startTime));
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FishingTimer.class, "currentCap", "getCurrentCap()I", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new FishingTimer();
        barnLocation = new LorenzVec(108, 89, -252);
        mobDespawnTime = new LinkedHashMap();
        lastSeaCreatureFished = SimpleTimeMark.Companion.farPast();
        lastMagmaSlugTime = SimpleTimeMark.Companion.farPast();
        recentBabyMagmaSlugs = new TimeLimitedSet(DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), null, 2, null);
        recentMobs = new TimeLimitedSet(DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), null, 2, null);
        currentCap$delegate = new RecalculatingValue(DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS), FishingTimer::currentCap_delegate$lambda$0, null);
        startTime = SimpleTimeMark.Companion.farPast();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IslandType.values().length];
            try {
                nArray[IslandType.CRYSTAL_HOLLOWS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.CRIMSON_ISLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.WINTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.HUB.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.PRIVATE_ISLAND.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

