/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.contest;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.garden.contest.ContestSummaryConfig;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.garden.farming.CropClickEvent;
import at.hannibal2.skyhanni.events.garden.farming.FarmingContestEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.features.garden.contest.FarmingContestApi;
import at.hannibal2.skyhanni.features.garden.contest.FarmingContestPhase;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R \u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR&\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0!0 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lat/hannibal2/skyhanni/features/garden/contest/JacobContestStatsSummary;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/garden/farming/CropClickEvent;", "event", "", "onCropClick", "(Lat/hannibal2/skyhanni/events/garden/farming/CropClickEvent;)V", "Lat/hannibal2/skyhanni/events/garden/farming/FarmingContestEvent;", "onFarmingContest", "(Lat/hannibal2/skyhanni/events/garden/farming/FarmingContestEvent;)V", "", "blocksPerSecond", "", "getBlocksPerSecondColor", "(D)Ljava/lang/String;", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/garden/contest/ContestSummaryConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/contest/ContestSummaryConfig;", "config", "", "Lat/hannibal2/skyhanni/features/garden/CropType;", "", "blocksBroken", "Ljava/util/Map;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "startTime", "J", "", "Lkotlin/Pair;", "massMigrationPairs", "Ljava/util/List;", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nJacobContestStatsSummary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JacobContestStatsSummary.kt\nat/hannibal2/skyhanni/features/garden/contest/JacobContestStatsSummary\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionUtils.kt\nat/hannibal2/skyhanni/utils/collection/CollectionUtils\n*L\n1#1,92:1\n1869#2,2:93\n344#3:95\n*S KotlinDebug\n*F\n+ 1 JacobContestStatsSummary.kt\nat/hannibal2/skyhanni/features/garden/contest/JacobContestStatsSummary\n*L\n87#1:93,2\n24#1:95\n*E\n"})
public final class JacobContestStatsSummary {
    @NotNull
    public static final JacobContestStatsSummary INSTANCE = new JacobContestStatsSummary();
    @NotNull
    private static final Map<CropType, Integer> blocksBroken;
    private static long startTime;
    @NotNull
    private static final List<Pair<String, String>> massMigrationPairs;

    private JacobContestStatsSummary() {
    }

    private final ContestSummaryConfig getConfig() {
        return GardenApi.INSTANCE.getConfig().getJacobContest().getContestSummary();
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN, priority=-2)
    public final void onCropClick(@NotNull CropClickEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.getConfig().getEnabled()) {
            return;
        }
        if (event2.getClickType() != ClickType.LEFT_CLICK) {
            return;
        }
        if (FarmingContestApi.INSTANCE.getInContest() && event2.getCrop() == FarmingContestApi.INSTANCE.getContestCrop()) {
            CollectionUtils.INSTANCE.addOrPut(blocksBroken, event2.getCrop(), 1);
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onFarmingContest(@NotNull FarmingContestEvent event2) {
        int cropsBroken;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.getConfig().getEnabled()) {
            return;
        }
        Integer n = blocksBroken.get((Object)event2.getCrop());
        int n2 = cropsBroken = n != null ? n : 0;
        if (event2.getPhase() == FarmingContestPhase.STOP && this.getConfig().getHideZeroCropStats() && cropsBroken == 0) {
            return;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[event2.getPhase().ordinal()]) {
            case 1: {
                blocksBroken.clear();
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Started tracking your Jacob Contest Blocks Per Second!", false, null, false, false, null, 62, null);
                startTime = SimpleTimeMark.Companion.now-uFjCsEo();
                break;
            }
            case 2: {
                long duration = SimpleTimeMark.passedSince-UwyO8pc(startTime);
                double blocksPerSecond = NumberUtil.INSTANCE.roundTo((double)cropsBroken / (double)Duration.getInWholeSeconds-impl((long)duration), 2);
                String cropName = event2.getCrop().getCropName();
                ChatUtils.chat$default(ChatUtils.INSTANCE, "Stats for " + cropName + " Contest:", false, null, false, false, null, 62, null);
                String time = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, duration, null, false, false, 0, false, false, 63, null);
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77Blocks Broken in total: \u00a7e" + NumberUtil.INSTANCE.addSeparators(cropsBroken), false, null, false, false, null, 62, null);
                String color = this.getBlocksPerSecondColor(blocksPerSecond);
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77Average Blocks Per Second: " + color + blocksPerSecond, false, null, false, false, null, 62, null);
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a77Participated for \u00a7b" + time, false, null, false, false, null, 62, null);
                break;
            }
            case 3: {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "You changed the crop during the contest, resetting the Blocks Per Second calculation..", false, null, false, false, null, 62, null);
                startTime = SimpleTimeMark.Companion.now-uFjCsEo();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final String getBlocksPerSecondColor(double blocksPerSecond) {
        return blocksPerSecond > 19.0 ? "\u00a7c" : "\u00a7a";
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        String oldBase = "garden";
        String newBase = "garden.jacobContest";
        Iterable $this$forEach$iv = massMigrationPairs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            String oldPath = (String)pair.component1();
            String newPath = (String)pair.component2();
            ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 96, oldBase + "." + oldPath, newBase + "." + newPath, null, 8, null);
        }
    }

    static {
        CollectionUtils this_$iv = CollectionUtils.INSTANCE;
        boolean $i$f$enumMapOf = false;
        blocksBroken = new EnumMap(CropType.class);
        startTime = SimpleTimeMark.Companion.farPast();
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)"nextJacobContests", (Object)"jacobContest.nextContest"), TuplesKt.to((Object)"personalBests", (Object)"jacobContest.personalBests"), TuplesKt.to((Object)"farmingFortuneForContest", (Object)"jacobContest.ffForContest"), TuplesKt.to((Object)"farmingFortuneForContestPos", (Object)"jacobContest.ffForContestPosition"), TuplesKt.to((Object)"jacobContestTimes", (Object)"jacobContest.timesNeeded.enabled"), TuplesKt.to((Object)"jacobContestTimesPosition", (Object)"jacobContest.timesNeeded.position"), TuplesKt.to((Object)"jacobContestCustomBps", (Object)"jacobContest.timesNeeded.customBps.enabled"), TuplesKt.to((Object)"jacobContestCustomBpsValue", (Object)"jacobContest.timesNeeded.customBps.value"), TuplesKt.to((Object)"jacobContestSummary", (Object)"jacobContest.contestSummary.enabled")};
        massMigrationPairs = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FarmingContestPhase.values().length];
            try {
                nArray[FarmingContestPhase.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FarmingContestPhase.STOP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FarmingContestPhase.CHANGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

