/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.farming.lane;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.garden.laneswitch.FarmingLaneConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.events.garden.GardenToolChangeEvent;
import at.hannibal2.skyhanni.events.garden.farming.CropClickEvent;
import at.hannibal2.skyhanni.events.garden.farming.FarmingLaneSwitchEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.features.garden.farming.lane.FarmingDirection;
import at.hannibal2.skyhanni.features.garden.farming.lane.FarmingLane;
import at.hannibal2.skyhanni.features.garden.farming.lane.FarmingLaneCreator;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\u000e\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0014\u001a\u00020\u0013*\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015J!\u0010\u0017\u001a\u00020\u0011*\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0011\u0010\u001c\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001f\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R$\u0010\"\u001a\u0004\u0018\u00010\u001e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0016\u0010)\u001a\u00020(8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLaneApi;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/garden/GardenToolChangeEvent;", "event", "", "onGardenToolChange", "(Lat/hannibal2/skyhanni/events/garden/GardenToolChangeEvent;)V", "Lat/hannibal2/skyhanni/events/garden/farming/CropClickEvent;", "onCropClick", "(Lat/hannibal2/skyhanni/events/garden/farming/CropClickEvent;)V", "Lat/hannibal2/skyhanni/features/garden/CropType;", "crop", "warnNoLane", "(Lat/hannibal2/skyhanni/features/garden/CropType;)V", "Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingDirection;", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "location", "", "getValue", "(Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingDirection;Lat/hannibal2/skyhanni/utils/LorenzVec;)D", "value", "setValue", "(Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingDirection;Lat/hannibal2/skyhanni/utils/LorenzVec;D)Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lat/hannibal2/skyhanni/config/features/garden/laneswitch/FarmingLaneConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/laneswitch/FarmingLaneConfig;", "config", "", "Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLane;", "getLanes", "()Ljava/util/Map;", "lanes", "currentLane", "Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLane;", "getCurrentLane", "()Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLane;", "setCurrentLane", "(Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLane;)V", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastNoLaneWarning", "J", "1.21.5"})
public final class FarmingLaneApi {
    @NotNull
    public static final FarmingLaneApi INSTANCE = new FarmingLaneApi();
    @Nullable
    private static FarmingLane currentLane;
    private static long lastNoLaneWarning;

    private FarmingLaneApi() {
    }

    @NotNull
    public final FarmingLaneConfig getConfig() {
        return GardenApi.INSTANCE.getConfig().getFarmingLane();
    }

    @Nullable
    public final Map<CropType, FarmingLane> getLanes() {
        ProfileSpecificStorage.GardenStorage gardenStorage = GardenApi.INSTANCE.getStorage();
        return gardenStorage != null ? gardenStorage.getFarmingLanes() : null;
    }

    @Nullable
    public final FarmingLane getCurrentLane() {
        return currentLane;
    }

    public final void setCurrentLane(@Nullable FarmingLane farmingLane) {
        currentLane = farmingLane;
    }

    @HandleEvent
    public final void onGardenToolChange(@NotNull GardenToolChangeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        currentLane = null;
    }

    @HandleEvent
    public final void onCropClick(@NotNull CropClickEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        CropType crop = event2.getCrop();
        if (!GardenApi.INSTANCE.hasFarmingToolInHand()) {
            return;
        }
        Map<CropType, FarmingLane> map = this.getLanes();
        if (map == null) {
            return;
        }
        Map<CropType, FarmingLane> lanes = map;
        FarmingLane lane = lanes.get((Object)crop);
        if (lane == null) {
            this.warnNoLane(crop);
        }
        if (Intrinsics.areEqual((Object)currentLane, (Object)lane)) {
            return;
        }
        currentLane = lane;
        new FarmingLaneSwitchEvent(lane).post();
    }

    private final void warnNoLane(CropType crop) {
        if (crop == null || currentLane != null) {
            return;
        }
        if (this.getConfig().getIgnoredCrops().contains((Object)crop)) {
            return;
        }
        if (!GardenApi.INSTANCE.hasFarmingToolInHand()) {
            return;
        }
        if (FarmingLaneCreator.INSTANCE.getDetection()) {
            return;
        }
        if (!this.getConfig().getDistanceDisplay() && !this.getConfig().getLaneSwitchNotification().getEnabled()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastNoLaneWarning), (long)DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS)) < 0) {
            return;
        }
        lastNoLaneWarning = SimpleTimeMark.Companion.now-uFjCsEo();
        ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, "No " + crop.getCropName() + " lane defined yet! Use \u00a7e/shlanedetection", FarmingLaneApi::warnNoLane$lambda$0, "\u00a7eClick to run /shlanedetection!", 0L, false, null, false, false, 248, null);
    }

    public final double getValue(@NotNull FarmingDirection $this$getValue, @NotNull LorenzVec location) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$getValue), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$getValue.ordinal()]) {
            case 1 -> location.getZ();
            case 2 -> location.getX();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final LorenzVec setValue(@NotNull FarmingDirection $this$setValue, @NotNull LorenzVec location, double value) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$setValue), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$setValue.ordinal()]) {
            case 1 -> LorenzVec.copy$default(location, 0.0, 0.0, value, 3, null);
            case 2 -> LorenzVec.copy$default(location, value, 0.0, 0.0, 6, null);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final Unit warnNoLane$lambda$0() {
        FarmingLaneCreator.INSTANCE.commandLaneDetection();
        return Unit.INSTANCE;
    }

    static {
        lastNoLaneWarning = SimpleTimeMark.Companion.farPast();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FarmingDirection.values().length];
            try {
                nArray[FarmingDirection.NORTH_SOUTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FarmingDirection.EAST_WEST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

