/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.farming.lane;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.config.features.garden.laneswitch.FarmingLaneConfig;
import at.hannibal2.skyhanni.events.garden.farming.CropClickEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.features.garden.farming.lane.FarmingDirection;
import at.hannibal2.skyhanni.features.garden.farming.lane.FarmingLane;
import at.hannibal2.skyhanni.features.garden.farming.lane.FarmingLaneApi;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0003J\u0017\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0011\u0010!\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\"\u0010\"\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010\u001d\"\u0004\b%\u0010&R\u0018\u0010'\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u0018\u0010)\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010(R\u0018\u0010*\u001a\u0004\u0018\u00010\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010(R\u0018\u0010\u000e\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000e\u0010+R\u0016\u0010-\u001a\u00020,8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLaneCreator;", "", "<init>", "()V", "", "commandLaneDetection", "Lat/hannibal2/skyhanni/events/garden/farming/CropClickEvent;", "event", "onCropClick", "(Lat/hannibal2/skyhanni/events/garden/farming/CropClickEvent;)V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "a", "b", "Lat/hannibal2/skyhanni/features/garden/CropType;", "crop", "saveLane", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/features/garden/CropType;)V", "Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLane;", "createLane", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;)Lat/hannibal2/skyhanni/features/garden/farming/lane/FarmingLane;", "reset", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/garden/laneswitch/FarmingLaneConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/laneswitch/FarmingLaneConfig;", "config", "detection", "Z", "getDetection", "setDetection", "(Z)V", "start", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "lastLocation", "potentialEnd", "Lat/hannibal2/skyhanni/features/garden/CropType;", "", "maxDistance", "D", "1.21.5"})
public final class FarmingLaneCreator {
    @NotNull
    public static final FarmingLaneCreator INSTANCE = new FarmingLaneCreator();
    private static boolean detection;
    @Nullable
    private static LorenzVec start;
    @Nullable
    private static LorenzVec lastLocation;
    @Nullable
    private static LorenzVec potentialEnd;
    @Nullable
    private static CropType crop;
    private static double maxDistance;

    private FarmingLaneCreator() {
    }

    @NotNull
    public final FarmingLaneConfig getConfig() {
        return FarmingLaneApi.INSTANCE.getConfig();
    }

    public final boolean getDetection() {
        return detection;
    }

    public final void setDetection(boolean bl) {
        detection = bl;
    }

    public final void commandLaneDetection() {
        boolean bl = detection = !detection;
        if (detection) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Enabled lane detection. Farm two layers to detect the lane border position.", false, null, false, false, null, 62, null);
        } else {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Stopped lane detection.", false, null, false, false, null, 62, null);
        }
    }

    @HandleEvent
    public final void onCropClick(@NotNull CropClickEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        LorenzVec location = LocationUtils.INSTANCE.playerLocation();
        LorenzVec lorenzVec = lastLocation;
        if (lorenzVec == null) {
            FarmingLaneCreator $this$onCropClick_u24lambda_u240 = this;
            boolean bl = false;
            start = location;
            maxDistance = 0.0;
            lastLocation = location;
            crop = event2.getCrop();
            return;
        }
        LorenzVec lastLocation = lorenzVec;
        if (crop != event2.getCrop()) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Different crop broken, stopping lane detection", false, null, false, false, null, 62, null);
            this.reset();
            return;
        }
        if (lastLocation.distance(location) < 0.5) {
            return;
        }
        FarmingLaneCreator.lastLocation = location;
        LorenzVec lorenzVec2 = start;
        if (lorenzVec2 == null) {
            throw new IllegalStateException("start can not be null".toString());
        }
        LorenzVec start2 = lorenzVec2;
        double distance = start2.distance(location);
        if (distance > maxDistance) {
            maxDistance = distance;
            potentialEnd = null;
        } else {
            LorenzVec lorenzVec3 = potentialEnd;
            if (lorenzVec3 == null) {
                FarmingLaneCreator $this$onCropClick_u24lambda_u241 = this;
                boolean bl = false;
                potentialEnd = location;
                return;
            }
            LorenzVec potentialEnd = lorenzVec3;
            if (potentialEnd.distance(location) > 2.0) {
                CropType cropType = crop;
                if (cropType == null) {
                    throw new IllegalStateException("crop can not be null".toString());
                }
                CropType crop = cropType;
                this.saveLane(start2, potentialEnd, crop);
            }
        }
    }

    private final void saveLane(LorenzVec a, LorenzVec b, CropType crop) {
        FarmingLane lane = this.createLane(a, b);
        Map<CropType, FarmingLane> map = FarmingLaneApi.INSTANCE.getLanes();
        if (map == null) {
            return;
        }
        Map<CropType, FarmingLane> lanes = map;
        lanes.put(crop, lane);
        FarmingLaneApi.INSTANCE.setCurrentLane(lane);
        ChatUtils.chat$default(ChatUtils.INSTANCE, crop.getCropName() + " lane saved! Farming Lane features are now working.", false, null, false, false, null, 62, null);
        this.reset();
    }

    private final FarmingLane createLane(LorenzVec a, LorenzVec b) {
        double diffX = a.getX() - b.getX();
        double diffZ = a.getZ() - b.getZ();
        FarmingDirection direction = Math.abs(diffZ) > Math.abs(diffX) ? FarmingDirection.NORTH_SOUTH : FarmingDirection.EAST_WEST;
        double min = Math.min(FarmingLaneApi.INSTANCE.getValue(direction, a), FarmingLaneApi.INSTANCE.getValue(direction, b));
        double max = Math.max(FarmingLaneApi.INSTANCE.getValue(direction, a), FarmingLaneApi.INSTANCE.getValue(direction, b));
        return new FarmingLane(direction, min, max);
    }

    private final void reset() {
        start = null;
        lastLocation = null;
        crop = null;
        maxDistance = 0.0;
        detection = false;
    }

    @HandleEvent
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event2) {
        block3: {
            LorenzVec it;
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            if (!this.isEnabled()) {
                return;
            }
            LorenzVec lorenzVec = start;
            if (lorenzVec != null) {
                it = lorenzVec;
                boolean bl = false;
                WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event2, it, LorenzColor.WHITE.toColor(), false, true, 0.0, 0.0, 0.0, 0.0f, false, 500, null);
                WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event2, it, "start", 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
            }
            LorenzVec lorenzVec2 = lastLocation;
            if (lorenzVec2 != null) {
                it = lorenzVec2;
                boolean bl = false;
                WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event2, it, LorenzColor.WHITE.toColor(), false, true, 0.0, 0.0, 0.0, 0.0f, false, 500, null);
                WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event2, it, "lastLocation", 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
            }
            LorenzVec lorenzVec3 = potentialEnd;
            if (lorenzVec3 == null) break block3;
            it = lorenzVec3;
            boolean bl = false;
            WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event2, it, LorenzColor.WHITE.toColor(), false, true, 0.0, 0.0, 0.0, 0.0f, false, 500, null);
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event2, it, "potentialEnd", 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        }
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        event2.registerBrigadier("shlanedetection", (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)FarmingLaneCreator::onCommandRegistration$lambda$6));
    }

    private final boolean isEnabled() {
        return GardenApi.INSTANCE.inGarden() && detection;
    }

    private static final Unit onCommandRegistration$lambda$6$lambda$5() {
        INSTANCE.commandLaneDetection();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$6(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Detect a farming lane in the Garden");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_ACTIVE);
        $this$registerBrigadier.simpleCallback((Function0<Unit>)((Function0)FarmingLaneCreator::onCommandRegistration$lambda$6$lambda$5));
        return Unit.INSTANCE;
    }
}

