/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.bazaar;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.inventory.BazaarConfig;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.features.inventory.bazaar.BazaarApi;
import at.hannibal2.skyhanni.features.inventory.bazaar.BazaarData;
import at.hannibal2.skyhanni.utils.InventoryDetector;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_476;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00042\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJO\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00062\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0016\u001a\u00020\u00152\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010!\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\"\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u001b\u0010)\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u001b\u0010,\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010&\u001a\u0004\b+\u0010(R\u001b\u0010/\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010&\u001a\u0004\b.\u0010(R\u0014\u00101\u001a\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102\u00a8\u00063"}, d2={"Lat/hannibal2/skyhanni/features/inventory/bazaar/BazaarOrderHelper;", "", "<init>", "()V", "", "", "Lnet/minecraft/class_1799;", "inventoryItems", "Lat/hannibal2/skyhanni/utils/LorenzColor;", "load", "(Ljava/util/Map;)Ljava/util/Map;", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;", "event", "", "onBackgroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;)V", "slot", "stack", "Lkotlin/Pair;", "", "buyOrSell", "Lat/hannibal2/skyhanni/features/inventory/bazaar/BazaarData;", "data", "", "map", "highlightItem", "(ILnet/minecraft/class_1799;Lkotlin/Pair;Lat/hannibal2/skyhanni/features/inventory/bazaar/BazaarData;Ljava/util/Map;)V", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Lat/hannibal2/skyhanni/config/features/inventory/BazaarConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/BazaarConfig;", "config", "highlightedSlots", "Ljava/util/Map;", "Ljava/util/regex/Pattern;", "bazaarItemNamePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getBazaarItemNamePattern", "()Ljava/util/regex/Pattern;", "bazaarItemNamePattern", "filledPattern$delegate", "getFilledPattern", "filledPattern", "pricePattern$delegate", "getPricePattern", "pricePattern", "Lat/hannibal2/skyhanni/utils/InventoryDetector;", "inventory", "Lat/hannibal2/skyhanni/utils/InventoryDetector;", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nBazaarOrderHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazaarOrderHelper.kt\nat/hannibal2/skyhanni/features/inventory/bazaar/BazaarOrderHelper\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n8#2:116\n8#2:119\n8#2:121\n1#3:117\n1#3:118\n1#3:120\n1#3:122\n*S KotlinDebug\n*F\n+ 1 BazaarOrderHelper.kt\nat/hannibal2/skyhanni/features/inventory/bazaar/BazaarOrderHelper\n*L\n63#1:116\n100#1:119\n105#1:121\n63#1:117\n100#1:120\n105#1:122\n*E\n"})
public final class BazaarOrderHelper {
    @NotNull
    public static final BazaarOrderHelper INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static Map<Integer, ? extends LorenzColor> highlightedSlots;
    @NotNull
    private static final RepoPattern bazaarItemNamePattern$delegate;
    @NotNull
    private static final RepoPattern filledPattern$delegate;
    @NotNull
    private static final RepoPattern pricePattern$delegate;
    @NotNull
    private static final InventoryDetector inventory;

    private BazaarOrderHelper() {
    }

    private final BazaarConfig getConfig() {
        return SkyHanniMod.feature.getInventory().getBazaar();
    }

    private final Pattern getBazaarItemNamePattern() {
        return (Pattern)bazaarItemNamePattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final Pattern getFilledPattern() {
        return (Pattern)filledPattern$delegate.getValue(this, $$delegatedProperties[1]);
    }

    private final Pattern getPricePattern() {
        return (Pattern)pricePattern$delegate.getValue(this, $$delegatedProperties[2]);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Integer, LorenzColor> load(Map<Integer, class_1799> inventoryItems) {
        Map slots;
        block2: {
            slots = new LinkedHashMap();
            Set errorItems = new LinkedHashSet();
            for (Map.Entry<Integer, class_1799> entry : inventoryItems.entrySet()) {
                void $this$matchMatcher$iv;
                int slot = ((Number)entry.getKey()).intValue();
                class_1799 stack = entry.getValue();
                RegexUtils regexUtils = RegexUtils.INSTANCE;
                Pattern pattern = this.getBazaarItemNamePattern();
                String text$iv = TextCompatKt.formattedTextCompatLeadingWhiteLessResets(stack.method_7964());
                boolean $i$f$matchMatcher = false;
                Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
                boolean bl = false;
                if (!it$iv.matches()) continue;
                Intrinsics.checkNotNull((Object)it$iv);
                Matcher $this$load_u24lambda_u246 = it$iv;
                boolean bl2 = false;
                String it = $this$load_u24lambda_u246.group("type");
                boolean bl3 = false;
                Pair buyOrSell = TuplesKt.to((Object)Intrinsics.areEqual((Object)it, (Object)"BUY"), (Object)Intrinsics.areEqual((Object)it, (Object)"SELL"));
                it = buyOrSell;
                boolean bl4 = false;
                if (!((Boolean)it.getFirst()).booleanValue() && !((Boolean)it.getSecond()).booleanValue()) continue;
                String string = $this$load_u24lambda_u246.group("name");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                NeuInternalName internalName2 = NeuInternalName.Companion.fromItemName(string);
                if (BazaarApi.INSTANCE.getBazaarData(internalName2) != null) {
                    BazaarData it2;
                    boolean bl5 = false;
                    INSTANCE.highlightItem(slot, stack, (Pair<Boolean, Boolean>)buyOrSell, it2, slots);
                    continue;
                }
                Matcher $this$load_u24lambda_u246_u24lambda_u245 = $this$load_u24lambda_u246;
                boolean bl6 = false;
                errorItems.add(internalName2);
            }
            NeuInternalName neuInternalName = (NeuInternalName)CollectionsKt.firstOrNull((Iterable)errorItems);
            if (neuInternalName == null) break block2;
            BazaarApi.INSTANCE.getBazaarDataOrError(neuInternalName);
        }
        return slots;
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onBackgroundDrawn(@NotNull GuiContainerEvent.BackgroundDrawnEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!inventory.isInside()) {
            return;
        }
        if (!(event2.getGui() instanceof class_476)) {
            return;
        }
        class_1703 class_17032 = event2.getContainer();
        Intrinsics.checkNotNull((Object)class_17032, (String)"null cannot be cast to non-null type net.minecraft.screen.GenericContainerScreenHandler");
        class_1707 chest = (class_1707)class_17032;
        Iterator<Map.Entry<class_1735, class_1799>> iterator2 = InventoryUtils.INSTANCE.getUpperItems(chest).entrySet().iterator();
        while (iterator2.hasNext()) {
            LorenzColor it;
            class_1735 slot = iterator2.next().getKey();
            if (highlightedSlots.get(slot.field_7874) == null) continue;
            boolean bl = false;
            RenderUtils.INSTANCE.highlight(slot, it);
        }
    }

    private final void highlightItem(int slot, class_1799 stack, Pair<Boolean, Boolean> buyOrSell, BazaarData data, Map<Integer, LorenzColor> map) {
        for (String line : ItemUtils.INSTANCE.getLore(stack)) {
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern $this$matchMatcher$iv = this.getFilledPattern();
            boolean $i$f$matchMatcher = false;
            Matcher it$iv = $this$matchMatcher$iv.matcher(line);
            boolean bl = false;
            if (it$iv.matches()) {
                Intrinsics.checkNotNull((Object)it$iv);
                Matcher $this$highlightItem_u24lambda_u248 = it$iv;
                boolean bl2 = false;
                Integer n = slot;
                map.put(n, LorenzColor.GREEN);
                return;
            }
            RegexUtils this_$iv = RegexUtils.INSTANCE;
            $this$matchMatcher$iv = this.getPricePattern();
            $i$f$matchMatcher = false;
            it$iv = $this$matchMatcher$iv.matcher(line);
            bl = false;
            if (!it$iv.matches()) continue;
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$highlightItem_u24lambda_u249 = it$iv;
            boolean bl3 = false;
            String string = $this$highlightItem_u24lambda_u249.group("number");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            double price = NumberUtil.INSTANCE.formatDouble(string);
            if (!((Boolean)buyOrSell.getFirst() != false && price < data.getInstantSellPrice()) && (!((Boolean)buyOrSell.getSecond()).booleanValue() || !(price > data.getInstantBuyPrice()))) continue;
            Integer n = slot;
            map.put(n, LorenzColor.GOLD);
            return;
        }
    }

    private static final Unit inventory$lambda$0(InventoryFullyOpenedEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        highlightedSlots = INSTANCE.load(it.getInventoryItems());
        return Unit.INSTANCE;
    }

    private static final boolean inventory$lambda$1(String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return BazaarApi.INSTANCE.isBazaarOrderInventory(name2) && INSTANCE.getConfig().getOrderHelper();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(BazaarOrderHelper.class, "bazaarItemNamePattern", "getBazaarItemNamePattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(BazaarOrderHelper.class, "filledPattern", "getFilledPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(BazaarOrderHelper.class, "pricePattern", "getPricePattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new BazaarOrderHelper();
        patternGroup = RepoPattern.Companion.group("bazaar.orderhelper");
        highlightedSlots = MapsKt.emptyMap();
        bazaarItemNamePattern$delegate = patternGroup.pattern("itemname", "\u00a7.\u00a7l(?<type>BUY|SELL) (?<name>.*)");
        filledPattern$delegate = patternGroup.pattern("filled", "\u00a77Filled: \u00a7[a6].*\u00a77/.* \u00a7a\u00a7l100%!");
        pricePattern$delegate = patternGroup.pattern("price", "\u00a77Price per unit: \u00a76(?<number>.*) coins");
        inventory = new InventoryDetector(BazaarOrderHelper::inventory$lambda$0, null, BazaarOrderHelper::inventory$lambda$1, 2, null);
    }
}

