/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandBuilder;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.features.mining.dwarves.KingTalismanConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.MiningApi;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockTime;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\r\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0004\b\r\u0010\bJ\u0017\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0003J\u000f\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001b\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0014J\u0017\u0010\u001b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020 H\u0007\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010&\u001a\u00020#8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0016\u0010*\u001a\u0004\u0018\u00010'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010,\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u001b\u00103\u001a\u00020.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u0014\u00105\u001a\u0002048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u001a\u00108\u001a\b\u0012\u0004\u0012\u00020\u0012078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00109R\u001c\u0010:\u001a\b\u0012\u0004\u0012\u00020\u0012078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u00109R\u0016\u0010;\u001a\u00020\u00128\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u001c\u0010=\u001a\b\u0012\u0004\u0012\u00020\u0012078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u00109\u00a8\u0006>"}, d2={"Lat/hannibal2/skyhanni/features/mining/KingTalismanHelper;", "", "<init>", "()V", "", "resetKings", "", "isNearby", "()Z", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "event", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "isEnabled", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "onInventoryFullyOpened", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "update", "", "nextMissingText", "()Ljava/lang/String;", "", "Lkotlin/time/Duration;", "getKingTimes", "()Ljava/util/Map;", "getCurrentKing", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "Lat/hannibal2/skyhanni/config/features/mining/dwarves/KingTalismanConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/mining/dwarves/KingTalismanConfig;", "config", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$MiningStorage;", "getStorage", "()Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$MiningStorage;", "storage", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "talismanPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getTalismanPattern", "()Ljava/util/regex/Pattern;", "talismanPattern", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "kingLocation", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "", "kingCircles", "Ljava/util/List;", "allKingsDisplay", "farDisplay", "Ljava/lang/String;", "display", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nKingTalismanHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KingTalismanHelper.kt\nat/hannibal2/skyhanni/features/mining/KingTalismanHelper\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,195:1\n538#2:196\n523#2,6:197\n1#3:203\n1573#4:204\n1604#4,4:205\n*S KotlinDebug\n*F\n+ 1 KingTalismanHelper.kt\nat/hannibal2/skyhanni/features/mining/KingTalismanHelper\n*L\n143#1:196\n143#1:197,6\n157#1:204\n157#1:205,4\n*E\n"})
public final class KingTalismanHelper {
    @NotNull
    public static final KingTalismanHelper INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern talismanPattern$delegate;
    @NotNull
    private static final LorenzVec kingLocation;
    @NotNull
    private static final List<String> kingCircles;
    @NotNull
    private static List<String> allKingsDisplay;
    @NotNull
    private static String farDisplay;
    @NotNull
    private static List<String> display;

    private KingTalismanHelper() {
    }

    private final KingTalismanConfig getConfig() {
        return SkyHanniMod.feature.getMining().getKingTalisman();
    }

    private final ProfileSpecificStorage.MiningStorage getStorage() {
        ProfileSpecificStorage profileSpecificStorage = ProfileStorageData.INSTANCE.getProfileSpecific();
        return profileSpecificStorage != null ? profileSpecificStorage.getMining() : null;
    }

    private final Pattern getTalismanPattern() {
        return (Pattern)talismanPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final void resetKings() {
        ProfileSpecificStorage.MiningStorage miningStorage = this.getStorage();
        if (miningStorage != null) {
            miningStorage.setKingsTalkedTo(new ArrayList());
        }
        this.update();
    }

    private final boolean isNearby() {
        return IslandType.DWARVEN_MINES.isCurrent() && Intrinsics.areEqual((Object)SkyBlockUtils.INSTANCE.getGraphArea(), (Object)"Royal Palace") && LocationUtils.INSTANCE.distanceToPlayer(kingLocation) < 10.0;
    }

    @HandleEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event2) {
        List<String> list;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        this.update();
        if (this.isNearby()) {
            list = allKingsDisplay;
        } else {
            List<String> list2 = Collections.singletonList(farDisplay);
            list = list2;
            Intrinsics.checkNotNullExpressionValue(list2, (String)"singletonList(...)");
        }
        display = list;
    }

    public final boolean isEnabled() {
        return this.getConfig().getEnabled() && SkyBlockUtils.INSTANCE.getInSkyBlock() && (IslandType.DWARVEN_MINES.isCurrent() || this.getConfig().getOutsideMines());
    }

    @HandleEvent
    public final void onInventoryFullyOpened(@NotNull InventoryFullyOpenedEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!Intrinsics.areEqual((Object)event2.getInventoryName(), (Object)"Commissions")) {
            return;
        }
        if (!this.isEnabled()) {
            return;
        }
        if (!this.isNearby()) {
            return;
        }
        ProfileSpecificStorage.MiningStorage miningStorage = this.getStorage();
        if (miningStorage == null) {
            return;
        }
        ProfileSpecificStorage.MiningStorage storage = miningStorage;
        String currentKing = this.getCurrentKing();
        List<String> kingsTalkedTo = storage.getKingsTalkedTo();
        if (!kingsTalkedTo.contains(currentKing)) {
            kingsTalkedTo.add(currentKing);
            this.update();
            display = allKingsDisplay;
        }
    }

    private final void update() {
        List list;
        Object object = this.getStorage();
        if (object == null || (object = ((ProfileSpecificStorage.MiningStorage)object).getKingsTalkedTo()) == null) {
            return;
        }
        Object kingsTalkedTo = object;
        if (kingsTalkedTo.size() == kingCircles.size()) {
            allKingsDisplay = Collections.singletonList("\u00a7eAll Kings found.");
            farDisplay = "";
            return;
        }
        List $this$update_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Object farDisplay_ = null;
        String currentKing = INSTANCE.getCurrentKing();
        for (Map.Entry<String, Duration> entry : INSTANCE.getKingTimes().entrySet()) {
            String currentString;
            String string;
            String king = entry.getKey();
            long timeUntil = entry.getValue().unbox-impl();
            boolean missing = !kingsTalkedTo.contains(king);
            String missingString = missing ? "" : " \u00a7aDone";
            boolean current = Intrinsics.areEqual((Object)king, (Object)currentKing);
            if (current) {
                long changedTime = Duration.getInWholeMilliseconds-impl((long)timeUntil) - (long)(1200000 * (kingCircles.size() - 1));
                String time = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, DurationKt.toDuration((long)changedTime, (DurationUnit)DurationUnit.MILLISECONDS), null, false, false, 2, false, false, 55, null);
                string = "\u00a77(\u00a7b" + time + " remaining\u00a77)";
            } else {
                String time = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, timeUntil, null, false, false, 2, false, false, 55, null);
                string = "\u00a77(\u00a7bin " + time + "\u00a77)";
            }
            String missingTimeFormat = string;
            String string2 = currentString = current ? "\u00a76King " : "";
            if (missing && current) {
                farDisplay_ = "\u00a7cNext missing king: \u00a77" + king + " \u00a7eNow " + missingTimeFormat;
            }
            Object timeString = missing ? " \u00a7cMissing " + missingTimeFormat : "";
            $this$update_u24lambda_u240.add("\u00a77" + currentString + king + missingString + (String)timeString);
        }
        Object object2 = farDisplay_;
        if (object2 == null) {
            object2 = INSTANCE.nextMissingText();
        }
        farDisplay = object2;
        allKingsDisplay = CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    private final String nextMissingText() {
        Map.Entry entry;
        block5: {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            ProfileSpecificStorage.MiningStorage miningStorage = this.getStorage();
            if (miningStorage == null) {
                throw new IllegalStateException("profileSpecific is null".toString());
            }
            ProfileSpecificStorage.MiningStorage storage = miningStorage;
            List<String> kingsTalkedTo = storage.getKingsTalkedTo();
            Map<String, Duration> map = this.getKingTimes();
            CollectionUtils collectionUtils = CollectionUtils.INSTANCE;
            boolean $i$f$filter = false;
            void var6_8 = $this$filter$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv;
                Map.Entry it = element$iv$iv = iterator2.next();
                boolean bl = false;
                if (!(!kingsTalkedTo.contains(it.getKey()))) continue;
                destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            for (Map.Entry it : collectionUtils.sorted(destination$iv$iv).entrySet()) {
                boolean bl = false;
                entry = it;
                if (entry == null) {
                    continue;
                }
                break block5;
            }
            entry = null;
        }
        if (entry == null) {
            throw new NoSuchElementException("No element of the map was transformed to a non-null value.");
        }
        Map.Entry entry2 = entry;
        String nextKing = (String)entry2.getKey();
        long until = ((Duration)entry2.getValue()).unbox-impl();
        String time = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, until, null, false, false, 2, false, false, 55, null);
        return "\u00a7cNext missing king: \u00a77" + nextKing + " \u00a77(\u00a7bin " + time + "\u00a77)";
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Duration> getKingTimes() {
        void $this$mapIndexedTo$iv$iv;
        SkyBlockTime sbTime = SkyBlockTime.Companion.now();
        int kingIndex = (sbTime.getDay() + 5) % kingCircles.size();
        int absDay = (sbTime.getYear() - 1) * 372 + (sbTime.getMonth() - 1) * 31 + sbTime.getDay();
        SkyBlockTime startTime = SkyBlockTime.Companion.fromAbsoluteDay(absDay - kingIndex);
        long oneSBDay = DurationKt.toDuration((int)20, (DurationUnit)DurationUnit.MINUTES);
        long oneCircleTime = Duration.times-UwyO8pc((long)oneSBDay, (int)kingCircles.size());
        Iterable $this$mapIndexed$iv = kingCircles;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void king;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            long timeNext = SimpleTimeMark.timeUntil-UwyO8pc(startTime.plus-LRDsOJo(Duration.times-UwyO8pc((long)oneSBDay, (int)index)).toTimeMark-uFjCsEo());
            while (Duration.isNegative-impl((long)timeNext)) {
                timeNext = Duration.plus-LRDsOJo((long)timeNext, (long)oneCircleTime);
            }
            collection.add(TuplesKt.to((Object)king, (Object)Duration.box-impl((long)timeNext)));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final String getCurrentKing() {
        String string;
        block3: {
            for (Map.Entry<String, Duration> it : CollectionUtils.INSTANCE.sortedDesc(this.getKingTimes()).entrySet()) {
                boolean bl = false;
                string = it.getKey();
                if (string == null) {
                    continue;
                }
                break block3;
            }
            string = null;
        }
        if (string == null) {
            throw new NoSuchElementException("No element of the map was transformed to a non-null value.");
        }
        return string;
    }

    @HandleEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        RenderUtils.renderStrings$default(RenderUtils.INSTANCE, this.getConfig().getPosition(), display, 0, "King Talisman Helper", 2, null);
    }

    @HandleEvent
    public final void onChat(@NotNull SkyHanniChatEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (!MiningApi.INSTANCE.getInDwarvenMines()) {
            return;
        }
        if (RegexUtils.INSTANCE.matches(this.getTalismanPattern(), event2.getMessage())) {
            ProfileSpecificStorage.MiningStorage miningStorage = this.getStorage();
            if (miningStorage != null) {
                miningStorage.setKingsTalkedTo(CollectionsKt.toMutableList((Collection)kingCircles));
            }
            this.update();
        }
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        event2.register("shresetkinghelper", (Function1<? super CommandBuilder, Unit>)((Function1)KingTalismanHelper::onCommandRegistration$lambda$6));
    }

    private static final Unit onCommandRegistration$lambda$6$lambda$5(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.resetKings();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$6(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.setDescription("Resets the King Talisman Helper");
        $this$register.setCategory(CommandCategory.USERS_RESET);
        $this$register.callback((Function1<? super String[], Unit>)((Function1)KingTalismanHelper::onCommandRegistration$lambda$6$lambda$5));
        return Unit.INSTANCE;
    }

    static {
        Object[] objectArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(KingTalismanHelper.class, "talismanPattern", "getTalismanPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = objectArray;
        INSTANCE = new KingTalismanHelper();
        patternGroup = RepoPattern.Companion.group("mining.kingtalisman");
        talismanPattern$delegate = patternGroup.pattern("talisman", "\u00a77You have received a \u00a7r\u00a7fKing Talisman\u00a7r\u00a77!");
        kingLocation = new LorenzVec(129.6, 196.5, 194.1);
        objectArray = new String[]{"Brammor", "Emkam", "Redros", "Erren", "Thormyr", "Emmor", "Grandan"};
        kingCircles = CollectionsKt.listOf((Object[])objectArray);
        allKingsDisplay = CollectionsKt.emptyList();
        farDisplay = "";
        display = CollectionsKt.emptyList();
    }
}

