/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.misc.MiscConfig;
import at.hannibal2.skyhanni.data.IslandGraphs;
import at.hannibal2.skyhanni.data.model.Graph;
import at.hannibal2.skyhanni.data.model.GraphNode;
import at.hannibal2.skyhanni.events.minecraft.WorldChangeEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.GraphUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_2338;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0017\u0010\b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ1\u0010\u0010\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000b0\rH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0012\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0003R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001f\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010 R\u0016\u0010\"\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010 R\u001c\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001b0\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010 R\u0016\u0010&\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010\u0019\u00a8\u0006'"}, d2={"Lat/hannibal2/skyhanni/features/misc/NeuSoulPathFind;", "", "<init>", "()V", "", "render", "Lat/hannibal2/skyhanni/events/minecraft/WorldChangeEvent;", "event", "onWorldChange", "(Lat/hannibal2/skyhanni/events/minecraft/WorldChangeEvent;)V", "", "Lnet/minecraft/class_2338;", "allSouls", "Ljava/util/TreeMap;", "", "missingSouls", "updateList", "(Ljava/util/List;Ljava/util/TreeMap;)V", "remindFast", "Lat/hannibal2/skyhanni/config/features/misc/MiscConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/misc/MiscConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastRender", "J", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "missing", "Ljava/util/Set;", "", "lastMissing", "I", "found", "total", "goodRoute", "Ljava/util/List;", "currentIndex", "lastFastReminder", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nNeuSoulPathFind.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NeuSoulPathFind.kt\nat/hannibal2/skyhanni/features/misc/NeuSoulPathFind\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,127:1\n2393#2,14:128\n2393#2,14:142\n1#3:156\n*S KotlinDebug\n*F\n+ 1 NeuSoulPathFind.kt\nat/hannibal2/skyhanni/features/misc/NeuSoulPathFind\n*L\n67#1:128,14\n85#1:142,14\n*E\n"})
public final class NeuSoulPathFind {
    @NotNull
    public static final NeuSoulPathFind INSTANCE = new NeuSoulPathFind();
    private static long lastRender = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static Set<LorenzVec> missing = SetsKt.emptySet();
    private static int lastMissing;
    private static int found;
    private static int total;
    @NotNull
    private static List<LorenzVec> goodRoute;
    private static int currentIndex;
    private static long lastFastReminder;

    private NeuSoulPathFind() {
    }

    @NotNull
    public final MiscConfig getConfig() {
        return SkyHanniMod.feature.misc;
    }

    @JvmStatic
    public static final void render() {
        lastRender = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    @HandleEvent
    public final void onWorldChange(@NotNull WorldChangeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        missing = SetsKt.emptySet();
        lastMissing = 0;
        found = 0;
        total = 0;
        goodRoute = CollectionsKt.emptyList();
        currentIndex = 0;
    }

    @JvmStatic
    public static final void updateList(@NotNull List<? extends class_2338> allSouls, @NotNull TreeMap<Double, class_2338> missingSouls) {
        Object t;
        Object t2;
        Intrinsics.checkNotNullParameter(allSouls, (String)"allSouls");
        Intrinsics.checkNotNullParameter(missingSouls, (String)"missingSouls");
        List<? extends GraphNode> list = IslandGraphs.INSTANCE.getCurrentIslandGraph-ZhRhRFc();
        if (list == null) {
            return;
        }
        List<? extends GraphNode> graph = list;
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastRender), (long)DurationKt.toDuration((int)300, (DurationUnit)DurationUnit.MILLISECONDS)) > 0) {
            return;
        }
        if (!INSTANCE.getConfig().getNeuSoulsPathFind()) {
            return;
        }
        if (INSTANCE.getConfig().getFastFairySouls()) {
            return;
        }
        INSTANCE.remindFast();
        Map missingLocally = new LinkedHashMap();
        int foundLocally = 0;
        for (class_2338 class_23382 : allSouls) {
            GraphNode node;
            double distance;
            Object t3;
            LorenzVec vec = LorenzVecKt.toLorenzVec(class_23382);
            Iterable $this$minBy$iv = Graph.box-impl(graph);
            boolean $i$f$minByOrThrow = false;
            Iterator iterator$iv = $this$minBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t3 = minElem$iv;
            } else {
                GraphNode it = (GraphNode)minElem$iv;
                boolean bl = false;
                double minValue$iv = it.getPosition().distance(vec);
                do {
                    Object e$iv = iterator$iv.next();
                    GraphNode it2 = (GraphNode)e$iv;
                    boolean bl2 = false;
                    double v$iv = it2.getPosition().distance(vec);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t3 = minElem$iv;
            }
            if (!((distance = (node = (GraphNode)t3).getPosition().distance(vec)) < 15.0)) continue;
            if (missingSouls.values().contains(class_23382)) {
                missingLocally.put(vec, node);
                continue;
            }
            ++foundLocally;
        }
        missing = CollectionsKt.toSet((Iterable)missingLocally.keySet());
        found = foundLocally;
        total = missing.size() + found;
        if (missing.isEmpty()) {
            return;
        }
        Iterable iterable = Graph.box-impl(graph);
        boolean $i$f$minByOrThrow = false;
        Iterator iterator$iv = iterable.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object minElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t2 = minElem$iv;
        } else {
            GraphNode it = (GraphNode)minElem$iv;
            boolean bl = false;
            double minValue$iv = LocationUtils.INSTANCE.distanceSqToPlayer(it.getPosition());
            do {
                Object e$iv = iterator$iv.next();
                GraphNode it3 = (GraphNode)e$iv;
                boolean bl3 = false;
                double v$iv = LocationUtils.INSTANCE.distanceSqToPlayer(it3.getPosition());
                if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t2 = minElem$iv;
        }
        GraphNode playerNode = (GraphNode)t2;
        Map map = new LinkedHashMap();
        for (Map.Entry entry : missingLocally.entrySet()) {
            LorenzVec location = (LorenzVec)entry.getKey();
            GraphNode node = (GraphNode)entry.getValue();
            double lastDistance = node.getPosition().distance(location);
            double distance = ((Number)GraphUtils.INSTANCE.findShortestPathAsGraphWithDistance(playerNode, node).component2()).doubleValue();
            map.put(location, distance + lastDistance);
        }
        double percentage = (double)found / (double)total * (double)100;
        String label = "\u00a7b" + found + "/" + total + " (" + NumberUtil.INSTANCE.roundTo(percentage, 1) + "%)";
        Iterable iterable2 = map.entrySet();
        Iterator iterator2 = iterable2.iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Object t4 = iterator2.next();
        if (!iterator2.hasNext()) {
            t = t4;
        } else {
            Map.Entry it = (Map.Entry)t4;
            boolean bl = false;
            double d = ((Number)it.getValue()).doubleValue();
            do {
                Object t5 = iterator2.next();
                Map.Entry it4 = (Map.Entry)t5;
                boolean bl4 = false;
                double d2 = ((Number)it4.getValue()).doubleValue();
                if (Double.compare(d, d2) <= 0) continue;
                t4 = t5;
                d = d2;
            } while (iterator2.hasNext());
            t = t4;
        }
        LorenzVec closest = (LorenzVec)((Map.Entry)t).getKey();
        IslandGraphs.pathFind$default(IslandGraphs.INSTANCE, closest, "\u00a75NEU Souls " + label, LorenzColor.DARK_PURPLE.toColor(), null, null, NeuSoulPathFind::updateList$lambda$3, 24, null);
    }

    private final void remindFast() {
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastFastReminder), (long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.HOURS)) > 0) {
            lastFastReminder = SimpleTimeMark.Companion.now-uFjCsEo();
            ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, "SkyHanni has an even faster Fairy Soul pathfinding logic. Click here to enable it.", NeuSoulPathFind::remindFast$lambda$4, null, 0L, false, null, false, false, 252, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean updateList$lambda$3() {
        if (!INSTANCE.getConfig().getNeuSoulsPathFind()) return false;
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastRender), (long)DurationKt.toDuration((int)300, (DurationUnit)DurationUnit.MILLISECONDS)) >= 0) return false;
        return true;
    }

    private static final Unit remindFast$lambda$4() {
        INSTANCE.getConfig().setNeuSoulsPathFind(false);
        INSTANCE.getConfig().setFastFairySouls(true);
        return Unit.INSTANCE;
    }

    static {
        goodRoute = CollectionsKt.emptyList();
        lastFastReminder = SimpleTimeMark.Companion.farPast();
    }
}

