/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.nether;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.crimsonisle.SulphurSkitterBoxConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniTickEvent;
import at.hannibal2.skyhanni.features.fishing.FishingApi;
import at.hannibal2.skyhanni.utils.BlockUtils;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_238;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u000f\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u0003J\u000f\u0010\u000e\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0018\u0010 \u001a\u0004\u0018\u00010\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0018\u0010#\u001a\u0004\u0018\u00010\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010&\u001a\u00020%8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006("}, d2={"Lat/hannibal2/skyhanni/features/nether/SulphurSkitterBox;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniTickEvent;", "event", "", "onTick", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniTickEvent;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "calculateClosestSponge", "calculateSpongeLocations", "onWorldChange", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/crimsonisle/SulphurSkitterBoxConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/crimsonisle/SulphurSkitterBoxConfig;", "config", "", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "spongeLocations", "Ljava/util/List;", "closestSponge", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lnet/minecraft/class_238;", "renderBox", "Lnet/minecraft/class_238;", "", "RADIUS", "I", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nSulphurSkitterBox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SulphurSkitterBox.kt\nat/hannibal2/skyhanni/features/nether/SulphurSkitterBox\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,102:1\n2423#2,14:103\n126#3:117\n153#3,3:118\n*S KotlinDebug\n*F\n+ 1 SulphurSkitterBox.kt\nat/hannibal2/skyhanni/features/nether/SulphurSkitterBox\n*L\n48#1:103,14\n63#1:117\n63#1:118,3\n*E\n"})
public final class SulphurSkitterBox {
    @NotNull
    public static final SulphurSkitterBox INSTANCE = new SulphurSkitterBox();
    @NotNull
    private static List<LorenzVec> spongeLocations = CollectionsKt.emptyList();
    @Nullable
    private static LorenzVec closestSponge;
    @Nullable
    private static class_238 renderBox;
    private static final int RADIUS = 4;

    private SulphurSkitterBox() {
    }

    private final SulphurSkitterBoxConfig getConfig() {
        return SkyHanniMod.feature.getFishing().getTrophyFishing().getSulphurSkitterBox();
    }

    @HandleEvent
    public final void onTick(@NotNull SkyHanniTickEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (SkyHanniTickEvent.isMod$default(event2, 5, 0, 2, null)) {
            this.calculateClosestSponge();
        }
    }

    @HandleEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        this.calculateSpongeLocations();
    }

    private final void calculateClosestSponge() {
        class_238 class_2383;
        Object v0;
        Iterable $this$minByOrNull$iv = spongeLocations;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                LorenzVec it = (LorenzVec)minElem$iv;
                boolean bl = false;
                double minValue$iv = LocationUtils.INSTANCE.distanceToPlayer(it);
                do {
                    Object e$iv = iterator$iv.next();
                    LorenzVec it2 = (LorenzVec)e$iv;
                    $i$a$-minByOrNull-SulphurSkitterBox$calculateClosestSponge$location$1 = false;
                    double v$iv = LocationUtils.INSTANCE.distanceToPlayer(it2);
                    if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        LorenzVec location = v0;
        if (Intrinsics.areEqual((Object)location, (Object)closestSponge)) {
            return;
        }
        closestSponge = location;
        LorenzVec lorenzVec = location;
        if (lorenzVec != null) {
            LorenzVec it = lorenzVec;
            boolean bl = false;
            LorenzVec pos1 = it.add(-4, -4, -4);
            LorenzVec pos2 = it.add(5, 5, 5);
            class_2383 = WorldRenderUtils.expandBlock$default(WorldRenderUtils.INSTANCE, pos1.axisAlignedTo(pos2), 0, 1, null);
        } else {
            class_2383 = null;
        }
        renderBox = class_2383;
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateSpongeLocations() {
        void $this$mapTo$iv$iv;
        LorenzVec lorenzVec = LocationUtils.INSTANCE.playerLocation();
        class_2248 class_22482 = class_2246.field_10258;
        Intrinsics.checkNotNullExpressionValue((Object)class_22482, (String)"SPONGE");
        Map $this$map$iv = BlockUtils.nearbyBlocks$default(BlockUtils.INSTANCE, lorenzVec, 15, 0, class_22482, 4, null);
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((LorenzVec)it.getKey());
        }
        spongeLocations = (List)destination$iv$iv;
    }

    @HandleEvent
    public final void onWorldChange() {
        spongeLocations = CollectionsKt.emptyList();
        closestSponge = null;
        renderBox = null;
    }

    @HandleEvent
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        LorenzVec lorenzVec = closestSponge;
        if (lorenzVec == null) {
            return;
        }
        LorenzVec location = lorenzVec;
        if (LocationUtils.INSTANCE.distanceToPlayer(location) >= 50.0) {
            return;
        }
        class_238 class_2383 = renderBox;
        if (class_2383 == null) {
            return;
        }
        class_238 axis = class_2383;
        ChromaColour color = this.getConfig().getBoxColor();
        switch (WhenMappings.$EnumSwitchMapping$0[this.getConfig().getBoxType().ordinal()]) {
            case 1: {
                WorldRenderUtils.drawFilledBoundingBox$default(WorldRenderUtils.INSTANCE, event2, axis, color, 0.0f, false, false, false, 60, null);
                break;
            }
            case 2: {
                WorldRenderUtils.drawHitbox$default(WorldRenderUtils.INSTANCE, event2, axis, ColorUtils.INSTANCE.toColor(color), 0, false, 12, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final boolean isEnabled() {
        return IslandType.CRIMSON_ISLE.isCurrent() && this.getConfig().getEnabled() && (!this.getConfig().getOnlyWithRods() || FishingApi.INSTANCE.getHoldingLavaRod());
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 24, "crimsonIsle.sulphurSkitterBoxConfig", "fishing.trophyFishing.sulphurSkitterBox", null, 8, null);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SulphurSkitterBoxConfig.BoxType.values().length];
            try {
                nArray[SulphurSkitterBoxConfig.BoxType.FULL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SulphurSkitterBoxConfig.BoxType.WIREFRAME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

