/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.nether.ashfang;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.crimsonisle.ashfang.AshfangConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.entity.EntityEnterWorldEvent;
import at.hannibal2.skyhanni.events.entity.EntityLeaveWorldEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.features.nether.ashfang.AshfangManager;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.EntityUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.SkullTextureHolder;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.awt.Color;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010#\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u000b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0003J#\u0010\u0015\u001a\u00020\u0007*\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010!\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001b\u0010&\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u001b\u0010)\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010#\u001a\u0004\b(\u0010%R\u001a\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00050*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u001a\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00050*8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010,R\u0014\u0010.\u001a\u00020\u00178\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b.\u0010/\u00a8\u00060"}, d2={"Lat/hannibal2/skyhanni/features/nether/ashfang/AshfangHighlights;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/entity/EntityEnterWorldEvent;", "Lnet/minecraft/class_1531;", "event", "", "onEntityJoin", "(Lat/hannibal2/skyhanni/events/entity/EntityEnterWorldEvent;)V", "Lat/hannibal2/skyhanni/events/entity/EntityLeaveWorldEvent;", "onEntityLeave", "(Lat/hannibal2/skyhanni/events/entity/EntityLeaveWorldEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "onWorldChange", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "location", "", "text", "drawBlendedColorString", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;Lat/hannibal2/skyhanni/utils/LorenzVec;Ljava/lang/String;)V", "", "distance", "getColorCode", "(D)Ljava/lang/String;", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/crimsonisle/ashfang/AshfangConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/crimsonisle/ashfang/AshfangConfig;", "config", "BLAZING_SOUL$delegate", "Lkotlin/Lazy;", "getBLAZING_SOUL", "()Ljava/lang/String;", "BLAZING_SOUL", "GRAVITY_ORB$delegate", "getGRAVITY_ORB", "GRAVITY_ORB", "", "blazingSouls", "Ljava/util/Set;", "gravityOrbs", "MAX_DISTANCE", "D", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nAshfangHighlights.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AshfangHighlights.kt\nat/hannibal2/skyhanni/features/nether/ashfang/AshfangHighlights\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1869#2,2:105\n1869#2,2:107\n*S KotlinDebug\n*F\n+ 1 AshfangHighlights.kt\nat/hannibal2/skyhanni/features/nether/ashfang/AshfangHighlights\n*L\n60#1:105,2\n69#1:107,2\n*E\n"})
public final class AshfangHighlights {
    @NotNull
    public static final AshfangHighlights INSTANCE = new AshfangHighlights();
    @NotNull
    private static final Lazy BLAZING_SOUL$delegate = LazyKt.lazy(AshfangHighlights::BLAZING_SOUL_delegate$lambda$0);
    @NotNull
    private static final Lazy GRAVITY_ORB$delegate = LazyKt.lazy(AshfangHighlights::GRAVITY_ORB_delegate$lambda$1);
    @NotNull
    private static final Set<class_1531> blazingSouls = new LinkedHashSet();
    @NotNull
    private static final Set<class_1531> gravityOrbs = new LinkedHashSet();
    private static final double MAX_DISTANCE = 15.0;

    private AshfangHighlights() {
    }

    private final AshfangConfig getConfig() {
        return AshfangManager.INSTANCE.getConfig();
    }

    private final String getBLAZING_SOUL() {
        Lazy lazy = BLAZING_SOUL$delegate;
        return (String)lazy.getValue();
    }

    private final String getGRAVITY_ORB() {
        Lazy lazy = GRAVITY_ORB$delegate;
        return (String)lazy.getValue();
    }

    @HandleEvent(onlyOnIsland=IslandType.CRIMSON_ISLE)
    public final void onEntityJoin(@NotNull EntityEnterWorldEvent<class_1531> event2) {
        Intrinsics.checkNotNullParameter(event2, (String)"event");
        if (!AshfangManager.INSTANCE.getActive()) {
            return;
        }
        class_1531 entity = event2.getEntity();
        DelayedRun.INSTANCE.runNextTick((Function0<Unit>)((Function0)() -> AshfangHighlights.onEntityJoin$lambda$2(entity)));
    }

    @HandleEvent(onlyOnIsland=IslandType.CRIMSON_ISLE)
    public final void onEntityLeave(@NotNull EntityLeaveWorldEvent<class_1531> event2) {
        Intrinsics.checkNotNullParameter(event2, (String)"event");
        ((Collection)blazingSouls).remove(event2.getEntity());
        ((Collection)gravityOrbs).remove(event2.getEntity());
    }

    @HandleEvent
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event2) {
        LorenzVec location;
        class_1531 it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Color color;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!AshfangManager.INSTANCE.getActive()) {
            return;
        }
        if (this.getConfig().getBlazingSouls().getEnabled()) {
            color = ColorUtils.INSTANCE.toColor(this.getConfig().getBlazingSouls().getColor());
            $this$forEach$iv = blazingSouls;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (class_1531)element$iv;
                boolean bl = false;
                location = WorldRenderUtils.INSTANCE.exactLocation(event2, (class_1297)it);
                WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event2, location.add(-0.5, 1.25, -0.5), color, false, false, -0.15, 0.0, 0.0, 0.0f, false, 492, null);
                INSTANCE.drawBlendedColorString(event2, location, "Blazing Soul");
            }
        }
        if (this.getConfig().getGravityOrbs().getEnabled()) {
            color = ColorUtils.INSTANCE.toColor(this.getConfig().getGravityOrbs().getColor());
            $this$forEach$iv = gravityOrbs;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (class_1531)element$iv;
                boolean bl = false;
                location = WorldRenderUtils.INSTANCE.exactLocation(event2, (class_1297)it);
                WorldRenderUtils.INSTANCE.drawCylinderInWorld(event2, color, location.add(-0.5, -2.0, -0.5), 3.5f, 4.5f);
                INSTANCE.drawBlendedColorString(event2, location, "Gravity Orb");
            }
        }
    }

    @HandleEvent
    public final void onWorldChange() {
        blazingSouls.clear();
        gravityOrbs.clear();
    }

    private final void drawBlendedColorString(SkyHanniRenderWorldEvent $this$drawBlendedColorString, LorenzVec location, String text) {
        double distance = LocationUtils.INSTANCE.distanceToPlayer(location);
        if (distance < 15.0) {
            String colorCode = this.getColorCode(distance);
            WorldRenderUtils.drawString$default(WorldRenderUtils.INSTANCE, $this$drawBlendedColorString, LorenzVec.add$default(location, 0.0, 2.5, 0.0, 5, null), colorCode + text, false, null, 0.0, false, 0.0f, 0, 252, null);
        }
    }

    private final String getColorCode(double distance) {
        return ColorUtils.getExtendedColorCode$default(ColorUtils.INSTANCE, ColorUtils.INSTANCE.blendRGB(LorenzColor.GREEN.toColor(), LorenzColor.RED.toColor(), distance / 15.0), false, 1, null);
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 2, "ashfang.blazingSouls", "crimsonIsle.ashfang.blazingSouls.enabled", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 2, "ashfang.blazingSoulsColor", "crimsonIsle.ashfang.blazingSouls.color", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 1, "ashfang.gravityOrbs", "ashfang.gravityOrbs.enabled", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 1, "ashfang.gravityOrbsColor", "ashfang.gravityOrbs.color", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 2, "ashfang.gravityOrbs", "crimsonIsle.ashfang.gravityOrbs", null, 8, null);
    }

    private static final String BLAZING_SOUL_delegate$lambda$0() {
        return SkullTextureHolder.INSTANCE.getTexture("ASHFANG_BLAZING_SOUL");
    }

    private static final String GRAVITY_ORB_delegate$lambda$1() {
        return SkullTextureHolder.INSTANCE.getTexture("ASHFANG_GRAVITY_ORB");
    }

    private static final Unit onEntityJoin$lambda$2(class_1531 $entity) {
        Intrinsics.checkNotNullParameter((Object)$entity, (String)"$entity");
        if (EntityUtils.INSTANCE.wearingSkullTexture($entity, INSTANCE.getBLAZING_SOUL())) {
            ((Collection)blazingSouls).add($entity);
        } else if (EntityUtils.INSTANCE.wearingSkullTexture($entity, INSTANCE.getGRAVITY_ORB())) {
            ((Collection)gravityOrbs).add($entity);
        }
        return Unit.INSTANCE;
    }
}

