/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.render;

import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.render.QueuedLine;
import at.hannibal2.skyhanni.utils.render.SkyHanniRenderLayers;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 62\u00020\u0001:\u00016B!\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\u000b\u001a\u00020\nH\u0001\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J-\u0010\u0018\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u00142\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001b\u0010\u001fJ%\u0010 \u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b \u0010\u0013J7\u0010#\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00102\b\b\u0002\u0010\"\u001a\u00020\u0004\u00a2\u0006\u0004\b#\u0010$J/\u0010'\u001a\u00020\r2\u0006\u0010&\u001a\u00020%2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b'\u0010(R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010)\u001a\u0004\b*\u0010+R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010,\u001a\u0004\b-\u0010.R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010/\u001a\u0004\b0\u00101R\u001a\u00104\u001a\b\u0012\u0004\u0012\u000203028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105\u00a8\u00067"}, d2={"Lat/hannibal2/skyhanni/utils/render/LineDrawer;", "", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "event", "", "lineWidth", "", "depth", "<init>", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;IZ)V", "", "drawQueuedLines", "()V", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "p1", "p2", "Ljava/awt/Color;", "color", "addQueuedLine", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;Ljava/awt/Color;)V", "", "path", "", "bezierPoint", "drawPath", "(Ljava/util/List;Ljava/awt/Color;D)V", "location", "drawEdges", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Ljava/awt/Color;)V", "Lnet/minecraft/class_238;", "axisAlignedBB", "(Lnet/minecraft/class_238;Ljava/awt/Color;)V", "draw3DLine", "p3", "segments", "drawBezier2", "(Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;Ljava/awt/Color;I)V", "", "t", "calculateBezierPoint", "(FLat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/utils/LorenzVec;)Lat/hannibal2/skyhanni/utils/LorenzVec;", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "getEvent", "()Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "I", "getLineWidth", "()I", "Z", "getDepth", "()Z", "", "Lat/hannibal2/skyhanni/utils/render/QueuedLine;", "queuedLines", "Ljava/util/List;", "Companion", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nLineDrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineDrawer.kt\nat/hannibal2/skyhanni/utils/render/LineDrawer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1869#2,2:150\n1878#2,3:152\n1869#2,2:155\n*S KotlinDebug\n*F\n+ 1 LineDrawer.kt\nat/hannibal2/skyhanni/utils/render/LineDrawer\n*L\n52#1:150,2\n57#1:152,3\n65#1:155,2\n*E\n"})
public final class LineDrawer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SkyHanniRenderWorldEvent event;
    private final int lineWidth;
    private final boolean depth;
    @NotNull
    private final List<QueuedLine> queuedLines;

    @PublishedApi
    public LineDrawer(@NotNull SkyHanniRenderWorldEvent event2, int lineWidth, boolean depth) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        this.event = event2;
        this.lineWidth = lineWidth;
        this.depth = depth;
        this.queuedLines = new ArrayList();
    }

    @NotNull
    public final SkyHanniRenderWorldEvent getEvent() {
        return this.event;
    }

    public final int getLineWidth() {
        return this.lineWidth;
    }

    public final boolean getDepth() {
        return this.depth;
    }

    @PublishedApi
    public final void drawQueuedLines() {
        if (this.queuedLines.isEmpty()) {
            return;
        }
        class_1921.class_4687 layer = SkyHanniRenderLayers.INSTANCE.getLines(this.lineWidth, !this.depth);
        class_4588 buf = this.event.getVertexConsumers().getBuffer((class_1921)layer);
        class_4587.class_4665 matrix = this.event.getMatrices().method_23760();
        for (QueuedLine line : this.queuedLines) {
            buf.method_22918(matrix.method_23761(), (float)line.getP1().getX(), (float)line.getP1().getY(), (float)line.getP1().getZ()).method_60831(matrix, (float)line.getNormal().getX(), (float)line.getNormal().getY(), (float)line.getNormal().getZ()).method_1336(line.getColor().getRed(), line.getColor().getGreen(), line.getColor().getBlue(), line.getColor().getAlpha());
            buf.method_22918(matrix.method_23761(), (float)line.getP2().getX(), (float)line.getP2().getY(), (float)line.getP2().getZ()).method_60831(matrix, (float)line.getNormal().getX(), (float)line.getNormal().getY(), (float)line.getNormal().getZ()).method_1336(line.getColor().getRed(), line.getColor().getGreen(), line.getColor().getBlue(), line.getColor().getAlpha());
        }
        this.queuedLines.clear();
    }

    private final void addQueuedLine(LorenzVec p1, LorenzVec p2, Color color) {
        QueuedLine last = (QueuedLine)CollectionsKt.lastOrNull(this.queuedLines);
        if (last == null) {
            this.queuedLines.add(new QueuedLine(p1, p2, color));
            return;
        }
        if (!Intrinsics.areEqual((Object)last.getP2(), (Object)p1)) {
            this.drawQueuedLines();
        }
        this.queuedLines.add(new QueuedLine(p1, p2, color));
    }

    /*
     * WARNING - void declaration
     */
    public final void drawPath(@NotNull List<LorenzVec> path, @NotNull Color color, double bezierPoint) {
        Intrinsics.checkNotNullParameter(path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (bezierPoint < 0.0) {
            Iterable $this$forEach$iv = CollectionsKt.zipWithNext((Iterable)path);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                this.draw3DLine((LorenzVec)it.getFirst(), (LorenzVec)it.getSecond(), color);
            }
        } else {
            List pathLines = CollectionsKt.zipWithNext((Iterable)path);
            Iterable $this$forEachIndexed$iv = pathLines;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void pathLine;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Pair pair = (Pair)item$iv;
                int index = n;
                boolean bl = false;
                LorenzVec reduce = ((LorenzVec)pathLine.getSecond()).minus((LorenzVec)pathLine.getFirst()).normalize().times(bezierPoint);
                this.draw3DLine(index != 0 ? ((LorenzVec)pathLine.getFirst()).plus(reduce) : (LorenzVec)pathLine.getFirst(), index != CollectionsKt.getLastIndex((List)pathLines) ? ((LorenzVec)pathLine.getSecond()).minus(reduce) : (LorenzVec)pathLine.getSecond(), color);
            }
            Iterable $this$forEach$iv = CollectionUtils.INSTANCE.zipWithNext3((Iterable)path);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Triple it = (Triple)element$iv;
                boolean bl = false;
                LorenzVec p1 = ((LorenzVec)it.getSecond()).minus(((LorenzVec)it.getSecond()).minus((LorenzVec)it.getFirst()).normalize().times(bezierPoint));
                LorenzVec p3 = ((LorenzVec)it.getSecond()).minus(((LorenzVec)it.getSecond()).minus((LorenzVec)it.getThird()).normalize().times(bezierPoint));
                LorenzVec p2 = (LorenzVec)it.getSecond();
                LineDrawer.drawBezier2$default(this, p1, p2, p3, color, 0, 16, null);
            }
        }
    }

    public static /* synthetic */ void drawPath$default(LineDrawer lineDrawer, List list, Color color, double d, int n, Object object) {
        if ((n & 4) != 0) {
            d = 1.0;
        }
        lineDrawer.drawPath(list, color, d);
    }

    public final void drawEdges(@NotNull LorenzVec location, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        for (Pair<LorenzVec, LorenzVec> pair : location.getEdges()) {
            LorenzVec p1 = (LorenzVec)pair.component1();
            LorenzVec p2 = (LorenzVec)pair.component2();
            this.draw3DLine(p1, p2, color);
        }
    }

    public final void drawEdges(@NotNull class_238 axisAlignedBB, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)axisAlignedBB, (String)"axisAlignedBB");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        for (Pair<LorenzVec, LorenzVec> pair : LocationUtils.INSTANCE.calculateEdges(axisAlignedBB)) {
            LorenzVec p1 = (LorenzVec)pair.component1();
            LorenzVec p2 = (LorenzVec)pair.component2();
            this.draw3DLine(p1, p2, color);
        }
    }

    public final void draw3DLine(@NotNull LorenzVec p1, @NotNull LorenzVec p2, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.addQueuedLine(p1, p2, color);
    }

    public final void drawBezier2(@NotNull LorenzVec p1, @NotNull LorenzVec p2, @NotNull LorenzVec p3, @NotNull Color color, int segments) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        for (int i2 = 0; i2 < segments; ++i2) {
            float t1 = (float)i2 / (float)segments;
            float t2 = (float)(i2 + 1) / (float)segments;
            LorenzVec point1 = this.calculateBezierPoint(t1, p1, p2, p3);
            LorenzVec point2 = this.calculateBezierPoint(t2, p1, p2, p3);
            this.addQueuedLine(point1, point2, color);
        }
    }

    public static /* synthetic */ void drawBezier2$default(LineDrawer lineDrawer, LorenzVec lorenzVec, LorenzVec lorenzVec2, LorenzVec lorenzVec3, Color color, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 30;
        }
        lineDrawer.drawBezier2(lorenzVec, lorenzVec2, lorenzVec3, color, n);
    }

    private final LorenzVec calculateBezierPoint(float t, LorenzVec p1, LorenzVec p2, LorenzVec p3) {
        float u = 1.0f - t;
        float tt = t * t;
        float uu = u * u;
        double x = (double)uu * p1.getX() + (double)((float)2 * u * t) * p2.getX() + (double)tt * p3.getX();
        double y = (double)uu * p1.getY() + (double)((float)2 * u * t) * p2.getY() + (double)tt * p3.getY();
        double z = (double)uu * p1.getZ() + (double)((float)2 * u * t) * p2.getZ() + (double)tt * p3.getZ();
        return new LorenzVec(x, y, z);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JF\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0019\b\u0004\u0010\u000e\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\b\rH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0011"}, d2={"Lat/hannibal2/skyhanni/utils/render/LineDrawer$Companion;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "event", "", "lineWidth", "", "depth", "Lkotlin/Function1;", "Lat/hannibal2/skyhanni/utils/render/LineDrawer;", "", "Lkotlin/ExtensionFunctionType;", "draws", "draw3D", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;IZLkotlin/jvm/functions/Function1;)V", "1.21.5"})
    public static final class Companion {
        private Companion() {
        }

        public final void draw3D(@NotNull SkyHanniRenderWorldEvent event2, int lineWidth, boolean depth, @NotNull Function1<? super LineDrawer, Unit> draws) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            Intrinsics.checkNotNullParameter(draws, (String)"draws");
            boolean $i$f$draw3D = false;
            event2.getMatrices().method_22903();
            LorenzVec inverseView = WorldRenderUtils.INSTANCE.getViewerPos().negated();
            event2.getMatrices().method_22904(inverseView.getX(), inverseView.getY(), inverseView.getZ());
            LineDrawer lineDrawer = new LineDrawer(event2, lineWidth, depth);
            draws.invoke((Object)lineDrawer);
            lineDrawer.drawQueuedLines();
            event2.getMatrices().method_22909();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

