package at.hannibal2.skyhanni.config.features.misc

import at.hannibal2.skyhanni.config.FeatureToggle
import com.google.gson.annotations.Expose
import io.github.notenoughupdates.moulconfig.ChromaColour
import io.github.notenoughupdates.moulconfig.annotations.ConfigEditorBoolean
import io.github.notenoughupdates.moulconfig.annotations.ConfigEditorColour
import io.github.notenoughupdates.moulconfig.annotations.ConfigOption
import io.github.notenoughupdates.moulconfig.observer.Property

class CenturyPartyInvitationConfig {

    @ConfigOption(
        name = "Player Highlighter",
        desc = "Find players that can be invited to your Century Party.",
    )
    @Expose
    @ConfigEditorBoolean
    @FeatureToggle
    var playerHighlighter: Boolean = true

    @Expose
    @ConfigOption(name = "Can Invite", desc = "Color for players you can invite.")
    @ConfigEditorColour
    val canColor: Property<ChromaColour> = Property.of(ChromaColour.fromStaticRGB(85, 255, 85, 1))

    @Expose
    @ConfigOption(name = "No invitation", desc = "Color for players you can't invite.")
    @ConfigEditorColour
    val canNotColor: Property<ChromaColour> = Property.of(ChromaColour.fromStaticRGB(76, 76, 76, 1))
}
