package at.hannibal2.skyhanni.events.render.gui

import at.hannibal2.skyhanni.api.event.SkyHanniEvent
import net.minecraft.inventory.Inventory
import net.minecraft.item.ItemStack
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable

class ReplaceItemEvent(val inventory: Inventory, val originalItem: ItemStack?, val slot: Int) : SkyHanniEvent() {
    var replacement: ItemStack? = null
        private set
    var shouldRemove = false
        private set

    fun replace(replacement: ItemStack) {
        this.replacement = replacement
    }

    fun remove() {
        shouldRemove = true
    }

    companion object {
        @JvmStatic
        fun postEvent(
            inventory: Inventory,
            inventoryContents: Array<ItemStack?>,
            slot: Int,
            cir: CallbackInfoReturnable<ItemStack>,
        ) {
            val originalItem = inventoryContents.getOrNull(slot)
            val event = ReplaceItemEvent(inventory, originalItem, slot)
            event.post()
            if (event.shouldRemove) {
                //#if MC < 1.21
                //$$ cir.returnValue = null
                //#else
                cir.returnValue = ItemStack.EMPTY
                //#endif
                return
            }
            event.replacement?.let { cir.returnValue = it }
        }
    }
}
