package at.hannibal2.skyhanni.mixins.transformers;

import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.events.BlockClickEvent;
import at.hannibal2.skyhanni.events.ItemClickEvent;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.LorenzVecKt;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_636;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_636.class)
public class MixinClientPlayerInteractionManager {


    @Inject(method = "attackBlock", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/MinecraftClient;getTutorialManager()Lnet/minecraft/client/tutorial/TutorialManager;", ordinal = 1), cancellable = true)
    public void attackBlock(class_2338 pos, class_2350 direction, CallbackInfoReturnable<Boolean> cir) {
        LorenzVec position = LorenzVecKt.toLorenzVec(pos);
        boolean blockClickCancelled = new BlockClickEvent(ClickType.LEFT_CLICK, position, InventoryUtils.INSTANCE.getItemInHand()).post();
        ItemClickEvent itemClickEvent = new ItemClickEvent(InventoryUtils.INSTANCE.getItemInHand(), ClickType.LEFT_CLICK);
        if (blockClickCancelled) itemClickEvent.cancel();
        boolean itemClickCancelled = itemClickEvent.post();
        if (blockClickCancelled || itemClickCancelled) cir.setReturnValue(false);

    }

}
