package at.hannibal2.skyhanni.mixins.transformers;

import at.hannibal2.skyhanni.events.DataWatcherUpdatedEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2945;
import net.minecraft.class_9221;

@Mixin(class_2945.class)
public abstract class MixinDataWatcher {
    @Shadow
    @Final
    private class_9221 trackedEntity;

    @Shadow
    @Final
    private class_2945.class_2946<?>[] entries;

    @Shadow
    protected abstract void copyToFrom(class_2945.class_2946<?> par1, class_2945.class_7834<?> par2);

    @Inject(method = "writeUpdatedEntries", at = @At("TAIL"))
    public void onWhatever(List<class_2945.class_7834<?>> entries, CallbackInfo ci) {
        if (trackedEntity instanceof class_1297 entity) {
            List<class_2945.class_2946<?>> dataEntries = new ArrayList<>();
            for (class_2945.class_7834<?> serializedEntry : entries) {
                class_2945.class_2946<?> entry = this.entries[serializedEntry.comp_1115()];
                this.copyToFrom(entry, serializedEntry);
                dataEntries.add(entry);
            }

            new DataWatcherUpdatedEvent<>(entity, dataEntries).post();
        }
    }
}
