package at.hannibal2.skyhanni.utils

import at.hannibal2.skyhanni.SkyHanniMod
import at.hannibal2.skyhanni.api.event.HandleEvent
import at.hannibal2.skyhanni.config.commands.CommandCategory
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent
import at.hannibal2.skyhanni.skyhannimodule.SkyHanniModule
import at.hannibal2.skyhanni.test.command.ErrorManager
import kotlinx.coroutines.delay
import net.minecraft.client.MinecraftClient
import net.minecraft.client.sound.SoundInstance
import net.minecraft.sound.SoundCategory
import net.minecraft.util.Identifier
//#if MC < 1.21
//$$ import net.minecraft.client.audio.PositionedSound
//$$
//#else
import net.minecraft.client.sound.PositionedSoundInstance
import net.minecraft.sound.SoundEvent
//#endif

@SkyHanniModule
object SoundUtils {

    private val config get() = SkyHanniMod.feature.misc
    private val beepSoundCache = mutableMapOf<Float, SoundInstance>()
    private val clickSound by lazy { createSound("gui.button.press", 1f) }
    private val errorSound by lazy { createSound("mob.endermen.portal", 0f) }
    val plingSound by lazy { createSound("note.pling", 1f) }
    val centuryActiveTimerAlert by lazy { createSound("skyhanni:centurytimer.active", 1f) }

    fun SoundInstance.playSound() {
        DelayedRun.onThread.execute {
            //#if MC < 1.21
            //$$ val category = SoundCategory.PLAYERS
            //#else
            val category = this.category
            //#endif

            val oldLevel = MinecraftClient.getInstance().options.getCategorySoundVolume(category)
            if (!config.maintainGameVolume) category.setLevel(1f)

            try {
                MinecraftClient.getInstance().soundManager.play(this)
            } catch (e: IllegalArgumentException) {
                if (e.message?.startsWith("value already present:") == true) return@execute
                ErrorManager.logErrorWithData(
                    e,
                    "Failed to play a sound",
                    "soundLocation" to this.id,
                )
            } catch (e: Exception) {
                ErrorManager.logErrorWithData(
                    e,
                    "Failed to play a sound",
                    "soundLocation" to this.id,
                )
            } finally {
                if (!config.maintainGameVolume) category.setLevel(oldLevel)
            }
        }
    }

    // TODO this needs fixing on 1.21.9
    private fun SoundCategory.setLevel(level: Float) =
        //#if MC < 1.21.9
        //$$ MinecraftClient.getInstance().soundManager.updateSoundVolume(this, level)
    //#else
    Unit
    //#endif

    fun createSound(name: String, pitch: Float, volume: Float = 50f): SoundInstance {
        //#if MC < 1.21
        //$$ val sound: SoundInstance = object : PositionedSound(Identifier(name)) {
        //$$     init {
        //$$         this.volume = volume
        //$$         repeat = false
        //$$         repeatDelay = 0
        //$$         attenuationType = SoundInstance.AttenuationType.NONE
        //$$         this.pitch = pitch
        //$$     }
        //$$ }
        //$$ return sound
        //#else
        val newSound = at.hannibal2.skyhanni.utils.compat.SoundCompat.getModernSoundName(name)
        val identifier = Identifier.of(newSound.replace(Regex("[^a-z0-9/._-]"), ""))
        return PositionedSoundInstance.master(SoundEvent.of(identifier), pitch, volume)
        //#endif
    }

    fun playBeepSound(pitch: Float = 1f) {
        val beepSound = beepSoundCache.getOrPut(pitch) { createSound("random.orb", pitch) }
        beepSound.playSound()
    }

    fun playClickSound() {
        clickSound.playSound()
    }

    fun playPlingSound() {
        plingSound.playSound()
    }

    private fun onCommand(args: Array<String>) {
        if (args.isEmpty()) {
            ChatUtils.userError("Specify a sound effect to test")
            return
        }

        val soundName = args[0]
        val pitch = args.getOrNull(1)?.toFloat() ?: 1f
        val volume = args.getOrNull(2)?.toFloat() ?: 50f

        createSound(soundName, pitch, volume).playSound()
    }

    fun playErrorSound() {
        errorSound.playSound()
    }

    // TODO use duration for delay
    fun repeatSound(delay: Long, repeat: Int, sound: SoundInstance) {
        SkyHanniMod.launchCoroutine("repeatSound") {
            repeat(repeat) {
                sound.playSound()
                delay(delay)
            }
        }
    }

    @HandleEvent
    fun onCommandRegistration(event: CommandRegistrationEvent) {
        event.registerBrigadier("shplaysound") {
            description = "Play the specified sound effect at the given pitch and volume."
            category = CommandCategory.DEVELOPER_TEST
            legacyCallbackArgs { onCommand(it) }
        }
    }
}
