/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.api.event;

import at.hannibal2.skyhanni.api.event.EventListeners;
import at.hannibal2.skyhanni.api.event.GenericSkyHanniEvent;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.api.event.SkyHanniEvent;
import at.hannibal2.skyhanni.api.event.SkyHanniEvents;
import at.hannibal2.skyhanni.api.minecraftevents.ClientEvents;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.utils.ReflectionUtils;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001)B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0015\b\u0016\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0001\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J+\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ+\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u001b\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0013\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\u0004\b \u0010!R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\"\u001a\u0004\b#\u0010$R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010%R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001f0&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(\u00a8\u0006*"}, d2={"Lat/hannibal2/skyhanni/api/event/EventListeners;", "", "", "name", "", "isGeneric", "<init>", "(Ljava/lang/String;Z)V", "Ljava/lang/Class;", "event", "(Ljava/lang/Class;)V", "listener", "", "removeListener", "(Ljava/lang/Object;)V", "Ljava/lang/reflect/Method;", "method", "instance", "Lat/hannibal2/skyhanni/api/event/HandleEvent;", "options", "addListener", "(Ljava/lang/reflect/Method;Ljava/lang/Object;Lat/hannibal2/skyhanni/api/event/HandleEvent;)V", "buildListenerName", "(Ljava/lang/reflect/Method;)Ljava/lang/String;", "Lkotlin/Function1;", "createZeroParameterConsumer", "(Ljava/lang/reflect/Method;Ljava/lang/Object;)Lkotlin/jvm/functions/Function1;", "createSingleParameterConsumer", "resolveGenericType", "(Ljava/lang/reflect/Method;)Ljava/lang/Class;", "", "Lat/hannibal2/skyhanni/api/event/EventListeners$Listener;", "getListeners", "()Ljava/util/List;", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "Z", "", "listeners", "Ljava/util/List;", "Listener", "1.21.10"})
public final class EventListeners {
    @NotNull
    private final String name;
    private final boolean isGeneric;
    @NotNull
    private final List<Listener> listeners;

    private EventListeners(String name2, boolean isGeneric) {
        this.name = name2;
        this.isGeneric = isGeneric;
        this.listeners = new ArrayList();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public EventListeners(@NotNull Class<?> event2) {
        Intrinsics.checkNotNullParameter(event2, (String)"event");
        String string = event2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String[] stringArray = new String[]{"."};
        String string2 = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        if (string2 == null) {
            string2 = event2.getName();
        }
        String string3 = string2;
        Intrinsics.checkNotNull((Object)string3);
        this(StringsKt.replace$default((String)string3, (String)"$", (String)".", (boolean)false, (int)4, null), GenericSkyHanniEvent.class.isAssignableFrom(event2));
    }

    public final void removeListener(@NotNull Object listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.listeners.removeIf(arg_0 -> EventListeners.removeListener$lambda$1(arg_0 -> EventListeners.removeListener$lambda$0(listener, arg_0), arg_0));
    }

    public final void addListener(@NotNull Method method, @NotNull Object instance, @NotNull HandleEvent options) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (!Modifier.isPublic(method.getModifiers())) {
            boolean $i$a$-require-EventListeners$addListener$22 = false;
            String $i$a$-require-EventListeners$addListener$22 = "Method " + method.getName() + "() in " + instance.getClass().getName() + " is not public. Make sure to set it to public.";
            throw new IllegalArgumentException($i$a$-require-EventListeners$addListener$22.toString());
        }
        String name2 = this.buildListenerName(method);
        Function1<Object, Unit> eventConsumer = switch (method.getParameterCount()) {
            case 0 -> this.createZeroParameterConsumer(method, instance);
            case 1 -> this.createSingleParameterConsumer(method, instance);
            default -> throw new IllegalArgumentException("Method " + method.getName() + " must have either 0 or 1 parameters.");
        };
        Class<?> generic = this.isGeneric ? this.resolveGenericType(method) : null;
        this.listeners.add(new Listener(name2, arg_0 -> EventListeners.addListener$lambda$3(eventConsumer, arg_0), options, generic, null, 16, null));
    }

    private final String buildListenerName(Method method) {
        Object[] objectArray = method.getParameterTypes();
        Intrinsics.checkNotNullExpressionValue(objectArray, (String)"getParameterTypes(...)");
        Object[] objectArray2 = objectArray;
        StringBuilder stringBuilder = new StringBuilder();
        String string = ((StringBuilder)ArraysKt.joinTo$default((Object[])objectArray2, (Appendable)stringBuilder, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)buildListenerName.paramTypesString.1.INSTANCE, (int)48, null)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String paramTypesString2 = string;
        return method.getDeclaringClass().getName() + "." + method.getName() + paramTypesString2;
    }

    private final Function1<Object, Unit> createZeroParameterConsumer(Method method, Object instance) {
        Runnable runnable = ReflectionUtils.INSTANCE.createRunnableFromMethod(instance, method);
        return arg_0 -> EventListeners.createZeroParameterConsumer$lambda$4(runnable, arg_0);
    }

    private final Function1<Object, Unit> createSingleParameterConsumer(Method method, Object instance) {
        Consumer<Object> consumer = ReflectionUtils.INSTANCE.createConsumerFromMethod(instance, method);
        return arg_0 -> EventListeners.createSingleParameterConsumer$lambda$5(consumer, arg_0);
    }

    private final Class<?> resolveGenericType(Method method) {
        Class<?> clazz;
        block5: {
            block4: {
                Type[] typeArray = method.getGenericParameterTypes();
                Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getGenericParameterTypes(...)");
                clazz = (Class<?>)ArraysKt.getOrNull((Object[])typeArray, (int)0);
                if (clazz == null) break block4;
                Class<?> genericType = clazz;
                boolean bl = false;
                TypeVariable typeVariable = GenericSkyHanniEvent.class.getTypeParameters()[0];
                Intrinsics.checkNotNullExpressionValue(typeVariable, (String)"get(...)");
                Class<?> clazz2 = ReflectionUtils.INSTANCE.resolveUpperBoundSuperClassGenericParameter(genericType, typeVariable);
                if (clazz2 == null) {
                    throw new IllegalStateException(("Generic event handler type parameter is not present in event class hierarchy for type " + genericType).toString());
                }
                clazz = clazz2;
                if (clazz2 != null) break block5;
            }
            throw new IllegalStateException(("Method " + method.getName() + " does not have a generic parameter type.").toString());
        }
        return clazz;
    }

    @NotNull
    public final List<Listener> getListeners() {
        return this.listeners;
    }

    private static final boolean removeListener$lambda$0(Object $listener, Listener it) {
        Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual(it.getInvoker(), (Object)$listener);
    }

    private static final boolean removeListener$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void addListener$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        $tmp0.invoke(p0);
    }

    private static final Unit createZeroParameterConsumer$lambda$4(Runnable $runnable, Object object) {
        Intrinsics.checkNotNullParameter((Object)$runnable, (String)"$runnable");
        Intrinsics.checkNotNullParameter((Object)object, (String)"<unused var>");
        $runnable.run();
        return Unit.INSTANCE;
    }

    private static final Unit createSingleParameterConsumer$lambda$5(Consumer $consumer, Object event2) {
        Intrinsics.checkNotNullParameter((Object)$consumer, (String)"$consumer");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        $consumer.accept(event2);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0010\u0018\u00002\u00020\u0001Bb\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b\u0012-\b\u0002\u0010\u0011\u001a'\u0012#\u0012!\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u0003\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\u000bj\u0002`\u00100\n\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001cR\u0017\u0010\u001e\u001a\u00020\u001d8\u0006\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\u00020\u000f8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R?\u0010&\u001a'\u0012#\u0012!\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u0003\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\u000bj\u0002`\u00100\n8\u0002X\u0082\u0004\u00a2\u0006\f\n\u0004\b&\u0010'\u0012\u0004\b(\u0010)R\u0016\u0010*\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010\u001fR\u0016\u0010+\u001a\u00020\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010#R9\u0010,\u001a'\u0012#\u0012!\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u0003\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\u000bj\u0002`\u00100\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010'\u00a8\u0006-"}, d2={"Lat/hannibal2/skyhanni/api/event/EventListeners$Listener;", "", "", "name", "Ljava/util/function/Consumer;", "invoker", "Lat/hannibal2/skyhanni/api/event/HandleEvent;", "options", "Ljava/lang/Class;", "generic", "", "Lkotlin/Function1;", "Lat/hannibal2/skyhanni/api/event/SkyHanniEvent;", "Lkotlin/ParameterName;", "event", "", "Lat/hannibal2/skyhanni/api/event/EventPredicate;", "extraPredicates", "<init>", "(Ljava/lang/String;Ljava/util/function/Consumer;Lat/hannibal2/skyhanni/api/event/HandleEvent;Ljava/lang/Class;Ljava/util/List;)V", "shouldInvoke", "(Lat/hannibal2/skyhanni/api/event/SkyHanniEvent;)Z", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "Ljava/util/function/Consumer;", "getInvoker", "()Ljava/util/function/Consumer;", "Ljava/lang/Class;", "", "priority", "I", "getPriority", "()I", "receiveCancelled", "Z", "getReceiveCancelled", "()Z", "cachedPredicates", "Ljava/util/List;", "getCachedPredicates$annotations", "()V", "lastTick", "cachedPredicateValue", "predicates", "1.21.10"})
    @SourceDebugExtension(value={"SMAP\nEventListeners.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventListeners.kt\nat/hannibal2/skyhanni/api/event/EventListeners$Listener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1740#2,3:135\n1740#2,3:138\n*S KotlinDebug\n*F\n+ 1 EventListeners.kt\nat/hannibal2/skyhanni/api/event/EventListeners$Listener\n*L\n98#1:135,3\n101#1:138,3\n*E\n"})
    public static final class Listener {
        @NotNull
        private final String name;
        @NotNull
        private final Consumer<Object> invoker;
        @Nullable
        private final Class<?> generic;
        private final int priority;
        private final boolean receiveCancelled;
        @NotNull
        private final List<Function1<SkyHanniEvent, Boolean>> cachedPredicates;
        private int lastTick;
        private boolean cachedPredicateValue;
        @NotNull
        private final List<Function1<SkyHanniEvent, Boolean>> predicates;

        /*
         * WARNING - void declaration
         */
        public Listener(@NotNull String name2, @NotNull Consumer<Object> invoker, @NotNull HandleEvent options, @Nullable Class<?> generic, @NotNull List<? extends Function1<? super SkyHanniEvent, Boolean>> extraPredicates) {
            void $this$_init__u24lambda_u248;
            List $this$_init__u24lambda_u245;
            List list;
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            Intrinsics.checkNotNullParameter(invoker, (String)"invoker");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            Intrinsics.checkNotNullParameter(extraPredicates, (String)"extraPredicates");
            this.name = name2;
            this.invoker = invoker;
            this.generic = generic;
            this.priority = options.priority();
            this.receiveCancelled = options.receiveCancelled();
            this.lastTick = -1;
            List list2 = list = CollectionsKt.createListBuilder();
            Listener listener = this;
            boolean bl = false;
            if (options.onlyOnSkyblock()) {
                $this$_init__u24lambda_u245.add(Listener::lambda$5$lambda$2);
            }
            if (options.onlyOnIsland() != IslandType.ANY) {
                IslandType island = options.onlyOnIsland();
                $this$_init__u24lambda_u245.add(arg_0 -> Listener.lambda$5$lambda$3(island, arg_0));
            }
            if (!(options.onlyOnIslands().length == 0)) {
                Set set = ArraysKt.toSet((Object[])options.onlyOnIslands());
                $this$_init__u24lambda_u245.add(arg_0 -> Listener.lambda$5$lambda$4(set, arg_0));
            }
            listener.cachedPredicates = CollectionsKt.build((List)list);
            $this$_init__u24lambda_u245 = list = CollectionsKt.createListBuilder();
            listener = this;
            boolean bl2 = false;
            if (!this.receiveCancelled) {
                $this$_init__u24lambda_u248.add(Listener::lambda$8$lambda$6);
            }
            if (this.generic != null) {
                $this$_init__u24lambda_u248.add(arg_0 -> Listener.lambda$8$lambda$7(this, arg_0));
            }
            $this$_init__u24lambda_u248.addAll((Collection)extraPredicates);
            listener.predicates = CollectionsKt.build((List)list);
        }

        public /* synthetic */ Listener(String string, Consumer consumer, HandleEvent handleEvent, Class clazz, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(string, consumer, handleEvent, clazz, list);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final Consumer<Object> getInvoker() {
            return this.invoker;
        }

        public final int getPriority() {
            return this.priority;
        }

        public final boolean getReceiveCancelled() {
            return this.receiveCancelled;
        }

        private static /* synthetic */ void getCachedPredicates$annotations() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean shouldInvoke(@NotNull SkyHanniEvent event2) {
            Function1 it;
            Iterable $this$all$iv;
            boolean $i$f$all;
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            if (SkyHanniEvents.INSTANCE.isDisabledInvoker(this.name)) {
                return false;
            }
            if (this.lastTick != ClientEvents.INSTANCE.getTotalTicks()) {
                boolean bl;
                boolean bl2;
                block7: {
                    Iterable iterable = this.cachedPredicates;
                    Listener listener = this;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (Function1)element$iv;
                            boolean bl3 = false;
                            if (((Boolean)it.invoke((Object)event2)).booleanValue()) continue;
                            bl2 = false;
                            break block7;
                        }
                        bl2 = true;
                    }
                }
                listener.cachedPredicateValue = bl = bl2;
                this.lastTick = ClientEvents.INSTANCE.getTotalTicks();
            }
            if (!this.cachedPredicateValue) return false;
            $this$all$iv = this.predicates;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                return true;
            }
            Iterator iterator2 = $this$all$iv.iterator();
            do {
                Object element$iv;
                if (!iterator2.hasNext()) return true;
                element$iv = iterator2.next();
                it = (Function1)element$iv;
                boolean bl = false;
            } while (((Boolean)it.invoke((Object)event2)).booleanValue());
            return false;
        }

        private static final boolean lambda$5$lambda$2(SkyHanniEvent skyHanniEvent) {
            Intrinsics.checkNotNullParameter((Object)skyHanniEvent, (String)"<unused var>");
            return SkyBlockUtils.INSTANCE.getInSkyBlock();
        }

        private static final boolean lambda$5$lambda$3(IslandType $island, SkyHanniEvent skyHanniEvent) {
            Intrinsics.checkNotNullParameter((Object)((Object)$island), (String)"$island");
            Intrinsics.checkNotNullParameter((Object)skyHanniEvent, (String)"<unused var>");
            return $island.isCurrent();
        }

        private static final boolean lambda$5$lambda$4(Set $set, SkyHanniEvent skyHanniEvent) {
            Intrinsics.checkNotNullParameter((Object)$set, (String)"$set");
            Intrinsics.checkNotNullParameter((Object)skyHanniEvent, (String)"<unused var>");
            return SkyBlockUtils.INSTANCE.inAnyIsland($set);
        }

        private static final boolean lambda$8$lambda$6(SkyHanniEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            return !event2.isCancelled();
        }

        private static final boolean lambda$8$lambda$7(Listener this$0, SkyHanniEvent event2) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            return event2 instanceof GenericSkyHanniEvent && this$0.generic.isAssignableFrom(((GenericSkyHanniEvent)event2).getType());
        }
    }
}

