/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net;

import at.hannibal2.skyhanni.deps.commons.net.ProtocolCommandEvent;
import at.hannibal2.skyhanni.deps.commons.net.ProtocolCommandListener;
import at.hannibal2.skyhanni.deps.commons.net.util.ListenerList;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;

public class ProtocolCommandSupport
implements Serializable {
    private static final long serialVersionUID = -8017692739988399978L;
    private final Object source;
    private final ListenerList listeners = new ListenerList();

    public ProtocolCommandSupport(Object source) {
        this.source = source;
    }

    public void addProtocolCommandListener(ProtocolCommandListener listener) {
        this.listeners.addListener(listener);
    }

    public void fireCommandSent(String command2, String message) {
        ProtocolCommandEvent event2 = new ProtocolCommandEvent(this.source, command2, message);
        for (EventListener listener : this.listeners) {
            ((ProtocolCommandListener)listener).protocolCommandSent(event2);
        }
    }

    public void fireReplyReceived(int replyCode, String message) {
        ProtocolCommandEvent event2 = new ProtocolCommandEvent(this.source, replyCode, message);
        for (EventListener listener : this.listeners) {
            ((ProtocolCommandListener)listener).protocolReplyReceived(event2);
        }
    }

    public int getListenerCount() {
        return this.listeners.getListenerCount();
    }

    private void readObject(ObjectInputStream in) {
        throw new UnsupportedOperationException("Serialization is not supported");
    }

    public void removeProtocolCommandListener(ProtocolCommandListener listener) {
        this.listeners.removeListener(listener);
    }

    private void writeObject(ObjectOutputStream out) {
        throw new UnsupportedOperationException("Serialization is not supported");
    }
}

