/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig.gui.component;

import at.hannibal2.skyhanni.deps.moulconfig.common.IFontRenderer;
import at.hannibal2.skyhanni.deps.moulconfig.common.IMinecraft;
import at.hannibal2.skyhanni.deps.moulconfig.common.KeyboardConstants;
import at.hannibal2.skyhanni.deps.moulconfig.common.text.StructuredText;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiComponent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.GuiImmediateContext;
import at.hannibal2.skyhanni.deps.moulconfig.gui.KeyboardEvent;
import at.hannibal2.skyhanni.deps.moulconfig.gui.MouseEvent;
import at.hannibal2.skyhanni.deps.moulconfig.observer.GetSetter;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b(\b\u0016\u0018\u0000 Q2\u00020\u0001:\u0001QBA\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u0017\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001bJ\u0017\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001f\u0010\u001bJ\u001f\u0010!\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010#\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b#\u0010\u001bJ\u001f\u0010&\u001a\u00020\b2\u0006\u0010%\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b(\u0010)J\u001f\u0010+\u001a\u00020\b2\u0006\u0010+\u001a\u00020*2\u0006\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b+\u0010,J\u001f\u0010/\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b/\u00100J'\u0010/\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b/\u00102J\u001d\u00104\u001a\u00020\u00132\u0006\u00103\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\u0004\b4\u00105J\u001f\u00107\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u00106\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b7\u00108J\u001f\u0010:\u001a\u00020\u00052\u0006\u00109\u001a\u00020\b2\u0006\u00106\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b:\u0010;J\u0015\u0010=\u001a\u00020\u00132\u0006\u0010<\u001a\u00020\b\u00a2\u0006\u0004\b=\u0010>R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010?\u001a\u0004\b@\u0010AR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010BR\u001d\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006\u00a2\u0006\f\n\u0004\b\t\u0010C\u001a\u0004\bD\u0010ER\u0017\u0010\n\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\n\u0010F\u001a\u0004\bG\u0010)R\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010H\u001a\u0004\bI\u0010JR\u0016\u0010K\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bK\u0010BR\u0016\u0010L\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u0010BR\u0016\u0010M\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010BR\u0018\u0010 \u001a\u0004\u0018\u00010\u00038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010FR\u0016\u0010N\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bN\u0010OR\u0016\u0010P\u001a\u00020\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010O\u00a8\u0006R"}, d2={"Lat/hannibal2/skyhanni/deps/moulconfig/gui/component/TextFieldComponent;", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/GuiComponent;", "Lat/hannibal2/skyhanni/deps/moulconfig/observer/GetSetter;", "", "text", "", "preferredWidth", "Ljava/util/function/Supplier;", "", "editable", "suggestion", "Lat/hannibal2/skyhanni/deps/moulconfig/common/IFontRenderer;", "font", "<init>", "(Lio/github/notenoughupdates/moulconfig/observer/GetSetter;ILjava/util/function/Supplier;Ljava/lang/String;Lio/github/notenoughupdates/moulconfig/common/IFontRenderer;)V", "getWidth", "()I", "getHeight", "width", "", "scrollCursorIntoView", "(I)V", "checkScrollOffset", "updateVisibleText", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/GuiImmediateContext;", "context", "render", "(Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)V", "validateCursor", "()V", "renderSelection", "renderCursor", "visibleText", "renderText", "(Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;Ljava/lang/String;)V", "renderBox", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/KeyboardEvent;", "event", "keyboardEvent", "(Lio/github/notenoughupdates/moulconfig/gui/KeyboardEvent;Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)Z", "getSelection", "()Ljava/lang/String;", "Lat/hannibal2/skyhanni/deps/moulconfig/gui/MouseEvent;", "mouseEvent", "(Lio/github/notenoughupdates/moulconfig/gui/MouseEvent;Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;)Z", "str", "startIndex", "safeSubString", "(Ljava/lang/String;I)Ljava/lang/String;", "endIndex", "(Ljava/lang/String;II)Ljava/lang/String;", "s", "writeText", "(Ljava/lang/String;I)V", "i", "onDirectionalKey", "(Lio/github/notenoughupdates/moulconfig/gui/GuiImmediateContext;I)V", "skipWords", "skipCharacters", "(ZI)I", "new", "setShouldExpandToFit", "(Z)V", "Lat/hannibal2/skyhanni/deps/moulconfig/observer/GetSetter;", "getText", "()Lio/github/notenoughupdates/moulconfig/observer/GetSetter;", "I", "Ljava/util/function/Supplier;", "getEditable", "()Ljava/util/function/Supplier;", "Ljava/lang/String;", "getSuggestion", "Lat/hannibal2/skyhanni/deps/moulconfig/common/IFontRenderer;", "getFont", "()Lio/github/notenoughupdates/moulconfig/common/IFontRenderer;", "cursor", "selection", "scrollOffset", "shouldExpandToFit", "Z", "initializedCursor", "Companion", "common"})
public class TextFieldComponent
extends GuiComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GetSetter<String> text;
    private final int preferredWidth;
    @NotNull
    private final Supplier<Boolean> editable;
    @NotNull
    private final String suggestion;
    @NotNull
    private final IFontRenderer font;
    private int cursor;
    private int selection;
    private int scrollOffset;
    @Nullable
    private String visibleText;
    private boolean shouldExpandToFit;
    private boolean initializedCursor;
    private static final int TEXT_PADDING_X = 4;
    private static final int BACKGROUND_COLOR = -16777216;
    private static final int BORDER_COLOR_SELECTED = -16711936;
    private static final int BORDER_COLOR_UNSELECTED = -1;
    private static final int ENABLED_COLOR = -2039584;
    private static final int SUGGESTION_COLOR = -8355712;
    private static final int DISABLED_COLOR = -9408400;
    private static final int CURSOR_COLOR = -3092272;
    private static final int TEXT_PADDING_Y = 2;

    public TextFieldComponent(@NotNull GetSetter<String> text, int preferredWidth, @NotNull Supplier<Boolean> editable, @NotNull String suggestion, @NotNull IFontRenderer font) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        Intrinsics.checkNotNullParameter(editable, (String)"editable");
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.text = text;
        this.preferredWidth = preferredWidth;
        this.editable = editable;
        this.suggestion = suggestion;
        this.font = font;
        this.selection = -1;
    }

    public /* synthetic */ TextFieldComponent(GetSetter getSetter, int n, Supplier supplier, String string, IFontRenderer iFontRenderer, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            supplier = GetSetter.constant(true);
        }
        if ((n2 & 8) != 0) {
            string = "";
        }
        if ((n2 & 0x10) != 0) {
            iFontRenderer = IMinecraft.INSTANCE.getDefaultFontRenderer();
        }
        this(getSetter, n, supplier, string, iFontRenderer);
    }

    @NotNull
    public final GetSetter<String> getText() {
        return this.text;
    }

    @NotNull
    public final Supplier<Boolean> getEditable() {
        return this.editable;
    }

    @NotNull
    public final String getSuggestion() {
        return this.suggestion;
    }

    @NotNull
    public final IFontRenderer getFont() {
        return this.font;
    }

    @Override
    public int getWidth() {
        if (this.isFocused() && this.shouldExpandToFit) {
            return Math.max(this.preferredWidth, this.font.getStringWidth(StructuredText.of(this.text.get())) + 10);
        }
        return this.preferredWidth;
    }

    @Override
    public int getHeight() {
        return 14;
    }

    public void scrollCursorIntoView(int width) {
        this.validateCursor();
        if (this.scrollOffset > this.cursor) {
            this.scrollOffset = this.cursor;
        }
        if (this.scrollOffset < this.cursor) {
            String string = this.text.get();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
            if (this.font.trimStringToWidth(this.safeSubString(string, this.scrollOffset), width - 8).length() + this.scrollOffset < this.cursor) {
                this.scrollOffset = this.cursor;
            }
        }
        this.checkScrollOffset(width);
    }

    public void checkScrollOffset(int width) {
        String text = this.text.get();
        int rightMostScrollOffset = text.length() - this.font.trimStringToWidth(text, width - 8, true).length();
        this.scrollOffset = Math.max(0, Math.min(rightMostScrollOffset, this.scrollOffset));
    }

    public final void updateVisibleText(int width) {
        String string = this.text.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        this.visibleText = this.font.trimStringToWidth(this.safeSubString(string, this.scrollOffset), width - 8);
    }

    @Override
    public void render(@NotNull GuiImmediateContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.validateCursor();
        this.checkScrollOffset(context2.getWidth());
        this.updateVisibleText(context2.getWidth());
        this.renderBox(context2);
        String string = this.visibleText;
        Intrinsics.checkNotNull((Object)string);
        this.renderText(context2, string);
        String string2 = this.text.get();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
        if (((CharSequence)string2).length() == 0 && !this.isFocused()) {
            context2.getRenderContext().drawString(this.font, StructuredText.of(this.suggestion), 4, context2.getHeight() / 2 - this.font.getHeight() / 2, -8355712, false);
        }
        if (this.isFocused()) {
            this.renderCursor(context2);
        }
        this.renderSelection(context2);
    }

    public void validateCursor() {
        this.cursor = Math.max(0, Math.min(this.text.get().length(), this.cursor));
    }

    private final void renderSelection(GuiImmediateContext context2) {
        int right;
        int left;
        block5: {
            block4: {
                if (this.selection == this.cursor || this.selection == -1) {
                    return;
                }
                left = Math.min(this.cursor, this.selection);
                right = Math.max(this.cursor, this.selection);
                if (right < this.scrollOffset) break block4;
                String string = this.visibleText;
                Intrinsics.checkNotNull((Object)string);
                if (left <= this.scrollOffset + string.length()) break block5;
            }
            return;
        }
        int normalizedLeft = Math.max(this.scrollOffset, left) - this.scrollOffset;
        String string = this.visibleText;
        Intrinsics.checkNotNull((Object)string);
        int normalizedRight = Math.min(this.scrollOffset + string.length(), right) - this.scrollOffset;
        String string2 = this.visibleText;
        Intrinsics.checkNotNull((Object)string2);
        int leftPos = this.font.getStringWidth(this.safeSubString(string2, 0, normalizedLeft));
        String string3 = this.visibleText;
        Intrinsics.checkNotNull((Object)string3);
        int rightPos = leftPos + this.font.getStringWidth(this.safeSubString(string3, normalizedLeft, normalizedRight));
        context2.getRenderContext().invertedRect(4 + leftPos, 2.0f, 4 + rightPos, context2.getHeight() - 2, -16776961);
    }

    private final void renderCursor(GuiImmediateContext context2) {
        if (System.currentTimeMillis() / (long)1000 % (long)2 == 0L) {
            return;
        }
        if (this.cursor < this.scrollOffset) {
            return;
        }
        String string = this.visibleText;
        Intrinsics.checkNotNull((Object)string);
        if (this.cursor > this.scrollOffset + string.length()) {
            return;
        }
        String string2 = this.visibleText;
        Intrinsics.checkNotNull((Object)string2);
        int cursorOffset = this.font.getStringWidth(this.safeSubString(string2, 0, this.cursor - this.scrollOffset));
        context2.getRenderContext().drawColoredRect(4 + cursorOffset, 2.0f, 4 + cursorOffset + 1, context2.getHeight() - 2, -3092272);
    }

    private final void renderText(GuiImmediateContext context2, String visibleText) {
        int textColor = this.editable.get() != false ? -2039584 : -9408400;
        context2.getRenderContext().drawString(this.font, StructuredText.of(visibleText), 4, context2.getHeight() / 2 - this.font.getHeight() / 2, textColor, true);
    }

    private final void renderBox(GuiImmediateContext context2) {
        int borderColor = this.isFocused() ? -16711936 : -1;
        context2.getRenderContext().drawColoredRect(0.0f, 0.0f, context2.getWidth(), context2.getHeight(), borderColor);
        context2.getRenderContext().drawColoredRect(1.0f, 1.0f, context2.getWidth() - 1, context2.getHeight() - 1, -16777216);
    }

    @Override
    public boolean keyboardEvent(@NotNull KeyboardEvent event2, @NotNull GuiImmediateContext context2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!this.editable.get().booleanValue()) {
            return false;
        }
        if (!this.isFocused()) {
            return false;
        }
        if (event2 instanceof KeyboardEvent.KeyPressed && ((KeyboardEvent.KeyPressed)event2).getPressed()) {
            int n = ((KeyboardEvent.KeyPressed)event2).getKeycode();
            if (n == KeyboardConstants.INSTANCE.getLeft()) {
                this.onDirectionalKey(context2, -1);
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getRight()) {
                this.onDirectionalKey(context2, 1);
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getHome() || n == KeyboardConstants.INSTANCE.getUp()) {
                if (context2.getRenderContext().isShiftDown()) {
                    if (this.selection == -1) {
                        this.selection = this.cursor;
                    }
                } else {
                    this.selection = -1;
                }
                this.cursor = 0;
                this.scrollCursorIntoView(context2.getWidth());
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getDown() || n == KeyboardConstants.INSTANCE.getEnd()) {
                if (context2.getRenderContext().isShiftDown()) {
                    if (this.selection == -1) {
                        this.selection = this.cursor;
                    }
                } else {
                    this.selection = -1;
                }
                this.cursor = this.text.get().length();
                this.scrollCursorIntoView(context2.getWidth());
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getBackSpace()) {
                if (this.selection == -1) {
                    this.selection = this.skipCharacters(context2.getRenderContext().isLogicalCtrlDown(), -1);
                }
                this.writeText("", context2.getWidth());
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getDelete()) {
                if (this.selection == -1) {
                    this.selection = this.skipCharacters(context2.getRenderContext().isLogicalCtrlDown(), 1);
                }
                this.writeText("", context2.getWidth());
                return true;
            }
            if (n == KeyboardConstants.INSTANCE.getKeyC()) {
                if (context2.getRenderContext().isLogicalCtrlDown()) {
                    IMinecraft.INSTANCE.copyToClipboard(this.getSelection());
                    return true;
                }
                return false;
            }
            if (n == KeyboardConstants.INSTANCE.getKeyX()) {
                if (context2.getRenderContext().isLogicalCtrlDown()) {
                    IMinecraft.INSTANCE.copyToClipboard(this.getSelection());
                    this.writeText("", context2.getWidth());
                    return true;
                }
                return false;
            }
            if (n == KeyboardConstants.INSTANCE.getKeyV()) {
                if (context2.getRenderContext().isLogicalCtrlDown()) {
                    String string = IMinecraft.INSTANCE.copyFromClipboard();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"copyFromClipboard(...)");
                    this.writeText(string, context2.getWidth());
                    return true;
                }
                return false;
            }
            if (n == KeyboardConstants.INSTANCE.getKeyA()) {
                if (context2.getRenderContext().isLogicalCtrlDown()) {
                    this.cursor = this.text.get().length();
                    this.selection = 0;
                    this.scrollCursorIntoView(context2.getWidth());
                    return true;
                }
                return false;
            }
            return false;
        }
        if (event2 instanceof KeyboardEvent.CharTyped) {
            char it = ((KeyboardEvent.CharTyped)event2).getChar();
            boolean anyWritten = false;
            if (Intrinsics.compare((int)it, (int)32) >= 0 && it != '\u00a7' && it != '\u007f') {
                char c = it;
                String string = "";
                this.writeText(c + string, context2.getWidth());
                anyWritten = true;
            }
            return anyWritten;
        }
        return false;
    }

    private final String getSelection() {
        if (this.selection == -1) {
            return "";
        }
        int l = Math.min(this.cursor, this.selection);
        int r = Math.max(this.cursor, this.selection);
        String string = this.text.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        return this.safeSubString(string, l, r);
    }

    @Override
    public boolean mouseEvent(@NotNull MouseEvent mouseEvent, @NotNull GuiImmediateContext context2) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super.mouseEvent(mouseEvent, context2);
        this.checkScrollOffset(context2.getWidth());
        this.updateVisibleText(context2.getWidth());
        if (mouseEvent instanceof MouseEvent.Click && ((MouseEvent.Click)mouseEvent).getMouseState()) {
            if (context2.isHovered()) {
                this.requestFocus();
                if (!this.initializedCursor) {
                    this.initializedCursor = true;
                    this.cursor = Integer.MAX_VALUE;
                    this.validateCursor();
                    this.scrollCursorIntoView(context2.getWidth());
                }
                return true;
            }
            this.setFocus(false);
        }
        return false;
    }

    private final String safeSubString(String str, int startIndex) {
        String string = str.substring(Math.min(startIndex, str.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private final String safeSubString(String str, int startIndex, int endIndex) {
        String string = str.substring(Math.min(startIndex, str.length()), Math.min(Math.max(startIndex, endIndex), str.length()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    public final void writeText(@NotNull String s, int width) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String t = this.text.get();
        if (this.selection == -1) {
            StringBuilder stringBuilder = new StringBuilder();
            Intrinsics.checkNotNull((Object)t);
            this.text.set(stringBuilder.append(this.safeSubString(t, 0, this.cursor)).append(s).append(this.safeSubString(t, this.cursor)).toString());
            this.cursor += s.length();
        } else {
            int l = Math.min(this.cursor, this.selection);
            int r = Math.max(this.cursor, this.selection);
            StringBuilder stringBuilder = new StringBuilder();
            Intrinsics.checkNotNull((Object)t);
            this.text.set(stringBuilder.append(this.safeSubString(t, 0, l)).append(s).append(this.safeSubString(t, r)).toString());
            this.cursor = l + s.length();
            this.selection = -1;
        }
        this.scrollCursorIntoView(width);
    }

    public void onDirectionalKey(@NotNull GuiImmediateContext context2, int i2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getRenderContext().isShiftDown()) {
            if (this.selection == -1) {
                this.selection = this.cursor;
            }
            this.cursor = this.skipCharacters(context2.getRenderContext().isLogicalCtrlDown(), i2);
        } else if (this.selection != -1) {
            this.cursor = i2 < 0 ? Math.min(this.cursor, this.selection) : Math.max(this.cursor, this.selection);
            this.selection = -1;
        } else {
            this.cursor = this.skipCharacters(context2.getRenderContext().isLogicalCtrlDown(), i2);
        }
        this.scrollCursorIntoView(context2.getWidth());
    }

    private final int skipCharacters(boolean skipWords, int i2) {
        if (i2 != -1 && i2 != 1) {
            return this.cursor;
        }
        int position = this.cursor;
        do {
            if ((position += i2) < 0) {
                return 0;
            }
            if (position > this.text.get().length()) {
                return this.text.get().length();
            }
            if (skipWords) continue;
            return position;
        } while (position >= this.text.get().length() || !Character.isWhitespace(this.text.get().charAt(position)));
        return position;
    }

    public final void setShouldExpandToFit(boolean bl) {
        this.shouldExpandToFit = bl;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0014\u0010\n\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006R\u0014\u0010\f\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006R\u0014\u0010\u000e\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lat/hannibal2/skyhanni/deps/moulconfig/gui/component/TextFieldComponent$Companion;", "", "<init>", "()V", "", "TEXT_PADDING_X", "I", "BACKGROUND_COLOR", "BORDER_COLOR_SELECTED", "BORDER_COLOR_UNSELECTED", "ENABLED_COLOR", "SUGGESTION_COLOR", "DISABLED_COLOR", "CURSOR_COLOR", "TEXT_PADDING_Y", "common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

