/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.bingo;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.storage.PlayerSpecificStorage;
import at.hannibal2.skyhanni.data.HypixelData;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.data.jsonobjects.repo.BingoData;
import at.hannibal2.skyhanni.data.jsonobjects.repo.BingoJson;
import at.hannibal2.skyhanni.data.jsonobjects.repo.BingoRanksJson;
import at.hannibal2.skyhanni.data.repo.AbstractRepoManager;
import at.hannibal2.skyhanni.data.repo.AbstractRepoReloadEvent;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.RepositoryReloadEvent;
import at.hannibal2.skyhanni.features.bingo.card.goals.BingoGoal;
import at.hannibal2.skyhanni.features.bingo.card.goals.GoalType;
import at.hannibal2.skyhanni.features.bingo.card.goals.HiddenGoalData;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0013\u0010\u0010J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0017\u001a\u00020\f\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u0018*\u00020\u001b\u00a2\u0006\u0004\b\u0019\u0010\u001cJ\u000f\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010\"\u001a\u00020\f2\u0006\u0010!\u001a\u00020 \u00a2\u0006\u0004\b\"\u0010#J\u0015\u0010%\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u000e\u00a2\u0006\u0004\b%\u0010\u0016R\"\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000e0&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010(R\"\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00180&8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010(R\u001d\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001b0*8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0017\u00101\u001a\b\u0012\u0004\u0012\u00020\u001b0.8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0017\u00103\u001a\b\u0012\u0004\u0012\u00020\u001b0.8F\u00a2\u0006\u0006\u001a\u0004\b2\u00100R\"\u00105\u001a\u0002048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b5\u00106\u001a\u0004\b7\u0010\u001f\"\u0004\b8\u00109R\u001b\u0010?\u001a\u00020:8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>R\u001b\u0010B\u001a\u00020:8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b@\u0010<\u001a\u0004\bA\u0010>R\u001b\u0010H\u001a\u00020C8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bD\u0010E\u001a\u0004\bF\u0010G\u00a8\u0006I"}, d2={"Lat/hannibal2/skyhanni/features/bingo/BingoApi;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "event", "", "onDebug", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;", "onRepoReload", "(Lat/hannibal2/skyhanni/events/RepositoryReloadEvent;)V", "", "text", "", "getRankFromScoreboard", "(Ljava/lang/String;)Ljava/lang/Integer;", "getIconFromScoreboard", "(Ljava/lang/String;)Ljava/lang/String;", "getRank", "searchRank", "getIcon", "(I)Ljava/lang/String;", "itemName", "Lat/hannibal2/skyhanni/data/jsonobjects/repo/BingoData;", "getData", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/data/jsonobjects/repo/BingoData;", "Lat/hannibal2/skyhanni/features/bingo/card/goals/BingoGoal;", "(Lat/hannibal2/skyhanni/features/bingo/card/goals/BingoGoal;)Lat/hannibal2/skyhanni/data/jsonobjects/repo/BingoData;", "", "getStartOfMonthInMillis", "()J", "", "percentage", "getCommunityPercentageColor", "(D)Ljava/lang/String;", "rank", "getBingoIcon", "", "ranks", "Ljava/util/Map;", "data", "", "getBingoGoals", "()Ljava/util/Map;", "bingoGoals", "", "getPersonalGoals", "()Ljava/util/List;", "personalGoals", "getCommunityGoals", "communityGoals", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastBingoCardOpenTime", "J", "getLastBingoCardOpenTime-uFjCsEo", "setLastBingoCardOpenTime-gJLAdNM", "(J)V", "Ljava/util/regex/Pattern;", "detectionPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getDetectionPattern", "()Ljava/util/regex/Pattern;", "detectionPattern", "titleDetectionPattern$delegate", "getTitleDetectionPattern", "titleDetectionPattern", "Lat/hannibal2/skyhanni/config/storage/PlayerSpecificStorage$BingoSession;", "bingoStorage$delegate", "Lkotlin/Lazy;", "getBingoStorage", "()Lat/hannibal2/skyhanni/config/storage/PlayerSpecificStorage$BingoSession;", "bingoStorage", "1.21.10"})
@SourceDebugExtension(value={"SMAP\nBingoApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BingoApi.kt\nat/hannibal2/skyhanni/features/bingo/BingoApi\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 AbstractRepoReloadEvent.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoReloadEvent\n+ 4 AbstractRepoManager.kt\nat/hannibal2/skyhanni/data/repo/AbstractRepoManager\n+ 5 JsonUtils.kt\nat/hannibal2/skyhanni/utils/json/JsonUtilsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,138:1\n774#2:139\n865#2,2:140\n774#2:142\n865#2,2:143\n13#3,7:145\n21#3,6:162\n13#3,7:168\n21#3,6:185\n167#4,5:152\n172#4,4:158\n167#4,5:175\n172#4,4:181\n24#5:157\n24#5:180\n1#6:191\n538#7:192\n523#7,6:193\n384#7,7:199\n*S KotlinDebug\n*F\n+ 1 BingoApi.kt\nat/hannibal2/skyhanni/features/bingo/BingoApi\n*L\n33#1:139\n33#1:140,2\n34#1:142\n34#1:143,2\n83#1:145,7\n83#1:162,6\n84#1:168,7\n84#1:185,6\n83#1:152,5\n83#1:158,4\n84#1:175,5\n84#1:181,4\n83#1:157\n84#1:180\n102#1:192\n102#1:193,6\n112#1:199,7\n*E\n"})
public final class BingoApi {
    @NotNull
    public static final BingoApi INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static Map<String, Integer> ranks;
    @NotNull
    private static Map<String, BingoData> data;
    private static long lastBingoCardOpenTime;
    @NotNull
    private static final RepoPattern detectionPattern$delegate;
    @NotNull
    private static final RepoPattern titleDetectionPattern$delegate;
    @NotNull
    private static final Lazy bingoStorage$delegate;

    private BingoApi() {
    }

    @NotNull
    public final Map<Integer, BingoGoal> getBingoGoals() {
        return this.getBingoStorage().getGoals();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BingoGoal> getPersonalGoals() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getBingoGoals().values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BingoGoal it = (BingoGoal)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == GoalType.PERSONAL)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<BingoGoal> getCommunityGoals() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.getBingoGoals().values();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            BingoGoal it = (BingoGoal)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == GoalType.COMMUNITY)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final long getLastBingoCardOpenTime-uFjCsEo() {
        return lastBingoCardOpenTime;
    }

    public final void setLastBingoCardOpenTime-gJLAdNM(long l) {
        lastBingoCardOpenTime = l;
    }

    private final Pattern getDetectionPattern() {
        return (Pattern)detectionPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final Pattern getTitleDetectionPattern() {
        return (Pattern)titleDetectionPattern$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @HandleEvent
    public final void onDebug(@NotNull DebugDataCollectEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        event2.title("Bingo Card");
        if (!SkyBlockUtils.INSTANCE.isBingoProfile()) {
            event2.addIrrelevant("not on bingo");
            return;
        }
        event2.addData((Function1<? super List<String>, Unit>)((Function1)BingoApi::onDebug$lambda$2));
    }

    @HandleEvent
    public final void onRepoReload(@NotNull RepositoryReloadEvent event2) {
        Object object;
        AbstractRepoManager<?> abstractRepoManager;
        Object constantData$iv;
        Throwable e$iv$iv;
        boolean $i$f$fromJson;
        Gson $this$fromJson$iv$iv$iv;
        JsonElement json$iv$iv;
        String path$iv$iv;
        boolean bl3;
        Object $this$getRepoData_u24lambda_u2414$iv$iv;
        Object object2;
        AbstractRepoManager<?> this_$iv$iv;
        boolean $i$f$getRepoData;
        String directory$iv$iv;
        boolean bl22;
        Object $this$getConstant_u24lambda_u242$iv;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        String constant$iv = "BingoRanks";
        Object type$iv = null;
        Gson gson$iv = ((AbstractRepoReloadEvent)event2).getGson();
        boolean $i$f$getConstant = false;
        Object object3 = event2;
        try {
            $this$getConstant_u24lambda_u242$iv = object3;
            bl22 = false;
            AbstractRepoManager<?> abstractRepoManager2 = ((AbstractRepoReloadEvent)$this$getConstant_u24lambda_u242$iv).getManager();
            directory$iv$iv = "constants";
            $i$f$getRepoData = false;
            object2 = this_$iv$iv;
            try {
                $this$getRepoData_u24lambda_u2414$iv$iv = object2;
                bl3 = false;
                path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, constant$iv);
                JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                if (jsonElement == null) {
                    ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + constant$iv + "' not found.");
                    throw new KotlinNothingValueException();
                }
                json$iv$iv = jsonElement;
                $this$fromJson$iv$iv$iv = gson$iv;
                $i$f$fromJson = false;
                Object object4 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(BingoRanksJson.class)));
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"fromJson(...)");
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)object4);
            }
            catch (Throwable bl3) {
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            object2 = $this$getRepoData_u24lambda_u2414$iv$iv;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                e$iv$iv = throwable;
                boolean bl4 = false;
                this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + constant$iv + "'", e$iv$iv);
                throw new KotlinNothingValueException();
            }
            constantData$iv = object2;
            ((AbstractRepoReloadEvent)$this$getConstant_u24lambda_u242$iv).getManager().addSuccessfulConstant(constant$iv);
            abstractRepoManager = constantData$iv;
        }
        catch (Throwable bl22) {
            object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl22));
            Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
            if (throwable != null) {
                Throwable it$iv = throwable;
                boolean bl5 = false;
                ((AbstractRepoReloadEvent)event2).getManager().addUnsuccessfulConstant(constant$iv);
                ((AbstractRepoReloadEvent)event2).getManager().getLogger().throwErrorWithCause("Could not load constant '" + constant$iv + "'", it$iv);
                throw new KotlinNothingValueException();
            }
            throw new KotlinNothingValueException();
        }
        ranks = ((BingoRanksJson)((Object)abstractRepoManager)).getRanks();
        constant$iv = "Bingo";
        type$iv = null;
        gson$iv = ((AbstractRepoReloadEvent)event2).getGson();
        $i$f$getConstant = false;
        object3 = event2;
        try {
            $this$getConstant_u24lambda_u242$iv = object3;
            bl22 = false;
            this_$iv$iv = ((AbstractRepoReloadEvent)$this$getConstant_u24lambda_u242$iv).getManager();
            directory$iv$iv = "constants";
            $i$f$getRepoData = false;
            object2 = this_$iv$iv;
            try {
                $this$getRepoData_u24lambda_u2414$iv$iv = object2;
                bl3 = false;
                path$iv$iv = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).resolvePath(directory$iv$iv, constant$iv);
                JsonElement jsonElement = ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).readJsonElement(path$iv$iv);
                if (jsonElement == null) {
                    ((AbstractRepoManager)$this$getRepoData_u24lambda_u2414$iv$iv).getLogger().throwError("Repo file '" + constant$iv + "' not found.");
                    throw new KotlinNothingValueException();
                }
                json$iv$iv = jsonElement;
                $this$fromJson$iv$iv$iv = gson$iv;
                $i$f$fromJson = false;
                Object object5 = $this$fromJson$iv$iv$iv.fromJson(json$iv$iv, ReflectJvmMapping.getJavaType((KType)Reflection.typeOf(BingoJson.class)));
                Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"fromJson(...)");
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)object5);
            }
            catch (Throwable throwable) {
                $this$getRepoData_u24lambda_u2414$iv$iv = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = $this$getRepoData_u24lambda_u2414$iv$iv;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                e$iv$iv = throwable;
                boolean bl6 = false;
                this_$iv$iv.getLogger().throwErrorWithCause("Repo parsing error while trying to read constant '" + constant$iv + "'", e$iv$iv);
                throw new KotlinNothingValueException();
            }
            constantData$iv = object2;
            ((AbstractRepoReloadEvent)$this$getConstant_u24lambda_u242$iv).getManager().addSuccessfulConstant(constant$iv);
            object = constantData$iv;
        }
        catch (Throwable throwable) {
            object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object3);
            if (throwable2 != null) {
                Throwable it$iv = throwable2;
                boolean bl7 = false;
                ((AbstractRepoReloadEvent)event2).getManager().addUnsuccessfulConstant(constant$iv);
                ((AbstractRepoReloadEvent)event2).getManager().getLogger().throwErrorWithCause("Could not load constant '" + constant$iv + "'", it$iv);
                throw new KotlinNothingValueException();
            }
            throw new KotlinNothingValueException();
        }
        data = ((BingoJson)object).getBingoTips();
    }

    @Nullable
    public final Integer getRankFromScoreboard(@NotNull String text) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (RegexUtils.INSTANCE.matches(this.getDetectionPattern(), text)) {
            n = this.getRank(text);
        } else {
            String string = HypixelData.INSTANCE.getScoreboardTitle();
            if (RegexUtils.INSTANCE.matches(this.getTitleDetectionPattern(), string != null ? StringUtils.removeColor$default(StringUtils.INSTANCE, string, false, 1, null) : null)) {
                String string2 = HypixelData.INSTANCE.getScoreboardTitle();
                if (string2 == null) {
                    string2 = "";
                }
                n = this.getRank(string2);
            } else {
                n = null;
            }
        }
        return n;
    }

    @Nullable
    public final String getIconFromScoreboard(@NotNull String text) {
        String string;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Integer n = this.getRankFromScoreboard(text);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            string = INSTANCE.getIcon(it);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final Integer getRank(@NotNull String text) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Iterable iterable = ranks.entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)text, (CharSequence)((CharSequence)it.getKey()), (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? (Integer)entry.getValue() : null;
    }

    @Nullable
    public final String getIcon(int searchRank) {
        Object v0;
        block1: {
            Iterable iterable = ranks.entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!(((Number)it.getValue()).intValue() == searchRank)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? (String)entry.getKey() : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final BingoData getData(@NotNull String itemName2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)itemName2, (String)"itemName");
        Map<String, BingoData> $this$filter$iv = data;
        boolean $i$f$filter = false;
        Map<String, BingoData> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            String[] stringArray = new String[]{" (Community Goal)"};
            if (!StringsKt.startsWith$default((String)itemName2, (String)((String)StringsKt.split$default((CharSequence)((CharSequence)it.getKey()), (String[])stringArray, (boolean)false, (int)0, (int)6, null).get(0)), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return (BingoData)CollectionsKt.firstOrNull((Iterable)destination$iv$iv.values());
    }

    @Nullable
    public final BingoData getData(@NotNull BingoGoal $this$getData) {
        Intrinsics.checkNotNullParameter((Object)$this$getData, (String)"<this>");
        return $this$getData.getType() == GoalType.COMMUNITY ? this.getData($this$getData.getDisplayName()) : data.get($this$getData.getDisplayName());
    }

    @NotNull
    public final PlayerSpecificStorage.BingoSession getBingoStorage() {
        Lazy lazy = bingoStorage$delegate;
        return (PlayerSpecificStorage.BingoSession)lazy.getValue();
    }

    private final long getStartOfMonthInMillis() {
        return OffsetDateTime.of(TimeUtils.INSTANCE.getCurrentLocalDate().plusDays(5L).withDayOfMonth(1), LocalTime.MIDNIGHT, ZoneOffset.UTC).toEpochSecond();
    }

    @NotNull
    public final String getCommunityPercentageColor(double percentage) {
        return (percentage < 0.01 ? "\u00a7a" : (percentage < 0.05 ? "\u00a7e" : (percentage < 0.1 ? "\u00a76" : (percentage < 0.25 ? "\u00a76" : "\u00a7c")))) + NumberUtil.INSTANCE.formatPercentage(percentage);
    }

    @NotNull
    public final String getBingoIcon(int rank) {
        String string = this.getIcon(rank);
        if (string == null) {
            string = "";
        }
        String rankIcon = string;
        return rank != -1 ? rankIcon + " " + rank : rankIcon;
    }

    private static final Unit onDebug$lambda$2(List $this$addData) {
        Intrinsics.checkNotNullParameter((Object)$this$addData, (String)"$this$addData");
        $this$addData.add("bingoGoals: " + INSTANCE.getBingoGoals().size());
        for (Map.Entry<Integer, BingoGoal> bingoGoal : INSTANCE.getBingoGoals().entrySet()) {
            BingoGoal goal = bingoGoal.getValue();
            $this$addData.add("  type: '" + goal.getType() + "'");
            $this$addData.add("  displayName: '" + goal.getDisplayName() + "'");
            $this$addData.add("  description: '" + goal.getDescription() + "'");
            $this$addData.add("  guide: '" + goal.getGuide() + "'");
            $this$addData.add("  done: '" + goal.getDone() + "'");
            $this$addData.add("  highlight: '" + goal.getHighlight() + "'");
            $this$addData.add("  communityGoalPercentage: '" + goal.getCommunityGoalData() + "'");
            HiddenGoalData hiddenGoalData = goal.getHiddenGoalData();
            $this$addData.add("  hiddenGoalData");
            $this$addData.add("    unknownTip: '" + hiddenGoalData.getUnknownTip() + "'");
            $this$addData.add("    nextHintTime: '" + hiddenGoalData.getNextHintTime-FghU774() + "'");
            $this$addData.add("    tipNote: '" + hiddenGoalData.getTipNote() + "'");
            $this$addData.add(" ");
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final PlayerSpecificStorage.BingoSession bingoStorage_delegate$lambda$8() {
        Object object;
        void $this$getOrPut$iv;
        PlayerSpecificStorage playerSpecificStorage = ProfileStorageData.INSTANCE.getPlayerSpecific();
        if (playerSpecificStorage == null) {
            throw new IllegalStateException("playerSpecific is null".toString());
        }
        PlayerSpecificStorage playerSpecific = playerSpecificStorage;
        Map<Long, PlayerSpecificStorage.BingoSession> map = playerSpecific.getBingoSessions();
        Long key$iv = INSTANCE.getStartOfMonthInMillis();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            PlayerSpecificStorage.BingoSession answer$iv = new PlayerSpecificStorage.BingoSession();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (PlayerSpecificStorage.BingoSession)object;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(BingoApi.class, "detectionPattern", "getDetectionPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(BingoApi.class, "titleDetectionPattern", "getTitleDetectionPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new BingoApi();
        ranks = MapsKt.emptyMap();
        data = MapsKt.emptyMap();
        lastBingoCardOpenTime = SimpleTimeMark.Companion.farPast();
        detectionPattern$delegate = RepoPattern.Companion.pattern("bingo.detection.scoreboard", " \u00a7.\u24b7 \u00a7.Bingo");
        titleDetectionPattern$delegate = RepoPattern.Companion.pattern("bingo.detection.scoreboardtitle", "SKYBLOCK \u24b7");
        bingoStorage$delegate = LazyKt.lazy(BingoApi::bingoStorage_delegate$lambda$8);
    }
}

