/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.fishing.SeaCreatureFishEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniTickEvent;
import at.hannibal2.skyhanni.features.fishing.FishingApi;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lat/hannibal2/skyhanni/features/fishing/SharkFishCounter;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/fishing/SeaCreatureFishEvent;", "event", "", "onSeaCreatureFish", "(Lat/hannibal2/skyhanni/events/fishing/SeaCreatureFishEvent;)V", "", "name", "", "sharkIndex", "(Ljava/lang/String;)I", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniTickEvent;", "onTick", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniTickEvent;)V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "count", "funnyComment", "(I)Ljava/lang/String;", "", "isWaterFishingRod", "()Z", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "", "counter", "Ljava/util/List;", "display", "Ljava/lang/String;", "hasWaterRodInHand", "Z", "1.21.10"})
public final class SharkFishCounter {
    @NotNull
    public static final SharkFishCounter INSTANCE = new SharkFishCounter();
    @NotNull
    private static List<Integer> counter;
    @NotNull
    private static String display;
    private static boolean hasWaterRodInHand;

    private SharkFishCounter() {
    }

    @HandleEvent
    public final void onSeaCreatureFish(@NotNull SeaCreatureFishEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!SkyHanniMod.feature.getFishing().getSharkFishCounter()) {
            return;
        }
        String name2 = event2.getSeaCreature().getName();
        if (!StringsKt.contains$default((CharSequence)name2, (CharSequence)"Shark", (boolean)false, (int)2, null)) {
            return;
        }
        List<Integer> list = counter;
        int n = this.sharkIndex(name2);
        list.set(n, ((Number)list.get(n)).intValue() + (event2.getDoubleHook() ? 2 : 1));
        display = "\u00a77Sharks caught: \u00a7e" + NumberUtil.INSTANCE.addSeparators(CollectionsKt.sumOfInt((Iterable)counter)) + " \u00a77(\u00a7a" + counter.get(0) + " \u00a79" + counter.get(1) + " \u00a75" + counter.get(2) + " \u00a76" + counter.get(3) + "\u00a77)";
    }

    private final int sharkIndex(String name2) {
        return StringsKt.contains$default((CharSequence)name2, (CharSequence)"Blue", (boolean)false, (int)2, null) ? 1 : (StringsKt.contains$default((CharSequence)name2, (CharSequence)"Tiger", (boolean)false, (int)2, null) ? 2 : (StringsKt.contains$default((CharSequence)name2, (CharSequence)"Great", (boolean)false, (int)2, null) ? 3 : 0));
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onTick(@NotNull SkyHanniTickEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!SkyHanniMod.feature.getFishing().getSharkFishCounter()) {
            return;
        }
        if (SkyHanniTickEvent.isMod$default(event2, 10, 0, 2, null)) {
            hasWaterRodInHand = this.isWaterFishingRod();
        }
    }

    @HandleEvent
    public final void onChat(@NotNull SkyHanniChatEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!Intrinsics.areEqual((Object)event2.getMessage(), (Object)"\u00a7b\u00a7lFISHING FESTIVAL \u00a7r\u00a7eThe festival has concluded! Time to dry off and repair your rods!")) {
            return;
        }
        int count = CollectionsKt.sumOfInt((Iterable)counter);
        if (count == 0) {
            return;
        }
        int n = ((Number)counter.get(0)).intValue();
        int b = ((Number)counter.get(1)).intValue();
        int t = ((Number)counter.get(2)).intValue();
        int g = ((Number)counter.get(3)).intValue();
        String total = NumberUtil.INSTANCE.addSeparators(count);
        String funnyComment = this.funnyComment(count);
        ChatUtils.chat$default(ChatUtils.INSTANCE, "You caught " + total + " \u00a7f(\u00a7a" + n + " \u00a79" + b + " \u00a75" + t + " \u00a76" + g + "\u00a7f) \u00a7esharks during this fishing festival. " + funnyComment, false, null, false, false, null, 62, null);
        Object[] objectArray = new Integer[]{0, 0, 0, 0};
        counter = CollectionsKt.mutableListOf((Object[])objectArray);
        display = "";
    }

    private final String funnyComment(int count) {
        return count < 50 ? "Well done!" : (count < 100 ? "Nice!" : (count < 150 ? "Really nice!" : (count < 200 ? "Super cool!" : (count < 250 ? "Mega cool!" : (count < 350 ? "Like a pro!" : "How???")))));
    }

    private final boolean isWaterFishingRod() {
        return FishingApi.isFishing$default(FishingApi.INSTANCE, false, 1, null) && !FishingApi.INSTANCE.getHoldingLavaRod();
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!SkyHanniMod.feature.getFishing().getSharkFishCounter()) {
            return;
        }
        if (!hasWaterRodInHand) {
            return;
        }
        RenderUtils.renderString$default(RenderUtils.INSTANCE, SkyHanniMod.feature.getFishing().getSharkFishCounterPos(), display, 0, 0, "Shark Fish Counter", 6, null);
    }

    static {
        Object[] objectArray = new Integer[]{0, 0, 0, 0};
        counter = CollectionsKt.mutableListOf((Object[])objectArray);
        display = "";
    }
}

