/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.config.features.garden.MoneyPerHourConfig;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.features.garden.farming.CropMoneyDisplay;
import at.hannibal2.skyhanni.features.garden.farming.GardenCropSpeed;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.NeuItems;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.PrimitiveItemStack;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0011\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lat/hannibal2/skyhanni/features/garden/GardenCropTimeCommand;", "", "<init>", "()V", "", "", "args", "", "onCommand", "([Ljava/lang/String;)V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "event", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "Lat/hannibal2/skyhanni/config/features/garden/MoneyPerHourConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/MoneyPerHourConfig;", "config", "1.21.10"})
public final class GardenCropTimeCommand {
    @NotNull
    public static final GardenCropTimeCommand INSTANCE = new GardenCropTimeCommand();

    private GardenCropTimeCommand() {
    }

    private final MoneyPerHourConfig getConfig() {
        return GardenApi.INSTANCE.getConfig().getMoneyPerHours();
    }

    private final void onCommand(String[] args) {
        if (!this.getConfig().getDisplay()) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "shcroptime requires 'Show money per Hour' feature to be enabled to work!", false, 2, null);
            return;
        }
        if (args.length < 2) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Usage: /shcroptime <amount> <item>", false, 2, null);
            return;
        }
        Long l = NumberUtil.INSTANCE.formatLongOrUserError(args[0]);
        if (l == null) {
            return;
        }
        long amount = l;
        Map<NeuInternalName, Integer> multipliers = CropMoneyDisplay.INSTANCE.getMultipliers();
        if (multipliers.isEmpty()) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Data not loaded yet. Join the garden and display the money per hour display.", false, 2, null);
            return;
        }
        String rawSearchName = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)ArraysKt.toMutableList((Object[])args), (int)1), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        String string = rawSearchName.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String searchName = string;
        Map map = new LinkedHashMap();
        for (Map.Entry<NeuInternalName, Integer> entry : multipliers.entrySet()) {
            NeuInternalName internalName2 = entry.getKey();
            String itemName2 = ItemUtils.INSTANCE.getRepoItemName(internalName2);
            String string2 = StringUtils.removeColor$default(StringUtils.INSTANCE, itemName2, false, 1, null).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)searchName, (boolean)false, (int)2, null)) continue;
            PrimitiveItemStack primitiveItemStack = NeuItems.getPrimitiveMultiplier$default(NeuItems.INSTANCE, internalName2, 0, 2, null);
            NeuInternalName baseId = primitiveItemStack.component1();
            int baseAmount = primitiveItemStack.component2();
            String baseName = ItemUtils.INSTANCE.getRepoItemName(baseId);
            CropType crop = CropType.Companion.getByName(StringUtils.removeColor$default(StringUtils.INSTANCE, baseName, false, 1, null));
            long fullAmount = (long)baseAmount * amount;
            String text = baseAmount == 1 ? "\u00a7e" + NumberUtil.INSTANCE.addSeparators(amount) + "x " + itemName2 : "\u00a7e" + NumberUtil.INSTANCE.addSeparators(amount) + "x " + itemName2 + " \u00a77(\u00a7e" + NumberUtil.INSTANCE.addSeparators(fullAmount) + "x " + baseName + "\u00a77)";
            Integer speed = GardenCropSpeed.INSTANCE.getSpeed(crop);
            if (speed == null) {
                map.put(text + " \u00a7cNo speed data!", -1L);
                continue;
            }
            long missingTime = DurationKt.toDuration((long)(fullAmount / (long)speed.intValue()), (DurationUnit)DurationUnit.SECONDS);
            String duration = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, missingTime, null, false, false, 0, false, false, 63, null);
            map.put(text + " \u00a7b" + duration, Duration.getInWholeSeconds-impl((long)missingTime));
        }
        if (map.isEmpty()) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "No crop item found for '" + rawSearchName + "'.", false, 2, null);
            return;
        }
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Crop Speed for " + map.size() + " items:\n" + CollectionsKt.joinToString$default((Iterable)CollectionUtils.INSTANCE.sorted(map).keySet(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), false, null, false, false, null, 62, null);
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        event2.registerBrigadier("shcroptime", (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)GardenCropTimeCommand::onCommandRegistration$lambda$1));
    }

    private static final Unit onCommandRegistration$lambda$1$lambda$0(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.onCommand(it);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$1(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Calculates with your current crop per second speed how long you need to farm a crop to collect this amount of items");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_ACTIVE);
        $this$registerBrigadier.legacyCallbackArgs((Function1<String[], Unit>)((Function1)GardenCropTimeCommand::onCommandRegistration$lambda$1$lambda$0));
        return Unit.INSTANCE;
    }
}

