/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.farming;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.title.TitleManager;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.garden.GardenToolChangeEvent;
import at.hannibal2.skyhanni.events.garden.farming.CropClickEvent;
import at.hannibal2.skyhanni.features.garden.CropType;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockItemModifierUtils;
import at.hannibal2.skyhanni.utils.SoundUtils;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0015\u001a\u00020\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0018\u001a\u00020\u00178\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/events/garden/farming/CropClickEvent;", "onCropClick", "(Lat/hannibal2/skyhanni/events/garden/farming/CropClickEvent;)V", "notifyWrong", "Lat/hannibal2/skyhanni/events/garden/GardenToolChangeEvent;", "onGardenToolChange", "(Lat/hannibal2/skyhanni/events/garden/GardenToolChangeEvent;)V", "Lnet/minecraft/class_1799;", "item", "readItem", "(Lnet/minecraft/class_1799;)V", "Lat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning$FungiMode;", "mode", "Lat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning$FungiMode;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastPlaySoundTime", "J", "FungiMode", "1.21.10"})
public final class WrongFungiCutterWarning {
    @NotNull
    public static final WrongFungiCutterWarning INSTANCE = new WrongFungiCutterWarning();
    @NotNull
    private static FungiMode mode = FungiMode.UNKNOWN;
    private static long lastPlaySoundTime = SimpleTimeMark.Companion.farPast();

    private WrongFungiCutterWarning() {
    }

    @HandleEvent
    public final void onChat(@NotNull SkyHanniChatEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        String message = event2.getMessage();
        if (Intrinsics.areEqual((Object)message, (Object)"\u00a7eFungi Cutter Mode: \u00a7r\u00a7cRed Mushrooms")) {
            mode = FungiMode.RED;
        }
        if (Intrinsics.areEqual((Object)message, (Object)"\u00a7eFungi Cutter Mode: \u00a7r\u00a76Brown Mushrooms")) {
            mode = FungiMode.BROWN;
        }
    }

    @HandleEvent
    public final void onCropClick(@NotNull CropClickEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getClickType() != ClickType.LEFT_CLICK) {
            return;
        }
        if (event2.getCrop() != CropType.MUSHROOM) {
            return;
        }
        String string = event2.getBlockState().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String toString = string;
        if (Intrinsics.areEqual((Object)toString, (Object)"minecraft:red_mushroom") && mode == FungiMode.BROWN) {
            this.notifyWrong();
        }
        if (Intrinsics.areEqual((Object)toString, (Object)"minecraft:brown_mushroom") && mode == FungiMode.RED) {
            this.notifyWrong();
        }
    }

    private final void notifyWrong() {
        if (!GardenApi.INSTANCE.getConfig().getFungiCutterWarn()) {
            return;
        }
        TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, "\u00a7cWrong Fungi Cutter Mode!", null, DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), null, null, null, 0.0, false, false, null, 0L, null, null, 0L, 16378, null);
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastPlaySoundTime), (long)DurationKt.toDuration((int)300, (DurationUnit)DurationUnit.MILLISECONDS)) > 0) {
            lastPlaySoundTime = SimpleTimeMark.Companion.now-uFjCsEo();
            SoundUtils.playBeepSound$default(SoundUtils.INSTANCE, 0.0f, 1, null);
        }
    }

    @HandleEvent
    public final void onGardenToolChange(@NotNull GardenToolChangeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getCrop() == CropType.MUSHROOM) {
            class_1799 class_17992 = event2.getToolItem();
            if (class_17992 == null) {
                throw new IllegalStateException("Tool item is null".toString());
            }
            this.readItem(class_17992);
        } else {
            mode = FungiMode.UNKNOWN;
        }
    }

    private final void readItem(class_1799 item2) {
        String string = SkyBlockItemModifierUtils.INSTANCE.getFungiCutterMode(item2);
        if (string == null) {
            return;
        }
        String rawMode = string;
        mode = FungiMode.Companion.getOrNull(rawMode);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u0000 \u00042\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning$FungiMode;", "", "<init>", "(Ljava/lang/String;I)V", "Companion", "RED", "BROWN", "UNKNOWN", "1.21.10"})
    public static final class FungiMode
    extends Enum<FungiMode> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ FungiMode RED;
        public static final /* enum */ FungiMode BROWN;
        public static final /* enum */ FungiMode UNKNOWN;
        private static final /* synthetic */ FungiMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FungiMode[] values() {
            return (FungiMode[])$VALUES.clone();
        }

        public static FungiMode valueOf(String value) {
            return Enum.valueOf(FungiMode.class, value);
        }

        @NotNull
        public static EnumEntries<FungiMode> getEntries() {
            return $ENTRIES;
        }

        static {
            RED = new FungiMode();
            BROWN = new FungiMode();
            UNKNOWN = new FungiMode();
            $VALUES = fungiModeArray = new FungiMode[]{FungiMode.RED, FungiMode.BROWN, FungiMode.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning$FungiMode$Companion;", "", "<init>", "()V", "", "mode", "Lat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning$FungiMode;", "getOrNull", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning$FungiMode;", "1.21.10"})
        @SourceDebugExtension(value={"SMAP\nWrongFungiCutterWarning.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WrongFungiCutterWarning.kt\nat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning$FungiMode$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n295#2,2:89\n*S KotlinDebug\n*F\n+ 1 WrongFungiCutterWarning.kt\nat/hannibal2/skyhanni/features/garden/farming/WrongFungiCutterWarning$FungiMode$Companion\n*L\n84#1:89,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final FungiMode getOrNull(@NotNull String mode) {
                Object v0;
                block2: {
                    Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
                    Iterable $this$firstOrNull$iv = (Iterable)FungiMode.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        FungiMode it = (FungiMode)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.name(), (Object)mode)) continue;
                        v0 = element$iv;
                        break block2;
                    }
                    v0 = null;
                }
                FungiMode fungiMode = v0;
                if (fungiMode == null) {
                    throw new IllegalStateException(("Unknown fungi mode: '" + mode + "'").toString());
                }
                return fungiMode;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

