/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.chocolatefactory;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.inventory.chocolatefactory.CFUpgradeWarningsConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.events.ProfileJoinEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.fame.ReminderUtils;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.CFApi;
import at.hannibal2.skyhanni.features.inventory.chocolatefactory.CFCustomReminder;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.reflect.KProperty0;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0015\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001b\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001e\u00a8\u0006 "}, d2={"Lat/hannibal2/skyhanni/features/inventory/chocolatefactory/CFUpgradeWarning;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "event", "", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "checkUpgradeWarning", "Lat/hannibal2/skyhanni/events/ProfileJoinEvent;", "onProfileChange", "(Lat/hannibal2/skyhanni/events/ProfileJoinEvent;)V", "", "slot", "level", "checkUpgradeChange", "(II)V", "Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/CFUpgradeWarningsConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/chocolatefactory/CFUpgradeWarningsConfig;", "config", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CFStorage;", "getProfileStorage", "()Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CFStorage;", "profileStorage", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastUpgradeWarning", "J", "lastUpgradeSlot", "I", "lastUpgradeLevel", "1.21.10"})
public final class CFUpgradeWarning {
    @NotNull
    public static final CFUpgradeWarning INSTANCE = new CFUpgradeWarning();
    private static long lastUpgradeWarning = SimpleTimeMark.Companion.farPast();
    private static int lastUpgradeSlot = -1;
    private static int lastUpgradeLevel;

    private CFUpgradeWarning() {
    }

    private final CFUpgradeWarningsConfig getConfig() {
        return CFApi.INSTANCE.getConfig().getChocolateUpgradeWarnings();
    }

    private final ProfileSpecificStorage.CFStorage getProfileStorage() {
        return CFApi.INSTANCE.getProfileStorage();
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onSecondPassed(@NotNull SecondPassedEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ProfileSpecificStorage.CFStorage cFStorage = this.getProfileStorage();
        if (cFStorage == null) {
            return;
        }
        ProfileSpecificStorage.CFStorage profileStorage = cFStorage;
        long upgradeAvailableAt = profileStorage.getBestUpgradeAvailableAt-uFjCsEo();
        if (SimpleTimeMark.isInPast-impl(upgradeAvailableAt) && !SimpleTimeMark.isFarPast-impl(upgradeAvailableAt)) {
            this.checkUpgradeWarning();
        }
    }

    private final void checkUpgradeWarning() {
        if (!CFApi.INSTANCE.isEnabled()) {
            return;
        }
        if (!this.getConfig().getUpgradeWarning()) {
            return;
        }
        if (ReminderUtils.isBusy$default(ReminderUtils.INSTANCE, false, 1, null)) {
            return;
        }
        if (CFCustomReminder.INSTANCE.isActive()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastUpgradeWarning), (long)TimeUtils.INSTANCE.getMinutes-5sfh64U(this.getConfig().getTimeBetweenWarnings())) < 0) {
            return;
        }
        lastUpgradeWarning = SimpleTimeMark.Companion.now-uFjCsEo();
        if (this.getConfig().getUpgradeWarningSound()) {
            SoundUtils.playBeepSound$default(SoundUtils.INSTANCE, 0.0f, 1, null);
        }
        if (CFApi.INSTANCE.getInChocolateFactory()) {
            return;
        }
        ChatUtils.clickToActionOrDisable$default(ChatUtils.INSTANCE, "You have a Chocolate factory upgrade available to purchase!", (KProperty0)new MutablePropertyReference0Impl(this.getConfig()){

            public Object get() {
                return ((CFUpgradeWarningsConfig)this.receiver).getUpgradeWarning();
            }

            public void set(Object value) {
                ((CFUpgradeWarningsConfig)this.receiver).setUpgradeWarning((Boolean)value);
            }
        }, "open Chocolate Factory", CFUpgradeWarning::checkUpgradeWarning$lambda$0, false, 16, null);
    }

    @HandleEvent
    public final void onProfileChange(@NotNull ProfileJoinEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        lastUpgradeWarning = SimpleTimeMark.Companion.farPast();
    }

    public final void checkUpgradeChange(int slot, int level) {
        if (slot != lastUpgradeSlot || level != lastUpgradeLevel) {
            lastUpgradeWarning = SimpleTimeMark.Companion.now-uFjCsEo();
            lastUpgradeSlot = slot;
            lastUpgradeLevel = level;
        }
    }

    private static final Unit checkUpgradeWarning$lambda$0() {
        HypixelCommands.INSTANCE.chocolateFactory();
        return Unit.INSTANCE;
    }
}

