/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.mining.eventtracker;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.enums.OutsideSBFeature;
import at.hannibal2.skyhanni.config.features.mining.MiningEventConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.features.mining.eventtracker.MiningEventData;
import at.hannibal2.skyhanni.features.mining.eventtracker.MiningEventTracker;
import at.hannibal2.skyhanni.features.mining.eventtracker.MiningEventType;
import at.hannibal2.skyhanni.features.mining.eventtracker.MiningIslandEventInfo;
import at.hannibal2.skyhanni.features.mining.eventtracker.RunningEventType;
import at.hannibal2.skyhanni.utils.ConfigUtils;
import at.hannibal2.skyhanni.utils.NeuInternalName;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.collection.RenderableCollectionUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.container.HorizontalContainerRenderable;
import at.hannibal2.skyhanni.utils.renderables.primitives.ItemStackRenderable;
import at.hannibal2.skyhanni.utils.renderables.primitives.StringRenderable;
import at.hannibal2.skyhanni.utils.renderables.primitives.TextRenderableKt;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0015\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J-\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00192\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020#H\u0007\u00a2\u0006\u0004\b$\u0010%R\u0014\u0010)\u001a\u00020&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R \u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020-0,8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010/R\u0014\u00101\u001a\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b1\u00102R\u0014\u00103\u001a\u0002008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00102R\u0014\u00105\u001a\u0002048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0014\u00107\u001a\u0002048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00106\u00a8\u00068"}, d2={"Lat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventDisplay;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "event", "", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "updateDisplay", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "updateEvents", "()Ljava/util/List;", "Lat/hannibal2/skyhanni/data/IslandType;", "islandType", "getIslandIcon", "(Lat/hannibal2/skyhanni/data/IslandType;)Ljava/util/List;", "Lat/hannibal2/skyhanni/features/mining/eventtracker/RunningEventType;", "events", "Lat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventType;", "lastEvent", "", "formatUpcomingEvents", "(Ljava/util/List;Lat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventType;)[Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "Lat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventData;", "eventData", "updateData", "(Lat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventData;)V", "", "shouldDisplay", "()Z", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/mining/MiningEventConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/mining/MiningEventConfig;", "config", "display", "Ljava/util/List;", "", "Lat/hannibal2/skyhanni/features/mining/eventtracker/MiningIslandEventInfo;", "islandEventData", "Ljava/util/Map;", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "mithrilOre", "Lat/hannibal2/skyhanni/utils/NeuInternalName;", "perfRuby", "Lat/hannibal2/skyhanni/utils/renderables/primitives/StringRenderable;", "unknownDisplay", "Lat/hannibal2/skyhanni/utils/renderables/primitives/StringRenderable;", "transitionDisplay", "1.21.10"})
@SourceDebugExtension(value={"SMAP\nMiningEventDisplay.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MiningEventDisplay.kt\nat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventDisplay\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,148:1\n1056#2:149\n1193#2,2:150\n1267#2,4:152\n774#2:156\n865#2,2:157\n1374#2:159\n1460#2,5:160\n1563#2:165\n1634#2,3:166\n1374#2:170\n1460#2,5:171\n774#2:180\n865#2,2:181\n1056#2:183\n1#3:169\n37#4:176\n36#4,3:177\n*S KotlinDebug\n*F\n+ 1 MiningEventDisplay.kt\nat/hannibal2/skyhanni/features/mining/eventtracker/MiningEventDisplay\n*L\n54#1:149\n61#1:150,2\n61#1:152,4\n103#1:156\n103#1:157,2\n104#1:159\n104#1:160,5\n107#1:165\n107#1:166,3\n111#1:170\n111#1:171,5\n119#1:180\n119#1:181,2\n120#1:183\n111#1:176\n111#1:177,3\n*E\n"})
public final class MiningEventDisplay {
    @NotNull
    public static final MiningEventDisplay INSTANCE = new MiningEventDisplay();
    @NotNull
    private static List<? extends Renderable> display = CollectionsKt.emptyList();
    @NotNull
    private static final Map<IslandType, MiningIslandEventInfo> islandEventData = new LinkedHashMap();
    @NotNull
    private static final NeuInternalName mithrilOre = NeuInternalName.Companion.toInternalName("MITHRIL_ORE");
    @NotNull
    private static final NeuInternalName perfRuby = NeuInternalName.Companion.toInternalName("PERFECT_RUBY_GEM");
    @NotNull
    private static final StringRenderable unknownDisplay = TextRenderableKt.text$default(Renderable.Companion, "\u00a77???", 0.0, null, null, null, 30, null);
    @NotNull
    private static final StringRenderable transitionDisplay = TextRenderableKt.text$default(Renderable.Companion, "\u00a78->", 0.0, null, null, null, 30, null);

    private MiningEventDisplay() {
    }

    private final MiningEventConfig getConfig() {
        return SkyHanniMod.feature.getMining().getMiningEvent();
    }

    @HandleEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        this.updateDisplay();
    }

    @HandleEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.shouldDisplay()) {
            return;
        }
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, this.getConfig().getPosition(), display, 0, "Mining Event Tracker", false, 10, null);
    }

    private final void updateDisplay() {
        display = this.updateEvents();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Renderable> updateEvents() {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Iterable $this$sortedBy$iv;
        List list;
        List $this$updateEvents_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (MiningEventTracker.INSTANCE.getApiError()) {
            int count = MiningEventTracker.INSTANCE.getApiErrorCount();
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$updateEvents_u24lambda_u243, "\u00a7cMining Event API Error! (" + count + ")", 0.0, null, null, 14, null);
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$updateEvents_u24lambda_u243, "\u00a7cSwap servers to try again!", 0.0, null, null, 14, null);
        }
        Iterable iterable = islandEventData.entrySet();
        boolean bl2 = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                int n;
                int n2;
                Map.Entry entry = (Map.Entry)a;
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$0[((IslandType)((Object)entry.getKey())).ordinal()]) {
                    case 1: {
                        n2 = 0;
                        break;
                    }
                    case 2: {
                        n2 = 1;
                        break;
                    }
                    default: {
                        n2 = Integer.MAX_VALUE;
                    }
                }
                entry = (Map.Entry)b;
                Comparable comparable = Integer.valueOf(n2);
                bl = false;
                switch (WhenMappings.$EnumSwitchMapping$0[((IslandType)((Object)entry.getKey())).ordinal()]) {
                    case 1: {
                        n = 0;
                        break;
                    }
                    case 2: {
                        n = 1;
                        break;
                    }
                    default: {
                        n = Integer.MAX_VALUE;
                    }
                }
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(n));
            }
        });
        boolean entry = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var8_12 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl22 = false;
            Pair pair = TuplesKt.to(it.getKey(), it.getValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map sortedIslandEventData = destination$iv$iv;
        for (Map.Entry entry2 : sortedIslandEventData.entrySet()) {
            boolean shouldShow;
            IslandType islandType = (IslandType)((Object)entry2.getKey());
            MiningIslandEventInfo eventDetails = (MiningIslandEventInfo)entry2.getValue();
            switch (WhenMappings.$EnumSwitchMapping$1[INSTANCE.getConfig().getShowType().ordinal()]) {
                case 1: {
                    boolean bl3;
                    if (islandType == IslandType.DWARVEN_MINES) {
                        bl3 = true;
                        break;
                    }
                    bl3 = false;
                    break;
                }
                case 2: {
                    boolean bl3;
                    if (islandType == IslandType.CRYSTAL_HOLLOWS) {
                        bl3 = true;
                        break;
                    }
                    bl3 = false;
                    break;
                }
                case 3: {
                    boolean bl3 = islandType.isCurrent();
                    break;
                }
                default: {
                    boolean bl3 = shouldShow = true;
                }
            }
            if ((RunningEventType)CollectionsKt.firstOrNull(eventDetails.getIslandEvents()) != null) {
                RunningEventType firstEvent;
                boolean bl4 = false;
                if (SimpleTimeMark.isInPast-impl(SimpleTimeMark.Companion.asTimeMark-1cd6UlU(firstEvent.getEndsAt()))) {
                    eventDetails.setLastEvent(firstEvent.getEvent());
                }
            }
            if (!shouldShow) continue;
            Object[] upcomingEvents = INSTANCE.formatUpcomingEvents(eventDetails.getIslandEvents(), eventDetails.getLastEvent());
            Renderable islandName = INSTANCE.getConfig().getIslandAsIcon() ? (Renderable)HorizontalContainerRenderable.Companion.horizontal$default(HorizontalContainerRenderable.Companion, Renderable.Companion, INSTANCE.getIslandIcon(islandType), 0, null, null, 14, null) : (Renderable)TextRenderableKt.text$default(Renderable.Companion, "\u00a7a" + islandType.getDisplayName() + "\u00a78:", 0.0, null, null, null, 30, null);
            $this$updateEvents_u24lambda_u243.add(HorizontalContainerRenderable.Companion.horizontal$default(HorizontalContainerRenderable.Companion, Renderable.Companion, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)islandName), (Object[])upcomingEvents), 3, null, null, 12, null));
        }
        return CollectionsKt.build((List)list);
    }

    private final List<Renderable> getIslandIcon(IslandType islandType) {
        Object[] objectArray = new Renderable[2];
        objectArray[0] = switch (WhenMappings.$EnumSwitchMapping$0[islandType.ordinal()]) {
            case 1 -> ItemStackRenderable.Companion.item$default(ItemStackRenderable.Companion, Renderable.Companion, mithrilOre, 0.0, 0, 0, false, null, null, 126, null);
            case 2 -> ItemStackRenderable.Companion.item$default(ItemStackRenderable.Companion, Renderable.Companion, perfRuby, 0.0, 0, 0, false, null, null, 126, null);
            default -> unknownDisplay;
        };
        objectArray[1] = TextRenderableKt.text$default(Renderable.Companion, "\u00a78:", 0.0, null, null, null, 30, null);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private final Renderable[] formatUpcomingEvents(List<RunningEventType> events2, MiningEventType lastEvent) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object list$iv$iv;
        Object[] objectArray;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = events2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (RunningEventType)element$iv$iv;
            boolean bl = false;
            if (!(!SimpleTimeMark.isInPast-impl(SimpleTimeMark.Companion.asTimeMark-1cd6UlU(((RunningEventType)it).getEndsAt())))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            it = (RunningEventType)element$iv$iv;
            boolean bl = false;
            if (((RunningEventType)it).isDoubleEvent()) {
                objectArray = new MiningEventType[]{((RunningEventType)it).getEvent(), ((RunningEventType)it).getEvent()};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                list = CollectionsKt.listOf((Object)((Object)((RunningEventType)it).getEvent()));
            }
            list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (MiningEventType)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((MiningEventType)((Object)it)).getRenderable());
        }
        List upcoming = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (upcoming.isEmpty()) {
            upcoming.add(unknownDisplay);
        }
        if (this.getConfig().getPassedEvents() && upcoming.size() < 4) {
            MiningEventType miningEventType = lastEvent;
            if (miningEventType != null) {
                MiningEventType it2 = miningEventType;
                boolean bl = false;
                upcoming.add(0, it2.getRenderableAsPast());
            }
        }
        $this$flatMap$iv = upcoming;
        $i$f$flatMap = false;
        Iterable bl = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Renderable)element$iv$iv;
            boolean bl2 = false;
            objectArray = new Renderable[]{it, transitionDisplay};
            list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.dropLast((List)((List)destination$iv$iv), (int)1);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new Renderable[0]);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateData(@NotNull MiningEventData eventData) {
        Intrinsics.checkNotNullParameter((Object)eventData, (String)"eventData");
        for (Map.Entry<IslandType, List<RunningEventType>> entry : eventData.getRunningEvents().entrySet()) {
            void $this$sortedBy$iv;
            void $this$filterTo$iv$iv;
            IslandType islandType = entry.getKey();
            List<RunningEventType> events2 = entry.getValue();
            if (islandType == IslandType.MINESHAFT) continue;
            Iterable $this$filter$iv = events2;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                RunningEventType it = (RunningEventType)element$iv$iv;
                boolean bl = false;
                if (!(islandType == IslandType.DWARVEN_MINES || !it.getEvent().getDwarvenSpecific())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$sortedBy = false;
            List sorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    RunningEventType it = (RunningEventType)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getEndsAt() - Duration.getInWholeMilliseconds-impl((long)it.getEvent().getDefaultLength-UwyO8pc()));
                    it = (RunningEventType)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getEndsAt() - Duration.getInWholeMilliseconds-impl((long)it.getEvent().getDefaultLength-UwyO8pc())));
                }
            });
            MiningIslandEventInfo oldData = islandEventData.get((Object)islandType);
            if (oldData == null) {
                if (!(!((Collection)sorted).isEmpty())) continue;
                islandEventData.put(islandType, new MiningIslandEventInfo(sorted, null, 2, null));
                continue;
            }
            oldData.setIslandEvents(sorted);
        }
    }

    private final boolean shouldDisplay() {
        boolean isOnValidMiningLocation = SkyBlockUtils.INSTANCE.getInSkyBlock() && (this.getConfig().getOutsideMining() || MiningEventTracker.INSTANCE.isMiningIsland());
        return (isOnValidMiningLocation || OutsideSBFeature.MINING_EVENT_DISPLAY.isSelected()) && this.getConfig().getEnabled();
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        event2.transform(46, "mining.miningEvent.compressedFormat", (Function1<? super JsonElement, ? extends JsonElement>)((Function1)MiningEventDisplay::onConfigFix$lambda$11));
    }

    private static final JsonElement onConfigFix$lambda$11(JsonElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConfigUtils.INSTANCE.migrateBooleanToEnum(it, (Enum)MiningEventType.Companion.CompressFormat.COMPACT_TEXT, (Enum)MiningEventType.Companion.CompressFormat.DEFAULT);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[IslandType.values().length];
            try {
                nArray[IslandType.DWARVEN_MINES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IslandType.CRYSTAL_HOLLOWS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MiningEventConfig.ShowType.values().length];
            try {
                nArray[MiningEventConfig.ShowType.DWARVEN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MiningEventConfig.ShowType.CRYSTAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MiningEventConfig.ShowType.CURRENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

