/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc.limbo;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.config.features.misc.MiscConfig;
import at.hannibal2.skyhanni.config.storage.PlayerSpecificStorage;
import at.hannibal2.skyhanni.data.HypixelData;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.MessageSendToServerEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import com.google.gson.JsonObject;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_238;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\f\u0010\u0003J\u000f\u0010\r\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\r\u0010\u0003J\u0017\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0003J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00062\b\b\u0002\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\r\u0010\u001c\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020#H\u0007\u00a2\u0006\u0004\b$\u0010%R\u0016\u0010)\u001a\u0004\u0018\u00010&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010-\u001a\u00020*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0016\u0010/\u001a\u00020.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\"\u00101\u001a\u00020\u00158\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u0010\u001d\"\u0004\b4\u0010\u0018R\u0016\u00105\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00102R\u0016\u00106\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00102R\u0016\u00108\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00100R\u0016\u00109\u001a\u00020\u001e8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0014\u0010;\u001a\u00020\u001e8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b;\u0010:R\u0014\u0010<\u001a\u00020\u001e8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b<\u0010:R\u0016\u0010=\u001a\u00020\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u00102R\u0014\u0010?\u001a\u00020>8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b?\u0010@\u00a8\u0006A"}, d2={"Lat/hannibal2/skyhanni/features/misc/limbo/LimboTimeTracker;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "event", "", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/events/MessageSendToServerEvent;", "onMessageSendToServer", "(Lat/hannibal2/skyhanni/events/MessageSendToServerEvent;)V", "onTick", "onWorldChange", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "leaveLimbo", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "", "onlyPlaytime", "printStats", "(Z)V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebug", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "isEnabled", "()Z", "", "input", "", "tryTruncateFloat", "(F)Ljava/lang/String;", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "Lat/hannibal2/skyhanni/config/storage/PlayerSpecificStorage$LimboStats;", "getStorage", "()Lat/hannibal2/skyhanni/config/storage/PlayerSpecificStorage$LimboStats;", "storage", "Lat/hannibal2/skyhanni/config/features/misc/MiscConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/misc/MiscConfig;", "config", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "limboJoinTime", "J", "inLimbo", "Z", "getInLimbo", "setInLimbo", "inFakeLimbo", "shownPB", "Lkotlin/time/Duration;", "oldPB", "userLuck", "F", "USER_LUCK_MULTIPLIER", "FIRE_MULTIPLIER", "onFire", "Lnet/minecraft/class_238;", "bedWarsLobbyLimbo", "Lnet/minecraft/class_238;", "1.21.10"})
public final class LimboTimeTracker {
    @NotNull
    public static final LimboTimeTracker INSTANCE = new LimboTimeTracker();
    private static long limboJoinTime = SimpleTimeMark.Companion.farPast();
    private static boolean inLimbo;
    private static boolean inFakeLimbo;
    private static boolean shownPB;
    private static long oldPB;
    private static float userLuck;
    private static final float USER_LUCK_MULTIPLIER = 8.10185E-4f;
    private static final float FIRE_MULTIPLIER = 1.01f;
    private static boolean onFire;
    @NotNull
    private static final class_238 bedWarsLobbyLimbo;

    private LimboTimeTracker() {
    }

    private final PlayerSpecificStorage.LimboStats getStorage() {
        PlayerSpecificStorage playerSpecificStorage = ProfileStorageData.INSTANCE.getPlayerSpecific();
        return playerSpecificStorage != null ? playerSpecificStorage.getLimbo() : null;
    }

    private final MiscConfig getConfig() {
        return SkyHanniMod.feature.misc;
    }

    public final boolean getInLimbo() {
        return inLimbo;
    }

    public final void setInLimbo(boolean bl) {
        inLimbo = bl;
    }

    @HandleEvent
    public final void onChat(@NotNull SkyHanniChatEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (Intrinsics.areEqual((Object)event2.getMessage(), (Object)"\u00a7cYou are AFK. Move around to return from AFK.") || Intrinsics.areEqual((Object)event2.getMessage(), (Object)"\u00a7cYou were spawned in Limbo.")) {
            limboJoinTime = SimpleTimeMark.Companion.now-uFjCsEo();
            inLimbo = true;
            onFire = MinecraftCompat.INSTANCE.getLocalPlayer().method_5809();
        }
    }

    @HandleEvent
    public final void onMessageSendToServer(@NotNull MessageSendToServerEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (StringsKt.startsWith$default((String)event2.getMessage(), (String)"/playtime", (boolean)false, (int)2, null) && inLimbo) {
            event2.cancel();
            this.printStats(true);
        }
    }

    @HandleEvent
    public final void onTick() {
        String lobbyName;
        JsonObject jsonObject;
        int personalBest;
        PlayerSpecificStorage.LimboStats limboStats = this.getStorage();
        int n = personalBest = limboStats != null ? limboStats.getPersonalBest() : 0;
        if (inLimbo && !shownPB) {
            if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(limboJoinTime), (long)DurationKt.toDuration((int)personalBest, (DurationUnit)DurationUnit.SECONDS)) >= 0 && personalBest != 0) {
                shownPB = true;
                oldPB = DurationKt.toDuration((int)personalBest, (DurationUnit)DurationUnit.SECONDS);
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7d\u00a7lPERSONAL BEST\u00a7f! You've surpassed your previous record of \u00a7e" + Duration.toString-impl((long)oldPB) + "\u00a7f!", false, null, false, false, null, 62, null);
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7fKeep it up!", false, null, false, false, null, 62, null);
            }
        }
        String string = (jsonObject = HypixelData.INSTANCE.getLocrawData()) != null && (jsonObject = jsonObject.get("lobbyname")) != null ? jsonObject.getAsString() : (lobbyName = null);
        if (StringsKt.startsWith$default((String)String.valueOf(lobbyName), (String)"bedwarslobby", (boolean)false, (int)2, null)) {
            if (LocationUtils.INSTANCE.isPlayerInside(bedWarsLobbyLimbo)) {
                if (inFakeLimbo) {
                    return;
                }
                limboJoinTime = SimpleTimeMark.Companion.now-uFjCsEo();
                inLimbo = true;
                inFakeLimbo = true;
            } else if (inLimbo) {
                this.leaveLimbo();
                inFakeLimbo = false;
            }
        }
    }

    @HandleEvent
    public final void onWorldChange() {
        if (!inLimbo) {
            return;
        }
        this.leaveLimbo();
    }

    @HandleEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (!inLimbo) {
            return;
        }
        if (SkyBlockUtils.INSTANCE.getInSkyBlock()) {
            this.leaveLimbo();
            return;
        }
        String duration = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, SimpleTimeMark.passedSince-UwyO8pc(limboJoinTime), null, false, false, 0, false, false, 63, null);
        RenderUtils.renderString$default(RenderUtils.INSTANCE, this.getConfig().getShowTimeInLimboPosition(), "\u00a7eIn Limbo since \u00a7b" + duration, 0, 0, "Limbo Time Tracker", 6, null);
    }

    private final void leaveLimbo() {
        float oldLuck;
        inLimbo = false;
        if (!this.isEnabled()) {
            return;
        }
        long passedSince = SimpleTimeMark.passedSince-UwyO8pc(limboJoinTime);
        String duration = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, passedSince, null, false, false, 0, false, false, 63, null);
        PlayerSpecificStorage.LimboStats limboStats = this.getStorage();
        long currentPB = DurationKt.toDuration((int)(limboStats != null ? limboStats.getPersonalBest() : 0), (DurationUnit)DurationUnit.SECONDS);
        PlayerSpecificStorage.LimboStats limboStats2 = this.getStorage();
        float f = oldLuck = limboStats2 != null ? limboStats2.getUserLuck() : 0.0f;
        if (Duration.compareTo-LRDsOJo((long)passedSince, (long)currentPB) > 0) {
            oldPB = currentPB;
            PlayerSpecificStorage.LimboStats limboStats3 = this.getStorage();
            if (limboStats3 != null) {
                limboStats3.setPersonalBest(Duration.toInt-impl((long)passedSince, (DurationUnit)DurationUnit.SECONDS));
            }
            PlayerSpecificStorage.LimboStats limboStats4 = this.getStorage();
            userLuck = NumberUtil.INSTANCE.roundTo((float)(limboStats4 != null ? limboStats4.getPersonalBest() : 0) * 8.10185E-4f, 2);
            if (onFire) {
                userLuck *= 1.01f;
            }
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7fYou were in Limbo for \u00a7e" + duration + "\u00a7f! \u00a7d\u00a7lPERSONAL BEST\u00a7r\u00a7f!", false, null, false, false, null, 62, null);
            if (!Duration.equals-impl0((long)oldPB, (long)DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.SECONDS))) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7fYour previous Personal Best was \u00a7e" + Duration.toString-impl((long)oldPB) + ".", false, null, false, false, null, 62, null);
            }
        } else {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7fYou were in Limbo for \u00a7e" + duration + "\u00a7f.", false, null, false, false, null, 62, null);
        }
        if (userLuck > oldLuck) {
            if (onFire) {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7fYour \u00a7aPersonal Bests\u00a7f perk is now granting you \u00a7a+" + NumberUtil.INSTANCE.roundTo(userLuck, 2) + "\u00a7c\u2734 \u00a7aSkyHanni User Luck\u00a7f! ", false, null, false, false, null, 62, null);
            } else {
                ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7fYour \u00a7aPersonal Bests\u00a7f perk is now granting you \u00a7a+" + NumberUtil.INSTANCE.roundTo(userLuck, 2) + "\u2734 SkyHanni User Luck\u00a7f!", false, null, false, false, null, 62, null);
            }
            PlayerSpecificStorage.LimboStats limboStats5 = this.getStorage();
            if (limboStats5 != null) {
                limboStats5.setUserLuck(userLuck);
            }
        }
        PlayerSpecificStorage.LimboStats limboStats6 = this.getStorage();
        if (limboStats6 != null) {
            PlayerSpecificStorage.LimboStats limboStats7 = this.getStorage();
            limboStats6.setPlaytime(limboStats7 != null ? limboStats7.getPlaytime() + Duration.toInt-impl((long)passedSince, (DurationUnit)DurationUnit.SECONDS) : 0);
        }
        onFire = false;
        shownPB = false;
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 27, "misc.limboTimePB", "#player.personalBest", null, 8, null);
    }

    public final void printStats(boolean onlyPlaytime) {
        int playtime;
        int timeInLimbo;
        int n = timeInLimbo = inLimbo ? (int)Duration.getInWholeSeconds-impl((long)SimpleTimeMark.passedSince-UwyO8pc(limboJoinTime)) : 0;
        if (inLimbo) {
            PlayerSpecificStorage.LimboStats limboStats = this.getStorage();
            v2 = (limboStats != null ? limboStats.getPlaytime() : 0) + (int)Duration.getInWholeSeconds-impl((long)SimpleTimeMark.passedSince-UwyO8pc(limboJoinTime));
        } else {
            PlayerSpecificStorage.LimboStats limboStats = this.getStorage();
            v2 = playtime = limboStats != null ? limboStats.getPlaytime() : 0;
        }
        if (onlyPlaytime) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7aYou have " + playtime / 3600 + " hours and " + playtime % 3600 / 60 + " minutes playtime!", false, null, false, false, null, 60, null);
        } else {
            PlayerSpecificStorage.LimboStats limboStats = this.getStorage();
            int currentPB = limboStats != null ? limboStats.getPersonalBest() : 0;
            PlayerSpecificStorage.LimboStats limboStats2 = this.getStorage();
            float userLuck = limboStats2 != null ? limboStats2.getUserLuck() : 0.0f;
            int limboPB = currentPB < timeInLimbo ? timeInLimbo : currentPB;
            Object luckString = this.tryTruncateFloat(NumberUtil.INSTANCE.roundTo(userLuck, 2));
            if (userLuck > 0.0f) {
                luckString = "+" + (String)luckString;
            }
            String firstMessage = "\u00a7fYour current PB is \u00a7e" + Duration.toString-impl((long)DurationKt.toDuration((int)limboPB, (DurationUnit)DurationUnit.SECONDS)) + "\u00a7f, granting you \u00a7a" + (String)luckString + "\u2734 SkyHanni User Luck\u00a7f!";
            String secondMessage = "\u00a7fYou have \u00a7e" + Duration.toString-impl((long)DurationKt.toDuration((int)playtime, (DurationUnit)DurationUnit.SECONDS)) + " \u00a7fof playtime!";
            if (userLuck == Float.POSITIVE_INFINITY || userLuck == Float.NEGATIVE_INFINITY) {
                firstMessage = firstMessage + " \u00a7Zwhat";
            }
            ChatUtils.chat$default(ChatUtils.INSTANCE, firstMessage, false, null, false, false, null, 62, null);
            ChatUtils.chat$default(ChatUtils.INSTANCE, secondMessage, false, null, false, false, null, 62, null);
        }
    }

    public static /* synthetic */ void printStats$default(LimboTimeTracker limboTimeTracker, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        limboTimeTracker.printStats(bl);
    }

    @HandleEvent
    public final void onDebug(@NotNull DebugDataCollectEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        event2.title("Limbo");
        if (!inLimbo) {
            event2.addIrrelevant("not in limbo");
            return;
        }
        event2.addData((Function1<? super List<String>, Unit>)((Function1)LimboTimeTracker::onDebug$lambda$0));
    }

    public final boolean isEnabled() {
        return this.getConfig().getShowTimeInLimbo();
    }

    private final String tryTruncateFloat(float input2) {
        String string = String.valueOf(input2);
        if (StringsKt.endsWith$default((String)string, (String)".0", (boolean)false, (int)2, null)) {
            return StringsKt.dropLast((String)string, (int)2);
        }
        return string;
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        event2.registerBrigadier("shlimbostats", (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)LimboTimeTracker::onCommandRegistration$lambda$2));
    }

    private static final Unit onDebug$lambda$0(List $this$addData) {
        Intrinsics.checkNotNullParameter((Object)$this$addData, (String)"$this$addData");
        $this$addData.add("inLimbo: " + inLimbo);
        $this$addData.add("isLimboFake: " + inFakeLimbo);
        $this$addData.add("since: " + Duration.toString-impl((long)SimpleTimeMark.passedSince-UwyO8pc(limboJoinTime)));
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$2$lambda$1() {
        LimboTimeTracker.printStats$default(INSTANCE, false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$2(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Prints your Limbo Stats.\n \u00a77This includes your Personal Best, Playtime, and \u00a7aSkyHanni User Luck\u00a77!");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_ACTIVE);
        $this$registerBrigadier.simpleCallback((Function0<Unit>)((Function0)LimboTimeTracker::onCommandRegistration$lambda$2$lambda$1));
        return Unit.INSTANCE;
    }

    static {
        oldPB = DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.SECONDS);
        bedWarsLobbyLimbo = new class_238(-662.0, 43.0, -76.0, -619.0, 86.0, -27.0);
    }
}

