/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.config.ConfigManager;
import at.hannibal2.skyhanni.data.jsonobjects.other.DisplayInfo;
import at.hannibal2.skyhanni.data.jsonobjects.other.NbtBoolean;
import at.hannibal2.skyhanni.data.jsonobjects.other.NeuNbtInfoJson;
import at.hannibal2.skyhanni.data.jsonobjects.other.NeuNbtInfoJsonKt;
import at.hannibal2.skyhanni.data.jsonobjects.other.PropertiesInfo;
import at.hannibal2.skyhanni.data.jsonobjects.other.SkullOwnerInfo;
import at.hannibal2.skyhanni.data.jsonobjects.other.TextureInfo;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.compat.ItemCompatKt;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.StringsKt;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_9279;
import net.minecraft.class_9282;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lat/hannibal2/skyhanni/utils/ComponentUtils;", "", "<init>", "()V", "Lnet/minecraft/class_1799;", "stack", "Lat/hannibal2/skyhanni/data/jsonobjects/other/NeuNbtInfoJson;", "nbtInfo", "", "convertToComponents", "(Lnet/minecraft/class_1799;Lat/hannibal2/skyhanni/data/jsonobjects/other/NeuNbtInfoJson;)V", "Lcom/google/gson/JsonObject;", "convertToNeuNbtInfoJson", "(Lnet/minecraft/class_1799;)Lcom/google/gson/JsonObject;", "", "id", "", "damage", "convertMinecraftIdToModern", "(Ljava/lang/String;I)Ljava/lang/String;", "convertMinecraftIdToModern2", "getColor", "(I)Ljava/lang/String;", "getWood", "1.21.10"})
@SourceDebugExtension(value={"SMAP\nComponentUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentUtils.kt\nat/hannibal2/skyhanni/utils/ComponentUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n1#2:323\n*E\n"})
public final class ComponentUtils {
    @NotNull
    public static final ComponentUtils INSTANCE = new ComponentUtils();

    private ComponentUtils() {
    }

    public final void convertToComponents(@NotNull class_1799 stack, @Nullable NeuNbtInfoJson nbtInfo) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (nbtInfo == null) {
            return;
        }
        JsonObject jsonObject = nbtInfo.getExtraAttributes();
        if (jsonObject != null) {
            JsonObject extraJson = jsonObject;
            boolean bl = false;
            Object t = ((class_2520)JsonOps.INSTANCE.convertTo((DynamicOps)class_2509.field_11560, (JsonElement)extraJson)).method_68571().get();
            Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
            class_2487 extraAttributes = (class_2487)t;
            class_9279 cfr_ignored_0 = (class_9279)stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)extraAttributes));
        }
        List<JsonObject> list = nbtInfo.getEnchantments();
        boolean bl = list != null ? !((Collection)list).isEmpty() : false;
        if (bl) {
            stack.method_57379(class_9334.field_49641, (Object)true);
        }
        NbtBoolean nbtBoolean = nbtInfo.getUnbreakable();
        boolean bl2 = nbtBoolean != null ? nbtBoolean.getBoolean() : false;
        if (bl2) {
            stack.method_57379(class_9334.field_49630, (Object)class_3902.field_17274);
        }
        String string = nbtInfo.getItemModel();
        if (string != null) {
            String it = string;
            boolean bl3 = false;
            class_2960 cfr_ignored_1 = (class_2960)stack.method_57379(class_9334.field_54199, (Object)class_2960.method_60654((String)it));
        }
        if (nbtInfo.getDisplay() != null) {
            DisplayInfo display2 = nbtInfo.getDisplay();
            if (display2.getColor() != null) {
                stack.method_57379(class_9334.field_49644, (Object)new class_9282(display2.getColor().intValue()));
            }
            if (display2.getName() == null) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"extra attributes", (Object)nbtInfo.getExtraAttributes())};
                ErrorManager.INSTANCE.skyHanniError("stack display name is null", pairArray);
                throw new KotlinNothingValueException();
            }
            ItemCompatKt.setCustomItemName(stack, display2.getName());
            if (display2.getLore() != null) {
                ItemUtils.INSTANCE.setLore(stack, display2.getLore());
            }
        }
        if (nbtInfo.getSkullOwner() != null) {
            SkullOwnerInfo skullOwner = nbtInfo.getSkullOwner();
            stack.method_57379(class_9334.field_49617, (Object)class_9296.method_73307((GameProfile)NeuNbtInfoJsonKt.toGameProfile(skullOwner)));
        }
    }

    @NotNull
    public final JsonObject convertToNeuNbtInfoJson(@NotNull class_1799 stack) {
        Object object;
        Property profileProperties;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        NbtBoolean isUnbreakable = new NbtBoolean(stack.method_57826(class_9334.field_49630));
        class_9296 profile = (class_9296)stack.method_58694(class_9334.field_49617);
        Object object2 = profile;
        Property property = profileProperties = object2 != null && (object2 = object2.method_73313()) != null && (object2 = object2.properties()) != null && (object2 = object2.get((Object)"textures")) != null ? (Property)CollectionsKt.firstOrNull((Iterable)((Iterable)object2)) : null;
        Object object3 = profile;
        if (object3 == null || (object3 = object3.method_73313()) == null || (object3 = object3.id()) == null) {
            object3 = "53924f1a-87e6-4709-8e53-f1c7d13dc239";
        }
        class_9296 uuid = object3;
        Property property2 = profileProperties;
        String value = property2 != null ? property2.value() : null;
        Property property3 = profileProperties;
        String signature = property3 != null ? property3.signature() : null;
        PropertiesInfo propertiesInfo = new PropertiesInfo(CollectionsKt.listOf((Object)new TextureInfo(value, signature)));
        SkullOwnerInfo skullOwner = new SkullOwnerInfo(uuid.toString(), propertiesInfo, new NbtBoolean(true), (object = profile) != null && (object = object.method_73317()) != null ? (String)OptionalsKt.getOrNull((Optional)object) : null);
        List<String> lore = ItemUtils.INSTANCE.getLore(stack);
        class_9282 class_92822 = (class_9282)stack.method_58694(class_9334.field_49644);
        Integer color = class_92822 != null ? Integer.valueOf(class_92822.comp_2384()) : null;
        DisplayInfo displayInfo = new DisplayInfo(TextCompatKt.formattedTextCompat$default(stack.method_7964(), false, false, 3, null), lore, color);
        class_9279 customData = (class_9279)stack.method_58694(class_9334.field_49628);
        class_1792 class_17922 = ItemUtils.INSTANCE.getItemModel(stack);
        String itemModel = class_17922 != null ? ItemCompatKt.getIdentifierString(class_17922) : null;
        JsonObject extraAttributes = customData != null ? ((JsonElement)class_2509.field_11560.method_29146((DynamicOps)JsonOps.INSTANCE, (class_2520)customData.method_57461())).getAsJsonObject() : null;
        List enchants = stack.method_57826(class_9334.field_49641) ? CollectionsKt.listOf((Object)new JsonObject()) : null;
        NbtBoolean nbtBoolean = new NbtBoolean(true);
        NeuNbtInfoJson nbt = new NeuNbtInfoJson(254, isUnbreakable, skullOwner, displayInfo, extraAttributes, null, null, enchants, itemModel, nbtBoolean, null, null);
        JsonObject jsonObject = ConfigManager.Companion.getGson().toJsonTree((Object)nbt).getAsJsonObject();
        Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
        return jsonObject;
    }

    @NotNull
    public final String convertMinecraftIdToModern(@NotNull String id, int damage) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String convertMinecraftIdToModern2 = this.convertMinecraftIdToModern2(id, damage);
        if (Intrinsics.areEqual((Object)convertMinecraftIdToModern2, (Object)id) && damage > 0) {
            System.out.println((Object)("Unconverted minecraft id with damage above 0. id: " + id + " damage: " + damage));
        }
        return "minecraft:" + convertMinecraftIdToModern2;
    }

    private final String convertMinecraftIdToModern2(String id, int damage) {
        Object object;
        String strippedId = StringsKt.replace$default((String)id, (String)"minecraft:", (String)"", (boolean)false, (int)4, null);
        if (Intrinsics.areEqual((Object)strippedId, (Object)"skull")) {
            object = "player_head";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"red_flower")) {
            switch (damage) {
                case 0: {
                    object = "poppy";
                    break;
                }
                case 1: {
                    object = "blue_orchid";
                    break;
                }
                case 2: {
                    object = "allium";
                    break;
                }
                case 3: {
                    object = "azure_bluet";
                    break;
                }
                case 4: {
                    object = "red_tulip";
                    break;
                }
                case 5: {
                    object = "orange_tulip";
                    break;
                }
                case 6: {
                    object = "white_tulip";
                    break;
                }
                case 7: {
                    object = "pink_tulip";
                    break;
                }
                case 8: {
                    object = "oxeye_daisy";
                    break;
                }
                default: {
                    object = strippedId;
                    break;
                }
            }
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"yellow_flower")) {
            object = "dandelion";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"fireworks")) {
            object = "firework_rocket";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"dye")) {
            switch (damage) {
                case 0: {
                    object = "ink_sac";
                    break;
                }
                case 1: {
                    object = "red_dye";
                    break;
                }
                case 2: {
                    object = "green_dye";
                    break;
                }
                case 3: {
                    object = "cocoa_beans";
                    break;
                }
                case 4: {
                    object = "lapis_lazuli";
                    break;
                }
                case 5: {
                    object = "purple_dye";
                    break;
                }
                case 6: {
                    object = "cyan_dye";
                    break;
                }
                case 7: {
                    object = "light_gray_dye";
                    break;
                }
                case 8: {
                    object = "gray_dye";
                    break;
                }
                case 9: {
                    object = "pink_dye";
                    break;
                }
                case 10: {
                    object = "lime_dye";
                    break;
                }
                case 11: {
                    object = "yellow_dye";
                    break;
                }
                case 12: {
                    object = "light_blue_dye";
                    break;
                }
                case 13: {
                    object = "magenta_dye";
                    break;
                }
                case 14: {
                    object = "orange_dye";
                    break;
                }
                case 15: {
                    object = "bone_meal";
                    break;
                }
                default: {
                    object = strippedId;
                    break;
                }
            }
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"spawn_egg")) {
            switch (damage) {
                case 0: {
                    object = "polar_bear_spawn_egg";
                    break;
                }
                case 4: {
                    object = "elder_guardian_spawn_egg";
                    break;
                }
                case 52: {
                    object = "spider_spawn_egg";
                    break;
                }
                case 54: {
                    object = "zombie_spawn_egg";
                    break;
                }
                case 55: {
                    object = "slime_spawn_egg";
                    break;
                }
                case 58: {
                    object = "enderman_spawn_egg";
                    break;
                }
                case 61: {
                    object = "blaze_spawn_egg";
                    break;
                }
                case 67: {
                    object = "endermite_spawn_egg";
                    break;
                }
                case 94: {
                    object = "squid_spawn_egg";
                    break;
                }
                case 96: {
                    object = "mooshroom_spawn_egg";
                    break;
                }
                case 101: {
                    object = "rabbit_spawn_egg";
                    break;
                }
                case 120: {
                    object = "villager_spawn_egg";
                    break;
                }
                default: {
                    object = strippedId;
                    break;
                }
            }
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"carpet")) {
            object = this.getColor(damage) + "_carpet";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"leaves")) {
            object = this.getWood(damage) + "_leaves";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"leaves2")) {
            switch (damage) {
                case 0: {
                    object = "acacia_leaves";
                    break;
                }
                case 1: {
                    object = "dark_oak_leaves";
                    break;
                }
                default: {
                    object = strippedId;
                    break;
                }
            }
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"banner")) {
            object = this.getColor(damage) + "_banner";
        } else if (StringsKt.contains$default((CharSequence)strippedId, (CharSequence)"record_", (boolean)false, (int)2, null)) {
            object = StringsKt.replace$default((String)strippedId, (String)"record_", (String)"music_disc_", (boolean)false, (int)4, null);
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"cooked_fish")) {
            switch (damage) {
                case 0: {
                    object = "cooked_cod";
                    break;
                }
                case 1: {
                    object = "cooked_salmon";
                    break;
                }
                default: {
                    object = strippedId;
                    break;
                }
            }
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"bed")) {
            object = "red_bed";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"wool")) {
            object = this.getColor(damage) + "_wool";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"trapdoor")) {
            object = "oak_trapdoor";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"speckled_melon")) {
            object = "glistering_melon_slice";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"melon")) {
            object = "melon_slice";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"melon_block")) {
            object = "melon";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"fish")) {
            switch (damage) {
                case 0: {
                    object = "cod";
                    break;
                }
                case 1: {
                    object = "salmon";
                    break;
                }
                case 2: {
                    object = "tropical_fish";
                    break;
                }
                case 3: {
                    object = "pufferfish";
                    break;
                }
                default: {
                    object = strippedId;
                    break;
                }
            }
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"log")) {
            object = this.getWood(damage) + "_log";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"log2")) {
            switch (damage) {
                case 0: {
                    object = "acacia_log";
                    break;
                }
                case 1: {
                    object = "dark_oak_log";
                    break;
                }
                default: {
                    object = strippedId;
                    break;
                }
            }
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"waterlily")) {
            object = "lily_pad";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"web")) {
            object = "cobweb";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"reeds")) {
            object = "sugar_cane";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"double_plant")) {
            switch (damage) {
                case 0: {
                    object = "sunflower";
                    break;
                }
                case 1: {
                    object = "lilac";
                    break;
                }
                case 2: {
                    object = "tall_grass";
                    break;
                }
                case 3: {
                    object = "large_fern";
                    break;
                }
                case 4: {
                    object = "rose_bush";
                    break;
                }
                case 5: {
                    object = "peony";
                    break;
                }
                default: {
                    object = strippedId;
                    break;
                }
            }
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"deadbush")) {
            object = "dead_bush";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"firework_charge")) {
            object = "firework_star";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"netherbrick")) {
            object = "nether_brick";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"wooden_button")) {
            object = "oak_button";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"slime")) {
            object = "slime_block";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"boat")) {
            object = "oak_boat";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"brick_block")) {
            object = "bricks";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"stained_glass")) {
            object = this.getColor(damage) + "_stained_glass";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"stained_glass_pane")) {
            object = this.getColor(damage) + "_stained_glass_pane";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"hardened_clay")) {
            object = "terracotta";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"stained_hardened_clay")) {
            object = this.getColor(damage) + "_terracotta";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"fence")) {
            object = "oak_fence";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"fence_gate")) {
            object = "oak_fence_gate";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"grass")) {
            object = "grass_block";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"pumpkin")) {
            object = "carved_pumpkin";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"lit_pumpkin")) {
            object = "jack_o_lantern";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"planks")) {
            object = this.getWood(damage) + "_planks";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"mob_spawner")) {
            object = "spawner";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"noteblock")) {
            object = "note_block";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"golden_rail")) {
            object = "powered_rail";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"quartz_ore")) {
            object = "nether_quartz_ore";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"sapling")) {
            object = this.getWood(damage) + "_sapling";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"sign")) {
            object = "oak_sign";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"stonebrick")) {
            switch (damage) {
                case 0: {
                    object = "stone_bricks";
                    break;
                }
                case 1: {
                    object = "mossy_stone_bricks";
                    break;
                }
                case 2: {
                    object = "cracked_stone_bricks";
                    break;
                }
                case 3: {
                    object = "chiseled_stone_bricks";
                    break;
                }
                default: {
                    object = strippedId;
                    break;
                }
            }
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"snow")) {
            object = "snow_block";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"snow_layer")) {
            object = "snow";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"wooden_slab")) {
            object = this.getWood(damage) + "_slab";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"stone_slab2")) {
            object = "red_sandstone_slab";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"wooden_door")) {
            object = "oak_door";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"wooden_pressure_plate")) {
            object = "oak_pressure_plate";
        } else if (Intrinsics.areEqual((Object)strippedId, (Object)"tallgrass")) {
            switch (damage) {
                case 0: {
                    object = "dead_bush";
                    break;
                }
                case 1: {
                    object = "short_grass";
                    break;
                }
                case 2: {
                    object = "fern";
                    break;
                }
                default: {
                    object = strippedId;
                    break;
                }
            }
        } else {
            object = Intrinsics.areEqual((Object)strippedId, (Object)"monster_egg") ? (damage == 0 ? "infested_stone" : strippedId) : (Intrinsics.areEqual((Object)strippedId, (Object)"sand") && damage == 1 ? "red_sand" : strippedId);
        }
        return object;
    }

    private final String getColor(int damage) {
        return switch (damage) {
            case 0 -> "white";
            case 1 -> "orange";
            case 2 -> "magenta";
            case 3 -> "light_blue";
            case 4 -> "yellow";
            case 5 -> "lime";
            case 6 -> "pink";
            case 7 -> "gray";
            case 8 -> "light_gray";
            case 9 -> "cyan";
            case 10 -> "purple";
            case 11 -> "blue";
            case 12 -> "brown";
            case 13 -> "green";
            case 14 -> "red";
            case 15 -> "black";
            default -> "";
        };
    }

    private final String getWood(int damage) {
        return switch (damage) {
            case 0 -> "oak";
            case 1 -> "spruce";
            case 2 -> "birch";
            case 3 -> "jungle";
            case 4 -> "acacia";
            case 5 -> "dark_oak";
            default -> "";
        };
    }
}

