/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.Features;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b)\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\u0007*\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u000b\u0010\tJ\u0019\u0010\u000f\u001a\u00020\f*\u00020\f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u000f\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0012J\u0011\u0010\u0013\u001a\u00020\u0007*\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0011\u0010\u0015\u001a\u00020\u0007*\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u0011\u0010\u0016\u001a\u00020\u0007*\u00020\u0004\u00a2\u0006\u0004\b\u0016\u0010\u0014J\u0011\u0010\u0017\u001a\u00020\r*\u00020\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0011\u0010\u0019\u001a\u00020\r*\u00020\u0007\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u0011\u0010\u001a\u001a\u00020\u0007*\u00020\r\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0011\u0010\u001c\u001a\u00020\u0007*\u00020\u0004\u00a2\u0006\u0004\b\u001c\u0010\u0014J'\u0010 \u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b \u0010!J\u0011\u0010\"\u001a\u00020\u0005*\u00020\u0007\u00a2\u0006\u0004\b\"\u0010#J\u0011\u0010$\u001a\u00020\u0005*\u00020\u0007\u00a2\u0006\u0004\b$\u0010#J\u0011\u0010%\u001a\u00020\u0005*\u00020\u0007\u00a2\u0006\u0004\b%\u0010#J\u0015\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020\f\u00a2\u0006\u0004\b(\u0010)J\u001d\u0010(\u001a\u00020'2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*\u00a2\u0006\u0004\b(\u0010-J#\u0010/\u001a\u00020\u0007*\u00020\u00042\u0006\u0010,\u001a\u00020\u00042\b\b\u0002\u0010.\u001a\u00020\r\u00a2\u0006\u0004\b/\u00100J\u0011\u00101\u001a\u00020\f*\u00020\u0007\u00a2\u0006\u0004\b1\u00102J\u0011\u00103\u001a\u00020**\u00020\u0007\u00a2\u0006\u0004\b3\u00104J\u0011\u00105\u001a\u00020\r*\u00020\u0007\u00a2\u0006\u0004\b5\u0010\u0018J\u0011\u00106\u001a\u00020\u0011*\u00020\u0007\u00a2\u0006\u0004\b6\u00107J\u0013\u00108\u001a\u0004\u0018\u00010\f*\u00020\u0007\u00a2\u0006\u0004\b8\u00109J\u0013\u0010:\u001a\u0004\u0018\u00010**\u00020\u0007\u00a2\u0006\u0004\b:\u0010;J\u0013\u0010<\u001a\u0004\u0018\u00010\r*\u00020\u0007\u00a2\u0006\u0004\b<\u0010=J\u0013\u0010>\u001a\u0004\u0018\u00010\u0011*\u00020\u0007\u00a2\u0006\u0004\b>\u0010?J\u0013\u0010@\u001a\u0004\u0018\u00010\r*\u00020\u0007\u00a2\u0006\u0004\b@\u0010=J\u0013\u0010A\u001a\u0004\u0018\u00010\f*\u00020\u0007\u00a2\u0006\u0004\bA\u00109J\u0019\u0010C\u001a\u00020\f*\u00020\u00042\u0006\u0010B\u001a\u00020\u0004\u00a2\u0006\u0004\bC\u0010DJ\u0013\u0010E\u001a\u00020\u0005*\u0004\u0018\u00010\r\u00a2\u0006\u0004\bE\u0010FJ%\u0010J\u001a\u00020\u00112\u0006\u0010G\u001a\u00020\u00112\u0006\u0010H\u001a\u00020\u00112\u0006\u0010I\u001a\u00020*\u00a2\u0006\u0004\bJ\u0010KJ\u0019\u0010M\u001a\u00020\r*\u00020\r2\u0006\u0010L\u001a\u00020\r\u00a2\u0006\u0004\bM\u0010NJ\u0011\u0010O\u001a\u00020\u0007*\u00020\f\u00a2\u0006\u0004\bO\u0010PJ!\u0010O\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\f2\b\u0010Q\u001a\u0004\u0018\u00010\u0007H\u0002\u00a2\u0006\u0004\bO\u0010RJ\u0011\u0010S\u001a\u00020\u0007*\u00020\f\u00a2\u0006\u0004\bS\u0010PR\u0014\u0010W\u001a\u00020T8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bU\u0010VR \u0010Y\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u00070X8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bY\u0010ZR0\u0010\\\u001a\u001e\u0012\f\u0012\n [*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n [*\u0004\u0018\u00010\u00070\u00070X8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\\\u0010ZR\u0014\u0010^\u001a\u00020]8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b^\u0010_R\u0014\u0010`\u001a\u00020]8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b`\u0010_R\u0015\u0010c\u001a\u00020\f*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\ba\u0010bR\u0015\u0010e\u001a\u00020\f*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\bd\u0010bR\u0015\u0010c\u001a\u00020**\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\ba\u0010f\u00a8\u0006g"}, d2={"Lat/hannibal2/skyhanni/utils/NumberUtil;", "", "<init>", "()V", "", "", "preciseBillions", "", "shortFormat", "(Ljava/lang/Number;Z)Ljava/lang/String;", "input", "compactFormat", "", "", "precision", "roundTo", "(DI)D", "", "(FI)F", "ordinal", "(Ljava/lang/Number;)Ljava/lang/String;", "addSuffix", "addSeparators", "romanToDecimalIfNecessary", "(Ljava/lang/String;)I", "romanToDecimal", "toRoman", "(I)Ljava/lang/String;", "toStringWithPlus", "decimal", "lastNumber", "lastDecimal", "processDecimal", "(III)I", "isInt", "(Ljava/lang/String;)Z", "isDouble", "isFormatNumber", "percentage", "Lat/hannibal2/skyhanni/utils/LorenzColor;", "percentageColor", "(D)Lat/hannibal2/skyhanni/utils/LorenzColor;", "", "have", "max", "(JJ)Lat/hannibal2/skyhanni/utils/LorenzColor;", "round", "percentWithColorCode", "(Ljava/lang/Number;Ljava/lang/Number;I)Ljava/lang/String;", "formatDouble", "(Ljava/lang/String;)D", "formatLong", "(Ljava/lang/String;)J", "formatInt", "formatFloat", "(Ljava/lang/String;)F", "formatDoubleOrUserError", "(Ljava/lang/String;)Ljava/lang/Double;", "formatLongOrUserError", "(Ljava/lang/String;)Ljava/lang/Long;", "formatIntOrUserError", "(Ljava/lang/String;)Ljava/lang/Integer;", "formatFloatOrUserError", "(Ljava/lang/String;)Ljava/lang/Float;", "formatIntOrNull", "formatDoubleOrNull", "maxValue", "fractionOf", "(Ljava/lang/Number;Ljava/lang/Number;)D", "isPositive", "(Ljava/lang/Integer;)Z", "now", "last", "lastUpdate", "interpolate", "(FFJ)F", "n", "intPow", "(II)I", "formatPercentage", "(D)Ljava/lang/String;", "format", "(DLjava/lang/String;)Ljava/lang/String;", "oneDecimal", "Lat/hannibal2/skyhanni/config/Features;", "getConfig", "()Lat/hannibal2/skyhanni/config/Features;", "config", "Ljava/util/TreeMap;", "suffixes", "Ljava/util/TreeMap;", "kotlin.jvm.PlatformType", "romanSymbols", "Ljava/util/regex/Pattern;", "numberPattern", "Ljava/util/regex/Pattern;", "formatPattern", "getMillion", "(I)D", "million", "getBillion", "billion", "(D)J", "1.21.10"})
@SourceDebugExtension(value={"SMAP\nNumberUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NumberUtil.kt\nat/hannibal2/skyhanni/utils/NumberUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,297:1\n1#2:298\n*E\n"})
public final class NumberUtil {
    @NotNull
    public static final NumberUtil INSTANCE;
    @NotNull
    private static final TreeMap<Long, String> suffixes;
    @NotNull
    private static final TreeMap<Integer, String> romanSymbols;
    @NotNull
    private static final Pattern numberPattern;
    @NotNull
    private static final Pattern formatPattern;

    private NumberUtil() {
    }

    private final Features getConfig() {
        return SkyHanniMod.feature;
    }

    @NotNull
    public final String shortFormat(@NotNull Number $this$shortFormat, boolean preciseBillions) {
        Intrinsics.checkNotNullParameter((Object)$this$shortFormat, (String)"<this>");
        return this.compactFormat($this$shortFormat, preciseBillions);
    }

    public static /* synthetic */ String shortFormat$default(NumberUtil numberUtil, Number number, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return numberUtil.shortFormat(number, bl);
    }

    private final String compactFormat(Number input2, boolean preciseBillions) {
        String string;
        boolean hasDecimal;
        int truncatedAt;
        double absDoubleValue = Math.abs(input2.doubleValue());
        if (absDoubleValue < 1.0) {
            return input2.toString();
        }
        long value = input2.longValue();
        if (value == Long.MIN_VALUE) {
            return this.compactFormat(-9223372036854775807L, preciseBillions);
        }
        if (value < 0L) {
            return "-" + this.compactFormat(-value, preciseBillions);
        }
        if (value < 1000L) {
            return String.valueOf(value);
        }
        Map.Entry<Long, String> entry = suffixes.floorEntry(value);
        Intrinsics.checkNotNull(entry);
        Long divideBy = entry.getKey();
        String suffix = entry.getValue();
        long truncated = value / (divideBy / (long)10);
        int n = Intrinsics.areEqual((Object)suffix, (Object)"M") ? 1000 : (truncatedAt = Intrinsics.areEqual((Object)suffix, (Object)"B") ? 1000000 : 100);
        boolean bl = truncated < (long)truncatedAt && !((double)truncated / 10.0 == (double)(truncated / (long)10)) ? true : (hasDecimal = false);
        if (value > 1000000000L && hasDecimal && preciseBillions) {
            long decimalPart = value % (long)1000000000 / (long)1000000;
            string = truncated / (long)10 + "." + decimalPart + suffix;
        } else {
            string = hasDecimal ? (double)truncated / 10.0 + suffix : truncated / (long)10 + suffix;
        }
        return string;
    }

    static /* synthetic */ String compactFormat$default(NumberUtil numberUtil, Number number, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return numberUtil.compactFormat(number, bl);
    }

    public final double roundTo(double $this$roundTo, int precision) {
        double scale = Math.pow(10.0, precision);
        return Math.rint($this$roundTo * scale) / scale;
    }

    public final float roundTo(float $this$roundTo, int precision) {
        return (float)this.roundTo((double)$this$roundTo, precision);
    }

    @NotNull
    public final String ordinal(@NotNull Number $this$ordinal) {
        Intrinsics.checkNotNullParameter((Object)$this$ordinal, (String)"<this>");
        long l = $this$ordinal.longValue();
        long l2 = l % (long)100;
        boolean bl = 11L <= l2 ? l2 < 14L : false;
        if (bl) {
            return "th";
        }
        l2 = l % (long)10;
        return l2 == 1L ? "st" : (l2 == 2L ? "nd" : (l2 == 3L ? "rd" : "th"));
    }

    @NotNull
    public final String addSuffix(@NotNull Number $this$addSuffix) {
        Intrinsics.checkNotNullParameter((Object)$this$addSuffix, (String)"<this>");
        return $this$addSuffix + this.ordinal($this$addSuffix);
    }

    @NotNull
    public final String addSeparators(@NotNull Number $this$addSeparators) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$addSeparators, (String)"<this>");
        if (!this.getConfig().getDev().getNumberFormatOverride()) {
            String string2 = NumberFormat.getNumberInstance().format($this$addSeparators);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        } else {
            String string3 = NumberFormat.getNumberInstance(Locale.US).format($this$addSeparators);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        }
        return string;
    }

    public final int romanToDecimalIfNecessary(@NotNull String $this$romanToDecimalIfNecessary) {
        Intrinsics.checkNotNullParameter((Object)$this$romanToDecimalIfNecessary, (String)"<this>");
        Integer n = StringsKt.toIntOrNull((String)$this$romanToDecimalIfNecessary);
        return n != null ? n.intValue() : this.romanToDecimal($this$romanToDecimalIfNecessary);
    }

    public final int romanToDecimal(@NotNull String $this$romanToDecimal) {
        Intrinsics.checkNotNullParameter((Object)$this$romanToDecimal, (String)"<this>");
        int decimal = 0;
        int lastNumber = 0;
        String string = $this$romanToDecimal.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String romanNumeral = string;
        for (int x = romanNumeral.length() - 1; -1 < x; --x) {
            char c = romanNumeral.charAt(x);
            if (c == 'M') {
                decimal = this.processDecimal(1000, lastNumber, decimal);
                lastNumber = 1000;
                continue;
            }
            if (c == 'D') {
                decimal = this.processDecimal(500, lastNumber, decimal);
                lastNumber = 500;
                continue;
            }
            if (c == 'C') {
                decimal = this.processDecimal(100, lastNumber, decimal);
                lastNumber = 100;
                continue;
            }
            if (c == 'L') {
                decimal = this.processDecimal(50, lastNumber, decimal);
                lastNumber = 50;
                continue;
            }
            if (c == 'X') {
                decimal = this.processDecimal(10, lastNumber, decimal);
                lastNumber = 10;
                continue;
            }
            if (c == 'V') {
                decimal = this.processDecimal(5, lastNumber, decimal);
                lastNumber = 5;
                continue;
            }
            if (c != 'I') continue;
            decimal = this.processDecimal(1, lastNumber, decimal);
            lastNumber = 1;
        }
        return decimal;
    }

    @NotNull
    public final String toRoman(int $this$toRoman) {
        Object object;
        if ($this$toRoman <= 0) {
            throw new IllegalStateException(($this$toRoman + " must be positive!").toString());
        }
        Integer l = romanSymbols.floorKey($this$toRoman);
        Integer n = l;
        if (n != null && $this$toRoman == n) {
            String string = romanSymbols.get($this$toRoman);
            Intrinsics.checkNotNull((Object)string);
            object = string;
        } else {
            String string = romanSymbols.get(l);
            Intrinsics.checkNotNull((Object)l);
            object = string + this.toRoman($this$toRoman - l);
        }
        return object;
    }

    @NotNull
    public final String toStringWithPlus(@NotNull Number $this$toStringWithPlus) {
        Intrinsics.checkNotNullParameter((Object)$this$toStringWithPlus, (String)"<this>");
        return ($this$toStringWithPlus.doubleValue() >= 0.0 ? "+" : "") + $this$toStringWithPlus;
    }

    private final int processDecimal(int decimal, int lastNumber, int lastDecimal) {
        return lastNumber > decimal ? lastDecimal - decimal : lastDecimal + decimal;
    }

    public final boolean isInt(@NotNull String $this$isInt) {
        Intrinsics.checkNotNullParameter((Object)$this$isInt, (String)"<this>");
        return ((CharSequence)$this$isInt).length() > 0 && numberPattern.matcher($this$isInt).matches();
    }

    public final boolean isDouble(@NotNull String $this$isDouble) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$isDouble, (String)"<this>");
        Object object2 = $this$isDouble;
        try {
            String $this$isDouble_u24lambda_u241 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)Double.parseDouble($this$isDouble_u24lambda_u241));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Result.isFailure-impl((Object)object2) ? null : object2) != null;
    }

    public final boolean isFormatNumber(@NotNull String $this$isFormatNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$isFormatNumber, (String)"<this>");
        return ((CharSequence)$this$isFormatNumber).length() > 0 && RegexUtils.INSTANCE.matches(formatPattern, $this$isFormatNumber);
    }

    @NotNull
    public final LorenzColor percentageColor(double percentage) {
        return percentage > 0.9 ? LorenzColor.DARK_GREEN : (percentage > 0.75 ? LorenzColor.GREEN : (percentage > 0.5 ? LorenzColor.YELLOW : (percentage > 0.25 ? LorenzColor.GOLD : LorenzColor.RED)));
    }

    @NotNull
    public final LorenzColor percentageColor(long have, long max) {
        return this.percentageColor(this.fractionOf(have, max));
    }

    @NotNull
    public final String percentWithColorCode(@NotNull Number $this$percentWithColorCode, @NotNull Number max, int round) {
        Intrinsics.checkNotNullParameter((Object)$this$percentWithColorCode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        double fraction = this.fractionOf($this$percentWithColorCode, max);
        LorenzColor color = this.percentageColor(fraction);
        double amount = this.roundTo(fraction * 100.0, round);
        return color.getChatColor() + amount + "%";
    }

    public static /* synthetic */ String percentWithColorCode$default(NumberUtil numberUtil, Number number, Number number2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return numberUtil.percentWithColorCode(number, number2, n);
    }

    public final double formatDouble(@NotNull String $this$formatDouble) {
        Intrinsics.checkNotNullParameter((Object)$this$formatDouble, (String)"<this>");
        Double d = this.formatDoubleOrNull($this$formatDouble);
        if (d == null) {
            throw new NumberFormatException("formatDouble failed for '" + $this$formatDouble + "'");
        }
        return d;
    }

    public final long formatLong(@NotNull String $this$formatLong) {
        Intrinsics.checkNotNullParameter((Object)$this$formatLong, (String)"<this>");
        Double d = this.formatDoubleOrNull($this$formatLong);
        if (d == null) {
            throw new NumberFormatException("formatLong failed for '" + $this$formatLong + "'");
        }
        return (long)d.doubleValue();
    }

    public final int formatInt(@NotNull String $this$formatInt) {
        Intrinsics.checkNotNullParameter((Object)$this$formatInt, (String)"<this>");
        Double d = this.formatDoubleOrNull($this$formatInt);
        if (d == null) {
            throw new NumberFormatException("formatInt failed for '" + $this$formatInt + "'");
        }
        return (int)d.doubleValue();
    }

    public final float formatFloat(@NotNull String $this$formatFloat) {
        Intrinsics.checkNotNullParameter((Object)$this$formatFloat, (String)"<this>");
        Double d = this.formatDoubleOrNull($this$formatFloat);
        if (d == null) {
            throw new NumberFormatException("formatFloat failed for '" + $this$formatFloat + "'");
        }
        return (float)d.doubleValue();
    }

    @Nullable
    public final Double formatDoubleOrUserError(@NotNull String $this$formatDoubleOrUserError) {
        Intrinsics.checkNotNullParameter((Object)$this$formatDoubleOrUserError, (String)"<this>");
        Double d = this.formatDoubleOrNull($this$formatDoubleOrUserError);
        if (d == null) {
            String $this$formatDoubleOrUserError_u24lambda_u242 = $this$formatDoubleOrUserError;
            boolean bl = false;
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Not a valid number: '" + $this$formatDoubleOrUserError_u24lambda_u242 + "'", false, 2, null);
            d = null;
        }
        return d;
    }

    @Nullable
    public final Long formatLongOrUserError(@NotNull String $this$formatLongOrUserError) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)$this$formatLongOrUserError, (String)"<this>");
        Double d = this.formatDoubleOrNull($this$formatLongOrUserError);
        if (d != null) {
            l = (long)d.doubleValue();
        } else {
            String $this$formatLongOrUserError_u24lambda_u243 = $this$formatLongOrUserError;
            boolean bl = false;
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Not a valid number: '" + $this$formatLongOrUserError_u24lambda_u243 + "'", false, 2, null);
            l = null;
        }
        return l;
    }

    @Nullable
    public final Integer formatIntOrUserError(@NotNull String $this$formatIntOrUserError) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)$this$formatIntOrUserError, (String)"<this>");
        Double d = this.formatDoubleOrNull($this$formatIntOrUserError);
        if (d != null) {
            n = (int)d.doubleValue();
        } else {
            String $this$formatIntOrUserError_u24lambda_u244 = $this$formatIntOrUserError;
            boolean bl = false;
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Not a valid number: '" + $this$formatIntOrUserError_u24lambda_u244 + "'", false, 2, null);
            n = null;
        }
        return n;
    }

    @Nullable
    public final Float formatFloatOrUserError(@NotNull String $this$formatFloatOrUserError) {
        Float f;
        Intrinsics.checkNotNullParameter((Object)$this$formatFloatOrUserError, (String)"<this>");
        Double d = this.formatDoubleOrNull($this$formatFloatOrUserError);
        if (d != null) {
            f = Float.valueOf((float)d.doubleValue());
        } else {
            String $this$formatFloatOrUserError_u24lambda_u245 = $this$formatFloatOrUserError;
            boolean bl = false;
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Not a valid number: '" + $this$formatFloatOrUserError_u24lambda_u245 + "'", false, 2, null);
            f = null;
        }
        return f;
    }

    @Nullable
    public final Integer formatIntOrNull(@NotNull String $this$formatIntOrNull) {
        Intrinsics.checkNotNullParameter((Object)$this$formatIntOrNull, (String)"<this>");
        Double d = this.formatDoubleOrNull($this$formatIntOrNull);
        return d != null ? Integer.valueOf((int)d.doubleValue()) : null;
    }

    @Nullable
    public final Double formatDoubleOrNull(@NotNull String $this$formatDoubleOrNull) {
        Double d;
        double d2;
        Intrinsics.checkNotNullParameter((Object)$this$formatDoubleOrNull, (String)"<this>");
        String string = $this$formatDoubleOrNull.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String text = StringsKt.replace$default((String)string, (String)",", (String)"", (boolean)false, (int)4, null);
        if (StringsKt.endsWith$default((String)text, (String)"k", (boolean)false, (int)2, null)) {
            String string2 = text.substring(0, text.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            text = string2;
            d2 = 1000.0;
        } else if (StringsKt.endsWith$default((String)text, (String)"m", (boolean)false, (int)2, null)) {
            String string3 = text.substring(0, text.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            text = string3;
            d2 = this.getMillion(1);
        } else if (StringsKt.endsWith$default((String)text, (String)"b", (boolean)false, (int)2, null)) {
            String string4 = text.substring(0, text.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            text = string4;
            d2 = this.getBillion(1);
        } else {
            d2 = 1.0;
        }
        double multiplier = d2;
        Double d3 = StringsKt.toDoubleOrNull((String)text);
        if (d3 != null) {
            double it = ((Number)d3).doubleValue();
            boolean bl = false;
            d = it * multiplier;
        } else {
            d = null;
        }
        return d;
    }

    public final double getMillion(int $this$million) {
        return (double)$this$million * 1000000.0;
    }

    public final double getBillion(int $this$billion) {
        return (double)$this$billion * 1.0E9;
    }

    public final long getMillion(double $this$million) {
        return (long)($this$million * 1000000.0);
    }

    public final double fractionOf(@NotNull Number $this$fractionOf, @NotNull Number maxValue) {
        double d;
        Intrinsics.checkNotNullParameter((Object)$this$fractionOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)maxValue, (String)"maxValue");
        Double d2 = maxValue.doubleValue();
        double it = ((Number)d2).doubleValue();
        boolean bl = false;
        Double d3 = !(it == 0.0) ? d2 : null;
        if (d3 != null) {
            double max = ((Number)d3).doubleValue();
            boolean bl2 = false;
            d = RangesKt.coerceIn((double)($this$fractionOf.doubleValue() / max), (double)0.0, (double)1.0);
        } else {
            d = 1.0;
        }
        return d;
    }

    public final boolean isPositive(@Nullable Integer $this$isPositive) {
        Integer n = $this$isPositive;
        return (n != null ? n : 0) > 0;
    }

    public final float interpolate(float now, float last, long lastUpdate) {
        float interp = now;
        if (last >= 0.0f && !(last == now)) {
            float factor = (float)(SimpleTimeMark.toMillis-impl(SimpleTimeMark.Companion.now-uFjCsEo()) - lastUpdate) / 1000.0f;
            factor = RangesKt.coerceIn((float)factor, (float)0.0f, (float)1.0f);
            interp = last + (now - last) * factor;
        }
        return interp;
    }

    public final int intPow(int $this$intPow, int n) {
        return (int)Math.pow($this$intPow, n);
    }

    @NotNull
    public final String formatPercentage(double $this$formatPercentage) {
        return this.formatPercentage($this$formatPercentage, "0.00");
    }

    private final String formatPercentage(double percentage, String format) {
        String string = new DecimalFormat(format).format(percentage * (double)100);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return StringsKt.replace$default((String)string, (char)',', (char)'.', (boolean)false, (int)4, null) + "%";
    }

    @NotNull
    public final String oneDecimal(double $this$oneDecimal) {
        String string = "%.1f";
        Object[] objectArray = new Object[]{$this$oneDecimal};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    static {
        Object object;
        INSTANCE = new NumberUtil();
        Pair[] $this$suffixes_u24lambda_u240 = object = new TreeMap();
        boolean bl = false;
        ((Map)$this$suffixes_u24lambda_u240).put(1000L, "k");
        ((Map)$this$suffixes_u24lambda_u240).put(1000000L, "M");
        ((Map)$this$suffixes_u24lambda_u240).put(1000000000L, "B");
        ((Map)$this$suffixes_u24lambda_u240).put(1000000000000L, "T");
        ((Map)$this$suffixes_u24lambda_u240).put(1000000000000000L, "P");
        ((Map)$this$suffixes_u24lambda_u240).put(1000000000000000000L, "E");
        suffixes = object;
        object = new Pair[]{TuplesKt.to((Object)1000, (Object)"M"), TuplesKt.to((Object)900, (Object)"CM"), TuplesKt.to((Object)500, (Object)"D"), TuplesKt.to((Object)400, (Object)"CD"), TuplesKt.to((Object)100, (Object)"C"), TuplesKt.to((Object)90, (Object)"XC"), TuplesKt.to((Object)50, (Object)"L"), TuplesKt.to((Object)40, (Object)"XL"), TuplesKt.to((Object)10, (Object)"X"), TuplesKt.to((Object)9, (Object)"IX"), TuplesKt.to((Object)5, (Object)"V"), TuplesKt.to((Object)4, (Object)"IV"), TuplesKt.to((Object)1, (Object)"I")};
        romanSymbols = new TreeMap(MapsKt.mapOf((Pair[])object));
        object = "^[0-9]*$";
        int n = 0;
        Pattern pattern = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        numberPattern = pattern;
        object = "^[0-9,.]*[kmb]?$";
        n = 0;
        Pattern pattern2 = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        formatPattern = pattern2;
    }
}

