/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.shader;

import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.shader.ShaderHelper;
import at.hannibal2.skyhanni.utils.shader.ShaderManager;
import at.hannibal2.skyhanni.utils.shader.ShaderType;
import at.hannibal2.skyhanni.utils.shader.Uniform;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\tJ\u000f\u0010\u000b\u001a\u00020\u0007H&\u00a2\u0006\u0004\b\u000b\u0010\tJ\r\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0004\b\f\u0010\tJ\r\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\tJ\r\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000e\u0010\tJ7\u0010\u0015\u001a\u00020\u0007\"\u0004\b\u0000\u0010\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00102\u0006\u0010\u0012\u001a\u00020\u00022\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0017\u001a\u0004\b\u001a\u0010\u0019R\"\u0010\u001c\u001a\u00020\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010\u001dR\u0016\u0010#\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010\u001dR\u001e\u0010&\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0$8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\"\u0010)\u001a\u00020(8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lat/hannibal2/skyhanni/utils/shader/Shader;", "", "", "vertex", "fragment", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "", "deleteOldShaders", "()V", "recompile", "registerUniforms", "updateUniforms", "enable", "disable", "T", "Lat/hannibal2/skyhanni/utils/shader/Uniform$UniformType;", "uniformType", "name", "Lkotlin/Function0;", "uniformValuesSupplier", "registerUniform", "(Lat/hannibal2/skyhanni/utils/shader/Uniform$UniformType;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "Ljava/lang/String;", "getVertex", "()Ljava/lang/String;", "getFragment", "", "shaderProgram", "I", "getShaderProgram", "()I", "setShaderProgram", "(I)V", "vertexShaderID", "fragmentShaderID", "", "Lat/hannibal2/skyhanni/utils/shader/Uniform;", "uniforms", "Ljava/util/List;", "", "created", "Z", "getCreated", "()Z", "setCreated", "(Z)V", "1.21.10"})
public abstract class Shader {
    @NotNull
    private final String vertex;
    @NotNull
    private final String fragment;
    private int shaderProgram;
    private int vertexShaderID;
    private int fragmentShaderID;
    @NotNull
    private final List<Uniform<?>> uniforms;
    private boolean created;

    public Shader(@NotNull String vertex, @NotNull String fragment) {
        Intrinsics.checkNotNullParameter((Object)vertex, (String)"vertex");
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        this.vertex = vertex;
        this.fragment = fragment;
        this.shaderProgram = -1;
        this.vertexShaderID = -1;
        this.fragmentShaderID = -1;
        this.uniforms = new ArrayList();
    }

    @NotNull
    public final String getVertex() {
        return this.vertex;
    }

    @NotNull
    public final String getFragment() {
        return this.fragment;
    }

    public final int getShaderProgram() {
        return this.shaderProgram;
    }

    public final void setShaderProgram(int n) {
        this.shaderProgram = n;
    }

    public final boolean getCreated() {
        return this.created;
    }

    public final void setCreated(boolean bl) {
        this.created = bl;
    }

    public final void deleteOldShaders() {
        if (this.vertexShaderID >= 0) {
            this.vertexShaderID = -1;
        }
        if (this.fragmentShaderID >= 0) {
            this.fragmentShaderID = -1;
        }
        if (this.shaderProgram >= 0) {
            this.shaderProgram = -1;
        }
        this.uniforms.clear();
        this.created = false;
    }

    public final void recompile() {
        this.deleteOldShaders();
        if (this.shaderProgram < 0) {
            return;
        }
        this.vertexShaderID = ShaderManager.INSTANCE.loadShader(ShaderType.VERTEX, this.vertex);
        if (this.vertexShaderID < 0) {
            return;
        }
        ShaderManager.INSTANCE.attachShader(this.shaderProgram, this.vertexShaderID);
        this.fragmentShaderID = ShaderManager.INSTANCE.loadShader(ShaderType.FRAGMENT, this.fragment);
        if (this.fragmentShaderID < 0) {
            return;
        }
        ShaderManager.INSTANCE.attachShader(this.shaderProgram, this.fragmentShaderID);
        ShaderHelper.INSTANCE.glLinkProgram(this.shaderProgram);
        if (ShaderHelper.INSTANCE.glGetProgramInt(this.shaderProgram, ShaderHelper.INSTANCE.getGL_LINK_STATUS()) == 0) {
            String errorMessage2 = "Failed to link vertex shader " + this.vertex + " and fragment shader " + this.fragment + ". Features that utilise this shader will not work correctly, if at all";
            String errorLog = StringUtils.trim((String)ShaderHelper.INSTANCE.glGetShaderInfoLog(this.shaderProgram, 1024));
            if (ShaderManager.INSTANCE.inWorld()) {
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Link Error:\n", (Object)errorLog)};
                ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, new Exception("Shader linking error."), errorMessage2, pairArray, false, false, false, 56, null);
            } else {
                ChatUtils.INSTANCE.consoleLog(errorMessage2 + " " + errorLog);
            }
            return;
        }
        this.registerUniforms();
        this.created = true;
    }

    public abstract void registerUniforms();

    public final void updateUniforms() {
        for (Uniform<?> uniform : this.uniforms) {
            uniform.update();
        }
    }

    public final void enable() {
        ShaderHelper.INSTANCE.glUseProgram(this.shaderProgram);
    }

    public final void disable() {
        ShaderHelper.INSTANCE.glUseProgram(0);
    }

    public final <T> void registerUniform(@NotNull Uniform.UniformType<T> uniformType, @NotNull String name2, @NotNull Function0<? extends T> uniformValuesSupplier) {
        Intrinsics.checkNotNullParameter(uniformType, (String)"uniformType");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter(uniformValuesSupplier, (String)"uniformValuesSupplier");
        this.uniforms.add(new Uniform<T>(this, uniformType, name2, uniformValuesSupplier));
    }
}

