package at.hannibal2.skyhanni.mixins.transformers;

import at.hannibal2.skyhanni.events.entity.EntityEquipmentChangeEvent;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2744;
import net.minecraft.class_634;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value = class_634.class)
public class MixinClientPlayNetworkHandler {

    @Inject(method = "onEntityEquipmentUpdate", at = @At(value = "INVOKE", target = "Lnet/minecraft/network/packet/s2c/play/EntityEquipmentUpdateS2CPacket;getEquipmentList()Ljava/util/List;", shift = At.Shift.AFTER), locals = LocalCapture.CAPTURE_FAILHARD)
    public void onEntityEquipmentUpdate(class_2744 packet, CallbackInfo ci, class_1297 entity, class_1309 livingEntity) {
        packet.method_30145().forEach((equipment) -> {
            new EntityEquipmentChangeEvent(entity, equipment.getFirst().method_63622(), equipment.getSecond()).post();
        });
    }
}
