package at.hannibal2.skyhanni.mixins.transformers;

import at.hannibal2.skyhanni.data.model.TextInput;
import at.hannibal2.skyhanni.features.garden.farming.GardenCustomKeybinds;
import at.hannibal2.skyhanni.test.graph.GraphEditor;
import net.minecraft.class_304;
import net.minecraft.class_4666;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_304.class)
public class MixinKeyBinding {

    @Inject(method = "isPressed", at = @At("HEAD"), cancellable = true)
    public void noIsKeyDown(CallbackInfoReturnable<Boolean> cir) {
        class_304 keyBinding = (class_304) (Object) this;
        GardenCustomKeybinds.isKeyDown(keyBinding, cir);
        //#if MC > 1.21
        if (keyBinding instanceof class_4666 stickyKeyBinding) {
            if (stickyKeyBinding.field_21334.getAsBoolean()) {
                return;
            }
        }
        //#endif
        TextInput.Companion.onMinecraftInput(keyBinding, cir);
        GraphEditor.INSTANCE.onMinecraftInput(keyBinding, cir);
    }

    @Inject(method = "wasPressed", at = @At("HEAD"), cancellable = true)
    public void noIsPressed(CallbackInfoReturnable<Boolean> cir) {
        class_304 keyBinding = (class_304) (Object) this;
        GardenCustomKeybinds.isKeyPressed(keyBinding, cir);
        //#if MC > 1.21
        if (keyBinding instanceof class_4666 stickyKeyBinding) {
            if (stickyKeyBinding.field_21334.getAsBoolean()) {
                return;
            }
        }
        //#endif
        TextInput.Companion.onMinecraftInput(keyBinding, cir);
        GraphEditor.INSTANCE.onMinecraftInput(keyBinding, cir);
    }
}
