/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.compat;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.events.utils.InitFinishedEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.render.SkyHanniRenderPipeline;
import at.hannibal2.skyhanni.utils.system.PlatformUtils;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.lang.reflect.Method;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J!\u0010\r\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u001b\u0010\u0012\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0015R\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0015R\u0018\u0010\u001b\u001a\u0004\u0018\u00010\u00018\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lat/hannibal2/skyhanni/compat/IrisCompat;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/utils/InitFinishedEvent;", "event", "", "onInitFinished", "(Lat/hannibal2/skyhanni/events/utils/InitFinishedEvent;)V", "assignPipelines", "Lcom/mojang/blaze3d/pipeline/RenderPipeline;", "pipeline", "enumValue", "assignPipeline", "(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Ljava/lang/Object;)V", "", "isIrisLoaded$delegate", "Lkotlin/Lazy;", "isIrisLoaded", "()Z", "IRIS_INSTANCE", "Ljava/lang/Object;", "Ljava/lang/reflect/Method;", "IRIS_ASSIGN_PIPELINE_METHOD", "Ljava/lang/reflect/Method;", "IRIS_PROGRAM_BASIC", "IRIS_PROGRAM_LINES", "IRIS_PROGRAMS_TEXTURED", "1.21.8"})
public final class IrisCompat {
    @NotNull
    public static final IrisCompat INSTANCE = new IrisCompat();
    @NotNull
    private static final Lazy isIrisLoaded$delegate = LazyKt.lazy(IrisCompat::isIrisLoaded_delegate$lambda$0);
    @Nullable
    private static Object IRIS_INSTANCE;
    @Nullable
    private static Method IRIS_ASSIGN_PIPELINE_METHOD;
    @Nullable
    private static Object IRIS_PROGRAM_BASIC;
    @Nullable
    private static Object IRIS_PROGRAM_LINES;
    @Nullable
    private static Object IRIS_PROGRAMS_TEXTURED;

    private IrisCompat() {
    }

    private final boolean isIrisLoaded() {
        Lazy lazy = isIrisLoaded$delegate;
        return (Boolean)lazy.getValue();
    }

    @HandleEvent
    public final void onInitFinished(@NotNull InitFinishedEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isIrisLoaded()) {
            return;
        }
        try {
            Class<?> irisApiClass = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            Object object = IRIS_INSTANCE = irisApiClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            Intrinsics.checkNotNull((Object)object);
            Class<?> irisInstanceClass = object.getClass();
            Class<?> irisProgramEnum = Class.forName("net.irisshaders.iris.api.v0.IrisProgram");
            IRIS_PROGRAM_BASIC = Enum.valueOf(irisProgramEnum.asSubclass(Enum.class), "BASIC");
            IRIS_PROGRAM_LINES = Enum.valueOf(irisProgramEnum.asSubclass(Enum.class), "LINES");
            IRIS_PROGRAMS_TEXTURED = Enum.valueOf(irisProgramEnum.asSubclass(Enum.class), "TEXTURED");
            Class[] classArray = new Class[]{RenderPipeline.class, irisProgramEnum};
            IRIS_ASSIGN_PIPELINE_METHOD = irisInstanceClass.getMethod("assignPipeline", classArray);
        }
        catch (Exception exception) {
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, exception, "Failed to initialize Iris compat!", new Pair[0], false, false, false, 56, null);
        }
        this.assignPipelines();
    }

    private final void assignPipelines() {
        this.assignPipeline(SkyHanniRenderPipeline.LINES.invoke(), IRIS_PROGRAM_LINES);
        this.assignPipeline(SkyHanniRenderPipeline.LINES_XRAY.invoke(), IRIS_PROGRAM_LINES);
        this.assignPipeline(SkyHanniRenderPipeline.FILLED.invoke(), IRIS_PROGRAM_BASIC);
        this.assignPipeline(SkyHanniRenderPipeline.FILLED_XRAY.invoke(), IRIS_PROGRAM_BASIC);
        this.assignPipeline(SkyHanniRenderPipeline.TRIANGLES.invoke(), IRIS_PROGRAM_BASIC);
        this.assignPipeline(SkyHanniRenderPipeline.TRIANGLES_XRAY.invoke(), IRIS_PROGRAM_BASIC);
        this.assignPipeline(SkyHanniRenderPipeline.TRIANGLE_FAN.invoke(), IRIS_PROGRAM_BASIC);
        this.assignPipeline(SkyHanniRenderPipeline.TRIANGLE_FAN_XRAY.invoke(), IRIS_PROGRAM_BASIC);
        this.assignPipeline(SkyHanniRenderPipeline.QUADS.invoke(), IRIS_PROGRAM_BASIC);
        this.assignPipeline(SkyHanniRenderPipeline.QUADS_XRAY.invoke(), IRIS_PROGRAM_BASIC);
        this.assignPipeline(SkyHanniRenderPipeline.ROUNDED_RECT.invoke(), IRIS_PROGRAM_BASIC);
        this.assignPipeline(SkyHanniRenderPipeline.ROUNDED_TEXTURED_RECT.invoke(), IRIS_PROGRAMS_TEXTURED);
        this.assignPipeline(SkyHanniRenderPipeline.ROUNDED_RECT_OUTLINE.invoke(), IRIS_PROGRAM_BASIC);
        this.assignPipeline(SkyHanniRenderPipeline.CIRCLE.invoke(), IRIS_PROGRAM_BASIC);
        this.assignPipeline(SkyHanniRenderPipeline.RADIAL_GRADIENT_CIRCLE.invoke(), IRIS_PROGRAM_BASIC);
        this.assignPipeline(SkyHanniRenderPipeline.CHROMA_STANDARD.invoke(), IRIS_PROGRAM_BASIC);
        this.assignPipeline(SkyHanniRenderPipeline.CHROMA_TEXT.invoke(), IRIS_PROGRAMS_TEXTURED);
    }

    private final void assignPipeline(RenderPipeline pipeline, Object enumValue) {
        block4: {
            if (enumValue == null) {
                return;
            }
            if (!this.isIrisLoaded()) {
                return;
            }
            Method method = IRIS_ASSIGN_PIPELINE_METHOD;
            if (method == null) break block4;
            Method method2 = method;
            boolean bl = false;
            try {
                Object object = new Object[]{pipeline, enumValue};
                object = method2.invoke(IRIS_INSTANCE, object);
            }
            catch (Exception exception) {
                Boolean bl2 = ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, exception, "Failed to assign Iris pipeline!", new Pair[0], false, false, false, 56, null);
            }
        }
    }

    private static final boolean isIrisLoaded_delegate$lambda$0() {
        return PlatformUtils.INSTANCE.isModInstalled("iris");
    }
}

