/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.config;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.config.BlockingMoulConfigProcessor;
import at.hannibal2.skyhanni.config.ConfigFileType;
import at.hannibal2.skyhanni.config.ConfigGuiManager;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.Features;
import at.hannibal2.skyhanni.config.NoConfigLink;
import at.hannibal2.skyhanni.config.core.config.Position;
import at.hannibal2.skyhanni.config.core.config.PositionList;
import at.hannibal2.skyhanni.deps.moulconfig.annotations.ConfigLink;
import at.hannibal2.skyhanni.deps.moulconfig.processor.BuiltinMoulConfigGuis;
import at.hannibal2.skyhanni.deps.moulconfig.processor.ConfigProcessorDriver;
import at.hannibal2.skyhanni.features.misc.update.UpdateManager;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.IdentityCharacteristics;
import at.hannibal2.skyhanni.utils.LorenzLogger;
import at.hannibal2.skyhanni.utils.OSUtils;
import at.hannibal2.skyhanni.utils.ReflectionUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.StringFileHandler;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.json.BaseGsonBuilder;
import at.hannibal2.skyhanni.utils.system.PlatformUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.concurrent.TimersKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_128;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 12\u00020\u0001:\u00011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0003J-\u0010\u0010\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00012\u0012\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000e0\rH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J)\u0010\u0016\u001a\u00020\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0018\u00a2\u0006\u0004\b\u001a\u0010\u001bJ/\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\u0007\u00a2\u0006\u0004\b \u0010\u0003J\r\u0010!\u001a\u00020\u0007\u00a2\u0006\u0004\b!\u0010\u0003R\u0014\u0010#\u001a\u00020\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R \u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\"\u0010)\u001a\u00020(8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0016\u0010 \u001a\u00020/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u00100\u00a8\u00062"}, d2={"Lat/hannibal2/skyhanni/config/ConfigManager;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/config/ConfigFileType;", "type", "value", "", "setConfigHolder", "(Lat/hannibal2/skyhanni/config/ConfigFileType;Ljava/lang/Object;)V", "firstLoad", "deleteOldBackups", "obj", "", "Lat/hannibal2/skyhanni/utils/IdentityCharacteristics;", "slog", "findPositionLinks", "(Ljava/lang/Object;Ljava/util/Set;)V", "Ljava/io/File;", "file", "fileType", "defaultValue", "firstLoadFile", "(Ljava/io/File;Lat/hannibal2/skyhanni/config/ConfigFileType;Ljava/lang/Object;)Ljava/lang/Object;", "", "reason", "saveConfig", "(Lat/hannibal2/skyhanni/config/ConfigFileType;Ljava/lang/String;)V", "fileName", "data", "saveFile", "(Ljava/io/File;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)V", "disableSaving", "recreateConfig", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "logger", "Lat/hannibal2/skyhanni/utils/LorenzLogger;", "", "jsonHolder", "Ljava/util/Map;", "Lat/hannibal2/skyhanni/config/BlockingMoulConfigProcessor;", "processor", "Lat/hannibal2/skyhanni/config/BlockingMoulConfigProcessor;", "getProcessor", "()Lat/hannibal2/skyhanni/config/BlockingMoulConfigProcessor;", "setProcessor", "(Lat/hannibal2/skyhanni/config/BlockingMoulConfigProcessor;)V", "", "Z", "Companion", "1.21.8"})
@SourceDebugExtension(value={"SMAP\nConfigManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigManager.kt\nat/hannibal2/skyhanni/config/ConfigManager\n+ 2 CollectionUtils.kt\nat/hannibal2/skyhanni/utils/collection/CollectionUtils\n+ 3 ErrorManager.kt\nat/hannibal2/skyhanni/test/command/ErrorManager\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,332:1\n344#2:333\n147#3,3:334\n11228#4:337\n11563#4,3:338\n*S KotlinDebug\n*F\n+ 1 ConfigManager.kt\nat/hannibal2/skyhanni/config/ConfigManager\n*L\n65#1:333\n99#1:334,3\n116#1:337\n116#1:338,3\n*E\n"})
public final class ConfigManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LorenzLogger logger = new LorenzLogger("config_manager");
    @NotNull
    private final Map<ConfigFileType, Object> jsonHolder;
    public BlockingMoulConfigProcessor processor;
    private boolean disableSaving;
    @NotNull
    private static final Gson gson;
    @NotNull
    private static final File configDirectory;

    public ConfigManager() {
        CollectionUtils this_$iv = CollectionUtils.INSTANCE;
        boolean $i$f$enumMapOf = false;
        this.jsonHolder = new EnumMap(ConfigFileType.class);
    }

    @NotNull
    public final BlockingMoulConfigProcessor getProcessor() {
        BlockingMoulConfigProcessor blockingMoulConfigProcessor = this.processor;
        if (blockingMoulConfigProcessor != null) {
            return blockingMoulConfigProcessor;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"processor");
        return null;
    }

    public final void setProcessor(@NotNull BlockingMoulConfigProcessor blockingMoulConfigProcessor) {
        Intrinsics.checkNotNullParameter((Object)blockingMoulConfigProcessor, (String)"<set-?>");
        this.processor = blockingMoulConfigProcessor;
    }

    private final void setConfigHolder(ConfigFileType type2, Object value) {
        if (!Intrinsics.areEqual(value.getClass(), type2.getClazz())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        KMutableProperty0<?> kMutableProperty0 = type2.getProperty();
        Intrinsics.checkNotNull(kMutableProperty0, (String)"null cannot be cast to non-null type kotlin.reflect.KMutableProperty0<kotlin.Any>");
        kMutableProperty0.set(value);
        Map<ConfigFileType, Object> map = this.jsonHolder;
        Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<at.hannibal2.skyhanni.config.ConfigFileType, kotlin.Any>");
        TypeIntrinsics.asMutableMap(map).put(type2, value);
    }

    public final void firstLoad() {
        block4: {
            Timer timer;
            if (!this.jsonHolder.isEmpty()) {
                this.logger.log("Loading config despite config being already loaded?");
            }
            configDirectory.mkdirs();
            for (ConfigFileType fileType : ConfigFileType.getEntries()) {
                File file = fileType.getFile();
                Object obj = fileType.getClazz().newInstance();
                Intrinsics.checkNotNullExpressionValue(obj, (String)"newInstance(...)");
                this.setConfigHolder(fileType, this.firstLoadFile(file, fileType, obj));
            }
            String string = "skyhanni-config-auto-save";
            long l = 60000L;
            long l2 = 60000L;
            boolean fileType = false;
            Timer timer2 = timer = TimersKt.timer((String)string, (boolean)fileType);
            timer2.scheduleAtFixedRate(new TimerTask(this){
                final /* synthetic */ ConfigManager this$0;
                {
                    this.this$0 = configManager;
                }

                public void run() {
                    TimerTask $this$firstLoad_u24lambda_u240 = this;
                    boolean bl = false;
                    this.this$0.saveConfig(ConfigFileType.FEATURES, "auto-save-60s");
                }
            }, l, l2);
            Features features = SkyHanniMod.feature;
            this.recreateConfig();
            try {
                this.findPositionLinks(features, new LinkedHashSet());
            }
            catch (Exception e) {
                Throwable throwable;
                ErrorManager errorManager = ErrorManager.INSTANCE;
                String reason$iv = "Couldn't load config links";
                boolean $i$f$crashInDevEnv = false;
                if (!PlatformUtils.INSTANCE.isDevEnvironment()) break block4;
                String string2 = reason$iv;
                String string3 = "SkyHanni - " + reason$iv;
                class_310 class_3102 = class_310.method_1551();
                boolean bl = false;
                Throwable throwable2 = throwable = (Throwable)e;
                String string4 = string3;
                class_3102.method_1494(new class_128(string4, throwable2));
            }
        }
        this.deleteOldBackups();
    }

    private final void deleteOldBackups() {
        OSUtils.INSTANCE.deleteExpiredFiles-HG0u8IE(new File("skyhanni/config/backup"), DurationKt.toDuration((int)SkyHanniMod.feature.getDev().getConfigBackupExpiryTime(), (DurationUnit)DurationUnit.DAYS));
    }

    /*
     * WARNING - void declaration
     */
    private final void findPositionLinks(Object obj, Set<IdentityCharacteristics<Object>> slog) {
        void $this$mapTo$iv$iv;
        if (obj == null) {
            return;
        }
        String string = obj.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"at.hannibal2.skyhanni.", (boolean)false, (int)2, null)) {
            return;
        }
        IdentityCharacteristics<Object> ic = new IdentityCharacteristics<Object>(obj);
        if (slog.contains(ic)) {
            return;
        }
        slog.add(ic);
        boolean missingConfigLink = false;
        Field[] fieldArray = obj.getClass().getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
        Object[] $this$map$iv = fieldArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Field field = (Field)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(ReflectionUtils.INSTANCE.makeAccessible((Field)it));
        }
        for (Field field : (List)destination$iv$iv) {
            if (!Intrinsics.areEqual(field.getType(), Position.class) && !Intrinsics.areEqual(field.getType(), PositionList.class)) {
                this.findPositionLinks(field.get(obj), slog);
                continue;
            }
            ConfigLink configLink = field.getAnnotation(ConfigLink.class);
            if (configLink == null) {
                if (!PlatformUtils.INSTANCE.isDevEnvironment()) continue;
                Object name2 = field.getDeclaringClass().getName() + "." + field.getName();
                name2 = StringsKt.replace$default((String)name2, (String)"at.hannibal2.skyhanni.config.", (String)"", (boolean)false, (int)4, null);
                boolean hasExplanatoryAnnotation = field.getAnnotation(NoConfigLink.class) != null;
                if (hasExplanatoryAnnotation) continue;
                System.out.println((Object)("WEE WOO WEE WOO HIER FEHLT EIN @CONFIGLINK: " + (String)name2));
                missingConfigLink = true;
                continue;
            }
            if (Intrinsics.areEqual(field.getType(), Position.class)) {
                Object object = field.get(obj);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type at.hannibal2.skyhanni.config.core.config.Position");
                Position position = (Position)object;
                position.setLink(configLink);
                continue;
            }
            if (!Intrinsics.areEqual(field.getType(), PositionList.class)) continue;
            Object object = field.get(obj);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type at.hannibal2.skyhanni.config.core.config.PositionList");
            PositionList list = (PositionList)object;
            list.setLink(configLink);
        }
        if (missingConfigLink) {
            System.out.println((Object)"");
            String string2 = "This crash is here to remind you to fix the missing @ConfigLink annotation over your new config position config element.";
            System.out.println((Object)string2);
            System.out.println((Object)"");
            System.out.println((Object)"Steps to fix:");
            System.out.println((Object)"1. Search for `WEE WOO WEE WOO` in the console output.");
            System.out.println((Object)"2. Either add the Config Link.");
            System.out.println((Object)"3. Or add the @NoConfigLink annotation to the field.");
            System.out.println((Object)"");
            PlatformUtils.INSTANCE.shutdownMinecraft("Missing Config Link");
        }
    }

    private final Object firstLoadFile(File file, ConfigFileType fileType, Object defaultValue) {
        String fileName = fileType.getFileName();
        this.logger.log("Trying to load " + fileName + " from " + file);
        Object output = defaultValue;
        File file2 = file;
        Intrinsics.checkNotNull((Object)file2);
        if (file2.exists()) {
            try {
                Object object;
                String text = new StringFileHandler(file).load();
                Gson lenientGson = BaseGsonBuilder.INSTANCE.lenientGson().create();
                this.logger.log("load-" + fileName + "-now");
                if (fileType == ConfigFileType.FEATURES) {
                    JsonObject jsonObject = (JsonObject)lenientGson.fromJson(text, JsonObject.class);
                    Intrinsics.checkNotNull((Object)jsonObject);
                    JsonObject newJsonObject = ConfigUpdaterMigrator.INSTANCE.fixConfig(jsonObject);
                    Function0 run = () -> ConfigManager.firstLoadFile$lambda$3(lenientGson, newJsonObject, defaultValue);
                    if (PlatformUtils.INSTANCE.isDevEnvironment()) {
                        Object object2;
                        try {
                            object2 = run.invoke();
                        }
                        catch (Throwable e) {
                            this.logger.log(ExceptionsKt.stackTraceToString((Throwable)e));
                            PlatformUtils.INSTANCE.shutdownMinecraft("Config is corrupt inside development environment.");
                            object2 = Unit.INSTANCE;
                        }
                        object = object2;
                    } else {
                        object = run.invoke();
                    }
                } else {
                    object = lenientGson.fromJson(text, defaultValue.getClass());
                }
                output = object;
                this.logger.log("Loaded " + fileName + " from file");
            }
            catch (Exception e) {
                this.logger.log(ExceptionsKt.stackTraceToString((Throwable)e));
                File backupFile = FilesKt.resolveSibling((File)file, (String)(fileName + "-" + SimpleTimeMark.toMillis-impl(SimpleTimeMark.Companion.now-uFjCsEo()) + "-backup.json"));
                this.logger.log("Exception while reading " + file + ". Will load blank " + fileName + " and save backup to " + backupFile);
                this.logger.log("Exception was " + e);
                try {
                    File file3 = FilesKt.copyTo$default((File)file, (File)backupFile, (boolean)false, (int)0, (int)6, null);
                }
                catch (Exception e2) {
                    this.logger.log("Could not create backup for " + fileName + " file");
                    this.logger.log(ExceptionsKt.stackTraceToString((Throwable)e2));
                    Unit unit = Unit.INSTANCE;
                }
            }
        }
        if (Intrinsics.areEqual((Object)output, (Object)defaultValue)) {
            this.logger.log("Setting " + fileName + " to be blank as it did not exist. It will be saved once something is written to it");
        }
        if (output == null) {
            this.logger.log("Setting " + fileName + " to be blank as it was null. It will be saved once something is written to it");
            output = defaultValue;
        }
        return output;
    }

    public final void saveConfig(@NotNull ConfigFileType fileType, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)((Object)fileType), (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        Object object = this.jsonHolder.get((Object)fileType);
        if (object == null) {
            throw new IllegalStateException(("Could not find json object for " + fileType).toString());
        }
        Object json2 = object;
        this.saveFile(fileType.getFile(), fileType.getFileName(), json2, reason);
        this.saveFile(fileType.getBackupFile(), fileType.getFileName(), json2, reason);
    }

    private final void saveFile(File file, String fileName, Object data, String reason) {
        if (this.disableSaving) {
            return;
        }
        this.logger.log("saveConfig: " + reason);
        try {
            this.logger.log("Saving " + fileName + " file");
            file.getParentFile().mkdirs();
            StringFileHandler stringFileHandler = new StringFileHandler(file);
            String string = gson.toJson(data);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            StringFileHandler.save$default(stringFileHandler, string, 0, 2, null);
            this.logger.log("Saved " + fileName + " file successfully");
        }
        catch (ClassCastException e) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"file", (Object)file), TuplesKt.to((Object)"data", (Object)data), TuplesKt.to((Object)"dataClass", data.getClass()), TuplesKt.to((Object)"fileName", (Object)fileName)};
            ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, e, "Could not save " + fileName + " file to " + file, pairArray, false, false, false, 56, null);
        }
        catch (IOException e) {
            this.logger.log("Could not save " + fileName + " file to " + file);
            this.logger.log(ExceptionsKt.stackTraceToString((Throwable)e));
        }
    }

    public final void disableSaving() {
        this.disableSaving = true;
    }

    public final void recreateConfig() {
        ConfigGuiManager.INSTANCE.setEditor(null);
        Features features = SkyHanniMod.feature;
        this.setProcessor(new BlockingMoulConfigProcessor());
        BuiltinMoulConfigGuis.addProcessors(this.getProcessor());
        UpdateManager.INSTANCE.injectConfigProcessor(this.getProcessor());
        ConfigProcessorDriver driver = new ConfigProcessorDriver(this.getProcessor());
        driver.warnForPrivateFields = false;
        driver.processConfig(features);
    }

    private static final Object firstLoadFile$lambda$3(Gson $lenientGson, JsonObject $newJsonObject, Object $defaultValue) {
        Intrinsics.checkNotNullParameter((Object)$newJsonObject, (String)"$newJsonObject");
        Intrinsics.checkNotNullParameter((Object)$defaultValue, (String)"$defaultValue");
        return $lenientGson.fromJson((JsonElement)$newJsonObject, $defaultValue.getClass());
    }

    static {
        Gson gson = BaseGsonBuilder.INSTANCE.gson().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        ConfigManager.gson = gson;
        configDirectory = new File("config/skyhanni");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lat/hannibal2/skyhanni/config/ConfigManager$Companion;", "", "<init>", "()V", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "Ljava/io/File;", "configDirectory", "Ljava/io/File;", "getConfigDirectory", "()Ljava/io/File;", "1.21.8"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGson() {
            return gson;
        }

        @NotNull
        public final File getConfigDirectory() {
            return configDirectory;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

