/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net.smtp;

import at.hannibal2.skyhanni.deps.commons.net.io.CRLFLineReader;
import at.hannibal2.skyhanni.deps.commons.net.smtp.SMTPClient;
import at.hannibal2.skyhanni.deps.commons.net.smtp.SMTPReply;
import at.hannibal2.skyhanni.deps.commons.net.util.SSLContextUtils;
import at.hannibal2.skyhanni.deps.commons.net.util.SSLSocketUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SMTPSClient
extends SMTPClient {
    private static final String DEFAULT_PROTOCOL = "TLS";
    private final boolean isImplicit;
    private final String protocol;
    private SSLContext context;
    private String[] suites;
    private String[] protocols;
    private TrustManager trustManager;
    private KeyManager keyManager;
    private HostnameVerifier hostnameVerifier;
    private boolean tlsEndpointChecking;

    public SMTPSClient() {
        this(DEFAULT_PROTOCOL, false);
    }

    public SMTPSClient(boolean implicit) {
        this(DEFAULT_PROTOCOL, implicit);
    }

    public SMTPSClient(boolean implicit, SSLContext ctx) {
        this.isImplicit = implicit;
        this.context = ctx;
        this.protocol = DEFAULT_PROTOCOL;
    }

    public SMTPSClient(SSLContext context2) {
        this(false, context2);
    }

    public SMTPSClient(String proto) {
        this(proto, false);
    }

    public SMTPSClient(String proto, boolean implicit) {
        this.protocol = proto;
        this.isImplicit = implicit;
    }

    public SMTPSClient(String proto, boolean implicit, String encoding) {
        super(encoding);
        this.protocol = proto;
        this.isImplicit = implicit;
    }

    @Override
    protected void _connectAction_() throws IOException {
        if (this.isImplicit) {
            this.applySocketAttributes();
            this.performSSLNegotiation();
        }
        super._connectAction_();
    }

    public boolean execTLS() throws IOException {
        if (!SMTPReply.isPositiveCompletion(this.sendCommand("STARTTLS"))) {
            return false;
        }
        this.performSSLNegotiation();
        return true;
    }

    public String[] getEnabledCipherSuites() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getEnabledCipherSuites();
        }
        return null;
    }

    public String[] getEnabledProtocols() {
        if (this._socket_ instanceof SSLSocket) {
            return ((SSLSocket)this._socket_).getEnabledProtocols();
        }
        return null;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hostnameVerifier;
    }

    public KeyManager getKeyManager() {
        return this.keyManager;
    }

    public TrustManager getTrustManager() {
        return this.trustManager;
    }

    private void initSSLContext() throws IOException {
        if (this.context == null) {
            this.context = SSLContextUtils.createSSLContext(this.protocol, this.getKeyManager(), this.getTrustManager());
        }
    }

    public boolean isEndpointCheckingEnabled() {
        return this.tlsEndpointChecking;
    }

    private void performSSLNegotiation() throws IOException {
        this.initSSLContext();
        SSLSocketFactory ssf = this.context.getSocketFactory();
        String host = this._hostname_ != null ? this._hostname_ : this.getRemoteAddress().getHostAddress();
        int port = this.getRemotePort();
        SSLSocket socket = (SSLSocket)ssf.createSocket(this._socket_, host, port, true);
        socket.setEnableSessionCreation(true);
        socket.setUseClientMode(true);
        if (this.tlsEndpointChecking) {
            SSLSocketUtils.enableEndpointNameVerification(socket);
        }
        if (this.protocols != null) {
            socket.setEnabledProtocols(this.protocols);
        }
        if (this.suites != null) {
            socket.setEnabledCipherSuites(this.suites);
        }
        socket.startHandshake();
        this._socket_ = socket;
        this._input_ = socket.getInputStream();
        this._output_ = socket.getOutputStream();
        this.reader = new CRLFLineReader(new InputStreamReader(this._input_, this.encoding));
        this.writer = new BufferedWriter(new OutputStreamWriter(this._output_, this.encoding));
        if (this.hostnameVerifier != null && !this.hostnameVerifier.verify(host, socket.getSession())) {
            throw new SSLHandshakeException("Hostname doesn't match certificate");
        }
    }

    public void setEnabledCipherSuites(String[] cipherSuites) {
        this.suites = (String[])cipherSuites.clone();
    }

    public void setEnabledProtocols(String[] protocolVersions) {
        this.protocols = (String[])protocolVersions.clone();
    }

    public void setEndpointCheckingEnabled(boolean enable) {
        this.tlsEndpointChecking = enable;
    }

    public void setHostnameVerifier(HostnameVerifier newHostnameVerifier) {
        this.hostnameVerifier = newHostnameVerifier;
    }

    public void setKeyManager(KeyManager newKeyManager) {
        this.keyManager = newKeyManager;
    }

    public void setTrustManager(TrustManager newTrustManager) {
        this.trustManager = newTrustManager;
    }
}

