/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.combat;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.combat.broodmother.BroodmotherConfig;
import at.hannibal2.skyhanni.config.features.combat.broodmother.BroodmotherSpawnAlertConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.model.TabWidget;
import at.hannibal2.skyhanni.data.title.TitleManager;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.WidgetUpdateEvent;
import at.hannibal2.skyhanni.features.combat.SpidersDenApi;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SoundUtils;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty0;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_1113;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001-B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u0003J\u000f\u0010\u000e\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u000f\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u000f\u0010\u0010\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0003J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u000f\u0010\u0018\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0018\u0010\fJ\u000f\u0010\u0019\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0019\u0010\fJ\u000f\u0010\u001a\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001a\u0010\fR\u0014\u0010\u001e\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\"\u001a\u00020\u001f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0018\u0010$\u001a\u0004\u0018\u00010#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0018\u0010&\u001a\u0004\u0018\u00010#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010%R\u0016\u0010(\u001a\u00020'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010+\u001a\u00020*8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,\u00a8\u0006."}, d2={"Lat/hannibal2/skyhanni/features/combat/BroodmotherFeatures;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/WidgetUpdateEvent;", "event", "", "onWidgetUpdate", "(Lat/hannibal2/skyhanni/events/WidgetUpdateEvent;)V", "onStageUpdate", "", "onServerJoin", "()Z", "onBroodmotherSpawn", "playImminentWarning", "onBroodmotherSlain", "onWorldChange", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "playTestSound", "inSpidersDen", "isCountdownEnabled", "isAliveMessageEnabled", "Lat/hannibal2/skyhanni/config/features/combat/broodmother/BroodmotherConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/combat/broodmother/BroodmotherConfig;", "config", "Lat/hannibal2/skyhanni/config/features/combat/broodmother/BroodmotherSpawnAlertConfig;", "getSpawnAlertConfig", "()Lat/hannibal2/skyhanni/config/features/combat/broodmother/BroodmotherSpawnAlertConfig;", "spawnAlertConfig", "Lat/hannibal2/skyhanni/features/combat/BroodmotherFeatures$StageEntry;", "lastStage", "Lat/hannibal2/skyhanni/features/combat/BroodmotherFeatures$StageEntry;", "currentStage", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "broodmotherSpawnTime", "J", "", "display", "Ljava/lang/String;", "StageEntry", "1.21.8"})
@SourceDebugExtension(value={"SMAP\nBroodmotherFeatures.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BroodmotherFeatures.kt\nat/hannibal2/skyhanni/features/combat/BroodmotherFeatures\n+ 2 TabWidget.kt\nat/hannibal2/skyhanni/data/model/TabWidget\n+ 3 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n405#2,2:184\n407#2:188\n8#3:186\n1#4:187\n*S KotlinDebug\n*F\n+ 1 BroodmotherFeatures.kt\nat/hannibal2/skyhanni/features/combat/BroodmotherFeatures\n*L\n50#1:184,2\n50#1:188\n50#1:186\n50#1:187\n*E\n"})
public final class BroodmotherFeatures {
    @NotNull
    public static final BroodmotherFeatures INSTANCE = new BroodmotherFeatures();
    @Nullable
    private static StageEntry lastStage;
    @Nullable
    private static StageEntry currentStage;
    private static long broodmotherSpawnTime;
    @NotNull
    private static String display;

    private BroodmotherFeatures() {
    }

    private final BroodmotherConfig getConfig() {
        return SkyHanniMod.feature.getCombat().getBroodmother();
    }

    private final BroodmotherSpawnAlertConfig getSpawnAlertConfig() {
        return this.getConfig().getSpawnAlert();
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onWidgetUpdate(@NotNull WidgetUpdateEvent event2) {
        String newStage;
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!event2.isWidget(TabWidget.BROODMOTHER)) {
            return;
        }
        TabWidget this_$iv = event2.getWidget();
        boolean $i$f$matchMatcherFirstLine = false;
        if (this_$iv.isActive()) {
            void $this$matchMatcher$iv$iv;
            RegexUtils regexUtils = RegexUtils.INSTANCE;
            Pattern pattern = this_$iv.getPattern();
            String text$iv$iv = (String)CollectionsKt.first(this_$iv.getLines());
            boolean $i$f$matchMatcher = false;
            Matcher it$iv$iv = $this$matchMatcher$iv$iv.matcher(text$iv$iv);
            boolean bl = false;
            if (it$iv$iv.matches()) {
                Intrinsics.checkNotNull((Object)it$iv$iv);
                Matcher $this$onWidgetUpdate_u24lambda_u240 = it$iv$iv;
                boolean bl2 = false;
                string2 = $this$onWidgetUpdate_u24lambda_u240.group("stage");
            } else {
                string2 = null;
            }
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        if (((CharSequence)(newStage = string)).length() > 0 && !Intrinsics.areEqual((Object)newStage, (Object)String.valueOf((Object)lastStage))) {
            lastStage = currentStage;
            String string3 = StringsKt.replace$default((String)newStage, (String)"!", (String)"", (boolean)false, (int)4, null).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            currentStage = StageEntry.valueOf(string3);
            this.onStageUpdate();
        }
    }

    private final void onStageUpdate() {
        ChatUtils.debug$default(ChatUtils.INSTANCE, "New Broodmother stage: " + currentStage, false, 2, null);
        if (this.onServerJoin()) {
            return;
        }
        if (currentStage == StageEntry.IMMINENT && lastStage == StageEntry.ALIVE) {
            return;
        }
        if (currentStage == StageEntry.ALIVE) {
            this.onBroodmotherSpawn();
            return;
        }
        StageEntry stageEntry = lastStage;
        if (stageEntry == null) {
            return;
        }
        StageEntry lastStage = stageEntry;
        StageEntry stageEntry2 = currentStage;
        if (stageEntry2 == null) {
            return;
        }
        long timeUntilSpawn = stageEntry2.getDuration-UwyO8pc();
        broodmotherSpawnTime = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), timeUntilSpawn);
        if (currentStage == StageEntry.IMMINENT && this.getConfig().getImminentWarning()) {
            this.playImminentWarning();
            return;
        }
        if (!CollectionsKt.contains((Iterable)this.getConfig().getStages(), (Object)((Object)currentStage))) {
            return;
        }
        if (currentStage == StageEntry.SLAIN) {
            this.onBroodmotherSlain();
        } else {
            String pluralize = StringUtils.pluralize$default(StringUtils.INSTANCE, Duration.toInt-impl((long)timeUntilSpawn, (DurationUnit)DurationUnit.MINUTES), "minute", null, false, 12, null);
            ChatUtils.chat$default(ChatUtils.INSTANCE, "Broodmother: " + lastStage + " \u00a7e-> " + currentStage + "\u00a7e. \u00a7b" + Duration.getInWholeMinutes-impl((long)timeUntilSpawn) + " " + pluralize + " \u00a7euntil it spawns!", false, null, false, false, null, 62, null);
        }
    }

    private final boolean onServerJoin() {
        if (lastStage != null || !this.getConfig().getStageOnJoin()) {
            return false;
        }
        if (currentStage != StageEntry.ALIVE || !this.isAliveMessageEnabled()) {
            StageEntry stageEntry = currentStage;
            Duration duration = stageEntry != null ? Duration.box-impl((long)stageEntry.getDuration-UwyO8pc()) : null;
            String message = "The Broodmother's current stage in this server is " + StringsKt.replace$default((String)String.valueOf((Object)currentStage), (String)"!", (String)"", (boolean)false, (int)4, null) + "\u00a7e.";
            long l = DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.MINUTES);
            Duration duration2 = duration;
            if (!(duration2 == null ? false : Duration.equals-impl0((long)duration2.unbox-impl(), (long)l))) {
                message = message + " It will spawn \u00a7bwithin " + duration + "\u00a7e.";
            }
            ChatUtils.chat$default(ChatUtils.INSTANCE, message, false, null, false, false, null, 62, null);
            return true;
        }
        return false;
    }

    private final void onBroodmotherSpawn() {
        broodmotherSpawnTime = SimpleTimeMark.Companion.farPast();
        if (!this.isAliveMessageEnabled()) {
            return;
        }
        KProperty0 feature = null;
        if (this.getConfig().getAlertOnSpawn()) {
            feature = (KProperty0)new MutablePropertyReference0Impl(this.getConfig()){

                public Object get() {
                    return ((BroodmotherConfig)this.receiver).getAlertOnSpawn();
                }

                public void set(Object value) {
                    ((BroodmotherConfig)this.receiver).setAlertOnSpawn((Boolean)value);
                }
            };
            class_1113 alertSound = SoundUtils.createSound$default(SoundUtils.INSTANCE, this.getSpawnAlertConfig().getAlertSound(), this.getSpawnAlertConfig().getPitch(), 0.0f, 4, null);
            SoundUtils.INSTANCE.repeatSound(100L, this.getSpawnAlertConfig().getRepeatSound(), alertSound);
            TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, StringsKt.replace$default((String)this.getSpawnAlertConfig().getText(), (String)"&", (String)"\u00a7", (boolean)false, (int)4, null), null, 0L, null, null, null, 0.0, false, false, null, 0L, null, null, 0L, 16382, null);
        } else {
            feature = (KProperty0)new PropertyReference0Impl(this.getConfig()){

                public Object get() {
                    return ((BroodmotherConfig)this.receiver).getStages();
                }
            };
        }
        ChatUtils.clickToActionOrDisable$default(ChatUtils.INSTANCE, "The Broodmother has spawned!", feature, "warp to the Top of the Nest", BroodmotherFeatures::onBroodmotherSpawn$lambda$1, false, 16, null);
    }

    private final void playImminentWarning() {
        SoundUtils.INSTANCE.repeatSound(100L, 2, SoundUtils.createSound$default(SoundUtils.INSTANCE, "note.pling", 0.5f, 0.0f, 4, null));
        ChatUtils.chat$default(ChatUtils.INSTANCE, "The Broodmother is \u00a74Imminent\u00a7e! It will spawn in \u00a7b60 seconds\u00a7e!", false, null, false, false, null, 62, null);
    }

    private final void onBroodmotherSlain() {
        broodmotherSpawnTime = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES));
        if (!this.getConfig().getHideSlainWhenNearby() || !SpidersDenApi.INSTANCE.isAtTopOfNest()) {
            ChatUtils.chat$default(ChatUtils.INSTANCE, "The Broodmother was killed!", false, null, false, false, null, 62, null);
        }
    }

    @HandleEvent
    public final void onWorldChange() {
        broodmotherSpawnTime = SimpleTimeMark.Companion.farPast();
        lastStage = null;
        currentStage = null;
        display = "";
    }

    @HandleEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isCountdownEnabled()) {
            return;
        }
        if (((CharSequence)display).length() == 0) {
            return;
        }
        if (SimpleTimeMark.isInPast-impl(broodmotherSpawnTime) && !SimpleTimeMark.isFarPast-impl(broodmotherSpawnTime)) {
            display = "\u00a74Broodmother spawning now!";
        }
        RenderUtils.renderString$default(RenderUtils.INSTANCE, this.getConfig().getCountdownPosition(), display, 0, 0, "Broodmother Countdown", 6, null);
    }

    @HandleEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isCountdownEnabled()) {
            return;
        }
        if (SimpleTimeMark.isFarPast-impl(broodmotherSpawnTime)) {
            if (currentStage == StageEntry.ALIVE) {
                display = "\u00a74Broodmother spawned!";
            }
        } else {
            String countdown = TimeUtils.format-ABIMYHs$default(TimeUtils.INSTANCE, SimpleTimeMark.timeUntil-UwyO8pc(broodmotherSpawnTime), null, false, false, 0, false, false, 63, null);
            display = "\u00a74Broodmother spawning in \u00a7b" + countdown;
        }
    }

    @JvmStatic
    public static final void playTestSound() {
        BroodmotherSpawnAlertConfig $this$playTestSound_u24lambda_u242 = INSTANCE.getSpawnAlertConfig();
        boolean bl = false;
        SoundUtils.INSTANCE.playSound(SoundUtils.createSound$default(SoundUtils.INSTANCE, $this$playTestSound_u24lambda_u242.getAlertSound(), $this$playTestSound_u24lambda_u242.getPitch(), 0.0f, 4, null));
    }

    private final boolean inSpidersDen() {
        return IslandType.SPIDER_DEN.isCurrent();
    }

    private final boolean isCountdownEnabled() {
        return this.inSpidersDen() && this.getConfig().getCountdown();
    }

    private final boolean isAliveMessageEnabled() {
        return this.getConfig().getAlertOnSpawn() || this.getConfig().getStages().contains((Object)StageEntry.ALIVE);
    }

    private static final Unit onBroodmotherSpawn$lambda$1() {
        HypixelCommands.INSTANCE.warp("nest");
        return Unit.INSTANCE;
    }

    static {
        broodmotherSpawnTime = SimpleTimeMark.Companion.farPast();
        display = "";
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lat/hannibal2/skyhanni/features/combat/BroodmotherFeatures$StageEntry;", "", "", "str", "Lkotlin/time/Duration;", "duration", "<init>", "(Ljava/lang/String;ILjava/lang/String;J)V", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "J", "getDuration-UwyO8pc", "()J", "SLAIN", "DORMANT", "SOON", "AWAKENING", "IMMINENT", "ALIVE", "1.21.8"})
    public static final class StageEntry
    extends Enum<StageEntry> {
        @NotNull
        private final String str;
        private final long duration;
        public static final /* enum */ StageEntry SLAIN = new StageEntry("\u00a7eSlain", DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.MINUTES));
        public static final /* enum */ StageEntry DORMANT = new StageEntry("\u00a7eDormant", DurationKt.toDuration((int)9, (DurationUnit)DurationUnit.MINUTES));
        public static final /* enum */ StageEntry SOON = new StageEntry("\u00a76Soon", DurationKt.toDuration((int)6, (DurationUnit)DurationUnit.MINUTES));
        public static final /* enum */ StageEntry AWAKENING = new StageEntry("\u00a76Awakening", DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.MINUTES));
        public static final /* enum */ StageEntry IMMINENT = new StageEntry("\u00a74Imminent", DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES));
        public static final /* enum */ StageEntry ALIVE = new StageEntry("\u00a74Alive!", DurationKt.toDuration((int)0, (DurationUnit)DurationUnit.MINUTES));
        private static final /* synthetic */ StageEntry[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private StageEntry(String str, long duration) {
            this.str = str;
            this.duration = duration;
        }

        public final long getDuration-UwyO8pc() {
            return this.duration;
        }

        @NotNull
        public String toString() {
            return this.str;
        }

        public static StageEntry[] values() {
            return (StageEntry[])$VALUES.clone();
        }

        public static StageEntry valueOf(String value) {
            return Enum.valueOf(StageEntry.class, value);
        }

        @NotNull
        public static EnumEntries<StageEntry> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stageEntryArray = new StageEntry[]{StageEntry.SLAIN, StageEntry.DORMANT, StageEntry.SOON, StageEntry.AWAKENING, StageEntry.IMMINENT, StageEntry.ALIVE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

