/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.pests;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.garden.pests.PestWaypointConfig;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.deps.moulconfig.ChromaColour;
import at.hannibal2.skyhanni.events.ItemClickEvent;
import at.hannibal2.skyhanni.events.ReceiveParticleEvent;
import at.hannibal2.skyhanni.events.garden.pests.PestUpdateEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.features.garden.GardenPlotApi;
import at.hannibal2.skyhanni.features.garden.pests.PestApi;
import at.hannibal2.skyhanni.utils.ColorUtils;
import at.hannibal2.skyhanni.utils.LocationUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.ParticlePathBezierFitter;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_2398;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0013\u0010\r\u001a\u00020\f*\u00020\tH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010\u000f\u001a\u00020\f*\u00020\tH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0003J\u000f\u0010\u0011\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0003J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0003J\u000f\u0010\u0016\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0003J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001f\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0016\u0010$\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020#8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010%R\u0018\u0010(\u001a\u0004\u0018\u00010'8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0016\u0010*\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lat/hannibal2/skyhanni/features/garden/pests/PestParticleWaypoint;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/ItemClickEvent;", "event", "", "onItemClick", "(Lat/hannibal2/skyhanni/events/ItemClickEvent;)V", "Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;", "onReceiveParticle", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)V", "", "isEnchantmentTable", "(Lat/hannibal2/skyhanni/events/ReceiveParticleEvent;)Z", "isVillagerAngry", "onWorldChange", "reset", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "onTick", "onPestUpdate", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/garden/pests/PestWaypointConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/pests/PestWaypointConfig;", "config", "Lat/hannibal2/skyhanni/utils/ParticlePathBezierFitter;", "bezierFitter", "Lat/hannibal2/skyhanni/utils/ParticlePathBezierFitter;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastPestTrackerUse", "J", "lastParticle", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "guessPosition", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "isGuessPlotMiddle", "Z", "1.21.8"})
public final class PestParticleWaypoint {
    @NotNull
    public static final PestParticleWaypoint INSTANCE = new PestParticleWaypoint();
    @NotNull
    private static final ParticlePathBezierFitter bezierFitter = new ParticlePathBezierFitter(3);
    private static long lastPestTrackerUse = SimpleTimeMark.Companion.farPast();
    private static long lastParticle = SimpleTimeMark.Companion.farPast();
    @Nullable
    private static LorenzVec guessPosition;
    private static boolean isGuessPlotMiddle;

    private PestParticleWaypoint() {
    }

    private final PestWaypointConfig getConfig() {
        return SkyHanniMod.feature.getGarden().getPests().getPestWaypoint();
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onItemClick(@NotNull ItemClickEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled() || !PestApi.INSTANCE.hasVacuumInHand()) {
            return;
        }
        if (event2.getClickType() != ClickType.LEFT_CLICK) {
            return;
        }
        if (MinecraftCompat.INSTANCE.getLocalPlayer().method_5715()) {
            return;
        }
        this.reset();
        lastPestTrackerUse = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN, priority=1, receiveCancelled=true)
    public final void onReceiveParticle(@NotNull ReceiveParticleEvent event2) {
        LorenzVec solved;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (this.getConfig().getHideParticles() && Intrinsics.areEqual(event2.getType(), (Object)class_2398.field_11248)) {
            event2.cancel();
        }
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastPestTrackerUse), (long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.SECONDS)) > 0) {
            return;
        }
        if (this.isEnchantmentTable(event2)) {
            if (this.getConfig().getHideParticles()) {
                event2.cancel();
            }
            return;
        }
        if (!this.isVillagerAngry(event2)) {
            return;
        }
        if (this.getConfig().getHideParticles()) {
            event2.cancel();
        }
        lastParticle = SimpleTimeMark.Companion.now-uFjCsEo();
        LorenzVec pos = event2.getLocation();
        if (bezierFitter.isEmpty()) {
            bezierFitter.addPoint(pos);
            return;
        }
        LorenzVec lorenzVec = bezierFitter.getLastPoint();
        if (lorenzVec == null) {
            return;
        }
        LorenzVec lastPoint = lorenzVec;
        double dist = lastPoint.distance(pos);
        if (dist == 0.0 || dist > 3.0) {
            return;
        }
        bezierFitter.addPoint(pos);
        LorenzVec lorenzVec2 = bezierFitter.solve();
        if (lorenzVec2 == null) {
            return;
        }
        guessPosition = solved = lorenzVec2;
        Object object = GardenPlotApi.INSTANCE.getPlot(solved);
        isGuessPlotMiddle = object != null && (object = ((GardenPlotApi.Plot)object).getMiddle()) != null ? ((LorenzVec)object).equalsIgnoreY(solved.ceil()) : false;
    }

    private final boolean isEnchantmentTable(ReceiveParticleEvent $this$isEnchantmentTable) {
        return Intrinsics.areEqual($this$isEnchantmentTable.getType(), (Object)class_2398.field_11215) && $this$isEnchantmentTable.getCount() == 10 && $this$isEnchantmentTable.getSpeed() == -2.0f && $this$isEnchantmentTable.getOffset().isZero();
    }

    private final boolean isVillagerAngry(ReceiveParticleEvent $this$isVillagerAngry) {
        return Intrinsics.areEqual($this$isVillagerAngry.getType(), (Object)class_2398.field_11231) && $this$isVillagerAngry.getCount() == 1 && $this$isVillagerAngry.getSpeed() == 0.0f && $this$isVillagerAngry.getOffset().isZero();
    }

    @HandleEvent
    public final void onWorldChange() {
        this.reset();
    }

    private final void reset() {
        lastPestTrackerUse = SimpleTimeMark.Companion.farPast();
        guessPosition = null;
        isGuessPlotMiddle = false;
        bezierFitter.reset();
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (bezierFitter.isEmpty()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastPestTrackerUse), (long)DurationKt.toDuration((int)this.getConfig().getShowForSeconds(), (DurationUnit)DurationUnit.SECONDS)) > 0) {
            this.reset();
            return;
        }
        LorenzVec lorenzVec = guessPosition;
        if (lorenzVec == null) {
            return;
        }
        LorenzVec waypoint = lorenzVec;
        double distance = waypoint.distance(WorldRenderUtils.INSTANCE.exactPlayerEyeLocation(event2));
        ChromaColour color = null;
        if (isGuessPlotMiddle && this.getConfig().getDifferentiatePlotMiddle()) {
            color = LorenzColor.toChromaColor$default(LorenzColor.YELLOW, 0, 0, 3, null);
            WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event2, waypoint, " \u00a7r\u00a7e(plot middle)", 1.0, (float)(-0.1 - distance / 20.4), 0.0, 0.0, false, false, null, 496, null);
        } else {
            color = LorenzColor.toChromaColor$default(LorenzColor.RED, 0, 0, 3, null);
        }
        WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event2, waypoint, ColorUtils.INSTANCE.toColor(color), false, true, 0.0, 0.0, 0.0, 0.0f, false, 500, null);
        WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event2, waypoint, "\u00a7aPest Guess", 1.3, 0.0f, 0.0, 0.0, false, false, null, 504, null);
        if (this.getConfig().getDrawLine()) {
            WorldRenderUtils.INSTANCE.drawLineToEye(event2, waypoint.add(0.5, 0.5, 0.5), color, 3, false);
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onTick() {
        if (!this.isEnabled()) {
            return;
        }
        LorenzVec lorenzVec = guessPosition;
        if (lorenzVec == null) {
            return;
        }
        LorenzVec guessPoint = lorenzVec;
        if (LocationUtils.INSTANCE.distanceToPlayerIgnoreY(guessPoint) > 8.0) {
            return;
        }
        long l = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.SECONDS);
        long l2 = DurationKt.toDuration((int)this.getConfig().getShowForSeconds(), (DurationUnit)DurationUnit.SECONDS);
        long l3 = SimpleTimeMark.passedSince-UwyO8pc(lastPestTrackerUse);
        if (!(0 <= ((Comparable)Duration.box-impl((long)l3)).compareTo(Duration.box-impl((long)l)) ? ((Comparable)Duration.box-impl((long)l3)).compareTo(Duration.box-impl((long)l2)) <= 0 : false)) {
            return;
        }
        this.reset();
    }

    @HandleEvent(eventType=PestUpdateEvent.class)
    public final void onPestUpdate() {
        if (PestApi.INSTANCE.getScoreboardPests() == 0) {
            this.reset();
        }
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        event2.transform(104, "garden.pests.pestWaypoint.enabled", (Function1<? super JsonElement, ? extends JsonElement>)((Function1)PestParticleWaypoint::onConfigFix$lambda$0));
    }

    private final boolean isEnabled() {
        return this.getConfig().getEnabled();
    }

    private static final JsonElement onConfigFix$lambda$0(JsonElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (JsonElement)new JsonPrimitive(Boolean.valueOf(true));
    }
}

