/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.test.graph;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.dev.GraphConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.model.GraphNodeTag;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.test.graph.GraphEditor;
import at.hannibal2.skyhanni.test.graph.GraphingNode;
import at.hannibal2.skyhanni.utils.GraphUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.collection.RenderableCollectionUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.ScrollValue;
import at.hannibal2.skyhanni.utils.renderables.SearchTextInput;
import at.hannibal2.skyhanni.utils.renderables.Searchable;
import at.hannibal2.skyhanni.utils.renderables.SearchableKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u0015\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u000f\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J'\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0007H\u0002\u00a2\u0006\u0004\b\u001f\u0010\nJ'\u0010!\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b!\u0010\"J\r\u0010#\u001a\u00020\u0017\u00a2\u0006\u0004\b#\u0010$R\u0014\u0010&\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020%8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010'R\u0014\u0010*\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u001c\u0010,\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0016\u0010/\u001a\u00020.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u001a\u00102\u001a\b\u0012\u0004\u0012\u00020\r018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u0010-R\u0014\u00106\u001a\u0002038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u00067"}, d2={"Lat/hannibal2/skyhanni/test/graph/GraphNodeEditor;", "", "<init>", "()V", "", "onRenderOverlay", "doRender", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "getNodeNames", "()Ljava/util/List;", "updateNodeNames", "updateToggleTags", "Lat/hannibal2/skyhanni/data/model/GraphNodeTag;", "tag", "toggleTag", "(Lat/hannibal2/skyhanni/data/model/GraphNodeTag;)V", "Lat/hannibal2/skyhanni/test/graph/GraphingNode;", "node", "updateTagView", "(Lat/hannibal2/skyhanni/test/graph/GraphingNode;)V", "drawTagNames", "(Lat/hannibal2/skyhanni/test/graph/GraphingNode;)Ljava/util/List;", "", "checkIsland", "(Lat/hannibal2/skyhanni/data/model/GraphNodeTag;)Z", "", "name", "createTagName", "(Ljava/lang/String;Lat/hannibal2/skyhanni/data/model/GraphNodeTag;Lat/hannibal2/skyhanni/test/graph/GraphingNode;)Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "drawNodeNames", "text", "createNodeTextLine", "(Ljava/lang/String;Ljava/lang/String;Lat/hannibal2/skyhanni/test/graph/GraphingNode;)Lat/hannibal2/skyhanni/utils/renderables/Searchable;", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/utils/renderables/ScrollValue;", "scrollValueNodes", "Lat/hannibal2/skyhanni/utils/renderables/ScrollValue;", "scrollValueTags", "Lat/hannibal2/skyhanni/utils/renderables/SearchTextInput;", "textInput", "Lat/hannibal2/skyhanni/utils/renderables/SearchTextInput;", "nodesDisplay", "Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastUpdate", "J", "", "tagsToShow", "Lat/hannibal2/skyhanni/config/features/dev/GraphConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/dev/GraphConfig;", "config", "1.21.8"})
@SourceDebugExtension(value={"SMAP\nGraphNodeEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphNodeEditor.kt\nat/hannibal2/skyhanni/test/graph/GraphNodeEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,256:1\n1788#2,4:257\n1788#2,4:261\n1788#2,4:265\n774#2:269\n865#2,2:270\n1563#2:272\n1634#2,3:273\n1056#2:276\n1761#2,3:277\n1#3:280\n*S KotlinDebug\n*F\n+ 1 GraphNodeEditor.kt\nat/hannibal2/skyhanni/test/graph/GraphNodeEditor\n*L\n61#1:257,4\n85#1:261,4\n90#1:265,4\n143#1:269\n143#1:270,2\n197#1:272\n197#1:273,3\n199#1:276\n201#1:277,3\n*E\n"})
public final class GraphNodeEditor {
    @NotNull
    public static final GraphNodeEditor INSTANCE = new GraphNodeEditor();
    @NotNull
    private static final ScrollValue scrollValueNodes = new ScrollValue();
    @NotNull
    private static final ScrollValue scrollValueTags = new ScrollValue();
    @NotNull
    private static final SearchTextInput textInput = new SearchTextInput();
    @NotNull
    private static List<? extends Renderable> nodesDisplay = CollectionsKt.emptyList();
    private static long lastUpdate = SimpleTimeMark.Companion.farPast();
    @NotNull
    private static final List<GraphNodeTag> tagsToShow = CollectionsKt.toMutableList((Collection)((Collection)GraphNodeTag.getEntries()));

    private GraphNodeEditor() {
    }

    @HandleEvent(eventType=GuiRenderEvent.GuiOnTopRenderEvent.class)
    public final void onRenderOverlay() {
        this.doRender();
    }

    private final void doRender() {
        if (!this.isEnabled()) {
            return;
        }
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, this.getConfig().getNamedNodesList(), this.getNodeNames(), 0, "Graph Nodes List", false, 10, null);
    }

    private final List<Renderable> getNodeNames() {
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastUpdate), (long)DurationKt.toDuration((int)250, (DurationUnit)DurationUnit.MILLISECONDS)) > 0) {
            this.updateNodeNames();
        }
        return nodesDisplay;
    }

    private final void updateNodeNames() {
        int n;
        List list;
        lastUpdate = SimpleTimeMark.Companion.now-uFjCsEo();
        List $this$updateNodeNames_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        List<Searchable> list2 = INSTANCE.drawNodeNames();
        Iterable $this$count$iv = GraphEditor.INSTANCE.getNodes();
        boolean $i$f$count22 = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                GraphingNode it = (GraphingNode)element$iv;
                boolean bl2 = false;
                String string = it.getName();
                boolean bl3 = string != null ? !StringsKt.isBlank((CharSequence)string) : false;
                if (!bl3 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int total = n;
        int shown = list2.size();
        Renderable.Companion $i$f$count22 = Renderable.Companion;
        String string = "\u00a7eGraph Nodes: " + shown + "/" + total;
        List list3 = CollectionsKt.listOf((Object)"\u00a7eClick to toggle node tags!");
        $this$updateNodeNames_u24lambda_u242.add(Renderable.Companion.clickable$default($i$f$count22, string, GraphNodeEditor::updateNodeNames$lambda$2$lambda$1, false, null, list3, null, 44, null));
        int height = RangesKt.coerceAtMost((int)(shown * 10), (int)250);
        if (!((Collection)list2).isEmpty()) {
            $this$updateNodeNames_u24lambda_u242.add(SearchableKt.buildSearchableScrollable(list2, height, textInput, scrollValueNodes, 10.0));
        }
        nodesDisplay = CollectionsKt.build((List)list);
    }

    private final void updateToggleTags() {
        List list;
        lastUpdate = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration((int)60, (DurationUnit)DurationUnit.SECONDS));
        List $this$updateToggleTags_u24lambda_u247 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$updateToggleTags_u24lambda_u247, "\u00a7eToggle Visible Tags", 0.0, null, null, 14, null);
        Map map = new LinkedHashMap();
        for (GraphNodeTag tag : GraphNodeTag.getEntries()) {
            int n;
            Iterable $this$count$iv = GraphEditor.INSTANCE.getNodes();
            boolean $i$f$count22 = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    GraphingNode it = (GraphingNode)element$iv;
                    boolean bl2 = false;
                    if (!it.getTags().contains((Object)tag) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int nodes = n;
            Integer $i$f$count22 = nodes;
            map.put(tag, $i$f$count22);
        }
        for (GraphNodeTag tag : CollectionUtils.INSTANCE.sortedDesc(map).keySet()) {
            int n;
            boolean isVisible = tagsToShow.contains((Object)tag);
            Iterable $this$count$iv = GraphEditor.INSTANCE.getNodes();
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    GraphingNode it = (GraphingNode)element$iv;
                    boolean bl3 = false;
                    if (!it.getTags().contains((Object)tag) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int nodes = n;
            String visibilityText = isVisible ? " \u00a7aVisible" : " \u00a77Invisible";
            String name2 = " - " + tag.getDisplayName() + " \u00a78(" + nodes + " nodes) " + visibilityText;
            Renderable.Companion companion = Renderable.Companion;
            List list2 = CollectionsKt.listOf((Object)("\u00a7eClick to " + (isVisible ? "hide" : "show") + " nodes with this tag!"));
            $this$updateToggleTags_u24lambda_u247.add(Renderable.Companion.clickable$default(companion, name2, () -> GraphNodeEditor.updateToggleTags$lambda$7$lambda$5(tag), false, null, list2, null, 44, null));
        }
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$updateToggleTags_u24lambda_u247, "", 0.0, null, null, 14, null);
        Renderable.Companion companion = Renderable.Companion;
        List list3 = CollectionsKt.listOf((Object)"\u00a7eClick to go back to the node list!");
        $this$updateToggleTags_u24lambda_u247.add(Renderable.Companion.clickable$default(companion, "\u00a7cGo Back!", GraphNodeEditor::updateToggleTags$lambda$7$lambda$6, false, null, list3, null, 44, null));
        nodesDisplay = CollectionsKt.build((List)list);
    }

    private final void toggleTag(GraphNodeTag tag) {
        boolean bl = tagsToShow.contains((Object)tag) ? tagsToShow.remove((Object)tag) : tagsToShow.add(tag);
    }

    private final void updateTagView(GraphingNode node) {
        List list;
        lastUpdate = SimpleTimeMark.plus-qeHQSLg(SimpleTimeMark.Companion.now-uFjCsEo(), DurationKt.toDuration((int)60, (DurationUnit)DurationUnit.SECONDS));
        List $this$updateTagView_u24lambda_u248 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        List<Renderable> list2 = INSTANCE.drawTagNames(node);
        int size = list2.size();
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$updateTagView_u24lambda_u248, "\u00a7eGraph Nodes: " + size, 0.0, null, null, 14, null);
        int height = RangesKt.coerceAtMost((int)(size * 10), (int)250);
        if (!((Collection)list2).isEmpty()) {
            $this$updateTagView_u24lambda_u248.add(Renderable.Companion.scrollList$default(Renderable.Companion, list2, height, scrollValueTags, 10.0, null, false, null, null, false, 496, null));
        }
        nodesDisplay = CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Renderable> drawTagNames(GraphingNode node) {
        void $this$filterTo$iv$iv;
        List list;
        List $this$drawTagNames_u24lambda_u2411 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$drawTagNames_u24lambda_u2411, "\u00a7eChange tag for node '" + node.getName() + "\u00a7e'", 0.0, null, null, 14, null);
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$drawTagNames_u24lambda_u2411, "", 0.0, null, null, 14, null);
        Iterable $this$filter$iv = (Iterable)GraphNodeTag.getEntries();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GraphNodeTag it = (GraphNodeTag)((Object)element$iv$iv);
            boolean bl2 = false;
            if (!(node.getTags().contains((Object)it) || INSTANCE.checkIsland(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (GraphNodeTag tag : (List)destination$iv$iv) {
            String state = node.getTags().contains((Object)tag) ? "\u00a7aYES" : "\u00a7cNO";
            String name2 = state + " \u00a7r" + tag.getDisplayName();
            $this$drawTagNames_u24lambda_u2411.add(INSTANCE.createTagName(name2, tag, node));
        }
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$drawTagNames_u24lambda_u2411, "", 0.0, null, null, 14, null);
        Renderable.Companion companion = Renderable.Companion;
        List list2 = CollectionsKt.listOf((Object)"\u00a7eClick to go back to the node list!");
        $this$drawTagNames_u24lambda_u2411.add(Renderable.Companion.clickable$default(companion, "\u00a7cGo Back!", GraphNodeEditor::drawTagNames$lambda$11$lambda$10, false, null, list2, null, 44, null));
        return CollectionsKt.build((List)list);
    }

    private final boolean checkIsland(GraphNodeTag tag) {
        boolean bl;
        boolean bl2;
        IslandType islandType = tag.getOnlyIsland();
        if (islandType != null) {
            IslandType it = islandType;
            boolean bl3 = false;
            bl2 = it == SkyBlockUtils.INSTANCE.getCurrentIsland();
        } else {
            Set set = (Set)CollectionUtils.INSTANCE.takeIfNotEmpty((Collection)tag.getOnlyIslands());
            if (set != null) {
                Set it = set;
                boolean bl4 = false;
                bl2 = it.contains((Object)SkyBlockUtils.INSTANCE.getCurrentIsland());
            } else {
                bl2 = true;
            }
        }
        boolean islandMatches = bl2;
        Boolean bl5 = tag.getOnlySkyblock();
        if (bl5 != null) {
            boolean it = bl5;
            boolean bl6 = false;
            bl = it == SkyBlockUtils.INSTANCE.getInSkyBlock();
        } else {
            bl = true;
        }
        boolean skyblockMatches = bl;
        return islandMatches && skyblockMatches;
    }

    private final Renderable createTagName(String name2, GraphNodeTag tag, GraphingNode node) {
        Renderable.Companion companion = Renderable.Companion;
        Object[] objectArray = new String[]{"Tag " + tag.name(), "\u00a77" + tag.getDescription(), "", "\u00a7eClick to set tag for " + node.getName() + " to " + tag.name() + "!"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        return Renderable.Companion.clickable$default(companion, name2, () -> GraphNodeEditor.createTagName$lambda$15(node, tag), false, null, list, null, 44, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Searchable> drawNodeNames() {
        void $this$sortedBy$iv;
        void $this$mapTo$iv$iv;
        List list;
        List $this$drawNodeNames_u24lambda_u2422 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$map$iv = GraphEditor.INSTANCE.getNodes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GraphingNode graphingNode = (GraphingNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(TuplesKt.to((Object)it, (Object)GraphUtils.INSTANCE.distanceSqToPlayer((GraphUtils.GenericNode)it)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        for (Pair pair : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Double)it.getSecond();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Double)it.getSecond()));
            }
        })) {
            Object object;
            String string;
            Object it;
            String element$iv2;
            GraphingNode node = (GraphingNode)pair.component1();
            double distance = ((Number)pair.component2()).doubleValue();
            if (!((Collection)node.getTags()).isEmpty()) {
                boolean bl3;
                block9: {
                    Iterable $this$any$iv = node.getTags();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (String element$iv2 : $this$any$iv) {
                            it = (GraphNodeTag)((Object)element$iv2);
                            boolean bl4 = false;
                            if (!tagsToShow.contains(it)) continue;
                            bl3 = true;
                            break block9;
                        }
                        bl3 = false;
                    }
                }
                if (!bl3) continue;
            }
            if ((string = node.getName()) == null) continue;
            it = element$iv2 = string;
            boolean bl5 = false;
            string = !StringsKt.isBlank((CharSequence)it) ? element$iv2 : null;
            if (string == null) {
                continue;
            }
            String name2 = string;
            String color = Intrinsics.areEqual((Object)node, (Object)GraphEditor.INSTANCE.getActiveNode()) ? "\u00a7a" : "\u00a77";
            String distanceFormat = NumberUtil.INSTANCE.addSeparators((int)Math.sqrt(distance));
            List<GraphNodeTag> tags = node.getTags();
            boolean bl6 = false;
            if (tags.isEmpty()) {
                object = " \u00a7cNo tag\u00a7r";
            } else {
                String text = CollectionsKt.joinToString$default((Iterable)node.getTags(), (CharSequence)", ", null, null, (int)0, null, GraphNodeEditor::drawNodeNames$lambda$22$lambda$21$lambda$20, (int)30, null);
                object = " \u00a7f(" + text + ")";
            }
            String tagText = object;
            String text = color + "Node \u00a7r" + name2 + tagText + " \u00a77[" + distanceFormat + "]";
            $this$drawNodeNames_u24lambda_u2422.add(INSTANCE.createNodeTextLine(text, name2, node));
        }
        return CollectionsKt.build((List)list);
    }

    private final Searchable createNodeTextLine(String text, String name2, GraphingNode node) {
        List list;
        Renderable.Companion companion = Renderable.Companion;
        List $this$createNodeTextLine_u24lambda_u2423 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$createNodeTextLine_u24lambda_u2423.add("Node '" + name2 + "'");
        $this$createNodeTextLine_u24lambda_u2423.add("");
        if (!((Collection)node.getTags()).isEmpty()) {
            $this$createNodeTextLine_u24lambda_u2423.add("Tags: ");
            for (GraphNodeTag tag : node.getTags()) {
                $this$createNodeTextLine_u24lambda_u2423.add(" \u00a78- \u00a7r" + tag.getDisplayName());
            }
            $this$createNodeTextLine_u24lambda_u2423.add("");
        }
        $this$createNodeTextLine_u24lambda_u2423.add("\u00a7eClick to select/deselect this node!");
        $this$createNodeTextLine_u24lambda_u2423.add("\u00a7eControl-Click to edit the tags for this node!");
        List list2 = CollectionsKt.build((List)list);
        return SearchableKt.toSearchable(Renderable.Companion.clickable$default(companion, text, () -> GraphNodeEditor.createNodeTextLine$lambda$24(node), false, null, list2, null, 44, null), name2);
    }

    public final boolean isEnabled() {
        return GraphEditor.INSTANCE.isEnabled();
    }

    private final GraphConfig getConfig() {
        return GraphEditor.INSTANCE.getConfig();
    }

    private static final Unit updateNodeNames$lambda$2$lambda$1() {
        INSTANCE.updateToggleTags();
        return Unit.INSTANCE;
    }

    private static final Unit updateToggleTags$lambda$7$lambda$5(GraphNodeTag $tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)$tag), (String)"$tag");
        INSTANCE.toggleTag($tag);
        INSTANCE.updateToggleTags();
        return Unit.INSTANCE;
    }

    private static final Unit updateToggleTags$lambda$7$lambda$6() {
        INSTANCE.updateNodeNames();
        return Unit.INSTANCE;
    }

    private static final Unit drawTagNames$lambda$11$lambda$10() {
        INSTANCE.updateNodeNames();
        return Unit.INSTANCE;
    }

    private static final Unit createTagName$lambda$15(GraphingNode $node, GraphNodeTag $tag) {
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        Intrinsics.checkNotNullParameter((Object)((Object)$tag), (String)"$tag");
        boolean bl = $node.getTags().contains((Object)$tag) ? $node.getTags().remove((Object)$tag) : $node.getTags().add($tag);
        INSTANCE.updateTagView($node);
        return Unit.INSTANCE;
    }

    private static final CharSequence drawNodeNames$lambda$22$lambda$21$lambda$20(GraphNodeTag it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.getInternalName();
    }

    private static final Unit createNodeTextLine$lambda$24(GraphingNode $node) {
        Intrinsics.checkNotNullParameter((Object)$node, (String)"$node");
        if (KeyboardManager.INSTANCE.isModifierKeyDown()) {
            INSTANCE.updateTagView($node);
        } else {
            GraphEditor.INSTANCE.setActiveNode($node);
            INSTANCE.updateNodeNames();
        }
        return Unit.INSTANCE;
    }
}

