/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.KryoObjectInput;
import com.esotericsoftware.kryo.io.KryoObjectOutput;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import com.esotericsoftware.kryo.util.ObjectMap;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;

public class ExternalizableSerializer
extends Serializer {
    private ObjectMap<Class, JavaSerializer> javaSerializerByType;
    private KryoObjectInput objectInput = null;
    private KryoObjectOutput objectOutput = null;

    public void write(Kryo kryo, Output output, Object object) {
        JavaSerializer serializer2 = this.getJavaSerializerIfRequired(object.getClass());
        if (serializer2 == null) {
            this.writeExternal(kryo, output, object);
        } else {
            serializer2.write(kryo, output, object);
        }
    }

    public Object read(Kryo kryo, Input input2, Class type2) {
        JavaSerializer serializer2 = this.getJavaSerializerIfRequired(type2);
        if (serializer2 == null) {
            return this.readExternal(kryo, input2, type2);
        }
        return serializer2.read(kryo, input2, type2);
    }

    private void writeExternal(Kryo kryo, Output output, Object object) {
        try {
            ((Externalizable)object).writeExternal(this.getObjectOutput(kryo, output));
        }
        catch (ClassCastException e) {
            throw new KryoException(e);
        }
        catch (IOException e) {
            throw new KryoException(e);
        }
    }

    private Object readExternal(Kryo kryo, Input input2, Class type2) {
        try {
            Externalizable object = (Externalizable)type2.newInstance();
            object.readExternal(this.getObjectInput(kryo, input2));
            return object;
        }
        catch (ClassCastException e) {
            throw new KryoException(e);
        }
        catch (ClassNotFoundException e) {
            throw new KryoException(e);
        }
        catch (IOException e) {
            throw new KryoException(e);
        }
        catch (InstantiationException e) {
            throw new KryoException(e);
        }
        catch (IllegalAccessException e) {
            throw new KryoException(e);
        }
    }

    private ObjectOutput getObjectOutput(Kryo kryo, Output output) {
        if (this.objectOutput == null) {
            this.objectOutput = new KryoObjectOutput(kryo, output);
        } else {
            this.objectOutput.setOutput(output);
        }
        return this.objectOutput;
    }

    private ObjectInput getObjectInput(Kryo kryo, Input input2) {
        if (this.objectInput == null) {
            this.objectInput = new KryoObjectInput(kryo, input2);
        } else {
            this.objectInput.setInput(input2);
        }
        return this.objectInput;
    }

    private JavaSerializer getJavaSerializerIfRequired(Class type2) {
        JavaSerializer javaSerializer = this.getCachedSerializer(type2);
        if (javaSerializer == null && this.isJavaSerializerRequired(type2)) {
            javaSerializer = new JavaSerializer();
        }
        return javaSerializer;
    }

    private JavaSerializer getCachedSerializer(Class type2) {
        if (this.javaSerializerByType == null) {
            this.javaSerializerByType = new ObjectMap();
            return null;
        }
        return this.javaSerializerByType.get(type2);
    }

    private boolean isJavaSerializerRequired(Class type2) {
        return ExternalizableSerializer.hasInheritableReplaceMethod(type2, "writeReplace") || ExternalizableSerializer.hasInheritableReplaceMethod(type2, "readResolve");
    }

    private static boolean hasInheritableReplaceMethod(Class type2, String methodName) {
        Method method = null;
        for (Class current = type2; current != null; current = current.getSuperclass()) {
            try {
                method = current.getDeclaredMethod(methodName, new Class[0]);
                break;
            }
            catch (NoSuchMethodException ex) {
                continue;
            }
        }
        return method != null && method.getReturnType() == Object.class;
    }
}

