/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.factories.ReflectionSerializerFactory;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;

final class FieldSerializerAnnotationsUtil {
    public FieldSerializerAnnotationsUtil(FieldSerializer serializer2) {
    }

    public void processAnnotatedFields(FieldSerializer fieldSerializer) {
        FieldSerializer.CachedField[] fields = fieldSerializer.getFields();
        int n = fields.length;
        for (int i2 = 0; i2 < n; ++i2) {
            Annotation annotation;
            Field field = fields[i2].getField();
            if (field.isAnnotationPresent(FieldSerializer.Bind.class)) {
                Class<? extends Serializer> serializerClass = field.getAnnotation(FieldSerializer.Bind.class).value();
                Serializer s = ReflectionSerializerFactory.makeSerializer(fieldSerializer.getKryo(), serializerClass, field.getClass());
                fields[i2].setSerializer(s);
            }
            if (!field.isAnnotationPresent(CollectionSerializer.BindCollection.class) || field.isAnnotationPresent(MapSerializer.BindMap.class)) {
                // empty if block
            }
            if (field.isAnnotationPresent(CollectionSerializer.BindCollection.class)) {
                if (fields[i2].serializer != null) {
                    throw new RuntimeException("CollectionSerialier.Bind cannot be used with field " + fields[i2].getField().getDeclaringClass().getName() + "." + fields[i2].getField().getName() + ", because it has a serializer already.");
                }
                annotation = field.getAnnotation(CollectionSerializer.BindCollection.class);
                if (Collection.class.isAssignableFrom(fields[i2].field.getType())) {
                    Class<? extends Serializer> elementSerializerClass = annotation.elementSerializer();
                    if (elementSerializerClass == Serializer.class) {
                        elementSerializerClass = null;
                    }
                    Serializer elementSerializer = elementSerializerClass == null ? null : ReflectionSerializerFactory.makeSerializer(fieldSerializer.getKryo(), elementSerializerClass, field.getClass());
                    boolean elementsCanBeNull = annotation.elementsCanBeNull();
                    Class<?> elementClass = annotation.elementClass();
                    if (elementClass == Object.class) {
                        elementClass = null;
                    }
                    CollectionSerializer serializer2 = new CollectionSerializer();
                    serializer2.setElementsCanBeNull(elementsCanBeNull);
                    serializer2.setElementClass(elementClass, elementSerializer);
                    fields[i2].setSerializer(serializer2);
                } else {
                    throw new RuntimeException("CollectionSerialier.Bind should be used only with fields implementing java.util.Collection, but field " + fields[i2].getField().getDeclaringClass().getName() + "." + fields[i2].getField().getName() + " does not implement it.");
                }
            }
            if (!field.isAnnotationPresent(MapSerializer.BindMap.class)) continue;
            if (fields[i2].serializer != null) {
                throw new RuntimeException("MapSerialier.Bind cannot be used with field " + fields[i2].getField().getDeclaringClass().getName() + "." + fields[i2].getField().getName() + ", because it has a serializer already.");
            }
            annotation = field.getAnnotation(MapSerializer.BindMap.class);
            if (Map.class.isAssignableFrom(fields[i2].field.getType())) {
                Class<? extends Serializer> valueSerializerClass = annotation.valueSerializer();
                Class<? extends Serializer> keySerializerClass = annotation.keySerializer();
                if (valueSerializerClass == Serializer.class) {
                    valueSerializerClass = null;
                }
                if (keySerializerClass == Serializer.class) {
                    keySerializerClass = null;
                }
                Serializer valueSerializer = valueSerializerClass == null ? null : ReflectionSerializerFactory.makeSerializer(fieldSerializer.getKryo(), valueSerializerClass, field.getClass());
                Serializer keySerializer = keySerializerClass == null ? null : ReflectionSerializerFactory.makeSerializer(fieldSerializer.getKryo(), keySerializerClass, field.getClass());
                boolean valuesCanBeNull = annotation.valuesCanBeNull();
                boolean keysCanBeNull = annotation.keysCanBeNull();
                Class<?> keyClass = annotation.keyClass();
                Class<?> valueClass = annotation.valueClass();
                if (keyClass == Object.class) {
                    keyClass = null;
                }
                if (valueClass == Object.class) {
                    valueClass = null;
                }
                MapSerializer serializer3 = new MapSerializer();
                serializer3.setKeysCanBeNull(keysCanBeNull);
                serializer3.setValuesCanBeNull(valuesCanBeNull);
                serializer3.setKeyClass(keyClass, keySerializer);
                serializer3.setValueClass(valueClass, valueSerializer);
                fields[i2].setSerializer(serializer3);
                continue;
            }
            throw new RuntimeException("MapSerialier.Bind should be used only with fields implementing java.util.Map, but field " + fields[i2].getField().getDeclaringClass().getName() + "." + fields[i2].getField().getName() + " does not implement it.");
        }
    }
}

