/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net;

import at.hannibal2.skyhanni.deps.commons.net.ProtocolCommandEvent;
import at.hannibal2.skyhanni.deps.commons.net.ProtocolCommandListener;
import at.hannibal2.skyhanni.deps.commons.net.io.Util;
import java.io.PrintStream;
import java.io.PrintWriter;

public class PrintCommandListener
implements ProtocolCommandListener {
    private final PrintWriter writer;
    private final boolean nologin;
    private final char eolMarker;
    private final boolean directionMarker;

    public PrintCommandListener(PrintStream printStream) {
        this(Util.newPrintWriter(printStream));
    }

    public PrintCommandListener(PrintStream printStream, boolean suppressLogin) {
        this(Util.newPrintWriter(printStream), suppressLogin);
    }

    public PrintCommandListener(PrintStream printStream, boolean suppressLogin, char eolMarker) {
        this(Util.newPrintWriter(printStream), suppressLogin, eolMarker);
    }

    public PrintCommandListener(PrintStream printStream, boolean suppressLogin, char eolMarker, boolean showDirection) {
        this(Util.newPrintWriter(printStream), suppressLogin, eolMarker, showDirection);
    }

    public PrintCommandListener(PrintWriter writer) {
        this(writer, false);
    }

    public PrintCommandListener(PrintWriter writer, boolean suppressLogin) {
        this(writer, suppressLogin, '\u0000');
    }

    public PrintCommandListener(PrintWriter writer, boolean suppressLogin, char eolMarker) {
        this(writer, suppressLogin, eolMarker, false);
    }

    public PrintCommandListener(PrintWriter writer, boolean suppressLogin, char eolMarker, boolean showDirection) {
        this.writer = writer;
        this.nologin = suppressLogin;
        this.eolMarker = eolMarker;
        this.directionMarker = showDirection;
    }

    private String getPrintableString(String msg) {
        if (this.eolMarker == '\u0000') {
            return msg;
        }
        int pos = msg.indexOf("\r\n");
        if (pos > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(msg.substring(0, pos));
            sb.append(this.eolMarker);
            sb.append(msg.substring(pos));
            return sb.toString();
        }
        return msg;
    }

    @Override
    public void protocolCommandSent(ProtocolCommandEvent event2) {
        if (this.directionMarker) {
            this.writer.print("> ");
        }
        if (this.nologin) {
            String cmd = event2.getCommand();
            if ("PASS".equalsIgnoreCase(cmd) || "USER".equalsIgnoreCase(cmd)) {
                this.writer.print(cmd);
                this.writer.println(" *******");
            } else {
                String IMAP_LOGIN = "LOGIN";
                if ("LOGIN".equalsIgnoreCase(cmd)) {
                    String msg = event2.getMessage();
                    msg = msg.substring(0, msg.indexOf("LOGIN") + "LOGIN".length());
                    this.writer.print(msg);
                    this.writer.println(" *******");
                } else {
                    this.writer.print(this.getPrintableString(event2.getMessage()));
                }
            }
        } else {
            this.writer.print(this.getPrintableString(event2.getMessage()));
        }
        this.writer.flush();
    }

    @Override
    public void protocolReplyReceived(ProtocolCommandEvent event2) {
        if (this.directionMarker) {
            this.writer.print("< ");
        }
        this.writer.print(event2.getMessage());
        this.writer.flush();
    }
}

