/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.dungeon;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.ClickType;
import at.hannibal2.skyhanni.data.ClickedBlockType;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.events.BlockClickEvent;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.events.InventoryFullyOpenedEvent;
import at.hannibal2.skyhanni.events.ScoreboardUpdateEvent;
import at.hannibal2.skyhanni.events.TabListUpdateEvent;
import at.hannibal2.skyhanni.events.TablistFooterUpdateEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.dungeon.DungeonBlockClickEvent;
import at.hannibal2.skyhanni.events.dungeon.DungeonBossRoomEnterEvent;
import at.hannibal2.skyhanni.events.dungeon.DungeonCompleteEvent;
import at.hannibal2.skyhanni.events.dungeon.DungeonEnterEvent;
import at.hannibal2.skyhanni.events.dungeon.DungeonStartEvent;
import at.hannibal2.skyhanni.features.dungeon.DungeonFloor;
import at.hannibal2.skyhanni.utils.BlockUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.PlayerUtils;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SkullTextureHolder;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import at.hannibal2.skyhanni.utils.compat.TextCompatKt;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0010!\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\b\u008a\u0001\u008b\u0001\u008c\u0001\u008d\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J!\u0010\n\u001a\u00020\u00042\u0012\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\"\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001aH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001eH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020!H\u0007\u00a2\u0006\u0004\b\"\u0010#J\u000f\u0010$\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b$\u0010\u0003J\u0017\u0010&\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020%H\u0007\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010)\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020(H\u0007\u00a2\u0006\u0004\b)\u0010*J?\u00101\u001a\u00020\r2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00160+2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020.0-2\u0006\u00100\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b1\u00102J7\u00103\u001a\u00020\r2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00160+2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020.0-H\u0002\u00a2\u0006\u0004\b3\u00104J\u0017\u00106\u001a\u00020\r2\u0006\u0010\u001b\u001a\u000205H\u0007\u00a2\u0006\u0004\b6\u00107J\u0017\u00109\u001a\u00020\r2\u0006\u0010\u001b\u001a\u000208H\u0007\u00a2\u0006\u0004\b9\u0010:J\u0015\u0010=\u001a\u00020<2\u0006\u0010;\u001a\u00020\b\u00a2\u0006\u0004\b=\u0010>J\u0017\u0010\"\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001eH\u0007\u00a2\u0006\u0004\b\"\u0010 R\u0014\u0010@\u001a\u00020?8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u0010AR\u0014\u0010C\u001a\u00020B8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bC\u0010DR\u0014\u0010E\u001a\u00020?8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bE\u0010AR\u0014\u0010F\u001a\u00020?8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010AR\u0014\u0010G\u001a\u00020?8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bG\u0010AR\u0014\u0010H\u001a\u00020?8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bH\u0010AR(\u0010J\u001a\u0004\u0018\u00010\b2\b\u0010I\u001a\u0004\u0018\u00010\b8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bJ\u0010K\u001a\u0004\bL\u0010MR$\u0010N\u001a\u00020\u00042\u0006\u0010I\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bN\u0010O\u001a\u0004\bP\u0010\u0006R$\u0010Q\u001a\u00020\u00042\u0006\u0010I\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bQ\u0010O\u001a\u0004\bR\u0010\u0006R$\u0010S\u001a\u00020\u00042\u0006\u0010I\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bS\u0010O\u001a\u0004\bT\u0010\u0006R(\u0010V\u001a\u0004\u0018\u00010U2\b\u0010I\u001a\u0004\u0018\u00010U8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bV\u0010W\u001a\u0004\bX\u0010YR$\u0010Z\u001a\u00020\u00162\u0006\u0010I\u001a\u00020\u00168\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\bZ\u0010[\u001a\u0004\b\\\u0010]R$\u0010^\u001a\u00020\u00042\u0006\u0010I\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b^\u0010O\u001a\u0004\b^\u0010\u0006R$\u0010_\u001a\u00020\b2\u0006\u0010I\u001a\u00020\b8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b_\u0010K\u001a\u0004\b`\u0010MR(\u0010a\u001a\u0004\u0018\u00010\b2\b\u0010I\u001a\u0004\u0018\u00010\b8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\ba\u0010K\u001a\u0004\bb\u0010MR\u0011\u0010d\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\bc\u0010\u0006R\u001f\u0010g\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0016\u0018\u00010+8F\u00a2\u0006\u0006\u001a\u0004\be\u0010fR\u0014\u0010i\u001a\u00020h8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bi\u0010jR\u001b\u0010n\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bk\u0010l\u001a\u0004\bm\u0010MR\u001b\u0010s\u001a\u00020?8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bo\u0010p\u001a\u0004\bq\u0010rR\u001b\u0010v\u001a\u00020?8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bt\u0010p\u001a\u0004\bu\u0010rR\u001b\u0010y\u001a\u00020?8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\bw\u0010p\u001a\u0004\bx\u0010rR\u001b\u0010|\u001a\u00020?8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bz\u0010p\u001a\u0004\b{\u0010rR\u001b\u0010\u007f\u001a\u00020?8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b}\u0010p\u001a\u0004\b~\u0010rR%\u0010\u0083\u0001\u001a\u00020?8FX\u0086\u0084\u0002\u00a2\u0006\u0015\n\u0005\b\u0080\u0001\u0010p\u0012\u0005\b\u0082\u0001\u0010\u0003\u001a\u0005\b\u0081\u0001\u0010rR\u0016\u0010\u0084\u0001\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0007\n\u0005\b\u0084\u0001\u0010KR\u0013\u0010\u0086\u0001\u001a\u00020\u00048F\u00a2\u0006\u0007\u001a\u0005\b\u0085\u0001\u0010\u0006R\u001e\u0010\u0088\u0001\u001a\t\u0012\u0004\u0012\u00020<0\u0087\u00018\u0002X\u0082\u0004\u00a2\u0006\b\n\u0006\b\u0088\u0001\u0010\u0089\u0001\u00a8\u0006\u008e\u0001"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonApi;", "", "<init>", "()V", "", "inDungeon", "()Z", "", "", "floors", "isOneOf", "([Ljava/lang/String;)Z", "rawMessage", "", "handleBossMessage", "(Ljava/lang/String;)V", "bossName", "checkBossName", "(Ljava/lang/String;)Z", "Lat/hannibal2/skyhanni/features/dungeon/DungeonFloor;", "getCurrentBoss", "()Lat/hannibal2/skyhanni/features/dungeon/DungeonFloor;", "", "level", "getColor", "(I)Ljava/lang/String;", "Lat/hannibal2/skyhanni/events/ScoreboardUpdateEvent;", "event", "onScoreboardUpdate", "(Lat/hannibal2/skyhanni/events/ScoreboardUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/TabListUpdateEvent;", "onTablistChange", "(Lat/hannibal2/skyhanni/events/TabListUpdateEvent;)V", "Lat/hannibal2/skyhanni/events/TablistFooterUpdateEvent;", "onTabUpdate", "(Lat/hannibal2/skyhanni/events/TablistFooterUpdateEvent;)V", "onWorldChange", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;", "onInventoryFullyOpened", "(Lat/hannibal2/skyhanni/events/InventoryFullyOpenedEvent;)V", "", "bossCollections", "", "Lnet/minecraft/class_1799;", "inventoryItems", "inventoryName", "readOneMaxCollection", "(Ljava/util/Map;Ljava/util/Map;Ljava/lang/String;)V", "readAllCollections", "(Ljava/util/Map;Ljava/util/Map;)V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebug", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "Lat/hannibal2/skyhanni/events/BlockClickEvent;", "onBlockClick", "(Lat/hannibal2/skyhanni/events/BlockClickEvent;)V", "username", "Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$TeamMember;", "getPlayerInfo", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$TeamMember;", "Ljava/util/regex/Pattern;", "floorPattern", "Ljava/util/regex/Pattern;", "Lkotlin/text/Regex;", "uniqueClassBonus", "Lkotlin/text/Regex;", "bossPattern", "levelPattern", "killPattern", "totalKillsPattern", "value", "dungeonFloor", "Ljava/lang/String;", "getDungeonFloor", "()Ljava/lang/String;", "started", "Z", "getStarted", "completed", "getCompleted", "inBossRoom", "getInBossRoom", "Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonClass;", "playerClass", "Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonClass;", "getPlayerClass", "()Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonClass;", "playerClassLevel", "I", "getPlayerClassLevel", "()I", "isUniqueClass", "time", "getTime", "roomId", "getRoomId", "getActive", "active", "getBossStorage", "()Ljava/util/Map;", "bossStorage", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "WITHER_ESSENCE_TEXTURE$delegate", "Lkotlin/Lazy;", "getWITHER_ESSENCE_TEXTURE", "WITHER_ESSENCE_TEXTURE", "timePattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getTimePattern", "()Ljava/util/regex/Pattern;", "timePattern", "dungeonComplete$delegate", "getDungeonComplete", "dungeonComplete", "dungeonRoomPattern$delegate", "getDungeonRoomPattern", "dungeonRoomPattern", "blessingPattern$delegate", "getBlessingPattern", "blessingPattern", "noBlessingPattern$delegate", "getNoBlessingPattern", "noBlessingPattern", "playerDungeonTeamPattern$delegate", "getPlayerDungeonTeamPattern", "getPlayerDungeonTeamPattern$annotations", "playerDungeonTeamPattern", "WATER_ROOM_ID", "getInWaterRoom", "inWaterRoom", "", "playerTeamClasses", "Ljava/util/List;", "DungeonBlessings", "DungeonClass", "DungeonChest", "TeamMember", "1.21.5"})
@SourceDebugExtension(value={"SMAP\nDungeonApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonApi.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonApi\n+ 2 RegexUtils.kt\nat/hannibal2/skyhanni/utils/RegexUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,481:1\n27#2:482\n14#2,2:483\n17#2:486\n27#2:487\n14#2,2:488\n17#2:491\n27#2:492\n14#2,2:493\n17#2:496\n8#2:498\n8#2:500\n8#2:503\n8#2:505\n8#2:507\n33#2,2:510\n36#2:514\n1#3:485\n1#3:490\n1#3:495\n1#3:497\n1#3:499\n1#3:501\n1#3:502\n1#3:504\n1#3:506\n1#3:508\n1#3:509\n1#3:512\n1#3:513\n1869#4,2:515\n*S KotlinDebug\n*F\n+ 1 DungeonApi.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonApi\n*L\n201#1:482\n201#1:483,2\n201#1:486\n209#1:487\n209#1:488,2\n209#1:491\n213#1:492\n213#1:493,2\n213#1:496\n281#1:498\n289#1:500\n321#1:503\n340#1:505\n345#1:507\n452#1:510,2\n452#1:514\n201#1:485\n209#1:490\n213#1:495\n281#1:499\n289#1:501\n321#1:504\n340#1:506\n345#1:508\n452#1:512\n378#1:515,2\n*E\n"})
public final class DungeonApi {
    @NotNull
    public static final DungeonApi INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final Pattern floorPattern;
    @NotNull
    private static final Regex uniqueClassBonus;
    @NotNull
    private static final Pattern bossPattern;
    @NotNull
    private static final Pattern levelPattern;
    @NotNull
    private static final Pattern killPattern;
    @NotNull
    private static final Pattern totalKillsPattern;
    @Nullable
    private static String dungeonFloor;
    private static boolean started;
    private static boolean completed;
    private static boolean inBossRoom;
    @Nullable
    private static DungeonClass playerClass;
    private static int playerClassLevel;
    private static boolean isUniqueClass;
    @NotNull
    private static String time;
    @Nullable
    private static String roomId;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final Lazy WITHER_ESSENCE_TEXTURE$delegate;
    @NotNull
    private static final RepoPattern timePattern$delegate;
    @NotNull
    private static final RepoPattern dungeonComplete$delegate;
    @NotNull
    private static final RepoPattern dungeonRoomPattern$delegate;
    @NotNull
    private static final RepoPattern blessingPattern$delegate;
    @NotNull
    private static final RepoPattern noBlessingPattern$delegate;
    @NotNull
    private static final RepoPattern playerDungeonTeamPattern$delegate;
    @NotNull
    private static final String WATER_ROOM_ID = "-60,-60";
    @NotNull
    private static final List<TeamMember> playerTeamClasses;

    private DungeonApi() {
    }

    @Nullable
    public final String getDungeonFloor() {
        return dungeonFloor;
    }

    public final boolean getStarted() {
        return started;
    }

    public final boolean getCompleted() {
        return completed;
    }

    public final boolean getInBossRoom() {
        return inBossRoom;
    }

    @Nullable
    public final DungeonClass getPlayerClass() {
        return playerClass;
    }

    public final int getPlayerClassLevel() {
        return playerClassLevel;
    }

    public final boolean isUniqueClass() {
        return isUniqueClass;
    }

    @NotNull
    public final String getTime() {
        return time;
    }

    @Nullable
    public final String getRoomId() {
        return roomId;
    }

    public final boolean getActive() {
        return started && !completed;
    }

    @Nullable
    public final Map<DungeonFloor, Integer> getBossStorage() {
        Object object = ProfileStorageData.INSTANCE.getProfileSpecific();
        return object != null && (object = ((ProfileSpecificStorage)object).getDungeons()) != null ? ((ProfileSpecificStorage.DungeonStorage)object).getBosses() : null;
    }

    private final String getWITHER_ESSENCE_TEXTURE() {
        Lazy lazy = WITHER_ESSENCE_TEXTURE$delegate;
        return (String)lazy.getValue();
    }

    private final Pattern getTimePattern() {
        return (Pattern)timePattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final Pattern getDungeonComplete() {
        return (Pattern)dungeonComplete$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @NotNull
    public final Pattern getDungeonRoomPattern() {
        return (Pattern)dungeonRoomPattern$delegate.getValue(this, $$delegatedProperties[2]);
    }

    private final Pattern getBlessingPattern() {
        return (Pattern)blessingPattern$delegate.getValue(this, $$delegatedProperties[3]);
    }

    private final Pattern getNoBlessingPattern() {
        return (Pattern)noBlessingPattern$delegate.getValue(this, $$delegatedProperties[4]);
    }

    @NotNull
    public final Pattern getPlayerDungeonTeamPattern() {
        return (Pattern)playerDungeonTeamPattern$delegate.getValue(this, $$delegatedProperties[5]);
    }

    public static /* synthetic */ void getPlayerDungeonTeamPattern$annotations() {
    }

    public final boolean inDungeon() {
        return IslandType.CATACOMBS.isCurrent();
    }

    public final boolean isOneOf(String ... floors) {
        Intrinsics.checkNotNullParameter((Object)floors, (String)"floors");
        String string = dungeonFloor;
        return string != null ? CollectionUtils.equalsOneOf(string, Arrays.copyOf(floors, floors.length)) : false;
    }

    public final void handleBossMessage(@NotNull String rawMessage) {
        Intrinsics.checkNotNullParameter((Object)rawMessage, (String)"rawMessage");
        if (!this.inDungeon()) {
            return;
        }
        String message = StringUtils.removeColor$default(StringUtils.INSTANCE, rawMessage, false, 1, null);
        String bossName = ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)message, (String)"[BOSS] ", null, (int)2, null), (String)":", null, (int)2, null))).toString();
        if (!Intrinsics.areEqual((Object)bossName, (Object)"The Watcher") && dungeonFloor != null && this.checkBossName(bossName) && !inBossRoom) {
            DungeonBossRoomEnterEvent.INSTANCE.post();
            inBossRoom = true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkBossName(String bossName) {
        String string;
        String string2 = dungeonFloor;
        if (string2 == null) return false;
        int n = -1;
        switch (string2.hashCode()) {
            case 2436: {
                if (string2.equals("M1")) {
                    n = 1;
                }
                break;
            }
            case 69: {
                if (string2.equals("E")) {
                    n = 2;
                }
                break;
            }
            case 2437: {
                if (string2.equals("M2")) {
                    n = 3;
                }
                break;
            }
            case 2438: {
                if (string2.equals("M3")) {
                    n = 4;
                }
                break;
            }
            case 2439: {
                if (string2.equals("M4")) {
                    n = 5;
                }
                break;
            }
            case 2440: {
                if (string2.equals("M5")) {
                    n = 6;
                }
                break;
            }
            case 2441: {
                if (string2.equals("M6")) {
                    n = 7;
                }
                break;
            }
            case 2442: {
                if (string2.equals("M7")) {
                    n = 8;
                }
                break;
            }
            case 2219: {
                if (string2.equals("F1")) {
                    n = 1;
                }
                break;
            }
            case 2220: {
                if (string2.equals("F2")) {
                    n = 3;
                }
                break;
            }
            case 2221: {
                if (string2.equals("F3")) {
                    n = 4;
                }
                break;
            }
            case 2222: {
                if (string2.equals("F4")) {
                    n = 5;
                }
                break;
            }
            case 2223: {
                if (string2.equals("F5")) {
                    n = 6;
                }
                break;
            }
            case 2224: {
                if (string2.equals("F6")) {
                    n = 7;
                }
                break;
            }
            case 2225: {
                if (string2.equals("F7")) {
                    n = 8;
                }
                break;
            }
        }
        switch (n) {
            case 2: {
                string = "The Watcher";
                break;
            }
            case 1: {
                string = "Bonzo";
                break;
            }
            case 3: {
                string = "Scarf";
                break;
            }
            case 4: {
                string = "The Professor";
                break;
            }
            case 5: {
                string = "Thorn";
                break;
            }
            case 6: {
                string = "Livid";
                break;
            }
            case 7: {
                string = "Sadan";
                break;
            }
            case 8: {
                string = "Maxor";
                break;
            }
            default: {
                return false;
            }
        }
        if (string == null) {
            return false;
        }
        String correctBoss = string;
        return StringsKt.endsWith$default((String)bossName, (String)correctBoss, (boolean)false, (int)2, null);
    }

    @Nullable
    public final DungeonFloor getCurrentBoss() {
        String string = dungeonFloor;
        if (string == null) {
            return null;
        }
        String floor = string;
        return DungeonFloor.valueOf(StringsKt.replace$default((String)floor, (String)"M", (String)"F", (boolean)false, (int)4, null));
    }

    public final boolean getInWaterRoom() {
        return Intrinsics.areEqual((Object)roomId, (Object)WATER_ROOM_ID);
    }

    @NotNull
    public final String getColor(int level) {
        return level >= 50 ? "\u00a7c\u00a7l" : (level >= 45 ? "\u00a7c" : (level >= 40 ? "\u00a76" : (level >= 35 ? "\u00a7d" : (level >= 30 ? "\u00a79" : (level >= 25 ? "\u00a7b" : (level >= 20 ? "\u00a72" : (level >= 15 ? "\u00a7a" : (level >= 10 ? "\u00a7e" : (level >= 5 ? "\u00a7f" : "\u00a77")))))))));
    }

    @HandleEvent
    public final void onScoreboardUpdate(@NotNull ScoreboardUpdateEvent event2) {
        boolean bl;
        Matcher it$iv$iv;
        Pattern $this$firstMatcher$iv$iv;
        Pattern $this$firstMatcher$iv;
        RegexUtils this_$iv;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = floorPattern;
        List<String> list$iv = event2.getAdded();
        boolean $i$f$firstMatcher = false;
        void var6_6 = this_$iv;
        void var7_7 = $this$firstMatcher$iv;
        Sequence sequence$iv$iv = CollectionsKt.asSequence((Iterable)list$iv);
        boolean $i$f$firstMatcher2 = false;
        for (String line$iv$iv : sequence$iv$iv) {
            it$iv$iv = $this$firstMatcher$iv$iv.matcher(line$iv$iv);
            bl = false;
            if (!it$iv$iv.matches()) continue;
            Intrinsics.checkNotNull((Object)it$iv$iv);
            Matcher $this$onScoreboardUpdate_u24lambda_u241 = it$iv$iv;
            boolean bl2 = false;
            String floor = $this$onScoreboardUpdate_u24lambda_u241.group("floor");
            if (Intrinsics.areEqual((Object)dungeonFloor, (Object)floor)) {
                return;
            }
            dungeonFloor = floor;
            Intrinsics.checkNotNull((Object)floor);
            new DungeonEnterEvent(floor).post();
            return;
        }
        if (!this.inDungeon()) {
            return;
        }
        this_$iv = RegexUtils.INSTANCE;
        $this$firstMatcher$iv = this.getDungeonRoomPattern();
        list$iv = event2.getAdded();
        $i$f$firstMatcher = false;
        RegexUtils this_$iv$iv = this_$iv;
        $this$firstMatcher$iv$iv = $this$firstMatcher$iv;
        sequence$iv$iv = CollectionsKt.asSequence((Iterable)list$iv);
        $i$f$firstMatcher2 = false;
        for (String line$iv$iv : sequence$iv$iv) {
            it$iv$iv = $this$firstMatcher$iv$iv.matcher(line$iv$iv);
            bl = false;
            if (!it$iv$iv.matches()) continue;
            Intrinsics.checkNotNull((Object)it$iv$iv);
            Matcher $this$onScoreboardUpdate_u24lambda_u242 = it$iv$iv;
            boolean bl3 = false;
            roomId = $this$onScoreboardUpdate_u24lambda_u242.group("roomId");
            return;
        }
        this_$iv = RegexUtils.INSTANCE;
        $this$firstMatcher$iv = this.getTimePattern();
        list$iv = event2.getAdded();
        $i$f$firstMatcher = false;
        this_$iv$iv = this_$iv;
        $this$firstMatcher$iv$iv = $this$firstMatcher$iv;
        sequence$iv$iv = CollectionsKt.asSequence((Iterable)list$iv);
        $i$f$firstMatcher2 = false;
        for (String line$iv$iv : sequence$iv$iv) {
            it$iv$iv = $this$firstMatcher$iv$iv.matcher(line$iv$iv);
            bl = false;
            if (!it$iv$iv.matches()) continue;
            Intrinsics.checkNotNull((Object)it$iv$iv);
            Matcher $this$onScoreboardUpdate_u24lambda_u243 = it$iv$iv;
            boolean bl4 = false;
            String string = RegexUtils.INSTANCE.groupOrNull($this$onScoreboardUpdate_u24lambda_u243, "minutes");
            if (string == null) {
                string = "00";
            }
            time = string + ":" + $this$onScoreboardUpdate_u24lambda_u243.group("seconds");
            return;
        }
    }

    @HandleEvent
    public final void onTablistChange(@NotNull TabListUpdateEvent event2) {
        String string;
        Object v0;
        block5: {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            if (!this.inDungeon()) {
                return;
            }
            if (dungeonFloor == null || playerClass != null) {
                return;
            }
            Iterable iterable = event2.getTabList();
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)PlayerUtils.INSTANCE.getName(), (boolean)false, (int)2, null)) continue;
                v0 = t;
                break block5;
            }
            v0 = null;
        }
        if ((string = (String)v0) == null || (string = StringUtils.removeColor$default(StringUtils.INSTANCE, string, false, 1, null)) == null) {
            return;
        }
        String playerTeam = string;
        for (DungeonClass dungeonClass : DungeonClass.getEntries()) {
            if (!StringsKt.contains$default((CharSequence)playerTeam, (CharSequence)("(" + dungeonClass.getScoreboardName() + " "), (boolean)false, (int)2, null)) continue;
            Object[] objectArray = new String[]{" "};
            String string2 = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)playerTeam, (String[])objectArray, (boolean)false, (int)0, (int)6, null));
            objectArray = new char[1];
            objectArray[0] = (String)41;
            int level = NumberUtil.INSTANCE.romanToDecimalIfNecessary(StringsKt.trimEnd((String)string2, (char[])objectArray));
            playerClass = dungeonClass;
            playerClassLevel = level;
            return;
        }
    }

    @HandleEvent
    public final void onTabUpdate(@NotNull TablistFooterUpdateEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.inDungeon()) {
            return;
        }
        String[] stringArray = new String[]{"\n"};
        for (String line : StringsKt.split$default((CharSequence)event2.getFooter(), (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
            String type2;
            if (RegexUtils.INSTANCE.matches(this.getNoBlessingPattern(), line)) {
                DungeonBlessings.Companion.reset();
                return;
            }
            Matcher matcher = this.getBlessingPattern().matcher(line);
            if (!matcher.find() || matcher.group("type") == null) continue;
            String string = matcher.group("amount");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            int amount = NumberUtil.INSTANCE.romanToDecimalIfNecessary(string);
            String string2 = type2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            if (DungeonBlessings.valueOf(string2).getPower() == amount) continue;
            String string3 = type2.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            DungeonBlessings.valueOf(string3).setPower(amount);
        }
    }

    @HandleEvent
    public final void onWorldChange() {
        dungeonFloor = null;
        started = false;
        inBossRoom = false;
        isUniqueClass = false;
        playerClass = null;
        playerClassLevel = -1;
        completed = false;
        playerTeamClasses.clear();
        time = "";
        roomId = null;
        DungeonBlessings.Companion.reset();
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onChat(@NotNull SkyHanniChatEvent event2) {
        Pattern $this$matchMatcher$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        String string = dungeonFloor;
        if (string == null) {
            return;
        }
        String floor = string;
        if (Intrinsics.areEqual((Object)event2.getMessage(), (Object)"\u00a7e[NPC] \u00a7bMort\u00a7f: \u00a7rHere, I found this map when I first entered the dungeon.")) {
            started = true;
            new DungeonStartEvent(floor).post();
        }
        if (uniqueClassBonus.matches((CharSequence)(object = (CharSequence)StringUtils.removeColor$default(StringUtils.INSTANCE, event2.getMessage(), false, 1, null)))) {
            isUniqueClass = true;
        }
        object = RegexUtils.INSTANCE;
        Pattern pattern = killPattern;
        String text$iv = StringUtils.removeColor$default(StringUtils.INSTANCE, event2.getMessage(), false, 1, null);
        boolean $i$f$matchMatcher = false;
        Matcher it$iv = $this$matchMatcher$iv.matcher(text$iv);
        boolean bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$onChat_u24lambda_u245 = it$iv;
            boolean bl2 = false;
            Map<DungeonFloor, Integer> map = INSTANCE.getBossStorage();
            if (map == null) {
                return;
            }
            Map<DungeonFloor, Integer> bossCollections = map;
            String string2 = $this$onChat_u24lambda_u245.group("boss");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            DungeonFloor boss = DungeonFloor.Companion.byBossName(string2);
            if ($this$onChat_u24lambda_u245.matches() && boss != null && !bossCollections.containsKey((Object)boss)) {
                CollectionUtils.INSTANCE.addOrPut(bossCollections, boss, 1);
            }
            return;
        }
        RegexUtils this_$iv = RegexUtils.INSTANCE;
        $this$matchMatcher$iv = this.getDungeonComplete();
        text$iv = event2.getMessage();
        $i$f$matchMatcher = false;
        it$iv = $this$matchMatcher$iv.matcher(text$iv);
        bl = false;
        if (it$iv.matches()) {
            Intrinsics.checkNotNull((Object)it$iv);
            Matcher $this$onChat_u24lambda_u246 = it$iv;
            boolean bl3 = false;
            completed = true;
            new DungeonCompleteEvent(floor).post();
            return;
        }
    }

    @HandleEvent
    public final void onInventoryFullyOpened(@NotNull InventoryFullyOpenedEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Map<DungeonFloor, Integer> map = this.getBossStorage();
        if (map == null) {
            return;
        }
        Map<DungeonFloor, Integer> bossCollections = map;
        if (Intrinsics.areEqual((Object)event2.getInventoryName(), (Object)"Boss Collections")) {
            this.readAllCollections(bossCollections, event2.getInventoryItems());
        } else if (StringsKt.endsWith$default((String)event2.getInventoryName(), (String)" Collection", (boolean)false, (int)2, null)) {
            this.readOneMaxCollection(bossCollections, event2.getInventoryItems(), event2.getInventoryName());
        }
    }

    private final void readOneMaxCollection(Map<DungeonFloor, Integer> bossCollections, Map<Integer, class_1799> inventoryItems, String inventoryName) {
        block11: {
            class_1799 class_17992 = inventoryItems.get(48);
            if (class_17992 == null) break block11;
            class_1799 item2 = class_17992;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)TextCompatKt.formattedTextCompatLeadingWhiteLessResets(item2.method_7964()), (Object)"\u00a7aGo Back")) {
                String string = (String)CollectionsKt.getOrNull(ItemUtils.INSTANCE.getLore(item2), (int)0);
                if (string != null) {
                    String firstLine = string;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)firstLine, (Object)"\u00a77To Boss Collections")) {
                        Integer n;
                        Object v4;
                        Object object;
                        DungeonFloor floor;
                        block10: {
                            String[] stringArray = new String[]{" "};
                            String name2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)inventoryName, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (int)1), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                            DungeonFloor dungeonFloor = DungeonFloor.Companion.byBossName(name2);
                            if (dungeonFloor == null) {
                                return;
                            }
                            floor = dungeonFloor;
                            Object object2 = inventoryItems.get(4);
                            if (object2 == null || (object2 = ItemUtils.INSTANCE.getLore((class_1799)object2)) == null) {
                                return;
                            }
                            Object lore = object2;
                            object = (Iterable)lore;
                            Iterator iterator2 = object.iterator();
                            while (iterator2.hasNext()) {
                                Object t = iterator2.next();
                                String it = (String)t;
                                boolean bl3 = false;
                                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"Total Kills:", (boolean)false, (int)2, null)) continue;
                                v4 = t;
                                break block10;
                            }
                            v4 = null;
                        }
                        String string2 = v4;
                        if (string2 == null) {
                            return;
                        }
                        String line = string2;
                        object = RegexUtils.INSTANCE;
                        Pattern $this$matchMatcher$iv = totalKillsPattern;
                        boolean $i$f$matchMatcher = false;
                        Matcher it$iv = $this$matchMatcher$iv.matcher(line);
                        boolean bl4 = false;
                        if (it$iv.matches()) {
                            Intrinsics.checkNotNull((Object)it$iv);
                            Matcher $this$readOneMaxCollection_u24lambda_u2410_u24lambda_u249_u24lambda_u248 = it$iv;
                            boolean bl5 = false;
                            String string3 = $this$readOneMaxCollection_u24lambda_u2410_u24lambda_u249_u24lambda_u248.group("kills");
                            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
                            n = NumberUtil.INSTANCE.formatInt(string3);
                        } else {
                            n = null;
                        }
                        if (n == null) {
                            return;
                        }
                        int kills = n;
                        object = kills;
                        bossCollections.put(floor, (Integer)object);
                    }
                }
            }
        }
    }

    private final void readAllCollections(Map<DungeonFloor, Integer> bossCollections, Map<Integer, class_1799> inventoryItems) {
        for (class_1799 stack : inventoryItems.values()) {
            DungeonFloor floor;
            String name2 = null;
            name2 = "";
            int kills = 0;
            for (String line : ItemUtils.INSTANCE.getLore(stack)) {
                String colorlessLine = StringUtils.removeColor$default(StringUtils.INSTANCE, line, false, 1, null);
                RegexUtils regexUtils = RegexUtils.INSTANCE;
                Pattern $this$matchMatcher$iv = bossPattern;
                boolean $i$f$matchMatcher = false;
                Matcher it$iv = $this$matchMatcher$iv.matcher(colorlessLine);
                boolean bl = false;
                if (it$iv.matches()) {
                    Intrinsics.checkNotNull((Object)it$iv);
                    Matcher $this$readAllCollections_u24lambda_u2411 = it$iv;
                    boolean bl2 = false;
                    if ($this$readAllCollections_u24lambda_u2411.matches()) {
                        name2 = $this$readAllCollections_u24lambda_u2411.group("name");
                    }
                }
                RegexUtils this_$iv = RegexUtils.INSTANCE;
                $this$matchMatcher$iv = levelPattern;
                $i$f$matchMatcher = false;
                it$iv = $this$matchMatcher$iv.matcher(colorlessLine);
                bl = false;
                if (!it$iv.matches()) continue;
                Intrinsics.checkNotNull((Object)it$iv);
                Matcher $this$readAllCollections_u24lambda_u2412 = it$iv;
                boolean bl3 = false;
                if (!$this$readAllCollections_u24lambda_u2412.matches()) continue;
                String string = $this$readAllCollections_u24lambda_u2412.group("kills");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                kills = Integer.parseInt(string);
                break;
            }
            if (DungeonFloor.Companion.byBossName(name2) == null) continue;
            bossCollections.put(floor, kills);
        }
    }

    @HandleEvent
    public final void onDebug(@NotNull DebugDataCollectEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        event2.title("Dungeon");
        if (!this.inDungeon()) {
            event2.addIrrelevant("not in dungeons");
            return;
        }
        event2.addData((Function1<? super List<String>, Unit>)((Function1)DungeonApi::onDebug$lambda$14));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @HandleEvent(onlyOnIsland=IslandType.CATACOMBS)
    public final void onBlockClick(@NotNull BlockClickEvent event2) {
        ClickedBlockType clickedBlockType;
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (event2.getClickType() != ClickType.RIGHT_CLICK) {
            return;
        }
        LorenzVec position = event2.getPosition();
        class_2248 class_22482 = BlockUtils.INSTANCE.getBlockAt(position);
        if (Intrinsics.areEqual((Object)class_22482, (Object)class_2246.field_10034)) {
            clickedBlockType = ClickedBlockType.CHEST;
        } else if (Intrinsics.areEqual((Object)class_22482, (Object)class_2246.field_10380)) {
            clickedBlockType = ClickedBlockType.TRAPPED_CHEST;
        } else if (Intrinsics.areEqual((Object)class_22482, (Object)class_2246.field_10363)) {
            clickedBlockType = ClickedBlockType.LEVER;
        } else {
            if (!Intrinsics.areEqual((Object)class_22482, (Object)class_2246.field_10432)) return;
            String blockTexture = BlockUtils.INSTANCE.getTextureFromSkull(position);
            if (!Intrinsics.areEqual((Object)blockTexture, (Object)this.getWITHER_ESSENCE_TEXTURE())) return;
            clickedBlockType = ClickedBlockType.WITHER_ESSENCE;
        }
        ClickedBlockType blockType = clickedBlockType;
        new DungeonBlockClickEvent(position, blockType).post();
    }

    @NotNull
    public final TeamMember getPlayerInfo(@NotNull String username) {
        TeamMember teamMember;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Iterable iterable = playerTeamClasses;
            for (Object t : iterable) {
                TeamMember it = (TeamMember)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUsername(), (Object)StringUtils.removeColor$default(StringUtils.INSTANCE, username, false, 1, null))) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((teamMember = (TeamMember)v0) == null) {
            teamMember = new TeamMember(username, null, 0, false, 14, null);
        }
        return teamMember;
    }

    /*
     * WARNING - void declaration
     */
    @HandleEvent
    public final void onTabUpdate(@NotNull TabListUpdateEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.inDungeon() || !started || completed) {
            return;
        }
        RegexUtils regexUtils = RegexUtils.INSTANCE;
        Pattern pattern = this.getPlayerDungeonTeamPattern();
        List<String> list$iv = event2.getTabList();
        boolean $i$f$matchAll = false;
        for (String line$iv : list$iv) {
            Object v1;
            String dungeonClassLevel;
            String dungeonClassName;
            boolean playerDead;
            String username;
            Matcher $this$onTabUpdate_u24lambda_u2419;
            block4: {
                void $this$matchAll$iv;
                Matcher it$iv = $this$matchAll$iv.matcher(line$iv);
                boolean bl = false;
                if (!it$iv.find()) continue;
                Intrinsics.checkNotNull((Object)it$iv);
                $this$onTabUpdate_u24lambda_u2419 = it$iv;
                boolean bl2 = false;
                String string = $this$onTabUpdate_u24lambda_u2419.group("playerName");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                username = StringUtils.removeColor$default(StringUtils.INSTANCE, string, false, 1, null);
                playerDead = Intrinsics.areEqual((Object)$this$onTabUpdate_u24lambda_u2419.group("playerDead"), (Object)"DEAD");
                dungeonClassName = $this$onTabUpdate_u24lambda_u2419.group("className");
                dungeonClassLevel = $this$onTabUpdate_u24lambda_u2419.group("classLevel");
                Iterable iterable = playerTeamClasses;
                for (Object t : iterable) {
                    TeamMember it = (TeamMember)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getUsername(), (Object)username)) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            if ((TeamMember)v1 != null) {
                TeamMember player;
                boolean bl = false;
                player.setPlayerDead(playerDead);
                if (player.getDungeonClass() != null || playerDead) continue;
                Intrinsics.checkNotNull((Object)dungeonClassName);
                player.setDungeonClass(DungeonClass.Companion.getByClassName(dungeonClassName));
                Intrinsics.checkNotNull((Object)dungeonClassLevel);
                player.setClassLevel(NumberUtil.INSTANCE.romanToDecimalIfNecessary(dungeonClassLevel));
                continue;
            }
            Matcher $this$onTabUpdate_u24lambda_u2419_u24lambda_u2418 = $this$onTabUpdate_u24lambda_u2419;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)dungeonClassName);
            DungeonClass dungeonClass = DungeonClass.Companion.getByClassName(dungeonClassName);
            Intrinsics.checkNotNull((Object)dungeonClassLevel);
            int classLevel = NumberUtil.INSTANCE.romanToDecimalIfNecessary(dungeonClassLevel);
            playerTeamClasses.add(new TeamMember(username, dungeonClass, classLevel, playerDead));
        }
    }

    private static final String WITHER_ESSENCE_TEXTURE_delegate$lambda$0() {
        return SkullTextureHolder.INSTANCE.getTexture("WITHER_ESSENCE");
    }

    private static final Unit onDebug$lambda$14(List $this$addData) {
        Intrinsics.checkNotNullParameter((Object)$this$addData, (String)"$this$addData");
        $this$addData.add("dungeonFloor: " + dungeonFloor);
        $this$addData.add("started: " + started);
        $this$addData.add("getRoomID: " + roomId);
        $this$addData.add("time: " + time);
        $this$addData.add("inBossRoom: " + inBossRoom);
        $this$addData.add("");
        $this$addData.add("playerClass: " + playerClass);
        $this$addData.add("isUniqueClass: " + isUniqueClass);
        $this$addData.add("playerClassLevel: " + playerClassLevel);
        $this$addData.add("");
        $this$addData.add("Blessings: ");
        Iterable $this$forEach$iv = (Iterable)DungeonBlessings.getEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DungeonBlessings it = (DungeonBlessings)((Object)element$iv);
            boolean bl = false;
            $this$addData.add("  " + it.getDisplayName() + " " + it.getPower());
        }
        return Unit.INSTANCE;
    }

    static {
        Object object = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DungeonApi.class, "timePattern", "getTimePattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DungeonApi.class, "dungeonComplete", "getDungeonComplete()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DungeonApi.class, "dungeonRoomPattern", "getDungeonRoomPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DungeonApi.class, "blessingPattern", "getBlessingPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DungeonApi.class, "noBlessingPattern", "getNoBlessingPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(DungeonApi.class, "playerDungeonTeamPattern", "getPlayerDungeonTeamPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = object;
        INSTANCE = new DungeonApi();
        object = " \u00a77\u23e3 \u00a7cThe Catacombs \u00a77\\((?<floor>.*)\\)";
        int n = 0;
        Pattern pattern = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        floorPattern = pattern;
        uniqueClassBonus = new Regex("^Your ([A-Za-z]+) stats are doubled because you are the only player using this class!$");
        object = "View all your (?<name>\\w+) Collection";
        n = 0;
        Pattern pattern2 = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        bossPattern = pattern2;
        object = " +(?<kills>\\d+).*";
        n = 0;
        Pattern pattern3 = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(...)");
        levelPattern = pattern3;
        object = " +\u2620 Defeated (?<boss>\\w+).*";
        n = 0;
        Pattern pattern4 = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern4, (String)"compile(...)");
        killPattern = pattern4;
        object = "\u00a77Total Kills: \u00a7e(?<kills>.*)";
        n = 0;
        Pattern pattern5 = Pattern.compile((String)object, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern5, (String)"compile(...)");
        totalKillsPattern = pattern5;
        playerClassLevel = -1;
        time = "";
        patternGroup = RepoPattern.Companion.group("dungeon");
        WITHER_ESSENCE_TEXTURE$delegate = LazyKt.lazy(DungeonApi::WITHER_ESSENCE_TEXTURE_delegate$lambda$0);
        timePattern$delegate = patternGroup.pattern("time", "Time Elapsed: \u00a7.(?:(?<minutes>\\d+)m )?(?<seconds>\\d+)s");
        dungeonComplete$delegate = patternGroup.pattern("complete", "\u00a7.\\s+\u00a7.\u00a7.(?:Master Mode )?The Catacombs \u00a7.\u00a7.- \u00a7.\u00a7.(?:Floor )?(?<floor>M?[IV]{1,3}|Entrance)");
        dungeonRoomPattern$delegate = patternGroup.pattern("room", "\u00a77\\d+/\\d+/\\d+ \u00a7\\w+ (?<roomId>[\\w,-]+)");
        blessingPattern$delegate = patternGroup.pattern("blessings", "\u00a7r\u00a7r\u00a7fBlessing of (?<type>\\w+) (?<amount>\\w+)\u00a7r");
        noBlessingPattern$delegate = patternGroup.pattern("noblessings", "\u00a7r\u00a7r\u00a77No Buffs active\\. Find them by exploring the Dungeon!\u00a7r");
        playerDungeonTeamPattern$delegate = patternGroup.pattern("tablist.playerteam", "^(?:\u00a7.)*(?<sbLevel>\\[(?:\u00a7.)*\\d+(?:\u00a7.)*]) (?<rank>(?:\u00a7.)*\\[(?:\u00a7.)*[^]]+(?:\u00a7.)*])? ?(?<playerName>\\S+)\\s?(?<symbols>[^(]*) \u00a7r\u00a7f\\((?:\u00a7.)*(?:(?<className>\\S+) (?<classLevel>[CLXVI0]+)|(?<playerDead>DEAD))(?:\u00a7.)*\\)(?:\u00a7.)*$");
        playerTeamClasses = new ArrayList();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fj\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u0016"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonBlessings;", "", "", "power", "<init>", "(Ljava/lang/String;II)V", "I", "getPower", "()I", "setPower", "(I)V", "", "displayName", "Ljava/lang/String;", "getDisplayName", "()Ljava/lang/String;", "Companion", "LIFE", "POWER", "STONE", "WISDOM", "TIME", "1.21.5"})
    public static final class DungeonBlessings
    extends Enum<DungeonBlessings> {
        @NotNull
        public static final Companion Companion;
        private int power;
        @NotNull
        private final String displayName;
        public static final /* enum */ DungeonBlessings LIFE;
        public static final /* enum */ DungeonBlessings POWER;
        public static final /* enum */ DungeonBlessings STONE;
        public static final /* enum */ DungeonBlessings WISDOM;
        public static final /* enum */ DungeonBlessings TIME;
        private static final /* synthetic */ DungeonBlessings[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DungeonBlessings(int power) {
            this.power = power;
            this.displayName = StringUtils.INSTANCE.firstLetterUppercase(this.name());
        }

        public final int getPower() {
            return this.power;
        }

        public final void setPower(int n) {
            this.power = n;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static DungeonBlessings[] values() {
            return (DungeonBlessings[])$VALUES.clone();
        }

        public static DungeonBlessings valueOf(String value) {
            return Enum.valueOf(DungeonBlessings.class, value);
        }

        @NotNull
        public static EnumEntries<DungeonBlessings> getEntries() {
            return $ENTRIES;
        }

        static {
            LIFE = new DungeonBlessings(0);
            POWER = new DungeonBlessings(0);
            STONE = new DungeonBlessings(0);
            WISDOM = new DungeonBlessings(0);
            TIME = new DungeonBlessings(0);
            $VALUES = dungeonBlessingsArray = new DungeonBlessings[]{DungeonBlessings.LIFE, DungeonBlessings.POWER, DungeonBlessings.STONE, DungeonBlessings.WISDOM, DungeonBlessings.TIME};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonBlessings$Companion;", "", "<init>", "()V", "", "reset", "1.21.5"})
        @SourceDebugExtension(value={"SMAP\nDungeonApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonApi.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonBlessings$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,481:1\n1869#2,2:482\n*S KotlinDebug\n*F\n+ 1 DungeonApi.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonBlessings$Companion\n*L\n140#1:482,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            public final void reset() {
                Iterable $this$forEach$iv = (Iterable)DungeonBlessings.getEntries();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    DungeonBlessings it = (DungeonBlessings)((Object)element$iv);
                    boolean bl = false;
                    it.setPower(0);
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0086\u0081\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonChest;", "", "", "inventory", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "Ljava/lang/String;", "getInventory", "()Ljava/lang/String;", "Companion", "WOOD", "GOLD", "DIAMOND", "EMERALD", "OBSIDIAN", "BEDROCK", "1.21.5"})
    public static final class DungeonChest
    extends Enum<DungeonChest> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String inventory;
        public static final /* enum */ DungeonChest WOOD;
        public static final /* enum */ DungeonChest GOLD;
        public static final /* enum */ DungeonChest DIAMOND;
        public static final /* enum */ DungeonChest EMERALD;
        public static final /* enum */ DungeonChest OBSIDIAN;
        public static final /* enum */ DungeonChest BEDROCK;
        private static final /* synthetic */ DungeonChest[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DungeonChest(String inventory) {
            this.inventory = inventory;
        }

        @NotNull
        public final String getInventory() {
            return this.inventory;
        }

        public static DungeonChest[] values() {
            return (DungeonChest[])$VALUES.clone();
        }

        public static DungeonChest valueOf(String value) {
            return Enum.valueOf(DungeonChest.class, value);
        }

        @NotNull
        public static EnumEntries<DungeonChest> getEntries() {
            return $ENTRIES;
        }

        static {
            WOOD = new DungeonChest("Wood Chest");
            GOLD = new DungeonChest("Gold Chest");
            DIAMOND = new DungeonChest("Diamond Chest");
            EMERALD = new DungeonChest("Emerald Chest");
            OBSIDIAN = new DungeonChest("Obsidian Chest");
            BEDROCK = new DungeonChest("Bedrock Chest");
            $VALUES = dungeonChestArray = new DungeonChest[]{DungeonChest.WOOD, DungeonChest.GOLD, DungeonChest.DIAMOND, DungeonChest.EMERALD, DungeonChest.OBSIDIAN, DungeonChest.BEDROCK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonChest$Companion;", "", "<init>", "()V", "", "inventory", "Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonChest;", "getByInventoryName", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonChest;", "1.21.5"})
        @SourceDebugExtension(value={"SMAP\nDungeonApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonApi.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonChest$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,481:1\n295#2,2:482\n*S KotlinDebug\n*F\n+ 1 DungeonApi.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonChest$Companion\n*L\n409#1:482,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final DungeonChest getByInventoryName(@NotNull String inventory) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
                    Iterable $this$firstOrNull$iv = (Iterable)DungeonChest.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        DungeonChest it = (DungeonChest)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getInventory(), (Object)inventory)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonClass;", "", "", "scoreboardName", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "Ljava/lang/String;", "getScoreboardName", "()Ljava/lang/String;", "Companion", "ARCHER", "BERSERK", "HEALER", "MAGE", "TANK", "1.21.5"})
    public static final class DungeonClass
    extends Enum<DungeonClass> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String scoreboardName;
        public static final /* enum */ DungeonClass ARCHER;
        public static final /* enum */ DungeonClass BERSERK;
        public static final /* enum */ DungeonClass HEALER;
        public static final /* enum */ DungeonClass MAGE;
        public static final /* enum */ DungeonClass TANK;
        private static final /* synthetic */ DungeonClass[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DungeonClass(String scoreboardName) {
            this.scoreboardName = scoreboardName;
        }

        @NotNull
        public final String getScoreboardName() {
            return this.scoreboardName;
        }

        public static DungeonClass[] values() {
            return (DungeonClass[])$VALUES.clone();
        }

        public static DungeonClass valueOf(String value) {
            return Enum.valueOf(DungeonClass.class, value);
        }

        @NotNull
        public static EnumEntries<DungeonClass> getEntries() {
            return $ENTRIES;
        }

        static {
            ARCHER = new DungeonClass("Archer");
            BERSERK = new DungeonClass("Berserk");
            HEALER = new DungeonClass("Healer");
            MAGE = new DungeonClass("Mage");
            TANK = new DungeonClass("Tank");
            $VALUES = dungeonClassArray = new DungeonClass[]{DungeonClass.ARCHER, DungeonClass.BERSERK, DungeonClass.HEALER, DungeonClass.MAGE, DungeonClass.TANK};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonClass$Companion;", "", "<init>", "()V", "", "className", "Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonClass;", "getByClassName", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonClass;", "1.21.5"})
        @SourceDebugExtension(value={"SMAP\nDungeonApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DungeonApi.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonClass$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,481:1\n295#2,2:482\n*S KotlinDebug\n*F\n+ 1 DungeonApi.kt\nat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonClass$Companion\n*L\n394#1:482,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final DungeonClass getByClassName(@NotNull String className) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)className, (String)"className");
                    Iterable $this$firstOrNull$iv = (Iterable)DungeonClass.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        DungeonClass it = (DungeonClass)((Object)element$iv);
                        boolean bl = false;
                        if (!StringsKt.equals((String)it.getScoreboardName(), (String)className, (boolean)true)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b!\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J:\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0017\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u0011J\u0010\u0010\u001a\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\rR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\rR$\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\u000f\"\u0004\b\u001f\u0010 R\"\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0007\u0010!\u001a\u0004\b\"\u0010\u0011\"\u0004\b#\u0010$R\"\u0010\t\u001a\u00020\b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\t\u0010%\u001a\u0004\b&\u0010\u0013\"\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$TeamMember;", "", "", "username", "Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonClass;", "dungeonClass", "", "classLevel", "", "playerDead", "<init>", "(Ljava/lang/String;Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonClass;IZ)V", "component1", "()Ljava/lang/String;", "component2", "()Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonClass;", "component3", "()I", "component4", "()Z", "copy", "(Ljava/lang/String;Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonClass;IZ)Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$TeamMember;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "toString", "Ljava/lang/String;", "getUsername", "Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonClass;", "getDungeonClass", "setDungeonClass", "(Lat/hannibal2/skyhanni/features/dungeon/DungeonApi$DungeonClass;)V", "I", "getClassLevel", "setClassLevel", "(I)V", "Z", "getPlayerDead", "setPlayerDead", "(Z)V", "1.21.5"})
    public static final class TeamMember {
        @NotNull
        private final String username;
        @Nullable
        private DungeonClass dungeonClass;
        private int classLevel;
        private boolean playerDead;

        public TeamMember(@NotNull String username, @Nullable DungeonClass dungeonClass, int classLevel, boolean playerDead) {
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            this.username = username;
            this.dungeonClass = dungeonClass;
            this.classLevel = classLevel;
            this.playerDead = playerDead;
        }

        public /* synthetic */ TeamMember(String string, DungeonClass dungeonClass, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                dungeonClass = null;
            }
            if ((n2 & 4) != 0) {
                n = 0;
            }
            if ((n2 & 8) != 0) {
                bl = false;
            }
            this(string, dungeonClass, n, bl);
        }

        @NotNull
        public final String getUsername() {
            return this.username;
        }

        @Nullable
        public final DungeonClass getDungeonClass() {
            return this.dungeonClass;
        }

        public final void setDungeonClass(@Nullable DungeonClass dungeonClass) {
            this.dungeonClass = dungeonClass;
        }

        public final int getClassLevel() {
            return this.classLevel;
        }

        public final void setClassLevel(int n) {
            this.classLevel = n;
        }

        public final boolean getPlayerDead() {
            return this.playerDead;
        }

        public final void setPlayerDead(boolean bl) {
            this.playerDead = bl;
        }

        @NotNull
        public final String component1() {
            return this.username;
        }

        @Nullable
        public final DungeonClass component2() {
            return this.dungeonClass;
        }

        public final int component3() {
            return this.classLevel;
        }

        public final boolean component4() {
            return this.playerDead;
        }

        @NotNull
        public final TeamMember copy(@NotNull String username, @Nullable DungeonClass dungeonClass, int classLevel, boolean playerDead) {
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            return new TeamMember(username, dungeonClass, classLevel, playerDead);
        }

        public static /* synthetic */ TeamMember copy$default(TeamMember teamMember, String string, DungeonClass dungeonClass, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = teamMember.username;
            }
            if ((n2 & 2) != 0) {
                dungeonClass = teamMember.dungeonClass;
            }
            if ((n2 & 4) != 0) {
                n = teamMember.classLevel;
            }
            if ((n2 & 8) != 0) {
                bl = teamMember.playerDead;
            }
            return teamMember.copy(string, dungeonClass, n, bl);
        }

        @NotNull
        public String toString() {
            return "TeamMember(username=" + this.username + ", dungeonClass=" + this.dungeonClass + ", classLevel=" + this.classLevel + ", playerDead=" + this.playerDead + ")";
        }

        public int hashCode() {
            int result2 = this.username.hashCode();
            result2 = result2 * 31 + (this.dungeonClass == null ? 0 : this.dungeonClass.hashCode());
            result2 = result2 * 31 + Integer.hashCode(this.classLevel);
            result2 = result2 * 31 + Boolean.hashCode(this.playerDead);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TeamMember)) {
                return false;
            }
            TeamMember teamMember = (TeamMember)other;
            if (!Intrinsics.areEqual((Object)this.username, (Object)teamMember.username)) {
                return false;
            }
            if (this.dungeonClass != teamMember.dungeonClass) {
                return false;
            }
            if (this.classLevel != teamMember.classLevel) {
                return false;
            }
            return this.playerDead == teamMember.playerDead;
        }
    }
}

