/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.event.carnival;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.event.carnival.CarnivalConfig;
import at.hannibal2.skyhanni.config.storage.ProfileSpecificStorage;
import at.hannibal2.skyhanni.data.EntityMovementData;
import at.hannibal2.skyhanni.data.IslandGraphs;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.Perk;
import at.hannibal2.skyhanni.data.ProfileStorageData;
import at.hannibal2.skyhanni.events.ProfileJoinEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.features.fame.ReminderUtils;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty0;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0003J\r\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0003J\r\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001d\u001a\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R(\u0010'\u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010!8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0014\u0010)\u001a\u00020(8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u001b\u00100\u001a\u00020+8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R!\u00104\u001a\u00020+8BX\u0082\u0084\u0002\u00a2\u0006\u0012\n\u0004\b1\u0010-\u0012\u0004\b3\u0010\u0003\u001a\u0004\b2\u0010/\u00a8\u00065"}, d2={"Lat/hannibal2/skyhanni/features/event/carnival/CarnivalReminder;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "event", "", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "Lat/hannibal2/skyhanni/events/ProfileJoinEvent;", "onProfileJoin", "(Lat/hannibal2/skyhanni/events/ProfileJoinEvent;)V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "checkDate", "check", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/event/carnival/CarnivalConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/event/carnival/CarnivalConfig;", "config", "Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CarnivalStorage;", "getStorage", "()Lat/hannibal2/skyhanni/config/storage/ProfileSpecificStorage$CarnivalStorage;", "storage", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "nextCheckTime", "J", "claimedToday", "Z", "Ljava/time/LocalDate;", "value", "getLastClaimedDay", "()Ljava/time/LocalDate;", "setLastClaimedDay", "(Ljava/time/LocalDate;)V", "lastClaimedDay", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "ticketClaimedPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getTicketClaimedPattern", "()Ljava/util/regex/Pattern;", "ticketClaimedPattern", "alreadyClaimedPattern$delegate", "getAlreadyClaimedPattern", "getAlreadyClaimedPattern$annotations", "alreadyClaimedPattern", "1.21.5"})
public final class CarnivalReminder {
    @NotNull
    public static final CarnivalReminder INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    private static long nextCheckTime;
    private static boolean claimedToday;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern ticketClaimedPattern$delegate;
    @NotNull
    private static final RepoPattern alreadyClaimedPattern$delegate;

    private CarnivalReminder() {
    }

    private final CarnivalConfig getConfig() {
        return SkyHanniMod.feature.getEvent().getCarnival();
    }

    private final ProfileSpecificStorage.CarnivalStorage getStorage() {
        ProfileSpecificStorage profileSpecificStorage = ProfileStorageData.INSTANCE.getProfileSpecific();
        return profileSpecificStorage != null ? profileSpecificStorage.getCarnival() : null;
    }

    private final LocalDate getLastClaimedDay() {
        ProfileSpecificStorage.CarnivalStorage carnivalStorage = this.getStorage();
        return carnivalStorage != null ? carnivalStorage.getLastClaimedDay() : null;
    }

    private final void setLastClaimedDay(LocalDate value) {
        block0: {
            ProfileSpecificStorage.CarnivalStorage carnivalStorage = this.getStorage();
            if (carnivalStorage == null) break block0;
            carnivalStorage.setLastClaimedDay(value);
        }
    }

    private final Pattern getTicketClaimedPattern() {
        return (Pattern)ticketClaimedPattern$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final Pattern getAlreadyClaimedPattern() {
        return (Pattern)alreadyClaimedPattern$delegate.getValue(this, $$delegatedProperties[1]);
    }

    private static /* synthetic */ void getAlreadyClaimedPattern$annotations() {
    }

    @HandleEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled() || SimpleTimeMark.isInFuture-impl(nextCheckTime)) {
            return;
        }
        this.check();
    }

    @HandleEvent
    public final void onProfileJoin(@NotNull ProfileJoinEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        claimedToday = false;
        if (!this.isEnabled()) {
            return;
        }
        nextCheckTime = SimpleTimeMark.Companion.fromNow-qeHQSLg(DurationKt.toDuration((double)30.0, (DurationUnit)DurationUnit.SECONDS));
        this.checkDate();
        this.check();
    }

    @HandleEvent
    public final void onChat(@NotNull SkyHanniChatEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled() && !claimedToday) {
            return;
        }
        if (!RegexUtils.INSTANCE.matches(this.getTicketClaimedPattern(), event2.getMessage()) && !RegexUtils.INSTANCE.matches(this.getAlreadyClaimedPattern(), event2.getMessage())) {
            return;
        }
        claimedToday = true;
        this.setLastClaimedDay(ZonedDateTime.now(ZoneOffset.UTC).toLocalDate());
    }

    private final void checkDate() {
        LocalDate currentDay = ZonedDateTime.now(ZoneOffset.UTC).toLocalDate();
        LocalDate lastClaimedDay = this.getLastClaimedDay();
        claimedToday = lastClaimedDay != null && !currentDay.isAfter(lastClaimedDay);
    }

    public final void check() {
        if (claimedToday) {
            this.checkDate();
            return;
        }
        if (ReminderUtils.isBusy$default(ReminderUtils.INSTANCE, false, 1, null)) {
            return;
        }
        ChatUtils.clickToActionOrDisable$default(ChatUtils.INSTANCE, "Carnival Tickets are ready to be claimed!", (KProperty0)new MutablePropertyReference0Impl(this.getConfig()){

            public Object get() {
                return ((CarnivalConfig)this.receiver).getReminderDailyTickets();
            }

            public void set(Object value) {
                ((CarnivalConfig)this.receiver).setReminderDailyTickets((Boolean)value);
            }
        }, "warp to The Carnival", CarnivalReminder::check$lambda$2, false, 16, null);
        nextCheckTime = SimpleTimeMark.Companion.fromNow-qeHQSLg(DurationKt.toDuration((double)5.0, (DurationUnit)DurationUnit.MINUTES));
    }

    public final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && this.getConfig().getReminderDailyTickets() && Perk.CHIVALROUS_CARNIVAL.isActive();
    }

    private static final boolean check$lambda$2$lambda$1$lambda$0() {
        return INSTANCE.getConfig().getReminderDailyTickets();
    }

    private static final Unit check$lambda$2$lambda$1() {
        IslandGraphs.pathFind$default(IslandGraphs.INSTANCE, new LorenzVec(-89.5, 71.0, -18.7), "\u00a7aCarnival Tickets", null, null, null, CarnivalReminder::check$lambda$2$lambda$1$lambda$0, 28, null);
        return Unit.INSTANCE;
    }

    private static final Unit check$lambda$2() {
        HypixelCommands.INSTANCE.warp("carnival");
        EntityMovementData.INSTANCE.onNextTeleport(IslandType.HUB, (Function0<Unit>)((Function0)CarnivalReminder::check$lambda$2$lambda$1));
        return Unit.INSTANCE;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CarnivalReminder.class, "ticketClaimedPattern", "getTicketClaimedPattern()Ljava/util/regex/Pattern;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(CarnivalReminder.class, "alreadyClaimedPattern", "getAlreadyClaimedPattern()Ljava/util/regex/Pattern;", 0)))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new CarnivalReminder();
        nextCheckTime = SimpleTimeMark.Companion.farFuture-uFjCsEo();
        patternGroup = RepoPattern.Companion.group("carnival.tickets");
        ticketClaimedPattern$delegate = patternGroup.pattern("claimed", "\u00a7aYou claimed \u00a7r\u00a7aCarnival Ticket \u00a7r\u00a78x25\u00a7r\u00a7a!");
        alreadyClaimedPattern$delegate = patternGroup.pattern("already", "\u00a7e\\[NPC\\] \u00a7aCarnival Leader\u00a7f: \u00a7rYou've already claimed your \u00a7aCarnival Tickets \u00a7ffor \u00a7btoday\u00a7f, but I'm happy to answer any questions you might have.");
    }
}

