/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.pests;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.config.features.garden.pests.PestFinderConfig;
import at.hannibal2.skyhanni.data.IslandType;
import at.hannibal2.skyhanni.data.model.TabWidget;
import at.hannibal2.skyhanni.data.title.TitleManager;
import at.hannibal2.skyhanni.events.IslandChangeEvent;
import at.hannibal2.skyhanni.events.PlaySoundEvent;
import at.hannibal2.skyhanni.events.chat.SkyHanniChatEvent;
import at.hannibal2.skyhanni.events.garden.pests.PestUpdateEvent;
import at.hannibal2.skyhanni.events.minecraft.KeyPressEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.features.garden.GardenPlotApi;
import at.hannibal2.skyhanni.features.garden.pests.PestApi;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ConfigUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.LorenzVec;
import at.hannibal2.skyhanni.utils.NeuItems;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderDisplayHelper;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.StringUtils;
import at.hannibal2.skyhanni.utils.collection.RenderableCollectionUtils;
import at.hannibal2.skyhanni.utils.render.WorldRenderUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import com.google.gson.JsonElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u0015\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0014J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J'\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020 H\u0007\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020#H\u0007\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010'\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020&H\u0007\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010)\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b)\u0010\u0003J\u0017\u0010+\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020*H\u0007\u00a2\u0006\u0004\b+\u0010,J\r\u0010-\u001a\u00020\u0012\u00a2\u0006\u0004\b-\u0010\u0014J\u0017\u0010/\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020.H\u0007\u00a2\u0006\u0004\b/\u00100R\u0014\u00104\u001a\u0002018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u001c\u00105\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0016\u00108\u001a\u0002078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b8\u00109\u00a8\u0006:"}, d2={"Lat/hannibal2/skyhanni/features/garden/pests/PestFinder;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/garden/pests/PestUpdateEvent;", "event", "", "onPestUpdate", "(Lat/hannibal2/skyhanni/events/garden/pests/PestUpdateEvent;)V", "update", "", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "drawDisplay", "()Ljava/util/List;", "remindInChat", "Lat/hannibal2/skyhanni/events/IslandChangeEvent;", "onIslandChange", "(Lat/hannibal2/skyhanni/events/IslandChangeEvent;)V", "", "shouldShowDisplay", "()Z", "shouldShowBasedOnHeldItem", "timePassedDisabled", "Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;", "onRenderWorld", "(Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/features/garden/GardenPlotApi$Plot;", "plot", "Lat/hannibal2/skyhanni/utils/LorenzVec;", "playerLocation", "drawName", "(Lat/hannibal2/skyhanni/features/garden/GardenPlotApi$Plot;Lat/hannibal2/skyhanni/utils/LorenzVec;Lat/hannibal2/skyhanni/events/minecraft/SkyHanniRenderWorldEvent;)V", "Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;", "onChat", "(Lat/hannibal2/skyhanni/events/chat/SkyHanniChatEvent;)V", "Lat/hannibal2/skyhanni/events/minecraft/KeyPressEvent;", "onKeyPress", "(Lat/hannibal2/skyhanni/events/minecraft/KeyPressEvent;)V", "Lat/hannibal2/skyhanni/events/PlaySoundEvent;", "onPlaySound", "(Lat/hannibal2/skyhanni/events/PlaySoundEvent;)V", "teleportNearestInfestedPlot", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "isEnabled", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/garden/pests/PestFinderConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/pests/PestFinderConfig;", "config", "display", "Ljava/util/List;", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastKeyPress", "J", "1.21.5"})
public final class PestFinder {
    @NotNull
    public static final PestFinder INSTANCE = new PestFinder();
    @NotNull
    private static List<? extends Renderable> display = CollectionsKt.emptyList();
    private static long lastKeyPress;

    private PestFinder() {
    }

    private final PestFinderConfig getConfig() {
        return PestApi.INSTANCE.getConfig().getPestFinder();
    }

    @HandleEvent
    public final void onPestUpdate(@NotNull PestUpdateEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        this.update();
    }

    private final void update() {
        if (this.isEnabled()) {
            display = this.drawDisplay();
        }
    }

    private final List<Renderable> drawDisplay() {
        List list;
        List $this$drawDisplay_u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u243, "\u00a76Total pests: \u00a7e" + PestApi.INSTANCE.getScoreboardPests() + "\u00a76/\u00a7e8", 0.0, null, null, 14, null);
        for (GardenPlotApi.Plot plot : PestApi.INSTANCE.getInfestedPlots()) {
            int pests = GardenPlotApi.INSTANCE.getPests(plot);
            String plotName = GardenPlotApi.INSTANCE.getName(plot);
            boolean isInaccurate = GardenPlotApi.INSTANCE.isPestCountInaccurate(plot);
            String pestsName = StringUtils.pluralize$default(StringUtils.INSTANCE, pests, "pest", null, false, 12, null);
            String name2 = "\u00a7e" + (isInaccurate ? "1+?" : Integer.valueOf(pests)) + " \u00a7c" + pestsName + " \u00a77in \u00a7b" + plotName;
            Renderable.Companion companion = Renderable.Companion;
            Object[] objectArray = new String[]{"\u00a77Pests Found: \u00a7e" + (isInaccurate ? "Unknown" : Integer.valueOf(pests)), "\u00a77In plot \u00a7b" + plotName, "", "\u00a7eClick here to warp!"};
            List list2 = CollectionsKt.listOf((Object[])objectArray);
            Renderable renderable2 = Renderable.Companion.clickable$default(companion, name2, () -> PestFinder.drawDisplay$lambda$3$lambda$0(plot), false, null, list2, null, 44, null);
            $this$drawDisplay_u24lambda_u243.add(renderable2);
        }
        if (PestApi.INSTANCE.getInfestedPlots().isEmpty() && PestApi.INSTANCE.getScoreboardPests() != 0) {
            INSTANCE.remindInChat();
            RenderableCollectionUtils.addString$default(RenderableCollectionUtils.INSTANCE, $this$drawDisplay_u24lambda_u243, "\u00a7e" + PestApi.INSTANCE.getScoreboardPests() + " \u00a76Bugged pests!", 0.0, null, null, 14, null);
            Object object = Renderable.Companion;
            List list3 = CollectionsKt.listOf((Object)"Runs /desk.");
            $this$drawDisplay_u24lambda_u243.add(Renderable.Companion.clickable$default((Renderable.Companion)object, "\u00a7cTry opening your plots menu", PestFinder::drawDisplay$lambda$3$lambda$1, false, null, list3, null, 44, null));
            object = Renderable.Companion;
            list3 = CollectionsKt.listOf((Object)"Runs /widget.");
            $this$drawDisplay_u24lambda_u243.add(Renderable.Companion.clickable$default((Renderable.Companion)object, "\u00a7cor enable Pests Widget in \u00a7e/widget.", PestFinder::drawDisplay$lambda$3$lambda$2, false, null, list3, null, 44, null));
        }
        return CollectionsKt.build((List)list);
    }

    private final void remindInChat() {
        if (!TabWidget.PESTS.isActive()) {
            ChatUtils.INSTANCE.userError("Pest detection requires the tab list widget to be enabled. Enable the 'Pests Widget' via /widget!", true);
        }
    }

    @HandleEvent
    public final void onIslandChange(@NotNull IslandChangeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        display = CollectionsKt.emptyList();
        this.update();
    }

    private final boolean shouldShowDisplay() {
        if (!this.isEnabled()) {
            return false;
        }
        if (!this.getConfig().getShowDisplay()) {
            return false;
        }
        return this.shouldShowBasedOnHeldItem();
    }

    private final boolean shouldShowBasedOnHeldItem() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getConfig().getWhenToShow().ordinal()]) {
            case 1 -> true;
            case 2 -> {
                if (PestApi.INSTANCE.hasVacuumInHand() || PestApi.INSTANCE.hasLassoInHand()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> PestApi.INSTANCE.hasVacuumInHand();
            case 4 -> PestApi.INSTANCE.hasLassoInHand();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean timePassedDisabled() {
        boolean vacuumPassed = Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(PestApi.INSTANCE.getLastTimeVacuumHeld-uFjCsEo()), (long)DurationKt.toDuration((int)this.getConfig().getShowBorderForSeconds(), (DurationUnit)DurationUnit.SECONDS)) > 0;
        boolean lassoPassed = Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(PestApi.INSTANCE.getLastTimeLassoHeld-uFjCsEo()), (long)DurationKt.toDuration((int)this.getConfig().getShowBorderForSeconds(), (DurationUnit)DurationUnit.SECONDS)) > 0;
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getConfig().getWhenToShow().ordinal()]) {
            case 1 -> false;
            case 3 -> vacuumPassed;
            case 4 -> lassoPassed;
            case 2 -> {
                if (vacuumPassed && lassoPassed) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @HandleEvent(priority=1)
    public final void onRenderWorld(@NotNull SkyHanniRenderWorldEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.isEnabled()) {
            return;
        }
        if (!this.getConfig().getShowPlotInWorld()) {
            return;
        }
        if (!this.shouldShowBasedOnHeldItem() && this.timePassedDisabled()) {
            return;
        }
        LorenzVec playerLocation = WorldRenderUtils.INSTANCE.exactPlayerEyeLocation(event2);
        PestFinderConfig.VisibilityType visibility = this.getConfig().getVisibilityType();
        boolean showBorder = visibility == PestFinderConfig.VisibilityType.BOTH || visibility == PestFinderConfig.VisibilityType.BORDER;
        boolean showName = visibility == PestFinderConfig.VisibilityType.BOTH || visibility == PestFinderConfig.VisibilityType.NAME;
        for (GardenPlotApi.Plot plot : PestApi.INSTANCE.getInfestedPlots()) {
            if (GardenPlotApi.INSTANCE.isPlayerInside(plot)) {
                if (!showBorder) continue;
                GardenPlotApi.renderPlot$default(GardenPlotApi.INSTANCE, event2, plot, LorenzColor.RED.toColor(), LorenzColor.DARK_RED.toColor(), false, 8, null);
                continue;
            }
            if (showBorder) {
                GardenPlotApi.renderPlot$default(GardenPlotApi.INSTANCE, event2, plot, LorenzColor.GOLD.toColor(), LorenzColor.RED.toColor(), false, 8, null);
            }
            if (!showName) continue;
            this.drawName(plot, playerLocation, event2);
        }
    }

    private final void drawName(GardenPlotApi.Plot plot, LorenzVec playerLocation, SkyHanniRenderWorldEvent event2) {
        int pests = GardenPlotApi.INSTANCE.getPests(plot);
        String pestsName = StringUtils.pluralize$default(StringUtils.INSTANCE, pests, "pest", null, false, 12, null);
        String plotName = GardenPlotApi.INSTANCE.getName(plot);
        LorenzVec middle = plot.getMiddle();
        boolean isInaccurate = GardenPlotApi.INSTANCE.isPestCountInaccurate(plot);
        LorenzVec location = LorenzVec.copy$default(playerLocation, middle.getX(), 0.0, middle.getZ(), 2, null);
        WorldRenderUtils.drawWaypointFilled$default(WorldRenderUtils.INSTANCE, event2, location, LorenzColor.RED.toColor(), false, false, 0.0, 0.0, 0.0, 0.0f, false, 508, null);
        Object number = isInaccurate ? "?" : Integer.valueOf(pests);
        WorldRenderUtils.drawDynamicText$default(WorldRenderUtils.INSTANCE, event2, location, "\u00a7e" + number + " \u00a7c" + pestsName + " \u00a77in \u00a7b" + plotName, 1.5, 0.0f, 0.0, 0.0, false, false, null, 504, null);
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onChat(@NotNull SkyHanniChatEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!this.getConfig().getNoPestTitle()) {
            return;
        }
        if (RegexUtils.INSTANCE.matches(PestApi.INSTANCE.getNoPestsChatPattern(), event2.getMessage())) {
            TitleManager.sendTitle-pX6VMpQ$default(TitleManager.INSTANCE, "\u00a7eNo pests!", null, DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS), null, null, null, 0.0, false, false, null, 0L, null, null, 0L, 16378, null);
        }
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onKeyPress(@NotNull KeyPressEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (class_310.method_1551().field_1755 != null) {
            return;
        }
        if (NeuItems.INSTANCE.neuHasFocus()) {
            return;
        }
        if (event2.getKeyCode() != this.getConfig().getTeleportHotkey()) {
            return;
        }
        if (Duration.compareTo-LRDsOJo((long)SimpleTimeMark.passedSince-UwyO8pc(lastKeyPress), (long)DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.SECONDS)) < 0) {
            return;
        }
        lastKeyPress = SimpleTimeMark.Companion.now-uFjCsEo();
        this.teleportNearestInfestedPlot();
    }

    @HandleEvent(onlyOnIsland=IslandType.GARDEN)
    public final void onPlaySound(@NotNull PlaySoundEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (PestApi.INSTANCE.getConfig().getMuteVacuum() && Intrinsics.areEqual((Object)event2.getSoundName(), (Object)"mob.wither.shoot")) {
            event2.cancel();
        }
    }

    private final void teleportNearestInfestedPlot() {
        if (!GardenApi.INSTANCE.inGarden()) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "This command only works while on the Garden!", false, 2, null);
        }
        GardenPlotApi.Plot plot = PestApi.INSTANCE.getNearestInfestedPlot();
        if (plot == null) {
            PestFinder $this$teleportNearestInfestedPlot_u24lambda_u246 = this;
            boolean bl = false;
            if ($this$teleportNearestInfestedPlot_u24lambda_u246.getConfig().getBackToGarden()) {
                HypixelCommands.INSTANCE.warp("garden");
                return;
            }
            ChatUtils.userError$default(ChatUtils.INSTANCE, "No infested plots detected to warp to!", false, 2, null);
            return;
        }
        GardenPlotApi.Plot plot2 = plot;
        if (GardenPlotApi.INSTANCE.isPlayerInside(plot2) && !this.getConfig().getAlwaysTp()) {
            ChatUtils.userError$default(ChatUtils.INSTANCE, "You're already in an infested plot!", false, 2, null);
            return;
        }
        GardenPlotApi.INSTANCE.sendTeleportTo(plot2);
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        event2.registerBrigadier("shtpinfested", (Function1<? super BaseBrigadierBuilder, Unit>)((Function1)PestFinder::onCommandRegistration$lambda$8));
    }

    public final boolean isEnabled() {
        return GardenApi.INSTANCE.inGarden() && (this.getConfig().getShowDisplay() || this.getConfig().getShowPlotInWorld());
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 97, "garden.pests.pestFinder.muteVacuum", "garden.pests.muteVacuum", null, 8, null);
        event2.move(97, "garden.pests.pestFinder.onlyWithVacuum", "garden.pests.pestFinder.whenToShow", (Function1<? super JsonElement, ? extends JsonElement>)((Function1)PestFinder::onConfigFix$lambda$9));
    }

    private static final Unit drawDisplay$lambda$3$lambda$0(GardenPlotApi.Plot $plot) {
        Intrinsics.checkNotNullParameter((Object)$plot, (String)"$plot");
        GardenPlotApi.INSTANCE.sendTeleportTo($plot);
        return Unit.INSTANCE;
    }

    private static final Unit drawDisplay$lambda$3$lambda$1() {
        HypixelCommands.INSTANCE.gardenDesk();
        return Unit.INSTANCE;
    }

    private static final Unit drawDisplay$lambda$3$lambda$2() {
        HypixelCommands.INSTANCE.widget();
        return Unit.INSTANCE;
    }

    private static final boolean _init_$lambda$4() {
        return INSTANCE.shouldShowDisplay();
    }

    private static final Unit _init_$lambda$5() {
        RenderUtils.renderRenderables$default(RenderUtils.INSTANCE, INSTANCE.getConfig().getPosition(), display, 0, "Pest Finder", false, 10, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$8$lambda$7() {
        INSTANCE.teleportNearestInfestedPlot();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$8(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter((Object)$this$registerBrigadier, (String)"$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Teleports you to the nearest infested plot");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_ACTIVE);
        $this$registerBrigadier.simpleCallback((Function0<Unit>)((Function0)PestFinder::onCommandRegistration$lambda$8$lambda$7));
        return Unit.INSTANCE;
    }

    private static final JsonElement onConfigFix$lambda$9(JsonElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ConfigUtils.INSTANCE.migrateBooleanToEnum(it, (Enum)PestFinderConfig.WhenToShow.BOTH, (Enum)PestFinderConfig.WhenToShow.ALWAYS);
    }

    static {
        new RenderDisplayHelper(null, true, true, PestFinder::_init_$lambda$4, null, PestFinder::_init_$lambda$5, 17, null);
        lastKeyPress = SimpleTimeMark.Companion.farPast();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PestFinderConfig.WhenToShow.values().length];
            try {
                nArray[PestFinderConfig.WhenToShow.ALWAYS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PestFinderConfig.WhenToShow.BOTH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PestFinderConfig.WhenToShow.ONLY_WITH_VACUUM_IN_HAND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PestFinderConfig.WhenToShow.ONLY_WITH_LASSO_IN_HAND.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

