/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.garden.sensitivity;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.commands.CommandBuilder;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.features.garden.SensitivityReducerConfig;
import at.hannibal2.skyhanni.events.ConfigLoadEvent;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.features.garden.GardenApi;
import at.hannibal2.skyhanni.features.garden.sensitivity.MouseSensitivityManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.ConditionalUtils;
import at.hannibal2.skyhanni.utils.KeyboardManager;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0003J\u000f\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\u0003J\u000f\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u001d\u0010\r\u001a\u00020\u00042\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u000f\u0010\u0010\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0003J\u000f\u0010\u0011\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0003J\u000f\u0010\u0012\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0003J\u0017\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0017\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u0017\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001cR\u0014\u0010!\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0016\u0010\"\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u0016\u0010$\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010#R\u0016\u0010%\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b%\u0010#R\u0014\u0010&\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001cR\u0014\u0010'\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001cR\u0014\u0010(\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001c\u00a8\u0006)"}, d2={"Lat/hannibal2/skyhanni/features/garden/sensitivity/SensitivityReducer;", "", "<init>", "()V", "", "onTick", "onConfigLoad", "updatePlayerStatus", "tryAutoToggle", "autoToggleIfNeeded", "Lkotlin/Function0;", "", "check", "toggleIfCondition", "(Lkotlin/jvm/functions/Function0;)V", "autoToggle", "disable", "enable", "manualToggle", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "event", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "onRenderOverlay", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "isHoldingTool", "()Z", "isHoldingKey", "Lat/hannibal2/skyhanni/config/features/garden/SensitivityReducerConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/garden/SensitivityReducerConfig;", "config", "inBarn", "Z", "onGround", "shouldBeActive", "isActive", "isAutoActive", "isManualActive", "1.21.5"})
public final class SensitivityReducer {
    @NotNull
    public static final SensitivityReducer INSTANCE = new SensitivityReducer();
    private static boolean inBarn;
    private static boolean onGround;
    private static boolean shouldBeActive;

    private SensitivityReducer() {
    }

    private final SensitivityReducerConfig getConfig() {
        return SkyHanniMod.feature.getGarden().getSensitivityReducer();
    }

    private final boolean isActive() {
        return this.isAutoActive() || this.isManualActive();
    }

    private final boolean isAutoActive() {
        return MouseSensitivityManager.SensitivityState.AUTO_REDUCED.isActive();
    }

    private final boolean isManualActive() {
        return MouseSensitivityManager.SensitivityState.MANUAL_REDUCED.isActive();
    }

    @HandleEvent
    public final void onTick() {
        if (!GardenApi.INSTANCE.inGarden()) {
            if (this.isAutoActive()) {
                this.autoToggle();
            }
            return;
        }
        if (MouseSensitivityManager.SensitivityState.LOCKED.isActive()) {
            return;
        }
        this.updatePlayerStatus();
        this.autoToggleIfNeeded();
    }

    @HandleEvent(eventType=ConfigLoadEvent.class)
    public final void onConfigLoad() {
        ConditionalUtils.INSTANCE.afterChange(this.getConfig().getReducingFactor(), SensitivityReducer::onConfigLoad$lambda$0);
        ConditionalUtils.INSTANCE.afterChange(this.getConfig().getOnlyPlot(), SensitivityReducer::onConfigLoad$lambda$1);
        ConditionalUtils.INSTANCE.afterChange(this.getConfig().getOnGround(), SensitivityReducer::onConfigLoad$lambda$2);
    }

    private final void updatePlayerStatus() {
        boolean newInBarn = GardenApi.INSTANCE.getOnBarnPlot();
        boolean newOnGround = MinecraftCompat.INSTANCE.getLocalPlayer().method_24828();
        if (inBarn != newInBarn) {
            inBarn = newInBarn;
            this.tryAutoToggle();
        }
        if (onGround != newOnGround) {
            onGround = newOnGround;
            this.tryAutoToggle();
        }
    }

    private final void tryAutoToggle() {
        if (!this.isAutoActive()) {
            return;
        }
        if (!this.isActive()) {
            shouldBeActive = true;
            MouseSensitivityManager.INSTANCE.setState(MouseSensitivityManager.SensitivityState.AUTO_REDUCED);
        } else {
            shouldBeActive = false;
            MouseSensitivityManager.INSTANCE.setState(MouseSensitivityManager.SensitivityState.UNCHANGED);
        }
    }

    private final void autoToggleIfNeeded() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getConfig().getMode().ordinal()]) {
            case 1: {
                this.toggleIfCondition((Function0<Boolean>)((Function0)SensitivityReducer::autoToggleIfNeeded$lambda$3));
                break;
            }
            case 2: {
                this.toggleIfCondition((Function0<Boolean>)((Function0)new Function0<Boolean>((Object)this){

                    public final Boolean invoke() {
                        return SensitivityReducer.access$isHoldingTool((SensitivityReducer)this.receiver);
                    }
                }));
                break;
            }
            case 3: {
                this.toggleIfCondition((Function0<Boolean>)((Function0)new Function0<Boolean>((Object)this){

                    public final Boolean invoke() {
                        return SensitivityReducer.access$isHoldingKey((SensitivityReducer)this.receiver);
                    }
                }));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void toggleIfCondition(Function0<Boolean> check2) {
        boolean conditionMet = (Boolean)check2.invoke();
        if (conditionMet && !this.isActive()) {
            this.autoToggle();
        } else if (this.isActive() && !conditionMet) {
            this.autoToggle();
        }
    }

    private final void autoToggle() {
        if (((Boolean)this.getConfig().getOnlyPlot().get()).booleanValue() && inBarn) {
            if (this.isActive()) {
                this.disable();
            }
            return;
        }
        if (((Boolean)this.getConfig().getOnGround().get()).booleanValue() && !onGround) {
            if (this.isActive()) {
                this.disable();
            }
            return;
        }
        if (this.isActive()) {
            this.disable();
        } else {
            this.enable();
        }
    }

    private final void disable() {
        shouldBeActive = false;
        MouseSensitivityManager.INSTANCE.setState(MouseSensitivityManager.SensitivityState.UNCHANGED);
    }

    private final void enable() {
        shouldBeActive = true;
        MouseSensitivityManager.INSTANCE.setState(MouseSensitivityManager.SensitivityState.AUTO_REDUCED);
    }

    private final void manualToggle() {
        if (!this.isActive()) {
            shouldBeActive = true;
            MouseSensitivityManager.INSTANCE.setState(MouseSensitivityManager.SensitivityState.MANUAL_REDUCED);
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7bMouse sensitivity is now lowered. Type /shsensreduce to restore your sensitivity.", false, null, false, false, null, 62, null);
        } else {
            shouldBeActive = false;
            MouseSensitivityManager.INSTANCE.setState(MouseSensitivityManager.SensitivityState.UNCHANGED);
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7bMouse sensitivity is now restored.", false, null, false, false, null, 62, null);
        }
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        event2.register("shsensreduce", (Function1<? super CommandBuilder, Unit>)((Function1)SensitivityReducer::onCommandRegistration$lambda$5));
    }

    @HandleEvent(eventType=GuiRenderEvent.GuiOverlayRenderEvent.class)
    public final void onRenderOverlay() {
        if (!this.isActive()) {
            return;
        }
        if (!this.getConfig().getShowGui()) {
            return;
        }
        RenderUtils.renderString$default(RenderUtils.INSTANCE, this.getConfig().getPosition(), "\u00a7eSensitivity Lowered", 0, 0, "Sensitivity Lowered", 6, null);
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 80, "garden.sensitivityReducerConfig", "garden.sensitivityReducer", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event2, 81, "garden.sensitivityReducer.showGUI", "garden.sensitivityReducer.showGui", null, 8, null);
    }

    private final boolean isHoldingTool() {
        return GardenApi.INSTANCE.getToolInHand() != null;
    }

    private final boolean isHoldingKey() {
        return KeyboardManager.INSTANCE.isKeyHeld(this.getConfig().getKeybind()) && class_310.method_1551().field_1755 == null;
    }

    private static final Unit onConfigLoad$lambda$0(float $this$afterChange) {
        MouseSensitivityManager.INSTANCE.destroyCache();
        return Unit.INSTANCE;
    }

    private static final Unit onConfigLoad$lambda$1(boolean $this$afterChange) {
        INSTANCE.autoToggle();
        return Unit.INSTANCE;
    }

    private static final Unit onConfigLoad$lambda$2(boolean $this$afterChange) {
        INSTANCE.autoToggle();
        return Unit.INSTANCE;
    }

    private static final boolean autoToggleIfNeeded$lambda$3() {
        return false;
    }

    private static final Unit onCommandRegistration$lambda$5$lambda$4(String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        INSTANCE.manualToggle();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$5(CommandBuilder $this$register) {
        Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
        $this$register.setDescription("Lowers the mouse sensitivity for easier small adjustments (for farming)");
        $this$register.setCategory(CommandCategory.USERS_ACTIVE);
        $this$register.callback((Function1<? super String[], Unit>)((Function1)SensitivityReducer::onCommandRegistration$lambda$5$lambda$4));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ boolean access$isHoldingTool(SensitivityReducer $this) {
        return $this.isHoldingTool();
    }

    public static final /* synthetic */ boolean access$isHoldingKey(SensitivityReducer $this) {
        return $this.isHoldingKey();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SensitivityReducerConfig.Mode.values().length];
            try {
                nArray[SensitivityReducerConfig.Mode.OFF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SensitivityReducerConfig.Mode.TOOL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SensitivityReducerConfig.Mode.KEYBIND.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

